/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.data.utils;

import cms.tmx.define.BsDict;
import cms.tmx.entity.data.CtpRefItem;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.utils.StringUtils;
import javafx.scene.control.TableCell;

public class HandicapCountCell<E extends HandicapInfo>
extends TableCell<HandicapInfo, Number> {
    private MarketItem info;
    private static final int INVALID_COUNT = -1;

    public HandicapCountCell(MarketItem info) {
        this.info = info;
    }

    public void updateItem(Number item, boolean empty) {
        HandicapInfo handiInfo;
        if (!(empty || item.longValue() == -1L || (handiInfo = (HandicapInfo)this.getTableRow().getItem()) == null || handiInfo.isClear() || this.info.isClear())) {
            if (this.info.getRefItem() instanceof CtpRefItem) {
                this.setText(String.valueOf(item));
            } else {
                int unit = this.info.getRefItem().getBuyUnit();
                if (this.info.getRefItem().getCode().startsWith("688") || "NEEQ".equals(this.info.getRefItem().getMarket())) {
                    this.setText(String.valueOf(item.longValue() / 100L));
                } else if (BsDict.HKUSA_MARKET.contains(this.info.getRefItem().getMarket())) {
                    this.setText(StringUtils.toThousands((String)String.valueOf(item.longValue())));
                } else if (unit != 0) {
                    this.setText(String.valueOf(item.longValue() / (long)unit));
                }
            }
            return;
        }
        this.setText(null);
    }
}

