/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.data.utils;

import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.utils.StringUtils;
import javafx.scene.control.Control;
import javafx.scene.control.TableCell;

public class FuturePriceCell
extends TableCell<HandicapInfo, String> {
    private MarketItem info;

    public FuturePriceCell(MarketItem info) {
        CssUtils.priceTag((Control)this);
        this.info = info;
    }

    public void updateItem(String item, boolean empty) {
        HandicapInfo handiInfo;
        if (!(empty || item.isEmpty() || (handiInfo = (HandicapInfo)this.getTableRow().getItem()) == null || handiInfo.isClear() || this.info.isClear())) {
            double price = Double.parseDouble(item);
            CssUtils.checkPrice((Control)this, (double)this.info.getPreSettlementPrice(), (double)price);
            if (price > 0.0) {
                String txt = StringUtils.toStr((double)price, (int)this.info.getRefItem().getScale());
                this.setText(txt);
                return;
            }
            if (price <= 0.0 && handiInfo.getIndex() == 1) {
                String txt = StringUtils.toStr((double)price, (int)this.info.getRefItem().getScale());
                this.setText(txt);
                return;
            }
        }
        this.setText(null);
    }
}

