/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.data.utils;

import cms.tmx.control.search.BaseAutoCompletion;
import cms.tmx.control.search.BaseSuggestion;
import cms.tmx.http.futures.dto.ArbitrageContract;
import java.util.Comparator;

public class ArbitrageSuggest
extends BaseSuggestion<ArbitrageContract> {
    private Comparator<ArbitrageContract> cp = new Comparator<ArbitrageContract>(){

        @Override
        public int compare(ArbitrageContract o1, ArbitrageContract o2) {
            if (ArbitrageSuggest.this.isLetters()) {
                return ArbitrageSuggest.this.weightLet(o2) - ArbitrageSuggest.this.weightLet(o1);
            }
            return ArbitrageSuggest.this.weightNum(o2) - ArbitrageSuggest.this.weightNum(o1);
        }
    };
    private static final int CODE_LENGTH = 30;
    private static final int ACRONYM_LENGTH = 30;

    public int weightNum(ArbitrageContract item) {
        String input = this.getRequest();
        String code = item.getContractId();
        int index = code.indexOf(input);
        int base = 30 - index;
        int weight = 1000000 * base;
        return weight - Integer.parseInt(code.replaceAll("[A-Za-z]*", ""));
    }

    public int weightLet(ArbitrageContract item) {
        String input = this.getRequest().toUpperCase();
        String code = item.getContractId().toUpperCase();
        int index = code.indexOf(input);
        int base = 30 - index;
        int weight = 1000000 * base;
        char[] chars = code.toCharArray();
        int letWeight = 0;
        int i = 0;
        while (i < chars.length) {
            letWeight += chars[i];
            ++i;
        }
        return weight - letWeight;
    }

    protected Comparator<ArbitrageContract> getComparator() {
        return this.cp;
    }

    public static StrSuggest getStrSuggest() {
        return new StrSuggest();
    }

    protected boolean isMatch(ArbitrageContract suggestion, BaseAutoCompletion.ISuggestionRequest request) {
        return suggestion.getContractId().contains(request.getUserText());
    }

    public static class StrSuggest
    extends BaseSuggestion<String> {
        private Comparator<String> cp = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.toString().compareTo(o2.toString());
            }
        };

        protected Comparator<String> getComparator() {
            return this.cp;
        }

        protected boolean isMatch(String str, BaseAutoCompletion.ISuggestionRequest req) {
            String userTextLower = req.getUserText().toLowerCase();
            String suggestionStr = str.toString().toLowerCase();
            return suggestionStr.contains(userTextLower);
        }
    }
}

