/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.data.impl;

import cms.tmx.api.data.IRefApi;
import cms.tmx.core.MConfService;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.data.http.RefDataMng;
import cms.tmx.data.impl.HkwolunDataMng;
import cms.tmx.data.impl.RefItemFactory;
import cms.tmx.datatype.message.PRefData;
import cms.tmx.entity.data.RefItem;
import cms.tmx.javafx.MxModel;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.core.HttpClientService;
import cmx.tmx.data.IRefDataMng;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReentrantLock;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class RefDataMngImpl
extends MxModel
implements IRefDataMng {
    private static final Logger logger = LogManager.getLogger(RefDataMngImpl.class);
    private static final String DELIMITER = ",";
    private static final String DONE_FLAG = "done_";
    private BooleanProperty done = new SimpleBooleanProperty(false);
    private volatile boolean bRefreshed = false;
    @Inject
    private MConfService ms;
    @Inject
    private HttpClientService httpClient;
    @Inject
    private ExecutorService exe;
    @Inject
    private IRefApi refApi;
    private HkwolunDataMng hkMng;
    private Map<String, Map<String, RefItem>> mapItem = new ConcurrentHashMap<String, Map<String, RefItem>>();
    private String version = "";
    private List<PRefData.SecListItem> listProto = new LinkedList<PRefData.SecListItem>();
    private ReentrantLock lockProto = new ReentrantLock();
    @Inject
    private MEventService es;
    @Inject
    @Named(value="base.path")
    private String pathBase;
    @Inject
    private RefDataMng refDataMng;
    private Map<String, String> codeTypeMap = new ConcurrentHashMap<String, String>(1024);
    private IntegerProperty count = new SimpleIntegerProperty(-1);
    private String ngVersion = "";

    @PostConstruct
    public void init() {
        if (RefDataMng.NEW_SECURITY) {
            this.refDataMng.doneProperty().addListener(ob -> {
                this.changed();
                this.setDone(!this.isDone());
            });
            return;
        }
        this.count.addListener(ob -> {
            if (this.count.get() == 0) {
                this.exe.execute(() -> this.cacheRefData());
            }
            if (this.count.get() == 0 && this.bRefreshed) {
                this.setDone(true);
            }
        });
        this.es.subscribe("auto_reload_refdata", event -> this.autoReLoad());
    }

    public void onLogin() {
        String name;
        File file;
        if (!StringUtils.isEmpty((String)this.ms.getValue("ref.data.server")) && this.checkNgVersion()) {
            try {
                long begin = System.currentTimeMillis();
                this.loadRefDataFromNginx();
                logger.error("load ref data from nginx takes:" + (System.currentTimeMillis() - begin));
                return;
            }
            catch (MException | Exception e) {
                logger.error("\u4ecenginx\u52a0\u8f7d\u9759\u6001\u6587\u4ef6\u51fa\u9519", e);
            }
        }
        this.version = this.getRefDataVersion();
        logger.info("server refdata version = " + this.version);
        if (!this.version.isEmpty() && (file = Paths.get(this.pathBase, "data", DONE_FLAG + (name = RefDataMngImpl.getRefCacheFileName(this.version))).toFile()).exists()) {
            logger.info("load refdata in local file");
            String fullName = file.getAbsolutePath();
            try {
                Object obj = RefDataMngImpl.readObject(fullName);
                this.listProto = (List)obj;
                if (!this.listProto.isEmpty()) {
                    this.loadRefData(this.listProto);
                    this.setDone(true);
                    this.listProto.clear();
                    this.changed();
                    return;
                }
            }
            catch (Exception e) {
                logger.error("read ref cache failed: " + fullName, (Throwable)e);
            }
        }
        try {
            this.getRefFromLocalFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loadRefData();
    }

    private void loadRefDataFromNginx() throws MException, Exception {
        Response resp = this.httpClient.download(String.valueOf(this.ms.getValue("ref.data.server")) + "ref-data.rd");
        InputStream inputStream = resp.body().byteStream();
        Object obj = RefDataMngImpl.readObjectFromStream(inputStream);
        this.listProto = (List)obj;
        if (!this.listProto.isEmpty()) {
            this.loadRefData(this.listProto);
            this.setDone(true);
            this.listProto.clear();
            this.changed();
        }
    }

    public void autoReLoad() {
        if (!StringUtils.isEmpty((String)this.ms.getValue("ref.data.server")) && this.checkNgVersion()) {
            try {
                long begin = System.currentTimeMillis();
                this.loadRefDataFromNginx();
                logger.error("load ref data from nginx takes:" + (System.currentTimeMillis() - begin));
                return;
            }
            catch (MException | Exception e) {
                logger.error("\u4ecenginx\u52a0\u8f7d\u9759\u6001\u6587\u4ef6\u51fa\u9519", e);
            }
        }
        logger.info("auto reload refdata local " + this.version);
        logger.info("auto reload refdata server " + this.getRefDataVersion());
        if (!this.version.equals(this.getRefDataVersion()) && !"".equals(this.getRefDataVersion())) {
            this.version = this.getRefDataVersion();
            this.loadRefData();
        }
    }

    private boolean checkNgVersion() {
        boolean needUpdate = false;
        try {
            Response res = this.httpClient.download(String.valueOf(this.ms.getValue("ref.data.server")) + "ref-version.txt");
            String version = res.body().string();
            if (StringUtils.isEmpty((String)version)) {
                logger.info("\u670d\u52a1\u5668\u65e0\u7248\u672c\u53f7\uff0c\u65e0\u9700\u66f4\u65b0");
                return needUpdate;
            }
            if (version.equals(this.ngVersion)) {
                logger.info("\u670d\u52a1\u5668\u7248\u672c\u4e0e\u5f53\u524d\u7248\u672c\u76f8\u540c\uff0c\u65e0\u9700\u66f4\u65b0\uff0c" + version);
                return needUpdate;
            }
            logger.info("\u9759\u6001\u6587\u4ef6\u66f4\u65b0ngVersion:" + this.ngVersion + ", server version:" + version);
            this.ngVersion = version;
        }
        catch (MException | Exception throwable) {
            logger.error("\u9759\u6001\u6587\u4ef6\u7248\u672c\u53f7\u83b7\u53d6\u5931\u8d25\uff0c\u65e0\u9700\u66f4\u65b0");
            return needUpdate;
        }
        needUpdate = true;
        return needUpdate;
    }

    public void timingRefresh() throws MException, Exception {
        if (!StringUtils.isEmpty((String)this.ms.getValue("ref.data.server"))) {
            if (!this.checkNgVersion()) {
                return;
            }
            this.loadRefDataFromNginx();
        }
    }

    private void cacheRefData() {
        File folder = Paths.get(this.pathBase, "data").toFile();
        if (!this.bRefreshed) {
            File[] listFiles;
            if (folder == null) {
                logger.error("no data folder");
                return;
            }
            File oldRdFile = null;
            File[] fileArray = listFiles = folder.listFiles(file -> file.getName().endsWith(".rd"));
            if (listFiles.length != 0) {
                File f;
                oldRdFile = f = fileArray[0];
            }
            if (oldRdFile != null) {
                String fullName = oldRdFile.getAbsolutePath();
                logger.info("load refdata in local file after query error:" + fullName);
                try {
                    Object obj = RefDataMngImpl.readObject(fullName);
                    this.listProto = (List)obj;
                    if (!this.listProto.isEmpty()) {
                        this.loadRefData(this.listProto);
                        this.setDone(true);
                        this.listProto.clear();
                        this.changed();
                        return;
                    }
                }
                catch (Exception e) {
                    logger.error("load refdata in local file after query error failed: " + fullName, (Throwable)e);
                }
            } else {
                logger.error("load refdata in local file failed: no local file");
            }
            return;
        }
        if (this.version.isEmpty()) {
            return;
        }
        File[] fileArray = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".rd");
            }
        });
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            f.delete();
            ++n2;
        }
        try {
            try {
                File file2 = Paths.get(this.pathBase, "data", RefDataMngImpl.getRefCacheFileName(this.version)).toFile();
                RefDataMngImpl.writeObject(file2.getAbsolutePath(), this.listProto);
                file2.renameTo(Paths.get(this.pathBase, "data", DONE_FLAG + RefDataMngImpl.getRefCacheFileName(this.version)).toFile());
            }
            catch (Exception e) {
                logger.error("cache ref data failed version: " + this.version, (Throwable)e);
                this.listProto.clear();
            }
        }
        finally {
            this.listProto.clear();
        }
    }

    private void getRefFromLocalFile() {
        File folder = Paths.get(this.pathBase, "data").toFile();
        if (!this.bRefreshed) {
            File[] listFiles;
            if (folder == null) {
                logger.error("no data folder");
                return;
            }
            File oldRdFile = null;
            File[] fileArray = listFiles = folder.listFiles(file -> file.getName().endsWith(".rd"));
            if (listFiles.length != 0) {
                File f;
                oldRdFile = f = fileArray[0];
            }
            if (oldRdFile != null) {
                String fullName = oldRdFile.getAbsolutePath();
                logger.info("load refdata in local file after login:" + fullName);
                List<PRefData.SecListItem> listProtoLocal = new LinkedList();
                try {
                    Object obj = RefDataMngImpl.readObject(fullName);
                    listProtoLocal = (List)obj;
                    if (!listProtoLocal.isEmpty()) {
                        Iterator iterator = listProtoLocal.iterator();
                        while (iterator.hasNext()) {
                            PRefData.SecListItem next = (PRefData.SecListItem)iterator.next();
                            if (!"OIS".equals(next.getInstrument().getSecurityType())) continue;
                            iterator.remove();
                        }
                        this.loadRefData(listProtoLocal);
                        this.setDone(true);
                        this.changed();
                        return;
                    }
                }
                catch (Exception e) {
                    logger.error("load refdata in local file after login: " + fullName, (Throwable)e);
                }
            } else {
                logger.error("load refdata in local file failed: no local file");
            }
            return;
        }
    }

    private static String getRefCacheFileName(String name) {
        return String.valueOf(name.replace(' ', '_').replace(':', '-')) + ".rd";
    }

    private synchronized void decreaseCount() {
        this.count.set(this.count.get() - 1);
    }

    private void loadRefData() {
        this.bRefreshed = true;
        this.count.set(10);
        this.exe.execute(() -> {
            boolean ret = this.loadRefData(4, "CCS", "", "");
            if (!ret) {
                this.bRefreshed = false;
            }
            this.decreaseCount();
        });
        this.exe.execute(() -> {
            boolean ret = this.loadRefData(4, "FUTURES", "", "");
            if (!ret) {
                this.bRefreshed = false;
            }
            this.decreaseCount();
        });
        this.exe.execute(() -> {
            boolean ret = this.loadRefData(1, "IB", "SBFWD", "");
            if (!ret) {
                this.bRefreshed = false;
            }
            this.decreaseCount();
        });
        this.exe.execute(() -> {
            boolean ret = this.loadRefData(1, "IB", "CTFixedFloatIRS", "");
            if (!ret) {
                this.bRefreshed = false;
            }
            this.decreaseCount();
        });
        this.exe.execute(() -> {
            boolean ret = this.loadRefData(1, "IB", "SBFWDDELIVER", "");
            if (!ret) {
                this.bRefreshed = false;
            }
            this.decreaseCount();
        });
        this.exe.execute(() -> {
            boolean ret = this.loadRefData(1, "IB", "BOND", "");
            if (!ret) {
                this.bRefreshed = false;
            }
            this.decreaseCount();
        });
        this.exe.execute(() -> {
            boolean ret = this.loadRefData(1, "CCS", "OIS", "2");
            if (!ret) {
                this.bRefreshed = false;
            }
            this.decreaseCount();
        });
        this.exe.execute(() -> {
            boolean ret = this.loadRefData(1, "CCS", "OIS", "1");
            if (!ret) {
                this.bRefreshed = false;
            }
            this.decreaseCount();
        });
        this.exe.execute(() -> {
            boolean ret = this.loadRefData(1, "CCS", "PLEDGE", "");
            if (!ret) {
                this.bRefreshed = false;
            }
            this.decreaseCount();
        });
        this.exe.execute(() -> {
            boolean ret = this.loadRefData(6, "CCS", "HKSTOCK", "");
            if (!ret) {
                this.bRefreshed = false;
            }
            this.decreaseCount();
        });
    }

    private void loadRefData(List<PRefData.SecListItem> list) {
        for (PRefData.SecListItem item : list) {
            RefItem refItem = RefItemFactory.create(item);
            this.addItem(refItem);
        }
    }

    @Override
    public boolean loadRefData(int reqType, String market, String secType, String subType) {
        String symbol = String.format("%d,%s,%s,%s", reqType, market, secType, subType);
        logger.info("--------load ref data start: " + symbol);
        try {
            List list = this.refApi.loadRefData(reqType, market, secType, subType, null);
            this.lockProto.lock();
            for (PRefData.SecListItem item : list) {
                this.listProto.add(item);
            }
            this.lockProto.unlock();
            for (PRefData.SecListItem item : list) {
                RefItem refItem = RefItemFactory.create(item);
                this.addItem(refItem);
            }
            this.changed();
            logger.info("--------load ref data done: " + symbol + ", size:" + list.size());
        }
        catch (MException e) {
            logger.error("--------load ref data failed: " + symbol, (Throwable)e);
            return false;
        }
        return true;
    }

    private void addItem(RefItem item) {
        String type = "";
        try {
            String key;
            RefItem old;
            type = item.getType();
            if ("XcfeXBond".equals(item.getSubSecurityType())) {
                type = String.valueOf(type) + item.getSubSecurityType();
            } else if ("SHSC".equals(item.getMarket()) || "SZSC".equals(item.getMarket())) {
                type = String.valueOf(type) + item.getMarket();
            }
            this.codeTypeMap.put(item.getCode(), type);
            Map<String, RefItem> map = this.mapItem.get(type);
            if (map == null) {
                map = new ConcurrentHashMap<String, RefItem>();
                this.mapItem.put(type, map);
            }
            if ((old = map.put(key = String.join((CharSequence)DELIMITER, item.getMarket(), item.getCode()), item)) != null && old.isHkWolun()) {
                item.setScale(old.getScale());
                item.setPriceUnit(old.getPriceUnit());
            }
        }
        catch (Exception e) {
            logger.error("\u6dfb\u52a0" + item.getCode() + type + "\u51fa\u9519", (Throwable)e);
        }
    }

    @Override
    @Deprecated
    public RefItem getItem(String market, String code) {
        if (RefDataMng.NEW_SECURITY) {
            RefItem item = this.refDataMng.getItem(market, code);
            return item;
        }
        RefItem item = null;
        String cacheType = this.codeTypeMap.get(code);
        String keyName = String.join((CharSequence)DELIMITER, market, code);
        if (!StringUtils.isEmpty((String)cacheType) && this.mapItem.get(cacheType) != null) {
            item = this.mapItem.get(cacheType).get(keyName);
        }
        if (item != null) {
            return item;
        }
        Set<String> keys = this.mapItem.keySet();
        for (String key : keys) {
            item = this.mapItem.get(key).get(keyName);
            if (item != null) break;
        }
        return item;
    }

    @Override
    public RefItem getItem(String type, String market, String code) {
        if (RefDataMng.NEW_SECURITY) {
            RefItem item = this.refDataMng.getItem(type, market, code);
            return item;
        }
        Map<String, RefItem> map = this.mapItem.get(type);
        if (map == null) {
            return null;
        }
        String subKey = String.join((CharSequence)DELIMITER, market, code);
        return map.get(subKey);
    }

    @Override
    public Collection<RefItem> getItems(String ... types) {
        if (RefDataMng.NEW_SECURITY) {
            Collection<RefItem> cHttp = this.refDataMng.getItems(types);
            return cHttp;
        }
        LinkedList<RefItem> c = new LinkedList<RefItem>();
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            Map<String, RefItem> map = this.mapItem.get(type);
            if (map == null) {
                map = new ConcurrentHashMap<String, RefItem>();
                this.mapItem.put(type, map);
            }
            c.addAll(map.values());
            ++n2;
        }
        return c;
    }

    private String getRefDataVersion() {
        String version = "";
        try {
            version = this.refApi.getRefDataVersion();
        }
        catch (MException e) {
            logger.error("get ref data version failed", (Throwable)e);
        }
        return version;
    }

    private static void writeObject(String fileName, Object obj) throws FileNotFoundException, IOException {
        ObjectOutputStream objOS = new ObjectOutputStream(new FileOutputStream(new File(fileName)));
        objOS.writeObject(obj);
        objOS.close();
    }

    private static Object readObject(String fileName) throws IOException, ClassNotFoundException {
        ObjectInputStream objIS = new ObjectInputStream(new FileInputStream(new File(fileName)));
        Object obj = objIS.readObject();
        objIS.close();
        return obj;
    }

    private static Object readObjectFromStream(InputStream fileStream) throws IOException, ClassNotFoundException {
        ObjectInputStream objIS = new ObjectInputStream(fileStream);
        Object obj = objIS.readObject();
        objIS.close();
        return obj;
    }

    public static void main(String[] args) {
    }

    @Override
    public final BooleanProperty doneProperty() {
        return this.done;
    }

    public final boolean isDone() {
        return this.doneProperty().get();
    }

    public final void setDone(boolean done) {
        this.doneProperty().set(done);
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public BooleanProperty changedHkRateProperty() {
        return this.hkMng.changedProperty();
    }

    void setHkwolunDataMng(HkwolunDataMng hkMng) {
        this.hkMng = hkMng;
    }
}

