/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.data.impl;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.define.BsDict;
import cms.tmx.entity.data.OtcRefItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.pricingit.GetSecurityListReq;
import cms.tmx.http.api.pricingit.SecurityServiceApi;
import cms.tmx.http.data.FundInfo;
import cms.tmx.http.data.GetFundsReq;
import cms.tmx.http.data.GetInstrumentsReq;
import cms.tmx.http.data.GetStocksReq;
import cms.tmx.http.security.dto.SecurityEvent;
import cms.tmx.http.security.dto.StockInfo;
import cms.tmx.http.utils.GsonFactory;
import cms.tmx.javafx.MxModel;
import cmx.tmx.data.INewRefMng;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class NewRefMngImpl
extends MxModel
implements INewRefMng {
    @Inject
    private SecurityServiceApi refMngApi;
    @Inject
    private ExecutorService exe;
    @Inject
    private MEventService es;
    private Map<String, Map<String, RefItem>> mapItem = new ConcurrentHashMap<String, Map<String, RefItem>>();
    private CountDownLatch count = new CountDownLatch(4);
    private static final String DELIMITER = ",";

    @PostConstruct
    public void init() {
        this.es.subscribe("uap.push.SecurityEvent", event -> this.onSecurityPush(event));
    }

    private void onSecurityPush(MEvent event) {
        RefItem item;
        JsonObject pushMsg = (JsonObject)event.getObj(JsonObject.class);
        SecurityEvent se = (SecurityEvent)GsonFactory.getInstance().fromJson(pushMsg.toString(), SecurityEvent.class);
        if ("valuation".equals(se.getSubType())) {
            return;
        }
        if ("kEventDelete".equals(se.getEvent())) {
            if (se.getSecurityType() == null || se.getSecurityId() == null || se.getMarket() == null) {
                return;
            }
            RefItem item2 = this.getItem(se.getSecurityType(), se.getMarket(), se.getSecurityId());
            if (item2 == null) {
                return;
            }
            this.removeItem(item2);
            MEvent e = new MEvent();
            e.setObj((Object)item2);
            this.es.postEvent("otc_ref_delete", e);
            return;
        }
        if (se.getFund() != null && se.getFund().getSecurity() != null && se.getFund().getSecurity().getInstrument() != null) {
            FundInfo fund = se.getFund();
            if (!"XOTC".equals(fund.getSecurity().getInstrument().getMarket())) {
                return;
            }
            item = this.getItem(fund.getSecurity().getInstrument().getSecurityType(), fund.getSecurity().getInstrument().getMarket(), fund.getSecurity().getInstrument().getSecurityId());
            if (item == null) {
                OtcRefItem refItem = new OtcRefItem();
                refItem.update((Object)fund);
                this.addItem((RefItem)refItem);
                MEvent e = new MEvent();
                e.setObj((Object)refItem);
                this.es.postEvent("otc_ref_new", e);
                return;
            }
            item.update((Object)fund);
        }
        if (se.getStock() != null && se.getStock().getSecurity() != null && se.getStock().getSecurity().getInstrument() != null) {
            StockInfo stock = se.getStock();
            if (!"NEEQ".equals(stock.getSecurity().getInstrument().getMarket()) || !"XHKG".equals(stock.getSecurity().getInstrument().getMarket())) {
                return;
            }
            item = this.getItem(stock.getSecurity().getInstrument().getSecurityType(), stock.getSecurity().getInstrument().getMarket(), stock.getSecurity().getInstrument().getSecurityId());
            if (item == null) {
                return;
            }
            item.update((Object)stock);
            MEvent ev = new MEvent();
            event.setObj((Object)item);
            this.es.postEvent("stock_ref_new", ev);
        }
    }

    public void loadNewRefData() {
        this.exe.execute(() -> this.loadFundsRefData());
        this.exe.execute(() -> this.loadStocksRefData());
        this.exe.execute(() -> this.loadHKStocksRefData());
        this.exe.execute(() -> this.loadSGEXData());
        try {
            this.count.await();
        }
        catch (InterruptedException e) {
            this.logger.error("\u67e5\u8be2\u65b0\u6846\u67b6\u9759\u6001\u884c\u60c5\u5f02\u5e38", (Throwable)e);
        }
        this.changed();
    }

    private void loadXSHEFundsRefData() {
        GetSecurityListReq req = new GetSecurityListReq();
        req.setMarket("XSHE");
        req.setSecurityType("FUND");
        try {
            List resp = this.refMngApi.getSecurityList(req);
            resp.forEach(info -> {
                OtcRefItem item = new OtcRefItem();
                item.update(info);
                this.addItem((RefItem)item);
            });
        }
        catch (MException e) {
            this.logger.error("load otc fund faild", (Throwable)e);
        }
        this.count.countDown();
    }

    private void loadXSHGFundsRefData() {
        GetSecurityListReq req = new GetSecurityListReq();
        req.setMarket("XSHG");
        req.setSecurityType("FUND");
        try {
            try {
                List resp = this.refMngApi.getSecurityList(req);
                resp.forEach(info -> {
                    OtcRefItem item = new OtcRefItem();
                    item.update(info);
                    this.addItem((RefItem)item);
                });
            }
            catch (MException e) {
                this.logger.error("load XSHG fund faild", (Throwable)e);
                this.count.countDown();
            }
        }
        finally {
            this.count.countDown();
        }
    }

    private void loadFundsRefData() {
        GetSecurityListReq req = new GetSecurityListReq();
        req.setMarket("XOTC");
        req.setSecurityType("FUND");
        try {
            List resp = this.refMngApi.getSecurityList(req);
            resp.forEach(info -> {
                OtcRefItem item = new OtcRefItem();
                item.update(info);
                this.addItem((RefItem)item);
            });
        }
        catch (MException e) {
            this.logger.error("load otc fund faild", (Throwable)e);
        }
        this.count.countDown();
    }

    private void loadStocksRefData() {
        GetInstrumentsReq req = new GetInstrumentsReq();
        req.setMarket("NEEQ");
        req.setSecurityType("STOCK");
        try {
            List resp = this.refMngApi.getInstruments(req);
            resp.forEach(info -> {
                RefItem item = new RefItem();
                item.update(info);
                this.addItem(item);
            });
        }
        catch (MException e) {
            this.logger.error("load otc fund faild", (Throwable)e);
        }
        this.count.countDown();
    }

    private void loadSGEXData() {
        GetInstrumentsReq req = new GetInstrumentsReq();
        req.setMarket("SGEX");
        req.setSecurityType("STOCK");
        try {
            try {
                List resp = this.refMngApi.getInstruments(req);
                resp.forEach(info -> {
                    RefItem item = new RefItem();
                    item.setMarket("SGEX");
                    item.update(info);
                    this.addItem(item);
                });
            }
            catch (MException e) {
                this.logger.error("load SGEX fund faild", (Throwable)e);
                this.logger.info("load SGEX fund ");
                this.count.countDown();
            }
        }
        finally {
            this.logger.info("load SGEX fund ");
            this.count.countDown();
        }
    }

    private void loadHKStocksRefData() {
        GetInstrumentsReq req = new GetInstrumentsReq();
        req.setMarket("XHKG");
        req.setSecurityType("STOCK");
        try {
            List resp = this.refMngApi.getInstruments(req);
            resp.forEach(info -> {
                RefItem item = new RefItem();
                item.update(info);
                item.setMarket("XHKG");
                item.setScale(3);
                this.addItem(item);
            });
        }
        catch (MException e) {
            this.logger.error("load XHKG fund faild", (Throwable)e);
        }
        this.count.countDown();
    }

    @Override
    public void queryFundInfo(RefItem item) {
        GetFundsReq req = new GetFundsReq();
        ArrayList<Instrument> list = new ArrayList<Instrument>();
        Instrument instrument = new Instrument();
        instrument.setSecurityId(item.getCode());
        instrument.setMarket(item.getMarket());
        list.add(instrument);
        req.setInstrument(list);
        try {
            List resp = this.refMngApi.getFundsReq(req);
            resp.forEach(info -> {
                item.update(info);
                if (item instanceof OtcRefItem) {
                    ((OtcRefItem)OtcRefItem.class.cast(item)).setNeedQuery(false);
                }
            });
        }
        catch (MException e) {
            this.logger.error("update otc fund faild" + item.getCode(), (Throwable)e);
        }
    }

    @Override
    public void queryStockInfo(RefItem item) {
        GetStocksReq req = new GetStocksReq();
        ArrayList<Instrument> list = new ArrayList<Instrument>();
        Instrument instrument = new Instrument();
        instrument.setSecurityId(item.getCode());
        instrument.setMarket(item.getMarket());
        list.add(instrument);
        req.setInstrument(list);
        try {
            List resp = this.refMngApi.getStocksReq(req);
            resp.forEach(info -> {
                item.update(info);
                item.setNeeqQuery(false);
            });
        }
        catch (MException e) {
            this.logger.error("update otc fund faild" + item.getCode(), (Throwable)e);
        }
    }

    private void addItem(RefItem item) {
        Map<String, RefItem> map;
        String type = item.getType();
        if (type == null) {
            this.logger.error("\u9759\u6001\u884c\u60c5\u7c7b\u578b\u4e3anull" + item.getCode() + item.getType());
            return;
        }
        if (BsDict.HKUSA_MARKET.contains(item.getMarket()) || "SGEX".equals(item.getMarket())) {
            type = String.valueOf(item.getType()) + item.getMarket();
        }
        if ((map = this.mapItem.get(type)) == null) {
            map = new ConcurrentHashMap<String, RefItem>();
            this.mapItem.put(type, map);
        }
        String key = String.join((CharSequence)DELIMITER, item.getMarket(), item.getCode());
        map.put(key, item);
    }

    private void removeItem(RefItem item) {
        if (item == null) {
            return;
        }
        String type = item.getType();
        if (type == null) {
            this.logger.error("\u9759\u6001\u884c\u60c5\u7c7b\u578b\u4e3anull" + item.getCode() + item.getType());
            return;
        }
        Map<String, RefItem> map = this.mapItem.get(type);
        if (map == null) {
            return;
        }
        String key = String.join((CharSequence)DELIMITER, item.getMarket(), item.getCode());
        map.remove(key);
    }

    @Override
    public RefItem getItem(String type, String market, String code) {
        Map<String, RefItem> map = this.mapItem.get(type);
        if (map == null) {
            return null;
        }
        String subKey = String.join((CharSequence)DELIMITER, market, code);
        return map.get(subKey);
    }

    @Override
    public Collection<RefItem> getItems(String ... types) {
        LinkedList<RefItem> c = new LinkedList<RefItem>();
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            Map<String, RefItem> map = this.mapItem.get(type);
            if (map == null) {
                map = new ConcurrentHashMap<String, RefItem>();
                this.mapItem.put(type, map);
            }
            c.addAll(map.values());
            ++n2;
        }
        return c;
    }
}

