/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.data.impl;

import cms.tmx.api.data.IMarketApi;
import cms.tmx.api.data.IRefItem;
import cms.tmx.core.MException;
import cms.tmx.data.impl.MarketDataMngImpl;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cmx.tmx.data.INewMarketDataMng;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class NewMarketDataMngImpl
implements INewMarketDataMng {
    private static final Logger logger = LogManager.getLogger(MarketDataMngImpl.class);
    @Inject
    private MarketDataMngImpl oldMng;
    @Inject
    private IMarketApi marketApi;

    @Override
    public Collection<MarketItem> sub(List<RefItem> listItem) {
        return this.oldMng.getItems(listItem, true);
    }

    @Override
    public synchronized void unsub(List<RefItem> list) {
        LinkedList listItem = new LinkedList();
        list.forEach(item -> {
            MarketItem itemMarket = this.oldMng.getInfo((IRefItem)item);
            if (itemMarket != null && itemMarket.isCanUnsub()) {
                listItem.add(item);
            }
        });
        try {
            this.marketApi.unSub(listItem);
        }
        catch (MException e) {
            logger.error("Unsub refitem failed", (Throwable)e);
        }
    }

    @Override
    public void unsub() {
    }
}

