/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.data.impl;

import cms.tmx.api.data.IGears;
import cms.tmx.api.data.IMarketApi;
import cms.tmx.api.data.IRefItem;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.data.impl.RefDataMngImpl;
import cms.tmx.data.utils.Gears;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PMarketData;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.entity.app.IndexInfo;
import cms.tmx.entity.data.CtpRefItem;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IMarketDataMng;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class MarketDataMngImpl
extends MxModel
implements IMarketDataMng {
    private static final Logger logger = LogManager.getLogger(MarketDataMngImpl.class);
    private Map<RefItem, MarketItem> mapInfo = new ConcurrentHashMap<RefItem, MarketItem>();
    @Inject
    private MEventService es;
    @Inject
    private RefDataMngImpl refMng;
    @Inject
    private IMarketApi marketApi;
    @Inject
    private ExecutorService exe;
    @Inject
    private ScheduledExecutorService ses;
    private boolean containsFutSub = false;
    @Inject
    @Named(value="fixed.mise.pool")
    protected ExecutorService esQ;
    private ObservableList<WeakReference<MarketItem>> listCreated = FxUtils.newList();
    private static final String SPEC = "spec";
    private static final int COUNT = 50;
    private String epoch = "";
    private String epochFuture = "";
    private boolean needUpdate = false;
    private static List<String> refList = new ArrayList<String>(){
        {
            this.add("000001_XSHE");
            this.add("000002_XSHE");
            this.add("000004_XSHE");
            this.add("000005_XSHE");
            this.add("000006_XSHE");
            this.add("000007_XSHE");
            this.add("000008_XSHE");
            this.add("000009_XSHE");
            this.add("000010_XSHE");
            this.add("600000_XSHG");
            this.add("600001_XSHG");
            this.add("600002_XSHG");
            this.add("600003_XSHG");
            this.add("600004_XSHG");
            this.add("600005_XSHG");
            this.add("600006_XSHG");
            this.add("600007_XSHG");
            this.add("600008_XSHG");
            this.add("600009_XSHG");
            this.add("600010_XSHG");
            this.add("600011_XSHG");
            this.add("600999_XSHG");
            this.add("TF2003_CCFX");
            this.add("TF1906_CCFX");
            this.add("T2003_CCFX");
            this.add("TT2003_CCFX");
            this.add("TS1912_CCFX");
            this.add("TS1909_CCFX");
            this.add("T1906_CCFX");
        }
    };

    @PostConstruct
    public void init() {
        this.es.subscribe(this.marketApi.getItemPushTopic(), event -> this.onMarketItemPush(event, true));
    }

    @Override
    public Map<RefItem, MarketItem> getMap() {
        return this.mapInfo;
    }

    @Override
    public synchronized MarketItem createItem(int gears) {
        MarketItem item = new MarketItem(gears);
        this.listCreated.add(new WeakReference<MarketItem>(item));
        return item;
    }

    private synchronized MarketItem createItem(RefItem item) {
        CtpRefItem it;
        int gears = item.getType().equals("FUT") ? 5 : 10;
        MarketItem marketItem = new MarketItem(gears);
        marketItem.setRefItem(item);
        if (item instanceof CtpRefItem && StringUtils.belongto((String)(it = (CtpRefItem)CtpRefItem.class.cast(item)).getProductId(), (String[])new String[]{"TS", "TF", "T"})) {
            marketItem.setMarketMaking(true);
        }
        this.mapInfo.put(item, marketItem);
        return marketItem;
    }

    @Override
    public Collection<MarketItem> getItems(List<RefItem> listItem) {
        return this.getItems(listItem, false);
    }

    @Override
    public synchronized Collection<MarketItem> getItems(List<RefItem> listItem, boolean unsub) {
        LinkedList<MarketItem> listMarket = new LinkedList<MarketItem>();
        LinkedList<RefItem> listSub = new LinkedList<RefItem>();
        for (RefItem item : listItem) {
            if (!this.checkRefItem(item)) continue;
            MarketItem mktItem = this.mapInfo.get(item);
            if (mktItem == null) {
                mktItem = this.createItem(item);
            }
            mktItem.setReSub(true);
            if (!this.containsFutSub && "FUT".equals(item.getType())) {
                this.containsFutSub = true;
            }
            if (!unsub) {
                mktItem.setCanUnsub(unsub);
            }
            if (!mktItem.isSubd()) {
                listSub.add(item);
            }
            listMarket.add(mktItem);
        }
        if (!listSub.isEmpty()) {
            this.exe.execute(() -> this.subMarketItems(listSub, null));
        }
        return listMarket;
    }

    @Override
    public synchronized MarketItem getItem(RefItem item) {
        if (!this.checkRefItem(item)) {
            return null;
        }
        MarketItem mktItem = this.mapInfo.get(item);
        if (mktItem == null) {
            mktItem = this.createItem(item);
        }
        mktItem.setReSub(true);
        if (!this.containsFutSub && "FUT".equals(item.getType())) {
            this.containsFutSub = true;
        }
        if (mktItem.notUpdatedForLongTime() || !mktItem.isSubd()) {
            LinkedList<RefItem> listSub = new LinkedList<RefItem>();
            listSub.add(item);
            this.exe.execute(() -> this.subMarketItems(listSub, null));
        }
        return mktItem;
    }

    private void queryMarketItems(List<RefItem> queryItems, Gears gears) {
        HashSet<RefItem> itemSet = new HashSet<RefItem>(queryItems);
        ArrayList<RefItem> items = new ArrayList<RefItem>(itemSet);
        int count = (int)Math.ceil(1.0 * (double)items.size() / 50.0);
        CountDownLatch latch = new CountDownLatch(count);
        int size = items.size();
        int start = 0;
        int end = 0;
        do {
            end = (end += 50) < size ? end : size;
            LinkedList list = new LinkedList();
            list.addAll(items.subList(start, end));
            this.esQ.execute(() -> {
                try {
                    try {
                        MEvent event = new MEvent();
                        event.setObj((Object)this.marketApi.query(list, (IGears)gears));
                        event.put((Object)SPEC, (Object)SPEC);
                        this.onMarketItemPush(event, false);
                    }
                    catch (MException e) {
                        logger.error((Object)e, (Throwable)e);
                        latch.countDown();
                    }
                }
                finally {
                    latch.countDown();
                }
            });
        } while ((start = end) != size);
        try {
            latch.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.error((Object)e);
        }
    }

    @Override
    public void subMarketItems(List<RefItem> items, Gears gears) {
        try {
            int size = items.size();
            int start = 0;
            int end = 0;
            do {
                end = (end += 50) < size ? end : size;
                LinkedList<RefItem> list = new LinkedList<RefItem>();
                list.addAll(items.subList(start, end));
                MEvent event = new MEvent();
                event.setObj((Object)this.marketApi.sub(list));
                this.onMarketItemPush(event, true);
                list.forEach(ref -> {
                    if (this.getInfo((IRefItem)ref) != null) {
                        this.getInfo((IRefItem)ref).subd();
                    }
                });
            } while ((start = end) != size);
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void onMarketItemPush(MEvent event, boolean isPush) {
        PMarketData.MarketDataResponse response = (PMarketData.MarketDataResponse)event.getObj(PMarketData.MarketDataResponse.class);
        if (logger.isDebugEnabled() && isPush) {
            logger.debug("PMarketData.MarketDataResponse:" + event.getId() + " " + response);
        }
        List list = response.getMdSnapshotList();
        if (response.getStatus().getStatus() == 40001) {
            System.out.println(response.getStatus().getReason());
            MEvent e = new MEvent();
            e.put((Object)"reason", (Object)response.getStatus().getReason());
            this.es.postEvent("market.no.message", e);
            return;
        }
        for (PMarketData.MarketDataSnapshot snap : list) {
            if (snap.getIsIndexData() == 1) {
                this.updateIndexInfo(snap);
                RefItem ref = new RefItem();
                ref.setCode(snap.getInstrument().getSecurityId());
                ref.setMarket(snap.getInstrument().getMarket());
                MarketItem mkt = this.mapInfo.get(ref);
                if (mkt == null) continue;
                mkt.setLastUpdateTime(System.currentTimeMillis());
                continue;
            }
            String market = snap.getInstrument().getMarket();
            String code = snap.getInstrument().getSecurityId();
            boolean isHkwolunQuota = MarketItem.checkQuotaUpdate((PMarketData.MarketDataSnapshot)snap);
            if (isHkwolunQuota) continue;
            RefItem refItem = this.refMng.getItem(market, code);
            if (refItem == null) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("[market]: no ref item " + code);
                continue;
            }
            if (refItem.getType().equals("PLEDGE") && (refItem = this.refMng.getItem("BOND", market, code)) == null) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("[market]: no ref item " + code);
                continue;
            }
            MarketItem item = this.mapInfo.get(refItem);
            if (item != null) {
                item.update((Object)snap, isPush);
                if (isPush) {
                    item.setLastUpdateTime(System.currentTimeMillis());
                }
            }
            if (isPush) {
                this.updateCreatedItems(snap);
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("[market manager] item updated: " + event.getId() + " " + code);
        }
    }

    private void updateCreateItem(PMarketData.MarketDataSnapshot snap, MarketItem item) {
        RefItem refItem = item.getRefItem();
        if (!this.checkRefItem(refItem)) {
            return;
        }
        String market = snap.getInstrument().getMarket();
        String code = snap.getInstrument().getSecurityId();
        if (refItem.getMarket().equals(market) && refItem.getCode().equals(code)) {
            Platform.runLater(() -> item.update((Object)snap));
        }
    }

    private void updateCreatedItems(PMarketData.MarketDataSnapshot snap) {
        for (WeakReference ref : this.listCreated) {
            MarketItem item = (MarketItem)ref.get();
            if (item == null) continue;
            this.updateCreateItem(snap, item);
        }
    }

    private synchronized void updateIndexInfo(PMarketData.MarketDataSnapshot snap) {
        IndexInfo info = new IndexInfo();
        info.update(snap);
        MEvent event = new MEvent();
        event.setObj((Object)info);
        this.es.postEvent("index.market", event);
    }

    @Override
    public void dye(MarketItem item) {
        MarketItem old = this.getItem(item.getRefItem());
        item.update((Object)old);
        if (item.getRefItem() != null && item.isValidRef()) {
            item.setClear(false);
        }
        item.changed();
    }

    private boolean checkRefItem(RefItem item) {
        return item != null && !item.getMarket().isEmpty() && !item.getCode().isEmpty();
    }

    public boolean doHeartBeat() {
        try {
            this.checkEpoch(this.marketApi.heartbeatReq());
            logger.debug("market heartbeat ok");
            return true;
        }
        catch (MException e) {
            logger.error("market heartbeat faild", (Throwable)e);
            return false;
        }
    }

    public boolean doFutureHeartBeat() {
        try {
            this.checkFutureEpoch(this.marketApi.heartbeatFutureReq());
            logger.debug("market heartbeat ok");
            return true;
        }
        catch (MException e) {
            logger.error("market heartbeat faild", (Throwable)e);
            return false;
        }
    }

    private void checkEpoch(PBase.OpStatus status) {
        String epoch = status.getData();
        if (this.epoch.isEmpty()) {
            this.epoch = epoch;
        }
        if (status.getStatus() == 100 || !this.epoch.equals(epoch)) {
            logger.info("ccs heart beat status :" + status.getStatus() + ",epoch:" + this.epoch);
            this.epoch = epoch;
            this.needUpdate = true;
            this.subAll();
        }
    }

    private void checkFutureEpoch(PBase.OpStatus status) {
        String epochFuture = status.getData();
        if (this.epochFuture.isEmpty()) {
            this.epochFuture = epochFuture;
        }
        if (status.getStatus() == 100 || !this.epochFuture.equals(epochFuture)) {
            logger.info("ctp heart beat status :" + status.getStatus() + ",epochFuture:" + this.epochFuture);
            this.epochFuture = epochFuture;
            if (this.containsFutSub) {
                this.needUpdate = true;
                this.subAll();
            }
        }
    }

    @Override
    public void query(List<RefItem> listItem, Gears gears) {
        logger.info("queryNewPrice");
        LinkedList<RefItem> listQuery = new LinkedList<RefItem>();
        for (RefItem item : listItem) {
            if (!this.checkRefItem(item)) continue;
            MarketItem mktItem = this.mapInfo.get(item);
            if (mktItem == null) {
                mktItem = this.createItem(item);
            }
            listQuery.add(item);
        }
        if (!listQuery.isEmpty()) {
            this.queryMarketItems(listQuery, gears);
        }
    }

    private synchronized void subAll() {
        if (this.needUpdate) {
            LinkedList<RefItem> listSub = new LinkedList<RefItem>();
            for (Map.Entry<RefItem, MarketItem> entry : this.mapInfo.entrySet()) {
                MarketItem mktItem = entry.getValue();
                if (!mktItem.isReSub()) continue;
                listSub.add(entry.getKey());
            }
            if (!listSub.isEmpty()) {
                this.exe.execute(() -> this.subMarketItems(listSub, null));
            }
            this.needUpdate = false;
        }
    }

    @Override
    public MarketItem getInfo(IRefItem ref) {
        return this.mapInfo.get(ref);
    }

    public static void main(String[] args) {
    }

    @Override
    public void queryMarket(MarketItem mktItem) {
        if (!mktItem.isValidRef()) {
            return;
        }
        Gears gears = new Gears();
        int i = 0;
        while (i < mktItem.getGears()) {
            gears.getBuys().add(i + 1);
            gears.getSells().add(i + 1);
            ++i;
        }
        LinkedList<RefItem> refItems = new LinkedList<RefItem>();
        refItems.add(mktItem.getRefItem());
        this.query(refItems, gears);
    }

    @Override
    public void refreshMarket(MarketItem mktItem) {
        if (!mktItem.isValidRef()) {
            return;
        }
        Gears gears = new Gears();
        int i = 0;
        while (i < mktItem.getGears()) {
            gears.getBuys().add(i + 1);
            gears.getSells().add(i + 1);
            ++i;
        }
        LinkedList<RefItem> refItems = new LinkedList<RefItem>();
        refItems.add(mktItem.getRefItem());
        this.query(refItems, gears);
        MarketItem marketItem = this.mapInfo.get(mktItem.getRefItem());
        mktItem.update((Object)marketItem);
    }

    @Override
    public void refreshMarketWithoutQuery(MarketItem mktItem) {
        MarketItem marketItem = this.mapInfo.get(mktItem.getRefItem());
        if (marketItem != null) {
            mktItem.update((Object)marketItem);
        }
    }

    private void marketDataMock() {
        for (String ref : refList) {
            String code = ref.split("_")[0];
            String market = ref.split("_")[1];
            MEvent event = new MEvent();
            PMarketData.MarketDataResponse.Builder mb = PMarketData.MarketDataResponse.newBuilder();
            PMarketData.MarketDataSnapshot.Builder mdb = PMarketData.MarketDataSnapshot.newBuilder();
            PComponent.Instrument.Builder pib = PComponent.Instrument.newBuilder();
            pib.setMarket(market);
            pib.setSecurityId(code);
            mdb.setInstrument(pib.build());
            PMarketData.MDFullGrp.Builder pmb = PMarketData.MDFullGrp.newBuilder();
            SimpleDateFormat sdf = new SimpleDateFormat("ssSSS");
            int i = 0;
            while (i < 5) {
                PMarketData.MDEntry.Builder pmeb1 = PMarketData.MDEntry.newBuilder();
                pmeb1.setMdPriceLevel(i);
                pmeb1.setMdEntryPx(new BigDecimal(sdf.format(new Date())).intValue() * 10);
                pmeb1.setMdEntrySize((int)(Math.random() * 10000.0));
                pmeb1.setMdEntryType(1);
                PMarketData.MDEntry.Builder pmeb2 = PMarketData.MDEntry.newBuilder();
                pmeb2.setMdPriceLevel(i);
                pmeb2.setMdEntryPx(new BigDecimal(sdf.format(new Date())).intValue() * 10);
                pmeb2.setMdEntrySize((int)(Math.random() * 10000.0));
                pmeb2.setMdEntryType(0);
                pmb.addMdEntry(pmeb1.build());
                pmb.addMdEntry(pmeb2.build());
                ++i;
            }
            mdb.setMdFullGrp(pmb.build());
            PMarketData.PriceUnit.Builder pb = PMarketData.PriceUnit.newBuilder();
            pb.setRisePx(new BigDecimal(sdf.format(new Date())).doubleValue() / 1000.0 + 2.0);
            pb.setFallPx(new BigDecimal(sdf.format(new Date())).doubleValue() / 1000.0 - 2.0);
            pb.setOpenPx(new BigDecimal(sdf.format(new Date())).doubleValue() / 1000.0 - 2.0);
            pb.setClosePx(new BigDecimal(sdf.format(new Date())).doubleValue() / 1000.0 - 2.0);
            pb.setHighestPx(new BigDecimal(sdf.format(new Date())).doubleValue() / 1000.0 + 1.0);
            pb.setLowestPx(new BigDecimal(sdf.format(new Date())).doubleValue() / 1000.0 - 1.0);
            pb.setLastPx(new BigDecimal(sdf.format(new Date())).doubleValue() / 1000.0);
            mdb.setPriceUnit(pb.build());
            mb.addMdSnapshot(mdb.build());
            event.setObj((Object)mb.build());
            this.onMarketItemPush(event, true);
        }
    }

    @Override
    public void queryNewPriceIn5Seconds(List<RefItem> listItem, Gears gears) {
        logger.info("queryNewPriceIn5Seconds");
        LinkedList<RefItem> listQuery = new LinkedList<RefItem>();
        for (RefItem item : listItem) {
            if (!this.checkRefItem(item)) continue;
            MarketItem mktItem = this.mapInfo.get(item);
            if (mktItem == null) {
                mktItem = this.createItem(item);
            } else if (System.currentTimeMillis() - mktItem.getLastUpdateTime() < 5000L) {
                System.err.println(String.valueOf(item.getCode()) + " 5\u79d2\u5185\u66f4\u65b0\u8fc7");
                continue;
            }
            listQuery.add(item);
        }
        if (!listQuery.isEmpty()) {
            this.queryMarketItems(listQuery, gears);
        }
    }

    @Override
    public void dyeSyc(MarketItem item) {
        if (!this.checkRefItem(item.getRefItem())) {
            return;
        }
        MarketItem old = this.mapInfo.get(item);
        if (old == null) {
            old = this.createItem(item.getRefItem());
        }
        old.setReSub(true);
        if (!this.containsFutSub && "FUT".equals(item.getRefItem().getType())) {
            this.containsFutSub = true;
        }
        if (!old.isSubd()) {
            LinkedList<RefItem> listSub = new LinkedList<RefItem>();
            listSub.add(item.getRefItem());
            this.subMarketItems(listSub, null);
        }
        item.update((Object)old);
        if (item.getRefItem() != null && item.isValidRef()) {
            item.setClear(false);
        }
        item.changed();
    }
}

