/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.data.impl;

import cms.tmx.core.MException;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.pricingit.SecurityServiceApi;
import cms.tmx.http.data.GetIssuesReq;
import cms.tmx.http.data.GetIssuesResp;
import cms.tmx.http.data.IssueInfo;
import cms.tmx.http.data.dto.Fragment;
import cms.tmx.javafx.MxModel;
import cmx.tmx.data.IIssueMng;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class IssueMngImpl
extends MxModel
implements IIssueMng {
    @Inject
    private SecurityServiceApi refMngApi;
    @Inject
    private ExecutorService exe;
    @Inject
    protected HttpBaseApi httpBaseApi;
    private Map<String, IssueInfo> mapItem = new ConcurrentHashMap<String, IssueInfo>();
    private Map<String, List<IssueInfo>> items = new ConcurrentHashMap<String, List<IssueInfo>>();
    private CountDownLatch count = new CountDownLatch(1);

    @Override
    public List<IssueInfo> getIssues(String market) {
        List<IssueInfo> list = this.items.get(market);
        if (list == null) {
            list = new LinkedList<IssueInfo>();
        }
        return list;
    }

    private void loadNeeqIssues() {
        GetIssuesReq req = new GetIssuesReq();
        req.setOpUser(this.httpBaseApi.getHttpOpUser());
        req.setMarket("NEEQ");
        Fragment fragment = new Fragment();
        fragment.setOffset(0);
        fragment.setSize(200);
        req.setFragment(fragment);
        try {
            GetIssuesResp resp = this.refMngApi.getIssues(req);
            List issues = resp.getIssue();
            if (issues == null) {
                this.count.countDown();
                return;
            }
            if (this.items.get("NEEQ") == null) {
                LinkedList list = new LinkedList();
                list.addAll(issues);
                this.items.put("NEEQ", list);
            } else {
                this.items.get("NEEQ").addAll(issues);
            }
            int queryTimes = (int)Math.ceil((double)resp.getFragment().getTotal() * 1.0 / 200.0);
            while (--queryTimes > 0) {
                fragment.setOffset(resp.getFragment().getOffset());
                req.setFragment(fragment);
                resp = this.refMngApi.getIssues(req);
                this.items.get("NEEQ").addAll(issues);
            }
        }
        catch (MException e) {
            this.logger.error("load neeq issues failed", (Throwable)e);
        }
        List<IssueInfo> results = this.items.get("NEEQ");
        if (results != null) {
            for (IssueInfo issueInfo : results) {
                this.mapItem.put(issueInfo.getSecurity().getInstrument().getSecurityId(), issueInfo);
            }
        } else {
            this.logger.error("neeq issues result is null");
        }
        this.count.countDown();
    }

    public void loadIssues() {
        this.exe.execute(() -> this.loadNeeqIssues());
        try {
            this.count.await();
        }
        catch (InterruptedException e) {
            this.logger.error("\u67e5\u8be2\u65b0\u6846\u67b6\u65b0\u4e09\u677f\u53d1\u884c\u9759\u6001\u884c\u60c5\u5f02\u5e38", (Throwable)e);
        }
        this.changed();
    }

    @Override
    public IssueInfo getIssue(String instrument) {
        IssueInfo issueInfo = this.mapItem.get(instrument);
        return issueInfo;
    }

    @Override
    public List<IssueInfo> getIssuesByType(String market, String securitySubType) {
        List<Object> list = this.items.get(market);
        list = list == null ? new LinkedList<IssueInfo>() : list.stream().filter(item -> item.getParams() != null && securitySubType.equals(item.getParams().getUnderlying().getSecuritySubType())).collect(Collectors.toList());
        return list;
    }
}

