/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.data.impl;

import cms.tmx.api.data.IRefApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.data.impl.MarketDataMngImpl;
import cms.tmx.data.impl.RefDataMngImpl;
import cms.tmx.datatype.message.PCcsRefdata;
import cms.tmx.datatype.message.PRefData;
import cms.tmx.entity.data.HkwolunPriceUnit;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.notice.HkwolunRateReport;
import cms.tmx.javafx.MxModel;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.LinkedList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class HkwolunDataMng
extends MxModel {
    public static final String HKWOLUN_QUOTA_CODE = "666666";
    private static final Logger logger = LogManager.getLogger(HkwolunDataMng.class);
    @Inject
    private MarketDataMngImpl mktMng;
    @Inject
    private RefDataMngImpl refMng;
    @Inject
    private IRefApi refApi;
    @Inject
    private MEventService es;

    @PostConstruct
    private void initialize() {
        this.refMng.setHkwolunDataMng(this);
    }

    public void init() {
        this.es.subscribe("server.sub", event -> this.autoReLoadHkwolunRate(event));
        this.subHkwolunQuota();
        this.loadRefRate();
        this.loadPirceUnit();
    }

    public boolean loadRefRate() {
        int reqType = 10;
        String market = "CCS";
        String secType = "HKSTOCK";
        String subType = "";
        String symbol = String.format("%d,%s,%s,%s", reqType, market, secType, subType);
        logger.info("--------load ref rate start: " + symbol);
        try {
            PRefData.SecurityList list = this.refApi.loadRefRate(reqType, market, secType, subType);
            RefItem.updateRate((PRefData.SecurityList)list);
            this.changed();
            logger.info("--------load hkwolun rate done: " + symbol);
        }
        catch (MException | InvalidProtocolBufferException e) {
            logger.error("--------load hkwolun rate failed: " + symbol, e);
            return false;
        }
        return true;
    }

    public PCcsRefdata.HKStockRefRate loadRefRate(String date, String hkmarket) {
        int reqType = 10;
        String market = "CCS";
        String secType = "HKSTOCK";
        String subType = "";
        String symbol = String.format("%d,%s,%s,%s,%s,%s", reqType, market, secType, subType, date, hkmarket);
        logger.info("--------load his hkwolun rate start: " + symbol);
        try {
            PRefData.SecurityList list = this.refApi.loadRefRate(reqType, market, secType, subType, date, hkmarket);
            Any any = list.getObject();
            if (any.is(PCcsRefdata.HKStockRefRate.class)) {
                PCcsRefdata.HKStockRefRate rate = (PCcsRefdata.HKStockRefRate)any.unpack(PCcsRefdata.HKStockRefRate.class);
                logger.info("--------load his hkwolun rate done: " + symbol + rate);
                return rate;
            }
        }
        catch (MException | InvalidProtocolBufferException e) {
            logger.error("--------load his hkwolun rate failed: " + symbol, e);
        }
        return null;
    }

    public boolean loadPirceUnit() {
        int reqType = 11;
        String market = "CCS";
        String secType = "HKSTOCK";
        String subType = "";
        String symbol = String.format("%d,%s,%s,%s", reqType, market, secType, subType);
        logger.info("--------load hkwolun unit start: " + symbol);
        try {
            PRefData.SecurityList list = this.refApi.loadRefRate(reqType, market, secType, subType);
            Any any = list.getObject();
            LinkedList<HkwolunPriceUnit> listUnit = new LinkedList<HkwolunPriceUnit>();
            if (any.is(PCcsRefdata.HKStockPriceUnit.class)) {
                PCcsRefdata.HKStockPriceUnit hkSpu = (PCcsRefdata.HKStockPriceUnit)any.unpack(PCcsRefdata.HKStockPriceUnit.class);
                for (PCcsRefdata.HKStockPriceUnitGroup group : hkSpu.getGroupsList()) {
                    HkwolunPriceUnit hkUnit = new HkwolunPriceUnit();
                    hkUnit.update(group);
                    listUnit.add(hkUnit);
                }
            }
            listUnit.sort((o1, o2) -> o1.getGroupSeq() - o2.getGroupSeq());
            HkwolunPriceUnit.setList(listUnit);
            logger.info("--------load hkwolun unit done: " + symbol);
        }
        catch (MException | InvalidProtocolBufferException e) {
            logger.error("--------load hkwolun unit failed: " + symbol, e);
            return false;
        }
        return true;
    }

    public void subHkwolunQuota() {
        LinkedList<RefItem> list = new LinkedList<RefItem>();
        RefItem refShsc = this.createIndex(HKWOLUN_QUOTA_CODE, "SHSC");
        list.add(refShsc);
        RefItem refSzsc = this.createIndex(HKWOLUN_QUOTA_CODE, "SZSC");
        list.add(refSzsc);
        this.mktMng.getItems(list);
        this.mktMng.getMap().remove(refShsc);
        this.mktMng.getMap().remove(refSzsc);
    }

    private RefItem createIndex(String code, String market) {
        RefItem refItem = new RefItem();
        refItem.setCode(code);
        refItem.setMarket(market);
        MarketItem item = this.mktMng.createItem(0);
        item.setRefItem(refItem);
        return refItem;
    }

    private void autoReLoadHkwolunRate(MEvent event) {
        Object obj = event.getObj();
        if (obj instanceof HkwolunRateReport) {
            HkwolunRateReport report = (HkwolunRateReport)HkwolunRateReport.class.cast(obj);
            PCcsRefdata.HKStockRefRate rate = report.getReport();
            RefItem.updateRate((PCcsRefdata.HKStockRefRate)rate);
            this.changed();
        }
    }
}

