/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.data.impl;

import cms.tmx.core.MAddon;
import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.data.http.RefDataMng;
import cms.tmx.data.impl.ContractServiceImpl;
import cms.tmx.data.impl.HeartBeatMng;
import cms.tmx.data.impl.HkwolunDataMng;
import cms.tmx.data.impl.IndexMarketMng;
import cms.tmx.data.impl.IssueMngImpl;
import cms.tmx.data.impl.MarketDataMngImpl;
import cms.tmx.data.impl.NewMarketDataMngImpl;
import cms.tmx.data.impl.NewRefMngImpl;
import cms.tmx.data.impl.RefDataMngImpl;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.data.StoreRefItem;
import cms.tmx.entity.notice.RefDataReport;
import cmx.tmx.data.IContractService;
import cmx.tmx.data.IIssueMng;
import cmx.tmx.data.IMarketDataMng;
import cmx.tmx.data.INewMarketDataMng;
import cmx.tmx.data.INewRefMng;
import cmx.tmx.data.IRefDataMng;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class DataAddon
extends MAddon {
    @Inject
    private ExecutorService exe;
    @Inject
    private MEventService es;
    @Inject
    private IEclipseContext ctxt;
    @Inject
    private MarketDataMngImpl marketMng;
    @Inject
    private RefDataMngImpl refMng;
    @Inject
    private RefDataMng refMngNew;
    @Inject
    private NewRefMngImpl newRefMng;
    @Inject
    private IssueMngImpl issueMngImpl;
    @Inject
    private IndexMarketMng indexMng;
    @Inject
    private NewMarketDataMngImpl mktMng;
    @Inject
    private ContractServiceImpl contractService;
    @Inject
    private HeartBeatMng hbMng;
    @Inject
    private MConfService cs;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    @Inject
    private HkwolunDataMng hkMng;
    private File commonSuggestionsfile;
    private Map<String, List<RefItem>> userCommonSuggesstionsMap = new HashMap<String, List<RefItem>>();
    private Gson gson = new Gson();

    @PostConstruct
    public void init() {
        this.es.subscribe("stage.pre.login", event -> this.preLogin());
        this.es.subscribe("server.sub", event -> this.autoReLoadRefData(event));
        this.es.subscribe("sub.index.market", event -> this.subIndexMarket());
        this.es.subscribe("stage.after.login", event -> this.hkMng.init());
        this.es.subscribe("on.exit", event -> this.onExit());
        this.ctxt.set(IMarketDataMng.class, (Object)this.marketMng);
        this.ctxt.set(IRefDataMng.class, (Object)this.refMng);
        this.ctxt.set(INewRefMng.class, (Object)this.newRefMng);
        this.ctxt.set(IndexMarketMng.class, (Object)this.indexMng);
        this.ctxt.set(INewMarketDataMng.class, (Object)this.mktMng);
        this.ctxt.set(IContractService.class, (Object)this.contractService);
        this.ctxt.set(IIssueMng.class, (Object)this.issueMngImpl);
        MarketItem.showAll = this.cs.getValueAsBool("market.show.all", false);
        this.eCore.put((Object)"common_use_refitem_map", this.userCommonSuggesstionsMap);
        super.loadDone();
    }

    private void autoReLoadRefData(MEvent event) {
        Object obj = event.getObj();
        if (obj instanceof RefDataReport) {
            RefDataReport report = (RefDataReport)RefDataReport.class.cast(obj);
            String newV = report.getReport().getUpdateVersion();
            String oldV = this.refMng.getVersion();
            if (oldV.equals(newV)) {
                return;
            }
            this.exe.execute(() -> {
                try {
                    int range = 180000;
                    Thread.sleep(new Random().nextInt(range));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.logger.info("ref data version update:" + oldV + " -> " + newV);
                if (RefDataMng.NEW_SECURITY) {
                    this.refMngNew.loadRefData();
                } else {
                    this.refMng.autoReLoad();
                }
            });
        }
    }

    private void subIndexMarket() {
        this.indexMng.subIndexMarkets();
    }

    private void preLogin() {
        this.initCommonRefItemSuggestions();
        this.exe.execute(() -> {
            if (RefDataMng.NEW_SECURITY) {
                this.refMngNew.loadRefData();
            } else {
                this.refMng.onLogin();
            }
            this.newRefMng.loadNewRefData();
            this.issueMngImpl.loadIssues();
        });
    }

    private void initCommonRefItemSuggestions() {
        block15: {
            this.checkFileIsNew();
            BufferedReader bufferedReader = null;
            try {
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.commonSuggestionsfile), "utf-8"));
                    String data = bufferedReader.readLine();
                    Type type = new TypeToken<Map<String, List<StoreRefItem>>>(){}.getType();
                    Map storeMap = (Map)this.gson.fromJson(data, type);
                    for (Map.Entry item : storeMap.entrySet()) {
                        ArrayList<RefItem> refItems = new ArrayList<RefItem>();
                        for (StoreRefItem storeRef : (List)item.getValue()) {
                            RefItem refItem = new RefItem();
                            refItem.update((Object)storeRef);
                            refItems.add(refItem);
                        }
                        this.userCommonSuggesstionsMap.put((String)item.getKey(), refItems);
                    }
                    if (!this.userCommonSuggesstionsMap.containsKey("common_use_ccstrade")) {
                        this.userCommonSuggesstionsMap.put("common_use_ccstrade", new ArrayList());
                    }
                    this.logger.info("\u5e38\u7528\u4ee3\u7801\u8bb0\u5f55\u6210\u529f");
                }
                catch (Exception e) {
                    this.logger.error("\u521d\u59cb\u5316\u7528\u6237\u5e38\u7528\u4ee3\u7801\u5931\u8d25", (Throwable)e);
                    this.userCommonSuggesstionsMap.put("common_use_ccstrade", new ArrayList());
                    if (bufferedReader == null) break block15;
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException e2) {
                        this.logger.error("\u5173\u95ed\u5e38\u7528\u80a1\u7968\u8bb0\u5f55\u6587\u4ef6\u8bfb\u53d6\u6d41\u51fa\u9519", (Throwable)e2);
                    }
                }
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException e) {
                        this.logger.error("\u5173\u95ed\u5e38\u7528\u80a1\u7968\u8bb0\u5f55\u6587\u4ef6\u8bfb\u53d6\u6d41\u51fa\u9519", (Throwable)e);
                    }
                }
            }
        }
    }

    private void checkFileIsNew() {
        String userId = this.eCore.getStr("user_id");
        String postId = this.eCore.getStr("post_id");
        String baseDir = System.getProperty("user.dir");
        Path savePath = Paths.get(baseDir, "data", userId, postId, "suggestion");
        this.commonSuggestionsfile = savePath.toFile();
        File parentFile = this.commonSuggestionsfile.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        if (!this.commonSuggestionsfile.exists()) {
            try {
                this.commonSuggestionsfile.createNewFile();
            }
            catch (IOException e) {
                this.logger.error("\u521b\u5efa\u5e38\u7528\u80a1\u7968\u8bb0\u5f55\u6587\u4ef6\u51fa\u9519", (Throwable)e);
            }
        }
    }

    private void onExit() {
        block16: {
            this.checkFileIsNew();
            BufferedWriter bufferedWriter = null;
            try {
                try {
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.commonSuggestionsfile), "utf-8"));
                    HashMap storeMap = new HashMap();
                    for (Map.Entry<String, List<RefItem>> item : this.userCommonSuggesstionsMap.entrySet()) {
                        ArrayList<StoreRefItem> stores = new ArrayList<StoreRefItem>();
                        for (RefItem ref : item.getValue()) {
                            StoreRefItem storeRefItem = new StoreRefItem(ref);
                            stores.add(storeRefItem);
                        }
                        storeMap.put(item.getKey(), stores);
                    }
                    String data = this.gson.toJson(storeMap);
                    bufferedWriter.write(data);
                    this.logger.info("\u8bb0\u5f55\u7528\u6237\u5e38\u7528\u80a1\u7968\u5b8c\u6210");
                }
                catch (Exception e) {
                    this.logger.error("\u8bb0\u5f55\u7528\u6237\u5e38\u7528\u80a1\u7968\u51fa\u9519", (Throwable)e);
                    if (bufferedWriter != null) {
                        try {
                            bufferedWriter.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

