/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.data.impl;

import cms.tmx.api.data.IContractApi;
import cms.tmx.core.MException;
import cms.tmx.data.impl.ContractFactory;
import cms.tmx.datatype.message.PContractService;
import cms.tmx.entity.data.CtpContract;
import cmx.tmx.data.IContractService;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class ContractServiceImpl
implements IContractService {
    @Inject
    private IContractApi contractApi;
    @Inject
    private ContractFactory contractFactory;
    private static final String DELIMITER = ",";
    private Map<String, Map<String, CtpContract>> mapItem = new ConcurrentHashMap<String, Map<String, CtpContract>>();
    private static final Logger logger = LogManager.getLogger(ContractServiceImpl.class);

    @Override
    public void query(String marketGrp, String market, String contractId, String brokerId, String investorId) throws MException {
        List listQuery = this.contractApi.query(marketGrp, market, contractId, brokerId, investorId);
        for (PContractService.Contract info : listQuery) {
            CtpContract contract = this.contractFactory.createCtpContract();
            contract.update((Object)info);
            this.addContract(contract);
        }
    }

    private void addContract(CtpContract item) {
        String type = String.join((CharSequence)DELIMITER, item.getMarket(), item.getContractId(), item.getBrokerId(), item.getInvestorId());
        Map<String, CtpContract> map = this.mapItem.get(type);
        if (map == null) {
            map = new ConcurrentHashMap<String, CtpContract>();
            this.mapItem.put(type, map);
        }
        String key = String.join((CharSequence)DELIMITER, item.getMarket(), item.getContractId(), item.getBrokerId(), item.getInvestorId());
        map.put(key, item);
    }

    @Override
    public CtpContract getContract(String marketGrp, String market, String code, String brokerId, String investorId) {
        CtpContract item;
        block5: {
            Set<String> keys = this.mapItem.keySet();
            item = null;
            String keyName = String.join((CharSequence)DELIMITER, market, code, brokerId, investorId);
            for (String key : keys) {
                item = this.mapItem.get(key).get(keyName);
                if (item != null) break;
            }
            try {
                if (item != null) break block5;
                this.query(marketGrp, market, code, brokerId, investorId);
                for (String key : keys) {
                    item = this.mapItem.get(key).get(keyName);
                    if (item == null) {
                        continue;
                    }
                    break;
                }
            }
            catch (MException e) {
                logger.error("\u83b7\u53d6\u5355\u4e2a\u5408\u7ea6\u6765\u8ba1\u7b97\u9884\u51bb\u7ed3\u91d1\u989d", (Throwable)e);
            }
        }
        return item;
    }

    @Override
    public List<CtpContract> query(String marketGrp, String brokerId, String investorId) throws MException {
        LinkedList<CtpContract> linkedList = new LinkedList<CtpContract>();
        List listQuery = this.contractApi.query(marketGrp, "", "", brokerId, investorId);
        for (PContractService.Contract info : listQuery) {
            CtpContract contract = this.contractFactory.createCtpContract();
            contract.update((Object)info);
            linkedList.add(contract);
        }
        return linkedList;
    }
}

