/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.data.http;

import cms.tmx.core.MConfService;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.data.CtpRefItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.data.RepoRefItem;
import cms.tmx.entity.data.StdBondForward;
import cms.tmx.entity.data.XBond;
import cms.tmx.entity.trade.ConvertibleBond;
import cms.tmx.entity.trade.PledgeInfo;
import cms.tmx.http.security.api.SecurityServiceImpl;
import cms.tmx.javafx.MxModel;
import cms.tmx.utils.StringUtils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class RefDataMng
extends MxModel {
    private static final Logger logger = LogManager.getLogger(RefDataMng.class);
    @Inject
    private SecurityServiceImpl securityApi;
    @Inject
    private ExecutorService exe;
    @Inject
    private MEventService es;
    @Inject
    private MConfService cs;
    private Map<String, Map<String, RefItem>> mapItem = new ConcurrentHashMap<String, Map<String, RefItem>>();
    private Map<String, String> codeTypeMap = new ConcurrentHashMap<String, String>(1024);
    private BooleanProperty done = new SimpleBooleanProperty(false);
    private IntegerProperty count = new SimpleIntegerProperty(-1);
    public static boolean NEW_SECURITY;
    private static final String DELIMITER = ",";
    private static final String STOCKS = "stocks";

    @PostConstruct
    public void init() {
        NEW_SECURITY = this.cs.getValueAsBool("load.new.security.data", false);
        if (!NEW_SECURITY) {
            return;
        }
        this.count.addListener(ob -> {
            if (this.count.get() == 0) {
                this.setDone(!this.isDone());
            }
        });
        this.es.subscribe("auto_reload_refdata", event -> this.loadRefData());
    }

    public void loadRefData() {
        this.count.set(12);
        this.exe.execute(() -> {
            this.getStocks();
            this.decreaseCount();
        });
        this.exe.execute(() -> {
            this.getNewStocks();
            this.decreaseCount();
        });
        this.exe.execute(() -> {
            this.getHkwoluns();
            this.decreaseCount();
        });
        this.exe.execute(() -> {
            this.getBonds();
            this.decreaseCount();
        });
        this.exe.execute(() -> {
            this.getIssues();
            this.decreaseCount();
        });
        this.exe.execute(() -> {
            this.getPledges();
            this.decreaseCount();
        });
        this.exe.execute(() -> {
            this.getRepos();
            this.decreaseCount();
        });
        this.exe.execute(() -> {
            this.getXRepos();
            this.decreaseCount();
        });
        this.exe.execute(() -> {
            this.getXBonds();
            this.decreaseCount();
        });
        this.exe.execute(() -> {
            this.getFixeds();
            this.decreaseCount();
        });
        this.exe.execute(() -> {
            this.getForwards();
            this.decreaseCount();
        });
        this.exe.execute(() -> {
            this.getFunds();
            this.decreaseCount();
        });
        this.exe.execute(() -> {
            this.getFutures();
            this.decreaseCount();
        });
    }

    public void getInstruments() {
        logger.info("load ref infos start");
        try {
            LinkedList listInfo = new LinkedList();
            listInfo.addAll(this.securityApi.getInstrument("XSHG", STOCKS));
            listInfo.addAll(this.securityApi.getInstrument("XSHE", STOCKS));
            listInfo.forEach(info -> {
                RefItem item = new RefItem();
                item.update(info);
                this.addItem(item);
            });
            logger.info("load ref infos done:" + listInfo.size());
        }
        catch (MException e) {
            logger.error("load ref infos faild", (Throwable)e);
        }
    }

    public void getStocks() {
        logger.info("load ref stocks start");
        try {
            LinkedList listInfo = new LinkedList();
            listInfo.addAll(this.securityApi.getStocks("XSHG"));
            listInfo.addAll(this.securityApi.getStocks("XSHE"));
            listInfo.forEach(info -> {
                RefItem item = new RefItem();
                item.update(info);
                this.addItem(item);
            });
            logger.info("load ref stocks done:" + listInfo.size());
        }
        catch (MException e) {
            logger.error("load ref stocks faild", (Throwable)e);
        }
    }

    public void getHkwoluns() {
        logger.info("load ref hkwoluns start");
        try {
            LinkedList listInfo = new LinkedList();
            listInfo.addAll(this.securityApi.getStocks("SHSC"));
            listInfo.addAll(this.securityApi.getStocks("SZSC"));
            listInfo.forEach(info -> {
                RefItem item = new RefItem();
                item.update(info);
                this.addItem(item);
            });
            logger.info("load ref hkwoluns done:" + listInfo.size());
        }
        catch (MException e) {
            logger.error("load ref hkwoluns faild", (Throwable)e);
        }
    }

    public void getBonds() {
        logger.info("load ref bonds start");
        try {
            LinkedList listInfo = new LinkedList();
            listInfo.addAll(this.securityApi.getBonds("XSHG"));
            listInfo.addAll(this.securityApi.getBonds("XSHE"));
            listInfo.forEach(info -> {
                RefItem item = new RefItem();
                item.update(info);
                this.addItem(item);
            });
            logger.info("load ref bonds done:" + listInfo.size());
        }
        catch (MException e) {
            logger.error("load ref bonds faild", (Throwable)e);
        }
    }

    public void getXBonds() {
        logger.info("load ref xbonds start");
        try {
            LinkedList listInfo = new LinkedList();
            listInfo.addAll(this.securityApi.getXBonds("XCFE"));
            listInfo.forEach(info -> {
                XBond item = new XBond();
                item.update(info);
                this.addItem((RefItem)item);
            });
            logger.info("load ref xbonds done:" + listInfo.size());
        }
        catch (MException e) {
            logger.error("load ref xbonds faild", (Throwable)e);
        }
    }

    public void getForwards() {
        logger.info("load ref forwards start");
        try {
            LinkedList listInfo = new LinkedList();
            listInfo.addAll(this.securityApi.getForwards("XCFE"));
            listInfo.forEach(info -> {
                StdBondForward item = new StdBondForward();
                item.update(info);
                this.addItem((RefItem)item);
            });
            logger.info("load ref forwards done:" + listInfo.size());
        }
        catch (MException e) {
            logger.error("load ref forwards faild", (Throwable)e);
        }
    }

    public void getXRepos() {
        logger.info("load ref xrepos start");
        try {
            LinkedList listInfo = new LinkedList();
            listInfo.addAll(this.securityApi.getRepos("XCFE"));
            listInfo.forEach(info -> {
                if (info.getParams() != null && info.getParams().getRepoType() == 1) {
                    RepoRefItem item = new RepoRefItem();
                    item.update(info);
                    this.addItem((RefItem)item);
                }
            });
            logger.info("load ref xrepos done:" + listInfo.size());
        }
        catch (MException e) {
            logger.error("load ref xrepos faild", (Throwable)e);
        }
    }

    public void getFunds() {
        logger.info("load ref funds start");
        try {
            LinkedList listInfo = new LinkedList();
            listInfo.addAll(this.securityApi.getFunds("XSHG"));
            listInfo.addAll(this.securityApi.getFunds("XSHE"));
            listInfo.forEach(info -> {
                RefItem item = new RefItem();
                item.update(info);
                this.addItem(item);
            });
            logger.info("load ref funds done:" + listInfo.size());
        }
        catch (MException e) {
            logger.error("load ref funds faild", (Throwable)e);
        }
    }

    public void getIssues() {
        logger.info("load ref issues start");
        try {
            LinkedList listInfo = new LinkedList();
            listInfo.addAll(this.securityApi.getIssues("XSHG"));
            listInfo.addAll(this.securityApi.getIssues("XSHE"));
            listInfo.forEach(info -> {
                info.getSecurity().getInstrument().setSecuritySubType("\u53ef\u8f6c\u503a\u7533\u8d2d");
                ConvertibleBond item = new ConvertibleBond();
                item.update(info);
                this.addItem((RefItem)item);
            });
            logger.info("load ref issues done:" + listInfo.size());
        }
        catch (MException e) {
            logger.error("load ref issues faild", (Throwable)e);
        }
    }

    public void getPledges() {
        logger.info("load ref pledges start");
        try {
            LinkedList listInfo = new LinkedList();
            listInfo.addAll(this.securityApi.getPledges("XSHG"));
            listInfo.addAll(this.securityApi.getPledges("XSHE"));
            listInfo.forEach(info -> {
                PledgeInfo item = new PledgeInfo();
                item.update(info);
                this.addItem((RefItem)item);
            });
            logger.info("load ref pledges done:" + listInfo.size());
        }
        catch (MException e) {
            logger.error("load ref pledges faild", (Throwable)e);
        }
    }

    public void getNewStocks() {
        logger.info("load ref newStocks start");
        try {
            LinkedList listInfo = new LinkedList();
            listInfo.addAll(this.securityApi.getNewStocks("XSHG"));
            listInfo.addAll(this.securityApi.getNewStocks("XSHE"));
            listInfo.forEach(info -> {
                info.getSecurity().getInstrument().setSecuritySubType("\u65b0\u80a1\u7533\u8d2d");
                ConvertibleBond item = new ConvertibleBond();
                item.update(info);
                this.addItem((RefItem)item);
            });
            logger.info("load ref newStocks done:" + listInfo.size());
        }
        catch (MException e) {
            logger.error("load ref newStocks faild", (Throwable)e);
        }
    }

    public void getRepos() {
        logger.info("load ref repos start");
        try {
            LinkedList listInfo = new LinkedList();
            listInfo.addAll(this.securityApi.getRepos("XSHG"));
            listInfo.addAll(this.securityApi.getRepos("XSHE"));
            listInfo.forEach(info -> {
                RepoRefItem item = new RepoRefItem();
                item.update(info);
                this.addItem((RefItem)item);
            });
            logger.info("load ref repos done:" + listInfo.size());
        }
        catch (MException e) {
            logger.error("load ref repos faild", (Throwable)e);
        }
    }

    public void getFixeds() {
        logger.info("load ref fixeds start");
        try {
            LinkedList listInfo = new LinkedList();
            listInfo.addAll(this.securityApi.getFixed());
            listInfo.forEach(info -> {
                RefItem item = new RefItem();
                item.update(info);
                this.addItem(item);
            });
            logger.info("load ref fixeds done:" + listInfo.size());
        }
        catch (MException e) {
            logger.error("load ref fixeds faild", (Throwable)e);
        }
    }

    public void getFutures() {
        logger.info("load ref futures start");
        try {
            LinkedList listInfo = new LinkedList();
            listInfo.addAll(this.securityApi.getFutures("SGEX"));
            listInfo.addAll(this.securityApi.getFutures("CCFX"));
            listInfo.forEach(info -> {
                CtpRefItem item = new CtpRefItem();
                item.update(info);
                this.addItem((RefItem)item);
            });
            logger.info("load ref futures done:" + listInfo.size());
        }
        catch (MException e) {
            logger.error("load ref futures faild", (Throwable)e);
        }
    }

    private void addItem(RefItem item) {
        String type = "";
        try {
            String key;
            RefItem old;
            type = item.getType();
            if ("XcfeXBond".equals(item.getSubSecurityType())) {
                type = String.valueOf(type) + item.getSubSecurityType();
            } else if ("SHSC".equals(item.getMarket()) || "SZSC".equals(item.getMarket())) {
                type = String.valueOf(type) + item.getMarket();
            } else if ("FIXED".equals(item.getSubSecurityType())) {
                type = String.valueOf(type) + item.getSubSecurityType();
            } else if ("SGEX".equals(item.getMarket())) {
                type = String.valueOf(type) + item.getMarket();
            } else if ("REPO".equals(item.getType()) && "XCFE".equals(item.getMarket())) {
                type = String.valueOf(type) + item.getMarket();
            }
            this.codeTypeMap.put(item.getCode(), type);
            Map<String, RefItem> map = this.mapItem.get(type);
            if (map == null) {
                map = new ConcurrentHashMap<String, RefItem>();
                this.mapItem.put(type, map);
            }
            if ((old = map.put(key = String.join((CharSequence)DELIMITER, item.getMarket(), item.getCode()), item)) != null && old.isHkWolun()) {
                item.setScale(old.getScale());
                item.setPriceUnit(old.getPriceUnit());
            }
        }
        catch (Exception e) {
            logger.error("\u6dfb\u52a0" + item.getCode() + type + "\u51fa\u9519", (Throwable)e);
        }
    }

    @Deprecated
    public RefItem getItem(String market, String code) {
        RefItem item = null;
        String cacheType = this.codeTypeMap.get(code);
        String keyName = String.join((CharSequence)DELIMITER, market, code);
        if (!StringUtils.isEmpty((String)cacheType) && this.mapItem.get(cacheType) != null) {
            item = this.mapItem.get(cacheType).get(keyName);
        }
        if (item != null) {
            return item;
        }
        Set<String> keys = this.mapItem.keySet();
        for (String key : keys) {
            item = this.mapItem.get(key).get(keyName);
            if (item != null) break;
        }
        return item;
    }

    public RefItem getItem(String type, String market, String code) {
        Map<String, RefItem> map = this.mapItem.get(type);
        if (map == null) {
            return null;
        }
        String subKey = String.join((CharSequence)DELIMITER, market, code);
        return map.get(subKey);
    }

    public Collection<RefItem> getItems(String ... types) {
        LinkedList<RefItem> c = new LinkedList<RefItem>();
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            Map<String, RefItem> map = this.mapItem.get(type);
            if (map == null) {
                map = new ConcurrentHashMap<String, RefItem>();
                this.mapItem.put(type, map);
            }
            c.addAll(map.values());
            ++n2;
        }
        return c;
    }

    public final BooleanProperty doneProperty() {
        return this.done;
    }

    public final boolean isDone() {
        return this.doneProperty().get();
    }

    public final void setDone(boolean done) {
        this.doneProperty().set(done);
    }

    public final IntegerProperty countProperty() {
        return this.count;
    }

    public final int getCount() {
        return this.countProperty().get();
    }

    public final void setCount(int count) {
        this.countProperty().set(count);
    }

    private synchronized void decreaseCount() {
        this.count.set(this.count.get() - 1);
    }
}

