/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.notification.prompt;

import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MScheduler;
import cms.tmx.notification.prompt.BasePromptPart;
import cms.tmx.notification.prompt.Prompt;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.application.Platform;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.stage.Popup;
import javafx.stage.Window;
import javafx.util.Duration;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.controlsfx.control.action.Action;
import org.controlsfx.tools.Utils;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class PromptMng {
    private double startX;
    private double startY;
    private double screenWidth;
    private double screenHeight;
    private final Map<Pos, List<Popup>> popupsMap = new HashMap<Pos, List<Popup>>();
    private final double padding = 15.0;
    private ParallelTransition parallelTransition;
    @Inject
    private ExecutorService exe;
    @Inject
    private MConfService cs;
    @Inject
    protected MScheduler msduler;
    private boolean isShowing = false;
    @Inject
    private static MEventService es;

    @PostConstruct
    private void init() {
        this.exe.execute(() -> {
            this.parallelTransition = new ParallelTransition();
            this.msduler.setInterval(100);
        });
    }

    public void show(Prompt prompt) {
        Window window;
        if (prompt.getOwner() == null) {
            this.initXY(prompt);
            window = Utils.getWindow(null);
        } else {
            this.startX = prompt.getOwner().getX();
            this.startY = prompt.getOwner().getY();
            this.screenWidth = prompt.getOwner().getWidth();
            this.screenHeight = prompt.getOwner().getHeight();
            if (this.startX < 0.0 && this.startY < 0.0) {
                this.initXY(prompt);
            }
            window = prompt.getOwner();
        }
        this.show(window, prompt);
    }

    private void initXY(Prompt prompt) {
        Rectangle2D screenBounds = prompt.getScreen().getVisualBounds();
        this.startX = screenBounds.getMinX();
        this.startY = screenBounds.getMinY();
        this.screenWidth = screenBounds.getWidth();
        this.screenHeight = screenBounds.getHeight();
    }

    private void show(Window owner, final Prompt prompt) {
        final Popup popup = new Popup();
        popup.setAutoFix(false);
        final Pos p = prompt.getPosition();
        BasePromptPart part = new BasePromptPart(this.exe){

            @Override
            public String getTitle() {
                return prompt.getTitle();
            }

            @Override
            public String getText() {
                return prompt.getText();
            }

            @Override
            public Node getGraphic() {
                return prompt.getGraphic();
            }

            @Override
            public boolean isPark() {
                return prompt.isPark();
            }

            @Override
            public ObservableList<Action> getActions() {
                return prompt.getActions();
            }

            @Override
            public boolean isShowing() {
                return PromptMng.this.isShowing;
            }

            @Override
            public boolean isShowFromTop() {
                return PromptMng.this.isShowFromTop(prompt.getPosition());
            }

            @Override
            public void hide() {
                PromptMng.this.isShowing = false;
                PromptMng.this.createHideTimeline(popup, this, p, Duration.ZERO).play();
            }

            @Override
            public boolean isCloseButtonVisible() {
                return !prompt.isHideCloseButton();
            }

            @Override
            public double getContainerHeight() {
                return PromptMng.this.startY + PromptMng.this.screenHeight;
            }

            @Override
            public void relocateInParent(double x, double y) {
                switch (p) {
                    case BOTTOM_LEFT: 
                    case BOTTOM_CENTER: 
                    case BOTTOM_RIGHT: {
                        popup.setAnchorY(y - 15.0);
                        break;
                    }
                }
            }
        };
        part.getPane().getStyleClass().clear();
        part.getPane().getStyleClass().add((Object)"root");
        String theme = this.cs.getUserProps().get("app_theme");
        part.getPane().getStyleClass().add((Object)(theme == null || theme.isEmpty() ? "blue-theme" : theme));
        part.setCd((int)prompt.getLife().toSeconds());
        part.setOnMouseClicked(e -> {
            if (prompt.getHandler() != null) {
                ActionEvent actionEvent = new ActionEvent((Object)part, (EventTarget)part);
                prompt.getHandler().handle((Event)actionEvent);
                this.createHideTimeline(popup, part, p, Duration.ZERO).play();
            }
        });
        popup.getContent().add((Object)part);
        popup.show(owner, 0.0, 0.0);
        double anchorX = 0.0;
        double anchorY = 0.0;
        double barWidth = part.getWidth();
        double barHeight = part.getHeight();
        switch (p) {
            case TOP_LEFT: 
            case CENTER_LEFT: 
            case BOTTOM_LEFT: {
                anchorX = 15.0 + this.startX;
                break;
            }
            case TOP_CENTER: 
            case CENTER: 
            case BOTTOM_CENTER: {
                anchorX = this.startX + this.screenWidth / 2.0 - barWidth / 2.0 - 7.5;
                break;
            }
            default: {
                anchorX = this.startX + this.screenWidth - barWidth - 15.0;
            }
        }
        switch (p) {
            case TOP_LEFT: 
            case TOP_CENTER: 
            case TOP_RIGHT: {
                anchorY = 15.0 + this.startY;
                break;
            }
            case CENTER_LEFT: 
            case CENTER: 
            case CENTER_RIGHT: {
                anchorY = this.startY + this.screenHeight / 2.0 - barHeight / 2.0 - 7.5;
                break;
            }
            default: {
                anchorY = this.startY + this.screenHeight - barHeight - 15.0;
            }
        }
        popup.setAnchorX(anchorX);
        popup.setAnchorY(anchorY);
        this.isShowing = true;
        part.doShow();
        this.addPopupToMap(p, popup);
        if (!part.isPark()) {
            Timeline timeline = this.createHideTimeline(popup, part, p, prompt.getLife());
            timeline.play();
        }
    }

    private void hide(Popup popup, Pos p) {
        popup.hide();
        this.removePopupFromMap(p, popup);
        BasePromptPart part = (BasePromptPart)((Object)BasePromptPart.class.cast(popup.getContent().get(0)));
        if (part.isPark()) {
            this.doAnimation(Pos.BOTTOM_RIGHT);
        }
    }

    private Timeline createHideTimeline(final Popup popup, BasePromptPart bar, final Pos p, Duration startDelay) {
        KeyValue fadeOutBegin = new KeyValue((WritableValue)bar.opacityProperty(), (Object)1.0);
        KeyValue fadeOutEnd = new KeyValue((WritableValue)bar.opacityProperty(), (Object)0.0);
        KeyFrame kfBegin = new KeyFrame(Duration.ZERO, new KeyValue[]{fadeOutBegin});
        KeyFrame kfEnd = new KeyFrame(Duration.millis((double)500.0), new KeyValue[]{fadeOutEnd});
        Timeline timeline = new Timeline(new KeyFrame[]{kfBegin, kfEnd});
        timeline.setDelay(startDelay);
        timeline.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                PromptMng.this.hide(popup, p);
            }
        });
        return timeline;
    }

    private void addPopupToMap(Pos p, Popup popup) {
        List<Object> popups;
        if (!this.popupsMap.containsKey(p)) {
            popups = new ArrayList();
            this.popupsMap.put(p, popups);
        } else {
            popups = this.popupsMap.get(p);
        }
        popups.add(popup);
        this.msduler.schedule(e -> Platform.runLater(() -> this.doAnimation(p)));
    }

    private void removePopupFromMap(Pos p, Popup popup) {
        if (this.popupsMap.containsKey(p)) {
            List<Popup> popups = this.popupsMap.get(p);
            popups.remove(popup);
        }
    }

    private synchronized void doAnimation(Pos p) {
        List<Popup> popups = this.popupsMap.get(p);
        if (popups == null) {
            return;
        }
        this.parallelTransition.stop();
        this.parallelTransition.getChildren().clear();
        boolean isShowFromTop = this.isShowFromTop(p);
        LinkedList<Popup> listPark = new LinkedList<Popup>();
        LinkedList<Popup> listBrevity = new LinkedList<Popup>();
        popups.forEach(popup -> {
            BasePromptPart part = (BasePromptPart)((Object)((Object)BasePromptPart.class.cast(popup.getContent().get(0))));
            if (part.isPark()) {
                listPark.add((Popup)popup);
            } else {
                listBrevity.add((Popup)popup);
            }
        });
        boolean isFirst = listPark.isEmpty();
        double sumBrevity = 0.0;
        sumBrevity = this.calTargetAnchors(listPark, isShowFromTop, sumBrevity, true, !isFirst);
        this.calTargetAnchors(listBrevity, isShowFromTop, sumBrevity, false, isFirst);
        this.parallelTransition.play();
    }

    private double calTargetAnchors(List<Popup> popups, boolean isShowFromTop, double sum, boolean isPark, boolean isFirst) {
        int i = popups.size() - 1;
        while (i >= 0) {
            Popup proup = popups.get(i);
            double popupHeight = ((Node)proup.getContent().get(0)).getBoundsInParent().getHeight();
            BasePromptPart part = (BasePromptPart)((Object)BasePromptPart.class.cast(proup.getContent().get(0)));
            if (isPark && i + 3 < popups.size()) {
                part.setVisible(false);
            } else {
                if (isPark && i < 0) {
                    return sum;
                }
                part.setVisible(true);
                if (isShowFromTop) {
                    sum = i == popups.size() - 1 ? this.startY + this.screenHeight + 15.0 : (sum += popupHeight);
                } else if (isFirst) {
                    sum = this.screenHeight - popupHeight;
                    isFirst = false;
                } else {
                    sum -= popupHeight;
                }
                double anchorYTarget = sum;
                if (!isPark && anchorYTarget < 0.0) {
                    proup.hide();
                }
                double oldAnchorY = proup.getAnchorY();
                double distance = anchorYTarget - oldAnchorY;
                CustomTransition t = new CustomTransition(proup, oldAnchorY, distance);
                t.setCycleCount(1);
                this.parallelTransition.getChildren().add((Object)t);
            }
            --i;
        }
        return sum;
    }

    private boolean isShowFromTop(Pos p) {
        switch (p) {
            case TOP_LEFT: 
            case TOP_CENTER: 
            case TOP_RIGHT: {
                return true;
            }
        }
        return false;
    }

    public static void check(String type, boolean check, boolean isPark) {
        MEvent event = new MEvent();
        event.setObj((Object)type);
        event.put((Object)type, (Object)(check ? "3" : (isPark ? "2" : "1")));
        es.sendEvent("topic.prompt", event);
    }

    class CustomTransition
    extends Transition {
        private WeakReference<Popup> popupWeakReference;
        private double oldAnchorY;
        private double distance;

        CustomTransition(Popup popup, double oldAnchorY, double distance) {
            this.popupWeakReference = new WeakReference<Popup>(popup);
            this.oldAnchorY = oldAnchorY;
            this.distance = distance;
            this.setCycleDuration(Duration.millis((double)350.0));
        }

        protected void interpolate(double frac) {
            Popup popup = (Popup)this.popupWeakReference.get();
            if (popup != null) {
                double newAnchorY = this.oldAnchorY + this.distance * frac;
                popup.setAnchorY(newAnchorY);
            }
        }
    }
}

