/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.notification.prompt;

import cms.tmx.notification.prompt.Prompt;
import cms.tmx.notification.prompt.PromptMng;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.NotificationPane;
import org.controlsfx.control.action.Action;

public abstract class BasePromptPart
extends Region {
    private static final Logger logger = LogManager.getLogger(Prompt.class);
    private static final String FXML = "BasePromptPart.fxml";
    private static final double MIN_HEIGHT = 40.0;
    @FXML
    protected AnchorPane pane;
    @FXML
    private HBox hbTitle;
    @FXML
    private Label lbTitle;
    @FXML
    private Button btnClose;
    private ExecutorService exe;
    @FXML
    private Label lbCont;
    @FXML
    private CheckBox cBox;
    @FXML
    private Label lbCd;
    private Parent parent;
    private volatile IntegerProperty cd = new SimpleIntegerProperty();
    public DoubleProperty transition = new SimpleDoubleProperty(){

        protected void invalidated() {
            BasePromptPart.this.layoutChildren();
        }
    };
    private final Duration TRANSITION_DURATION = new Duration(350.0);
    private Timeline timeline;
    private double transitionStartValue;

    public void loadFXML() {
        FXMLLoader loader = new FXMLLoader();
        loader.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        loader.setLocation(((Object)((Object)this)).getClass().getResource(FXML));
        loader.setController((Object)this);
        try {
            this.parent = (Parent)loader.load();
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    public String getTitle() {
        return "";
    }

    public boolean isCloseButtonVisible() {
        return true;
    }

    public abstract String getText();

    public abstract boolean isPark();

    public abstract Node getGraphic();

    public abstract ObservableList<Action> getActions();

    public abstract void hide();

    public abstract boolean isShowing();

    public abstract boolean isShowFromTop();

    public abstract double getContainerHeight();

    public abstract void relocateInParent(double var1, double var3);

    public BasePromptPart() {
        this.loadFXML();
        this.getChildren().setAll((Object[])new Node[]{this.parent});
        this.setVisible(this.isShowing());
        String titleStr = this.getTitle();
        if (titleStr != null && !titleStr.isEmpty()) {
            this.lbTitle.setText(titleStr);
        }
        this.lbCont.setText(this.getText());
        this.lbCont.setGraphic(this.getGraphic());
        this.btnClose.setOnAction(event -> this.hide());
        StackPane graphic = new StackPane();
        graphic.getStyleClass().add((Object)"graphic");
        this.btnClose.setGraphic((Node)graphic);
        this.btnClose.setFocusTraversable(false);
        this.parent.opacityProperty().bind((ObservableValue)this.transition);
        this.cBox.selectedProperty().addListener((ob, old, now) -> PromptMng.check(this.getTitle(), now, this.isPark()));
        if (!this.isPark()) {
            this.countDown();
        } else {
            this.lbCd.setText("");
        }
    }

    public BasePromptPart(ExecutorService exe) {
        this.exe = exe;
        this.loadFXML();
        this.getChildren().setAll((Object[])new Node[]{this.parent});
        this.setVisible(this.isShowing());
        String titleStr = this.getTitle();
        if (titleStr != null && !titleStr.isEmpty()) {
            this.lbTitle.setText(titleStr);
        }
        this.lbCont.setText(this.getText());
        this.lbCont.setGraphic(this.getGraphic());
        this.btnClose.setOnAction(event -> this.hide());
        StackPane graphic = new StackPane();
        graphic.getStyleClass().add((Object)"graphic");
        this.btnClose.setGraphic((Node)graphic);
        this.btnClose.setFocusTraversable(false);
        this.parent.opacityProperty().bind((ObservableValue)this.transition);
        this.cBox.selectedProperty().addListener((ob, old, now) -> PromptMng.check(this.getTitle(), now, this.isPark()));
        if (!this.isPark()) {
            this.countDown();
        } else {
            this.lbCd.setText("");
        }
    }

    protected void layoutChildren() {
        double w = this.getWidth();
        double h = this.computePrefHeight(-1.0);
        double notificationBarHeight = this.prefHeight(w);
        double notificationMinHeight = this.minHeight(w);
        if (this.isShowFromTop()) {
            this.parent.resize(w, h);
            this.relocateInParent(0.0, (this.transition.get() - 1.0) * notificationMinHeight);
        } else {
            this.parent.resize(w, notificationBarHeight);
        }
    }

    protected double computeMinHeight(double width) {
        return Math.max(super.computePrefHeight(width), 40.0);
    }

    protected double computePrefHeight(double width) {
        return Math.max(this.parent.prefHeight(width), this.minHeight(width)) * this.transition.get();
    }

    public void doShow() {
        this.transitionStartValue = 0.0;
        this.doAnimationTransition();
    }

    public void doHide() {
        this.transitionStartValue = 1.0;
        this.doAnimationTransition();
    }

    private void doAnimationTransition() {
        KeyFrame k2;
        KeyFrame k1;
        Duration duration;
        if (this.timeline != null && this.timeline.getStatus() != Animation.Status.STOPPED) {
            duration = this.timeline.getCurrentTime();
            duration = duration == Duration.ZERO ? this.TRANSITION_DURATION : duration;
            this.transitionStartValue = this.transition.get();
            this.timeline.stop();
        } else {
            duration = this.TRANSITION_DURATION;
        }
        this.timeline = new Timeline();
        this.timeline.setCycleCount(1);
        if (this.isShowing()) {
            k1 = new KeyFrame(Duration.ZERO, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    BasePromptPart.this.setCache(true);
                    BasePromptPart.this.setVisible(true);
                    BasePromptPart.this.parent.fireEvent(new Event(NotificationPane.ON_SHOWING));
                }
            }, new KeyValue[]{new KeyValue((WritableValue)this.transition, (Object)this.transitionStartValue)});
            k2 = new KeyFrame(duration, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    BasePromptPart.this.parent.setCache(false);
                    BasePromptPart.this.parent.fireEvent(new Event(NotificationPane.ON_SHOWN));
                }
            }, new KeyValue[]{new KeyValue((WritableValue)this.transition, (Object)1, Interpolator.EASE_OUT)});
        } else {
            k1 = new KeyFrame(Duration.ZERO, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    BasePromptPart.this.parent.setCache(true);
                    BasePromptPart.this.parent.fireEvent(new Event(NotificationPane.ON_HIDING));
                }
            }, new KeyValue[]{new KeyValue((WritableValue)this.transition, (Object)this.transitionStartValue)});
            k2 = new KeyFrame(duration, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    BasePromptPart.this.setCache(false);
                    BasePromptPart.this.setVisible(false);
                    BasePromptPart.this.parent.fireEvent(new Event(NotificationPane.ON_HIDDEN));
                }
            }, new KeyValue[]{new KeyValue((WritableValue)this.transition, (Object)0, Interpolator.EASE_IN)});
        }
        this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{k1, k2});
        this.timeline.play();
    }

    public IntegerProperty cdProperty() {
        return this.cd;
    }

    public int getCd() {
        return this.cdProperty().get();
    }

    public void setCd(int cd) {
        this.cdProperty().set(cd);
    }

    private void countDown() {
        this.lbCd.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> String.valueOf(this.cd.get()) + "\u79d2\u540e\u81ea\u52a8\u5173\u95ed", (Observable[])new Observable[]{this.cd}));
        this.exe.execute(() -> {
            while (this.cd.get() > 0) {
                try {
                    TimeUnit.SECONDS.sleep(1L);
                    Platform.runLater(() -> this.cd.set(this.cd.get() - 1));
                }
                catch (InterruptedException e) {
                    logger.error("baskprompt InterruptedException " + Thread.currentThread(), (Throwable)e);
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        });
    }

    public AnchorPane getPane() {
        return this.pane;
    }

    public void setPane(AnchorPane pane) {
        this.pane = pane;
    }

    public void setExe(ExecutorService exe) {
        this.exe = exe;
    }
}

