/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.notification.message;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MScheduler;
import cms.tmx.core.utils.DesEncrypt;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.notification.IMessage;
import cms.tmx.notification.message.Message;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class MessageMng {
    private List<Message> all = new LinkedList<Message>();
    private ObservableList<Message> list = FxUtils.newList();
    private StringProperty search = new SimpleStringProperty("");
    public ObservableList<String> validType = FxUtils.newList();
    public BooleanProperty changed = new SimpleBooleanProperty();
    private File file;
    private File fileType;
    private static final Logger logger = LogManager.getLogger(Message.class);
    @Inject
    private MEventService es;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    @Inject
    private MScheduler se;
    @Inject
    private MScheduler seAdd;
    private static final int LOG_INTERVAL = 30000;
    private static final int ADD_INTERVAL = 1000;
    private List<Message> messages = new ArrayList<Message>();
    private ReentrantLock msgLock = new ReentrantLock();
    private ReentrantLock validLock = new ReentrantLock();
    private List<Message> cacheList = new ArrayList<Message>();

    @PostConstruct
    public void init() {
        this.es.subscribe("stage.pre.login", event -> this.loadMessageLog());
        this.es.subscribe("on.exit", event -> this.recordCache());
        this.se.setInterval(30000);
        this.seAdd.setInterval(1000);
        this.search.addListener(ob -> this.filterMsg());
    }

    private void initValidType() {
        LinkedList<String> list;
        block16: {
            list = new LinkedList<String>();
            ObjectInputStream oos = null;
            if (this.fileType.length() != 0L) {
                try {
                    try {
                        FileInputStream fis = new FileInputStream(this.fileType);
                        oos = new ObjectInputStream(fis);
                        list.addAll((List)oos.readObject());
                    }
                    catch (Exception e) {
                        logger.error("\u6d88\u606f\u63d0\u793a\u7c7b\u522b\u52fe\u9009\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25" + e);
                        if (oos != null) {
                            try {
                                oos.close();
                            }
                            catch (IOException e2) {
                                logger.error("\u6d88\u606f\u63d0\u793a\u7c7b\u522b\u52fe\u9009\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25" + e2);
                            }
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (oos != null) {
                        try {
                            oos.close();
                        }
                        catch (IOException e) {
                            logger.error("\u6d88\u606f\u63d0\u793a\u7c7b\u522b\u52fe\u9009\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25" + e);
                        }
                    }
                    throw throwable;
                }
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException e) {
                        logger.error("\u6d88\u606f\u63d0\u793a\u7c7b\u522b\u52fe\u9009\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25" + e);
                    }
                }
            }
        }
        if (list.isEmpty()) {
            list.add("\u5168\u90e8");
            list.addAll(IMessage.TIPS_MAP.keySet());
        }
        this.validType.addAll(list);
        this.validType.addListener(ob -> this.filterMsg());
    }

    private void filterMsg() {
        this.validLock.lock();
        this.list.clear();
        for (Message msg : this.all) {
            if (!msg.getCont().contains(this.getSearch()) && !msg.getAccount().contains(this.getSearch()) || !this.validType.contains((Object)"\u5168\u90e8") && !this.validType.contains((Object)msg.getType())) continue;
            this.list.add((Object)msg);
        }
        this.validLock.unlock();
    }

    @PreDestroy
    public void onModelClose() {
        block12: {
            ObjectOutputStream oos = null;
            try {
                try {
                    FileOutputStream fis = new FileOutputStream(this.fileType);
                    oos = new ObjectOutputStream(fis);
                    oos.writeObject(new LinkedList<String>((Collection<String>)this.validType));
                }
                catch (IOException e) {
                    logger.error("\u6d88\u606f\u63d0\u793a\u7c7b\u522b\u52fe\u9009\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25" + e);
                    if (oos == null) break block12;
                    try {
                        oos.close();
                    }
                    catch (IOException e2) {
                        logger.error("\u6d88\u606f\u63d0\u793a\u7c7b\u522b\u52fe\u9009\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25" + e2);
                    }
                }
            }
            finally {
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException e) {
                        logger.error("\u6d88\u606f\u63d0\u793a\u7c7b\u522b\u52fe\u9009\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25" + e);
                    }
                }
            }
        }
    }

    public synchronized void record(Message message) {
        this.validLock.lock();
        try {
            this.all.add(0, message);
            this.addToTable(message);
        }
        finally {
            this.validLock.unlock();
        }
        this.msgLock.lock();
        try {
            this.messages.add(message);
        }
        finally {
            this.msgLock.unlock();
        }
        this.runRecord();
    }

    private void addToTable(Message message) {
        if (this.validType.contains((Object)message.getType())) {
            this.cacheList.add(0, message);
        }
        this.runAsynAdd();
    }

    private void runAsynAdd() {
        this.seAdd.schedule(event -> {
            this.validLock.lock();
            ArrayList<Message> newList = new ArrayList<Message>();
            try {
                newList.addAll(this.cacheList);
                this.cacheList.clear();
            }
            finally {
                this.validLock.unlock();
            }
            Platform.runLater(() -> this.list.addAll(0, (Collection)newList));
        });
    }

    private void runRecord() {
        this.se.schedule(event -> this.recordCache());
    }

    private void recordCache() {
        this.msgLock.lock();
        ArrayList<Message> records = new ArrayList<Message>();
        try {
            records.addAll(this.messages);
            this.messages.clear();
        }
        finally {
            this.msgLock.unlock();
        }
        Gson gson = new Gson();
        try (PrintWriter pw = null;){
            try {
                pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file, true), "UTF-8"));
                for (Message msg : records) {
                    pw.println(DesEncrypt.encrypt((String)gson.toJson((Object)msg)));
                }
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u8bb0\u5f55\u8f93\u51fa\u6d41\u5931\u8d25:" + e);
                if (pw != null) {
                    pw.close();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadMessageLog() {
        this.checkFileIsNew();
        this.initValidType();
        BufferedReader br = null;
        try {
            try {
                FileInputStream fis = new FileInputStream(this.file);
                InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                br = new BufferedReader(isr);
                String line = null;
                LinkedList<String> lines = new LinkedList<String>();
                while ((line = br.readLine()) != null) {
                    try {
                        lines.add(DesEncrypt.decrypt((String)line, (String)"SsdfDfdLfFgAsJafSFgasN2f14wfe"));
                    }
                    catch (Exception exception) {
                        logger.error("\u5355\u6761\u6570\u636e\u89e3\u5bc6\u5931\u8d25");
                    }
                }
                LinkedList<Message> listMsg = new LinkedList<Message>();
                Gson gson = new Gson();
                for (String json : lines) {
                    try {
                        Message msg = (Message)gson.fromJson(json, Message.class);
                        listMsg.add(0, msg);
                    }
                    catch (Exception e) {
                        logger.error("\u5355\u6761\u6570\u636e\u8f6c\u6362\u51fa\u9519\uff1a" + json, (Throwable)e);
                    }
                }
                Platform.runLater(() -> {
                    this.all.addAll(listMsg);
                    this.filterMsg();
                });
                return;
            }
            catch (FileNotFoundException e) {
                logger.error("file not found exception", (Throwable)e);
                if (br == null) return;
                try {
                    br.close();
                    return;
                }
                catch (IOException e2) {
                    logger.error("io exception", (Throwable)e2);
                }
                return;
            }
            catch (IOException e) {
                logger.error("io exception", (Throwable)e);
                if (br == null) return;
                try {
                    br.close();
                    return;
                }
                catch (IOException e3) {
                    logger.error("io exception", (Throwable)e3);
                }
                return;
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    logger.error("io exception", (Throwable)e);
                }
            }
        }
    }

    private void checkFileIsNew() {
        String userId = this.eCore.getStr("user_id");
        String postId = this.eCore.getStr("post_id");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String today = sdf.format(new Date());
        String baseDir = System.getProperty("user.dir");
        Path savePath = Paths.get(baseDir, "message", userId, postId, String.valueOf(today) + ".msg");
        this.file = savePath.toFile();
        File parentFile = this.file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        File[] fileArray = parentFile.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (!f.getName().equals(this.file.getName()) && !f.getName().equals("type.msg")) {
                f.delete();
            }
            ++n2;
        }
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        Path typePath = Paths.get(baseDir, "message", userId, postId, "type.msg");
        this.fileType = typePath.toFile();
        if (!this.fileType.exists()) {
            try {
                this.fileType.createNewFile();
            }
            catch (IOException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    public ObservableList<Message> getList() {
        return this.list;
    }

    public ObservableList<String> getValidTypes() {
        return this.validType;
    }

    public void setValidTypes(List<String> types) {
        this.validType.setAll(types);
    }

    public final StringProperty searchProperty() {
        return this.search;
    }

    public final String getSearch() {
        return (String)this.searchProperty().get();
    }

    public final void setSearch(String search) {
        this.searchProperty().set((Object)search);
    }
}

