/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.notification.message;

import cms.tmx.notification.IMessage;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class Message
implements Serializable {
    private static final long serialVersionUID = 8636559488748656233L;
    private String time = "";
    private String account = "";
    private String type = "";
    private String cont = "";
    private transient String checkType = "";
    private boolean isPark;

    public Message() {
        this.setTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("MM-dd HH:mm:ss.SSS")));
    }

    public void update(IMessage imsg) {
        this.setAccount(imsg.getAccount());
        this.setType(imsg.getType());
        this.setCont(imsg.getCont());
        this.setCheckType(imsg.getCheckType());
        this.setPark(imsg.isPark());
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCont() {
        return this.cont;
    }

    public void setCont(String cont) {
        this.cont = "  " + cont;
    }

    public String getCheckType() {
        return this.checkType;
    }

    public void setCheckType(String checkType) {
        this.checkType = checkType;
    }

    public String toString() {
        return String.join((CharSequence)"  ", this.time, this.account, this.type, this.cont);
    }

    public boolean isPark() {
        return this.isPark;
    }

    public void setPark(boolean isPark) {
        this.isPark = isPark;
    }
}

