/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.notification.impl;

import cms.tmx.core.MConfService;
import cms.tmx.core.MEventService;
import cms.tmx.core.MObjFactory;
import cms.tmx.notification.IMessage;
import cms.tmx.notification.INotifyService;
import cms.tmx.notification.IPrompt;
import cms.tmx.notification.message.Message;
import cms.tmx.notification.message.MessageMng;
import cms.tmx.notification.prompt.Prompt;
import cms.tmx.notification.prompt.PromptMng;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javafx.application.Platform;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import javafx.util.Pair;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class INotifiyServiceImpl
implements INotifyService {
    private LinkedBlockingQueue<Pair<Long, Message>> queue = new LinkedBlockingQueue(100);
    private static final Logger logger = LogManager.getLogger(INotifiyServiceImpl.class);
    @Inject
    private MObjFactory of;
    @Inject
    private MessageMng messageMng;
    @Inject
    private PromptMng promptMng;
    @Inject
    private MEventService es;
    @Inject
    private ExecutorService exe;
    private Future<?> future;
    @Inject
    private MConfService cs;
    private AtomicLong time = new AtomicLong(0L);
    private AtomicInteger count = new AtomicInteger(0);

    @PostConstruct
    public void init() {
        this.es.subscribe("stage.after.login", event -> {
            this.future = this.exe.submit(() -> this.onTake());
        });
    }

    @Override
    public void recordData(IMessage data) {
        Message message = new Message();
        message.update(data);
        this.messageMng.record(message);
    }

    @Override
    public void recordShow(IMessage data) {
        Message message = new Message();
        message.update(data);
        this.messageMng.record(message);
        Long now = System.currentTimeMillis();
        if (this.count.get() == 0) {
            this.time.set(now);
        }
        if (data.isPark()) {
            Long time = System.currentTimeMillis();
            Pair pair = new Pair((Object)time, (Object)message);
            this.queue.offer((Pair<Long, Message>)pair);
        } else if (this.count.get() < 5) {
            this.count.incrementAndGet();
            Long time = System.currentTimeMillis();
            Pair pair = new Pair((Object)time, (Object)message);
            this.queue.offer((Pair<Long, Message>)pair);
        }
        if (now - this.time.get() > 5000L) {
            this.count.set(0);
        }
    }

    @Override
    public void recordError(final String data) {
        this.recordShow(new IMessage(){

            @Override
            public String getType() {
                return "\u7cfb\u7edf\u5f02\u5e38 ";
            }

            @Override
            public String getCont() {
                return data;
            }

            @Override
            public String getAccount() {
                return "";
            }
        });
    }

    @Override
    public void notifyUser(IPrompt data) {
        Stage stage = (Stage)this.of.getContext().get(Stage.class);
        Window owner = data.getWindow();
        if (owner == null && stage == null) {
            return;
        }
        Prompt prompt = new Prompt();
        prompt.setTitle(data.getTitle());
        prompt.setText(data.getContent());
        prompt.setCheckType(data.getCheckType());
        prompt.setLife(Duration.seconds((double)data.getLife()));
        prompt.setPark(data.isPark());
        Platform.runLater(() -> {
            prompt.owner(owner == null ? stage : owner);
            this.promptMng.show(prompt);
        });
    }

    private void onTake() {
        if (!this.cs.getValueAsBool("record.pop", true)) {
            return;
        }
        try {
            while (true) {
                Pair<Long, Message> pair = this.queue.take();
                this.notifyUser(this.convert((Message)pair.getValue()));
            }
        }
        catch (InterruptedException e) {
            logger.error("[take prompt] dequeue failed: " + Thread.currentThread(), (Throwable)e);
            Thread.currentThread().interrupt();
            throw new RuntimeException();
        }
    }

    @PreDestroy
    private void close() {
        if (this.future != null) {
            this.future.cancel(true);
        }
    }

    private IPrompt convert(final Message data) {
        IPrompt prompt = new IPrompt(){

            @Override
            public String getTitle() {
                return data.getType();
            }

            @Override
            public String getContent() {
                StringBuffer content = new StringBuffer();
                String acc = data.getAccount();
                if (!acc.isEmpty()) {
                    content.append(acc);
                }
                content.append(data.getCont());
                return content.toString();
            }

            @Override
            public String getCheckType() {
                return data.getCheckType();
            }

            @Override
            public boolean isPark() {
                return data.isPark();
            }
        };
        return prompt;
    }
}

