/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.viewers.basket;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.DateStrConverter;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.utils.DatePickerUtils;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.User;
import cms.tmx.entity.trade.WorkflowTemplete;
import cms.tmx.entity.trade.basket.BasketTradeItem;
import cms.tmx.entity.trade.instruction.AppointedTraderSetting;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.trade.utils.ItemPriceCell;
import cms.tmx.utils.StringUtils;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableObjectValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.controlsfx.control.CheckComboBox;

public class MarginBasketEntrustConfirmDialog
extends DialogObj {
    @FXML
    private TableView<BasketTradeItem> tableItems;
    @FXML
    private TableColumn<BasketTradeItem, String> index;
    @FXML
    private TableColumn<BasketTradeItem, String> colCode;
    @FXML
    private TableColumn<BasketTradeItem, String> colName;
    @FXML
    private TableColumn<BasketTradeItem, String> colBasketName;
    @FXML
    private TableColumn<BasketTradeItem, MxNode> colMkt;
    @FXML
    private TableColumn<BasketTradeItem, MxNode> colDirection;
    @FXML
    private TableColumn<BasketTradeItem, Number> colCount;
    @FXML
    private TableColumn<BasketTradeItem, Object> colTrader;
    @FXML
    private TableColumn<BasketTradeItem, String> colStrategy;
    @FXML
    private TableColumn<BasketTradeItem, Number> colPrice;
    @FXML
    private TableColumn<BasketTradeItem, Number> colAmt;
    @FXML
    private TableColumn<BasketTradeItem, Number> colTotalAmt;
    @FXML
    private TableColumn<BasketTradeItem, CcsFundAccount> colAcc;
    @FXML
    private TableColumn<BasketTradeItem, SecAccount> colSecAcc;
    @FXML
    private TableColumn<BasketTradeItem, String> colPorfolio;
    @FXML
    private TableColumn<BasketTradeItem, String> colTip;
    @FXML
    private TableColumn<BasketTradeItem, Object> colExpiredDate;
    @FXML
    private TableColumn<BasketTradeItem, String> colBasketTip;
    @FXML
    private String entrustInfo = "";
    @FXML
    private Label lbTotalCount;
    @FXML
    private Label lbEntrustInfo;
    @FXML
    private Label lbTotalAmt;
    @FXML
    private Label totalTip;
    @FXML
    private Tooltip tpTip;
    private ObservableList<BasketTradeItem> list;
    private long totalCount;
    private double totalAmt;
    private String strTip = "";
    private Map<CcsFundAccount, Double> accBuyMap = new HashMap<CcsFundAccount, Double>();
    private boolean triggered = false;
    private String bsSymbol = "";
    private boolean isExecution = false;
    private boolean isInstruction = false;
    private String errorInfo = "";
    private String basketSide = "";
    private String instructionType = "";
    private String instructionPanelType = "";
    private boolean showWarning = true;
    @Inject
    private MxAlert alert;
    private Map<FundAccount, String> insExpiredMap = new HashMap<FundAccount, String>();
    private Map<FundAccount, AppointedTraderSetting> fundTraderMap = new HashMap<FundAccount, AppointedTraderSetting>();

    public void setList(ObservableList<BasketTradeItem> list) {
        this.list = list;
    }

    private void calTotalInfo() {
        this.showWarning = false;
        this.totalCount = 0L;
        this.totalAmt = 0.0;
        this.strTip = "";
        for (BasketTradeItem item : this.list) {
            if (this.isBuy(item)) {
                double num = item.getBuyAmt().doubleValue();
                if (this.accBuyMap.containsKey(item.getAcc())) {
                    num = this.accBuyMap.get(item.getAcc()) + num;
                }
                this.accBuyMap.put(item.getAcc(), num);
            }
            this.totalCount += this.isBuy(item) ? item.getBuyCount() : item.getSellCount();
            this.totalAmt += this.isBuy(item) ? item.getBuyAmt().doubleValue() : item.getSellAmt().doubleValue();
            if (!this.showWarning || !item.isTrigged()) continue;
            this.strTip = "\u8bf7\u6ce8\u610f\u5907\u6ce8\u4fe1\u606f\u63d0\u793a\n";
            this.triggered = true;
        }
        if (this.triggered || !this.showWarning) {
            return;
        }
        for (CcsFundAccount acc : this.accBuyMap.keySet()) {
            if (!(acc.getAvailable() < this.accBuyMap.get(acc))) continue;
            this.strTip = String.valueOf(this.strTip) + acc.getInvestId() + "\u8d26\u53f7\u53ef\u7528\u8d44\u91d1\u4e0d\u8db3" + "\t";
        }
    }

    @FXML
    public void initialize() {
        this.createTable();
        this.lbTotalCount.setText(this.totalCount == 0L ? "" : Long.toString(this.totalCount));
        this.lbEntrustInfo.setText(this.getEntrustInfo());
        this.lbEntrustInfo.getStyleClass().add((Object)"priceTag");
        CssUtils.makeRise((Control)this.lbEntrustInfo);
        if (this.isInstruction && !this.isExecution) {
            this.colName.setVisible(false);
            this.colBasketName.setVisible(true);
            this.lbTotalCount.setVisible(true);
            this.colAmt.setVisible(false);
            this.colTotalAmt.setVisible(true);
            this.colCount.setVisible(false);
            this.colStrategy.setVisible(true);
            this.colTip.setVisible(false);
            this.colBasketTip.setVisible(true);
            this.calBasketToatalInfo();
        } else {
            this.calTotalInfo();
        }
        if (!"2".equals(this.instructionPanelType) && !"1".equals(this.instructionPanelType)) {
            this.colExpiredDate.setVisible(false);
        }
        if ("12".equals(this.instructionType)) {
            this.colExpiredDate.setVisible(false);
        }
        if (this.fundTraderMap == null || this.fundTraderMap.isEmpty()) {
            this.colTrader.setVisible(false);
        }
        this.lbTotalAmt.setText(this.totalAmt == 0.0 ? "" : StringUtils.toPriceStr((double)this.totalAmt, (int)2));
        this.totalTip.getStyleClass().add((Object)"priceTag");
        this.totalTip.setText(this.strTip);
        CssUtils.makeRise((Control)this.totalTip);
        this.tpTip.setText(this.strTip);
    }

    private void calBasketToatalInfo() {
        this.totalCount = 0L;
        this.totalAmt = 0.0;
        this.strTip = "";
        for (BasketTradeItem item : this.list) {
            this.totalAmt += item.getBasketTotalAmt();
            if (!this.showWarning) {
                item.setBasketTip("");
                continue;
            }
            if (!item.isBasketTrigged()) continue;
            this.strTip = "\u8bf7\u6ce8\u610f\u5907\u6ce8\u4fe1\u606f\u63d0\u793a\n";
        }
    }

    private void createTable() {
        this.index.setCellValueFactory(data -> new ReadOnlyStringWrapper(String.valueOf(data.getTableView().getItems().indexOf(data.getValue()) + 1)));
        this.colCode.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).getItem().securityIdProperty());
        this.colName.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).getItem().securityNameProperty());
        this.colBasketName.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).basketNameProperty());
        this.colMkt.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).getItem().marketProperty());
        this.colDirection.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).bsTradeProperty());
        this.colDirection.setCellFactory(cell -> new BasketBsCell());
        this.colCount.setCellValueFactory(m -> this.isBuy((BasketTradeItem)m.getValue()) ? ((BasketTradeItem)m.getValue()).buyCountProperty() : ((BasketTradeItem)m.getValue()).sellCountProperty());
        this.colCount.setCellFactory(cell -> new NumberTableCell());
        this.colStrategy.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).basketStrategyProperty());
        this.colPrice.setCellFactory(cell -> new ItemPriceCell());
        this.colPrice.setCellValueFactory(m -> this.isBuy((BasketTradeItem)m.getValue()) ? ((BasketTradeItem)m.getValue()).buyPriceProperty() : ((BasketTradeItem)m.getValue()).sellPriceProperty());
        this.colAmt.setCellFactory(cell -> new ItemPriceCell());
        this.colAmt.setCellValueFactory(m -> this.isBuy((BasketTradeItem)m.getValue()) ? ((BasketTradeItem)m.getValue()).getBuyAmt() : ((BasketTradeItem)m.getValue()).getSellAmt());
        this.colTotalAmt.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).basketTotalAmtProperty());
        this.colTotalAmt.setCellFactory(m -> new DoubleTableCell());
        this.colAcc.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).accProperty());
        this.colSecAcc.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).secAccProperty());
        this.colPorfolio.setCellValueFactory(m -> {
            if (((BasketTradeItem)m.getValue()).getAcc() instanceof CcsSubFundAccount) {
                CcsSubFundAccount secAcc = (CcsSubFundAccount)CcsSubFundAccount.class.cast(((BasketTradeItem)m.getValue()).getAcc());
                return secAcc.portfolioNameProperty();
            }
            return new SimpleStringProperty();
        });
        this.colTip.setCellFactory(cell -> new TipCell());
        this.colTip.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).tipProperty());
        this.colBasketTip.setCellFactory(cell -> new TipCell());
        this.colBasketTip.setCellValueFactory(m -> ((BasketTradeItem)m.getValue()).basketTipProperty());
        this.colExpiredDate.setCellValueFactory(m -> this.setExpiredDateChooser((TableColumn.CellDataFeatures<BasketTradeItem, Object>)m));
        this.colTrader.setCellValueFactory(m -> this.setTraderChooser((TableColumn.CellDataFeatures<BasketTradeItem, Object>)m));
        this.tableItems.setItems(this.list);
    }

    private boolean isBuy(BasketTradeItem item) {
        if (this.isInstruction && !this.isExecution) {
            return true;
        }
        return "49".equals(item.getBsTrade().getRaw());
    }

    protected boolean isOK(ButtonType bt) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<FundAccount, String> entry : this.insExpiredMap.entrySet()) {
            if (!(entry.getKey() instanceof CcsSubFundAccount)) break;
            CcsSubFundAccount subFund = (CcsSubFundAccount)CcsSubFundAccount.class.cast(entry.getKey());
            if (!StringUtils.isEmpty((String)entry.getValue()) && hashMap.get(subFund.getPortfolioId()) != null && !entry.getValue().equals(hashMap.get(subFund.getPortfolioId()))) {
                this.alert.alert(Alert.AlertType.ERROR, "\u540c\u4e00\u4e2a\u6295\u7ec4\uff0c\u8bf7\u9009\u62e9\u76f8\u540c\u7684\u6307\u4ee4\u7ec8\u6b62\u65e5\u671f\u3002");
                return false;
            }
            hashMap.put(subFund.getPortfolioId(), entry.getValue());
        }
        for (AppointedTraderSetting appointedTraderSetting : this.fundTraderMap.values()) {
            if (WorkflowTemplete.THREE_STEP_RISK != appointedTraderSetting.getWt() || !appointedTraderSetting.getAppointedTraderIds().isEmpty()) continue;
            this.alert.alert(Alert.AlertType.ERROR, "\u4e09\u8282\u70b9\u98ce\u63a7\u6307\u4ee4\uff0c\u8bf7\u6307\u5b9a\u4ea4\u6613\u5458");
            return false;
        }
        return true;
    }

    private ObservableObjectValue<Object> setExpiredDateChooser(TableColumn.CellDataFeatures<BasketTradeItem, Object> m) {
        HBox box = new HBox();
        DatePicker dp = new DatePicker();
        DatePickerUtils.setDaysLaterLimit((DatePicker)dp, (int)30);
        dp.setEditable(false);
        dp.setConverter((StringConverter)new DateStrConverter("yyyyMMdd"));
        dp.valueProperty().addListener((ob, oldV, newV) -> {
            if (newV == null || StringUtils.isEmpty((String)newV.toString())) {
                this.insExpiredMap.put((FundAccount)((BasketTradeItem)m.getValue()).getAcc(), "");
            } else {
                this.insExpiredMap.put((FundAccount)((BasketTradeItem)m.getValue()).getAcc(), newV.toString().replace("-", ""));
            }
        });
        dp.setValue((Object)LocalDate.now());
        box.setSpacing(10.0);
        box.setAlignment(Pos.CENTER);
        box.getChildren().add((Object)dp);
        return new ReadOnlyObjectWrapper((Object)box);
    }

    private ObservableObjectValue<Object> setTraderChooser(TableColumn.CellDataFeatures<BasketTradeItem, Object> m) {
        BasketTradeItem en = (BasketTradeItem)m.getValue();
        if (en == null || en.getAcc() == null) {
            return null;
        }
        AppointedTraderSetting setting = this.fundTraderMap.get(en.getAcc());
        if (setting == null) {
            return null;
        }
        HBox box = new HBox();
        CheckComboBox comboBox = new CheckComboBox();
        comboBox.getItems().setAll((Collection)setting.getUsers());
        comboBox.getCheckModel().checkAll();
        ListChangeListener tradersLis = ob -> {
            setting.getAppointedTraderIds().clear();
            ObservableList checkedItems = comboBox.getCheckModel().getCheckedItems();
            for (User checkUser : checkedItems) {
                setting.getAppointedTraderIds().add(checkUser.getId());
            }
        };
        comboBox.getCheckModel().getCheckedItems().addListener(tradersLis);
        box.setSpacing(10.0);
        box.setAlignment(Pos.CENTER);
        box.getChildren().add((Object)comboBox);
        return new ReadOnlyObjectWrapper((Object)box);
    }

    public String getBsSymbol() {
        return this.bsSymbol;
    }

    public void setBsSymbol(String bsSymbol) {
        this.bsSymbol = bsSymbol;
    }

    public boolean isExecution() {
        return this.isExecution;
    }

    public void setExecution(boolean isExecution) {
        this.isExecution = isExecution;
    }

    public boolean isInstruction() {
        return this.isInstruction;
    }

    public void setInstruction(boolean isInstruction) {
        this.isInstruction = isInstruction;
    }

    public String getErrorInfo() {
        return this.errorInfo;
    }

    public void setErrorInfo(String errorInfo) {
        this.errorInfo = errorInfo;
    }

    public String getBasketSide() {
        return this.basketSide;
    }

    public void setBasketSide(String basketSide) {
        this.basketSide = basketSide;
    }

    public boolean isShowWarning() {
        return this.showWarning;
    }

    public void setShowWarning(boolean showWarning) {
        this.showWarning = showWarning;
    }

    public Map<FundAccount, String> getInsExpiredMap() {
        return this.insExpiredMap;
    }

    public void setInsExpiredMap(Map<FundAccount, String> insExpiredMap) {
        this.insExpiredMap = insExpiredMap;
    }

    public String getInstructionType() {
        return this.instructionType;
    }

    public void setInstructionType(String instructionType) {
        this.instructionType = instructionType;
    }

    public String getInstructionPanelType() {
        return this.instructionPanelType;
    }

    public void setInstructionPanelType(String instructionPanelType) {
        this.instructionPanelType = instructionPanelType;
    }

    public String getEntrustInfo() {
        return this.entrustInfo;
    }

    public void setEntrustInfo(String entrustInfo) {
        this.entrustInfo = entrustInfo;
    }

    public Map<FundAccount, AppointedTraderSetting> getFundTraderMap() {
        return this.fundTraderMap;
    }

    public void setFundTraderMap(Map<FundAccount, AppointedTraderSetting> fundTraderMap) {
        this.fundTraderMap = fundTraderMap;
    }

    public class BasketBsCell
    extends TableCell<BasketTradeItem, MxNode> {
        private Label label = new Label();

        public BasketBsCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(MxNode value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            BasketTradeItem item = (BasketTradeItem)this.getTableRow().getItem();
            if (!StringUtils.isEmpty((String)MarginBasketEntrustConfirmDialog.this.bsSymbol)) {
                this.label.setText(MarginBasketEntrustConfirmDialog.this.bsSymbol);
                if ("49".equals(item.getBasketSide())) {
                    CssUtils.makeRise((Control)this.label);
                } else if ("50".equals(item.getBasketSide())) {
                    CssUtils.makeFall((Control)this.label);
                }
                this.setGraphic((Node)this.label);
                return;
            }
            this.label.setText(value.getValue());
            if (value.getRaw().equals("49")) {
                CssUtils.makeRise((Control)this.label);
            } else {
                CssUtils.makeFall((Control)this.label);
            }
            this.setGraphic((Node)this.label);
        }
    }

    private class TipCell
    extends TableCell<BasketTradeItem, String> {
        private Label label = new Label();

        private TipCell() {
            this.label.getStyleClass().add((Object)"priceTag");
            CssUtils.makeRise((Control)this.label);
        }

        public void updateItem(String value, boolean empty) {
            if (empty || !MarginBasketEntrustConfirmDialog.this.showWarning) {
                this.setGraphic(null);
                return;
            }
            this.label.setText(value);
            this.setGraphic((Node)this.label);
        }
    }
}

