/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.margin.view.xt;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.entity.web.workflow.WorkflowTemplate;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MarginSelectWorkflowDialog
extends DialogObj {
    private static final Logger logger = LogManager.getLogger(MarginSelectWorkflowDialog.class);
    @FXML
    private VBox vbox;
    private Map<String, List<WorkflowTemplate>> map = new HashMap<String, List<WorkflowTemplate>>();
    private Map<String, WorkflowTemplate> orderMap = new HashMap<String, WorkflowTemplate>();
    private List<ToggleGroup> list = new LinkedList<ToggleGroup>();

    @FXML
    public void initialize() {
    }

    public void init(String panelType) {
        for (String accntId : this.map.keySet()) {
            HBox hBox = new HBox();
            Label label = new Label();
            label.setAlignment(Pos.TOP_CENTER);
            label.setText(accntId);
            hBox.getChildren().add((Object)label);
            hBox.setSpacing(20.0);
            HBox.setHgrow((Node)hBox, (Priority)Priority.ALWAYS);
            ToggleGroup group = new ToggleGroup();
            group.setUserData((Object)accntId);
            this.list.add(group);
            boolean isFirst = false;
            List<WorkflowTemplate> listWorkflow = this.map.get(accntId);
            int i = 0;
            while (i < listWorkflow.size()) {
                if (panelType.equals(listWorkflow.get(i).getNode().getOrderType())) {
                    RadioButton radioButton = new RadioButton();
                    radioButton.setText(listWorkflow.get(i).getInstanceName());
                    radioButton.setUserData((Object)listWorkflow.get(i));
                    radioButton.setToggleGroup(group);
                    if (!isFirst) {
                        radioButton.setSelected(true);
                        isFirst = true;
                    }
                    hBox.getChildren().add((Object)radioButton);
                }
                ++i;
            }
            this.vbox.getChildren().add((Object)hBox);
            VBox.setMargin((Node)hBox, (Insets)new Insets(10.0, 20.0, 0.0, 20.0));
        }
    }

    public boolean isOK(ButtonType bt) {
        try {
            for (ToggleGroup toggleGroup : this.list) {
                this.orderMap.put((String)String.class.cast(toggleGroup.getUserData()), (WorkflowTemplate)WorkflowTemplate.class.cast(toggleGroup.getSelectedToggle().getUserData()));
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public VBox getVbox() {
        return this.vbox;
    }

    public void setVbox(VBox vbox) {
        this.vbox = vbox;
    }

    public Map<String, List<WorkflowTemplate>> getMap() {
        return this.map;
    }

    public void setMap(Map<String, List<WorkflowTemplate>> map) {
        this.map = map;
    }

    public Map<String, WorkflowTemplate> getOrderMap() {
        return this.orderMap;
    }

    public void setOrderMap(Map<String, WorkflowTemplate> orderMap) {
        this.orderMap = orderMap;
    }
}

