/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.margin.view.xt;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.margin.model.xt.MarginInstructionQueryModel;
import cms.tmx.margin.view.xt.InstructionMarginDialog;
import cms.tmx.query.current.views.NeeqInstructionQueryPart;
import cms.tmx.query.history.views.InstructionSideCell;
import javafx.scene.control.Alert;
import javax.inject.Inject;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class MarginInstructionQueryPart
extends NeeqInstructionQueryPart {
    @Inject
    protected MScheduler mScheduler;
    @Inject
    private MarginInstructionQueryModel model;

    public boolean premise(ObSimpleInstruction order) {
        if (!"COMMON_STOCK".equals(order.getMarketIndicate())) {
            return true;
        }
        if ("NEEQ".equals(order.getMarket().getRaw())) {
            return false;
        }
        return false;
    }

    public void initialize() {
        super.initialize();
        this.mScheduler.setInterval(1000);
    }

    public void onVisit() {
        this.mScheduler.schedule(e -> this.refresh());
    }

    protected void createTable() {
        super.createTable();
        this.colSide.setCellValueFactory(data -> ((ObSimpleInstruction)data.getValue()).marketIndicateProperty());
        this.colSide.setCellFactory(cell -> new InstructionSideCell());
    }

    protected void afterTableRestore() {
        super.afterTableRestore();
        this.tableNewInstruction.getColumns().remove((Object)this.colSecuritySubType);
        this.tableNewInstruction.getColumns().remove((Object)this.colLevelInfo);
    }

    public MarginInstructionQueryModel getModel() {
        return this.model;
    }

    protected void sendEvent(ObSimpleInstruction instruction) {
        if (instruction == null || !"XSHE".equals(instruction.getSecMarket()) && !"XSHG".equals(instruction.getSecMarket())) {
            return;
        }
        if (!instruction.getIsOrderStep() && !instruction.isIsApproveStep()) {
            this.alert.alert(Alert.AlertType.WARNING, "\u53cc\u51fb\u64cd\u4f5c\u65e0\u6548\uff0c\u8bf7\u786e\u8ba4\u6307\u4ee4\u72b6\u6001");
            return;
        }
        if (instruction.getIsOrderStep() || instruction.isIsApproveStep()) {
            try {
                this.model.udpateAvailableOrderQty(instruction);
            }
            catch (MException e) {
                this.alert.alert(Alert.AlertType.ERROR, "\u66f4\u65b0\u8d44\u6e90\u8be6\u60c5\u51fa\u9519");
                this.logger.error("\u66f4\u65b0\u8d44\u6e90\u8be6\u60c5\u51fa\u9519", (Throwable)e);
                return;
            }
        }
        MEvent eCall = new MEvent();
        if ("SimpleDetail".equals(instruction.getType())) {
            MPart newPart = null;
            if (instruction.getIsOrderStep()) {
                newPart = this.eps.findPart("cms.tmx.margin.trade.execute.xt");
            } else if (instruction.isIsApproveStep()) {
                newPart = this.eps.findPart("cms.tmx.margin.trade.approve.xt");
            } else {
                return;
            }
            this.eps.showPart(newPart, EPartService.PartState.ACTIVATE);
        }
        eCall.put((Object)"instruction", (Object)instruction);
        this.es.sendEvent("instruction.set.on.pane.margin", eCall);
    }

    protected void showDetail(ObSimpleInstruction instruction) {
        this.selectRow(instruction);
        InstructionMarginDialog obj = (InstructionMarginDialog)((Object)this.of.create(InstructionMarginDialog.class));
        obj.setInstruction(instruction);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u6307\u4ee4\u8be6\u60c5" + instruction.getId());
        dialog.launch();
    }
}

