/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.margin.view.xt;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.http.api.strategy.dto.ObSingleOrderMargin;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.query.margin.models.xt.InstructionMarginOrderModel;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class InstructionMarginOrderPart
extends MxPart {
    @FXML
    protected TableView<ObSingleOrderMargin> tableOrder;
    @FXML
    protected TableColumn<ObSingleOrderMargin, String> coloSecId;
    @FXML
    protected TableColumn<ObSingleOrderMargin, String> coloSecName;
    @FXML
    protected TableColumn<ObSingleOrderMargin, String> ordTypeDesc;
    @FXML
    protected TableColumn<ObSingleOrderMargin, String> marketIndicator;
    @FXML
    protected TableColumn<ObSingleOrderMargin, String> coloOrdTime;
    @FXML
    protected TableColumn<ObSingleOrderMargin, String> coloOrdDate;
    @FXML
    protected TableColumn<ObSingleOrderMargin, String> coloOrdStatus;
    @FXML
    protected TableColumn<ObSingleOrderMargin, String> coloMarket;
    @FXML
    protected TableColumn<ObSingleOrderMargin, String> coloUnit;
    @FXML
    protected TableColumn<ObSingleOrderMargin, String> coloOrderId;
    @FXML
    protected TableColumn<ObSingleOrderMargin, String> coloAccId;
    @FXML
    protected TableColumn<ObSingleOrderMargin, String> coloSecAcc;
    @FXML
    protected TableColumn<ObSingleOrderMargin, Number> coloPrice;
    @FXML
    protected TableColumn<ObSingleOrderMargin, Number> coloOrderQty;
    @FXML
    protected TableColumn<ObSingleOrderMargin, Number> colFrozenAmt;
    @FXML
    protected TableColumn<ObSingleOrderMargin, Number> coloOrderAmt;
    @FXML
    protected TableColumn<ObSingleOrderMargin, Number> coloDoneVol;
    @FXML
    protected TableColumn<ObSingleOrderMargin, Number> coloPercent;
    @FXML
    protected TableColumn<ObSingleOrderMargin, Number> coloAvgPrice;
    @FXML
    protected TableColumn<ObSingleOrderMargin, String> coloInfo;
    @FXML
    protected TableColumn<ObSingleOrderMargin, String> coloUser;
    @FXML
    protected TableColumn<ObSingleOrderMargin, String> colPortfolioId;
    @FXML
    protected TableColumn<ObSingleOrderMargin, String> colPortfolioName;
    @FXML
    protected TableColumn<ObSingleOrderMargin, String> colReference;
    @FXML
    protected Label labCount;
    @Inject
    private IRefDataMng refMng;
    @Inject
    protected InstructionMarginOrderModel orderModel;
    @Inject
    private MxAlert alert;
    protected int count;
    protected MxList<ObSingleOrderMargin> orderMxList = new MxList();
    protected ObSimpleInstruction instruction;
    private InvalidationListener lstnOrderModel = ob -> this.lstnOrder();

    @FXML
    public void initialize() {
        this.listener();
        this.createOrderTable();
        this.refreshOrder();
        this.initValue();
    }

    @PostConstruct
    public void init() {
        try {
            this.loadFXML();
        }
        catch (IOException iOException) {}
    }

    protected void initValue() {
        this.labCount.getStyleClass().add((Object)"priceTag");
        CssUtils.makeRise((Control)this.labCount);
    }

    @PreDestroy
    public void close() {
        this.orderModel.changedProperty().removeListener(this.lstnOrderModel);
    }

    protected void listener() {
        this.orderModel.changedProperty().addListener(this.lstnOrderModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lstnOrder() {
        List newList = Collections.synchronizedList(new ArrayList());
        List list = this.orderModel.getList();
        synchronized (list) {
            newList.addAll(this.orderModel.getList());
        }
        Platform.runLater(() -> {
            this.count = 0;
            for (ObSingleOrderMargin order : newList) {
                if (!order.isCanCancel()) continue;
                ++this.count;
            }
            StringBuilder string = new StringBuilder();
            if ("kStatusCanceled".equals(this.instruction.getStatus()) && this.count != 0) {
                string.append("\u6307\u4ee4\u5df2\u64a4\u9500\uff0c\u8fd8\u6709").append(this.count).append("\u7b14\u9700\u8981\u624b\u5de5\u64a4\u5355\u3002");
            }
            this.labCount.setText(string.toString());
            this.orderMxList.update(newList);
            Collections.sort(this.orderMxList.getList(), (o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
            this.tableOrder.sort();
            this.tableOrder.refresh();
        });
    }

    @FXML
    public void copyOrder() {
        TableUtils.copyContentWithHead(this.tableOrder);
    }

    @FXML
    public void refreshOrder() {
        if (this.instruction == null) {
            return;
        }
        this.orderModel.setInstruction(this.instruction);
        try {
            if ("".equals(this.instruction.getId())) {
                throw new MException(999997, String.valueOf(this.instruction.getId()) + "\u6307\u4ee4ID\u4e3a\u7a7a");
            }
            this.orderModel.query(this.instruction);
        }
        catch (MException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @FXML
    public void exportOrder() {
        try {
            ExcelUtils.writeExcel(this.tableOrder, (String)"\u59d4\u6258\u660e\u7ec6");
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    protected void createOrderTable() {
        this.coloSecId.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).securityIdProperty());
        this.coloSecName.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).securityNameProperty());
        this.ordTypeDesc.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).ordTypeDescProperty());
        this.marketIndicator.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).marketIndicatorProperty());
        this.coloPrice.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).priceProperty());
        this.coloPrice.setCellFactory(p -> new PriceCell());
        this.coloOrderQty.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).orderQtyProperty());
        this.coloOrderQty.setCellFactory(cell -> new DoubleTableCell());
        this.coloOrderAmt.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).orderAmountProperty());
        this.coloOrderAmt.setCellFactory(p -> new DoubleTableCell());
        this.colFrozenAmt.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).frozenMarginProperty());
        this.colFrozenAmt.setCellFactory(p -> new DoubleTableCell());
        this.coloDoneVol.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).cumQtyProperty());
        this.coloDoneVol.setCellFactory(cell -> new DoubleTableCell());
        this.coloPercent.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).donePercentProperty());
        this.coloPercent.setCellFactory(data -> new DoubleTableCell());
        this.coloAvgPrice.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).avgPxProperty());
        this.coloAvgPrice.setCellFactory(p -> new DoubleTableCell());
        this.coloOrdTime.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).ordTimeProperty());
        this.coloOrdDate.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).ordDateProperty());
        this.coloOrdStatus.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).statusProperty());
        this.coloMarket.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).marketProperty());
        this.coloUnit.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).unitProperty());
        this.coloOrderId.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).extOrderIdProperty());
        this.coloAccId.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).investorIdProperty());
        this.coloSecAcc.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).investorSecIdProperty());
        this.coloInfo.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).errInfoProperty());
        this.coloInfo.setCellFactory(data -> new TooltipTableCell<ObSingleOrderMargin, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((ObSingleOrderMargin)this.getValue()).getErrInfo();
                }
                return null;
            }
        });
        this.coloUser.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).userIdProperty());
        this.colReference.setCellValueFactory(data -> ((ObSingleOrderMargin)data.getValue()).referenceProperty());
        this.tableOrder.setItems(this.orderMxList.getList());
        this.tableOrder.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableOrder);
        this.coloOrdTime.setSortType(TableColumn.SortType.DESCENDING);
        this.tableOrder.getSortOrder().add(this.coloOrdTime);
    }

    public ObSimpleInstruction getInstruction() {
        return this.instruction;
    }

    public void setInstruction(ObSimpleInstruction instruction) {
        this.instruction = instruction;
    }

    private class PriceCell
    extends DoubleTableCell<ObSingleOrderMargin> {
        int scale = 3;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                ObSingleOrderMargin order = (ObSingleOrderMargin)ObSingleOrderMargin.class.cast(this.getTableRow().getItem());
                RefItem refItem = InstructionMarginOrderPart.this.refMng.getItem(order.getInstrument().getSecurityType(), order.getInstrument().getMarket(), order.getInstrument().getSecurityId());
                if (refItem != null) {
                    this.scale = refItem.getScale();
                }
                if (item.doubleValue() != 0.0) {
                    this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
                } else {
                    this.setText(null);
                }
            }
        }
    }
}

