/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.margin.view.xt;

import cms.tmx.core.MEventHandler;
import cms.tmx.core.MException;
import cms.tmx.entity.Result;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.trade.MarginAccountDistribution;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.http.workflow.dto.ExecJob;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.margin.view.xt.InstructionMarginBasePart;
import cms.tmx.utils.StringUtils;
import java.util.Collection;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Alert;
import javafx.scene.control.Control;
import javafx.scene.control.TreeTableColumn;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

public class InstructionMarginExecutePart
extends InstructionMarginBasePart {
    protected MEventHandler hSetCodeApp = event -> {
        if (event.get((Object)"instruction") == null || !(event.get((Object)"instruction") instanceof ObSimpleInstruction)) {
            return;
        }
        ObSimpleInstruction ins = (ObSimpleInstruction)ObSimpleInstruction.class.cast(event.get((Object)"instruction"));
        if (!this.validOrderFill(ins)) {
            return;
        }
        this.instruction = ins;
        this.doFill();
    };
    protected ChangeListener<Boolean> lstnFocusPrice = (ob, old, newV) -> {
        if (this.instruction == null) {
            return;
        }
        if (this.marginModel.isUpLimit() && !newV.booleanValue() && this.marginModel.getPrice() > this.instruction.getOrderDetail().getPrice()) {
            this.marginModel.setPrice(this.instruction.getOrderDetail().getPrice());
            this.priceSpn.getEditor().requestFocus();
            this.priceSpn.getEditor().selectAll();
        }
        if (this.marginModel.isDownLimit() && !newV.booleanValue() && this.marginModel.getPrice() < this.instruction.getOrderDetail().getPrice()) {
            this.marginModel.setPrice(this.instruction.getOrderDetail().getPrice());
            this.priceSpn.getEditor().requestFocus();
            this.priceSpn.getEditor().selectAll();
        }
    };
    protected ChangeListener<Boolean> lstnFocusQuantity = (ob, old, newV) -> {
        if (this.instruction == null) {
            return;
        }
        if (newV.booleanValue()) {
            return;
        }
        this.modifyQuantity();
    };

    @Override
    public void initialize() {
        this.marginModel.create("3");
        this.setConfirmSymbol("\u6307\u4ee4\u6267\u884c");
        this.setBtnNamePrefix("\u6307\u4ee4\u6267\u884c");
        this.onApprove(false);
        super.initialize();
        this.lbUpDownPrice.setVisible(false);
        this.lbUpDownPrice.setDisable(true);
        this.priceSpn.getEditor().focusedProperty().addListener(this.lstnFocusPrice);
        this.quantitySpn.getEditor().focusedProperty().addListener(this.lstnFocusQuantity);
        this.initFinished.set(true);
        this.doFill();
        this.hide();
        this.btnOrder.setText("\u6307\u4ee4\u6267\u884c");
    }

    @Override
    protected void reloadComponent() {
        switch (((MxNode)this.cmbType.getValue()).getRaw()) {
            case "1": {
                this.panelType = "margin_trade";
                MxBindings.bindSi((Property)this.lbCanCount.textProperty(), (ObservableNumberValue)this.marginModel.getAccDisModel().canBuyProperty());
                this.lbCanOne.setText("\u53ef\u4e70");
                this.showTreeTableCol((TreeTableColumn<MarginAccountDistribution, Number>)this.canBuyCol, null, null);
                if (!this.stkPaneCommon.getChildren().contains((Object)this.hboxMoney)) {
                    this.stkPaneCommon.getChildren().add((Object)this.hboxMoney);
                    this.amtMag.visibleProperty().bind((ObservableValue)this.hboxMoney.visibleProperty());
                }
                this.lbPriceMoney.setText("\u4ef7\u683c");
                this.lbCanCountTwo.textProperty().unbind();
                this.lbCanTwo.setVisible(false);
                this.lbCanCountTwo.setVisible(false);
                CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
                break;
            }
            case "2": {
                this.panelType = "margin_trade";
                MxBindings.bindSi((Property)this.lbCanCount.textProperty(), (ObservableNumberValue)this.marginModel.getAccDisModel().canSellProperty());
                this.lbCanOne.setText("\u53ef\u5356");
                this.showTreeTableCol((TreeTableColumn<MarginAccountDistribution, Number>)this.canSellCol, null, null);
                if (!this.stkPaneCommon.getChildren().contains((Object)this.hboxMoney)) {
                    this.stkPaneCommon.getChildren().add((Object)this.hboxMoney);
                    this.amtMag.visibleProperty().bind((ObservableValue)this.hboxMoney.visibleProperty());
                }
                this.lbCanCountTwo.textProperty().unbind();
                this.lbCanTwo.setVisible(false);
                this.lbCanCountTwo.setVisible(false);
                CssUtils.removeStyleClass((Control)this.btnOrder, (String)"btnRed");
                break;
            }
            case "3": {
                this.panelType = "margin_trade";
                MxBindings.bindSi((Property)this.lbCanCount.textProperty(), (ObservableNumberValue)this.marginModel.getAccDisModel().canMetalProperty());
                this.lbCanOne.setText("\u53ef\u878d\u8d44\u4e70\u5165\u6570\u91cf");
                this.canMetalCol.setText("\u53ef\u878d\u8d44\u4e70\u5165\u6570\u91cf");
                this.showTreeTableCol((TreeTableColumn<MarginAccountDistribution, Number>)this.canMetalCol, null, null);
                if (!this.stkPaneCommon.getChildren().contains((Object)this.hboxMoney)) {
                    this.stkPaneCommon.getChildren().add((Object)this.hboxMoney);
                    this.amtMag.visibleProperty().bind((ObservableValue)this.hboxMoney.visibleProperty());
                }
                this.lbPriceMoney.setText("\u4ef7\u683c");
                this.lbCanCountTwo.textProperty().unbind();
                this.lbCanTwo.setVisible(false);
                this.lbCanCountTwo.setVisible(false);
                CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
                break;
            }
            case "6": {
                this.panelType = "margin_trade";
                MxBindings.bindSi((Property)this.lbCanCount.textProperty(), (ObservableNumberValue)this.marginModel.getAccDisModel().canMetalProperty());
                this.lbCanOne.setText("\u53ef\u878d\u5238\u5356\u51fa\u6570\u91cf");
                this.canMetalCol.setText("\u53ef\u878d\u5238\u5356\u51fa\u6570\u91cf");
                this.showTreeTableCol((TreeTableColumn<MarginAccountDistribution, Number>)this.canMetalCol, null, null);
                if (!this.stkPaneCommon.getChildren().contains((Object)this.hboxMoney)) {
                    this.stkPaneCommon.getChildren().add((Object)this.hboxMoney);
                    this.amtMag.visibleProperty().bind((ObservableValue)this.hboxMoney.visibleProperty());
                }
                this.lbPriceMoney.setText("\u4ef7\u683c");
                this.lbCanCountTwo.textProperty().unbind();
                this.lbCanTwo.setVisible(false);
                this.lbCanCountTwo.setVisible(false);
                CssUtils.removeStyleClass((Control)this.btnOrder, (String)"btnRed");
                break;
            }
            case "5": {
                this.panelType = "margin_cash_sell_payoff";
                MxBindings.bindSi((Property)this.lbCanCount.textProperty(), (ObservableNumberValue)this.marginModel.getAccDisModel().canReturnQuantProperty());
                this.lbCanOne.setText("\u53ef\u7528\u6570\u91cf");
                MxBindings.bindSD((Property)this.lbCanCountTwo.textProperty(), (ObservableNumberValue)this.marginModel.getAccDisModel().notReturnMoneyProperty(), (int)2);
                this.lbCanTwo.setText("\u878d\u8d44\u8d1f\u503a\u91d1\u989d");
                MxBindings.bindSD((Property)this.lbCanCountThree.textProperty(), (ObservableNumberValue)this.marginModel.getAccDisModel().debtContractsProperty(), (int)2);
                this.lbCanThree.setText("\u8d1f\u503a\u5408\u7ea6\u606f\u8d39(\u53ef\u8fd8)");
                this.canReturnCol.setText("\u53ef\u7528\u6570\u91cf");
                this.showTreeTableCol((TreeTableColumn<MarginAccountDistribution, Number>)this.canReturnCol, null, (TreeTableColumn<MarginAccountDistribution, Number>)this.debtContractsCol);
                if (!this.stkPaneCommon.getChildren().contains((Object)this.hboxMoney)) {
                    this.stkPaneCommon.getChildren().add((Object)this.hboxMoney);
                    this.amtMag.visibleProperty().bind((ObservableValue)this.hboxMoney.visibleProperty());
                }
                this.lbPriceMoney.setText("\u4ef7\u683c");
                this.lbCanTwo.setVisible(true);
                this.lbCanCountTwo.setVisible(true);
                this.lbCanCountThree.setVisible(true);
                CssUtils.removeStyleClass((Control)this.btnOrder, (String)"btnRed");
                break;
            }
            case "8": {
                this.panelType = "margin_pos_buy_payoff";
                MxBindings.bindSi((Property)this.lbCanCount.textProperty(), (ObservableNumberValue)this.marginModel.getAccDisModel().canBuyProperty());
                this.lbCanOne.setText("\u53ef\u4e70\u6570\u91cf");
                MxBindings.bindSi((Property)this.lbCanCountTwo.textProperty(), (ObservableNumberValue)this.marginModel.getAccDisModel().notReturnQuantProperty());
                this.lbCanTwo.setText("\u878d\u5238\u8d1f\u503a\u6570\u91cf");
                this.canBuyCol.setText("\u53ef\u4e70\u6570\u91cf");
                this.notReturnCol.setText("\u878d\u5238\u8d1f\u503a\u91d1\u989d");
                this.showTreeTableCol((TreeTableColumn<MarginAccountDistribution, Number>)this.canBuyCol, (TreeTableColumn<MarginAccountDistribution, Number>)this.notReturnCol, (TreeTableColumn<MarginAccountDistribution, Number>)this.posBuyavailableCol);
                this.debtContractsCol.setVisible(false);
                if (!this.stkPaneCommon.getChildren().contains((Object)this.hboxMoney)) {
                    this.stkPaneCommon.getChildren().add((Object)this.hboxMoney);
                    this.amtMag.visibleProperty().bind((ObservableValue)this.hboxMoney.visibleProperty());
                }
                this.lbPriceMoney.setText("\u4ef7\u683c");
                this.lbCanTwo.setVisible(true);
                this.lbCanCountTwo.setVisible(true);
                CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
                break;
            }
            case "14": {
                this.panelType = "margin_cash";
                MxBindings.bindSD((Property)this.lbCanCount.textProperty(), (ObservableNumberValue)this.marginModel.getAccDisModel().notReturnMoneyProperty(), (int)2);
                this.lbCanOne.setText("\u878d\u8d44\u8d1f\u503a\u91d1\u989d");
                MxBindings.bindSD((Property)this.lbCanCountTwo.textProperty(), (ObservableNumberValue)this.marginModel.getAccDisModel().canReturnMoneyProperty(), (int)2);
                this.lbCanTwo.setText("\u53ef\u7528\u91d1\u989d");
                MxBindings.bindSD((Property)this.lbCanCountThree.textProperty(), (ObservableNumberValue)this.marginModel.getAccDisModel().debtContractsProperty(), (int)2);
                this.lbCanThree.setText("\u8d1f\u503a\u5408\u7ea6\u606f\u8d39(\u53ef\u8fd8)");
                this.canReturnMoneyCol.setText("\u53ef\u7528\u91d1\u989d");
                this.notReturnMoneyCol.setText("\u878d\u8d44\u8d1f\u503a\u91d1\u989d");
                this.showTreeTableCol((TreeTableColumn<MarginAccountDistribution, Number>)this.canReturnMoneyCol, (TreeTableColumn<MarginAccountDistribution, Number>)this.notReturnMoneyCol, null);
                this.doChange(null, "");
                this.lbPriceMoney.setText("\u91d1\u989d");
                this.txtCode.setText("");
                this.stkPaneCommon.getChildren().remove((Object)this.hboxMoney);
                this.amtMag.visibleProperty().unbind();
                this.amtMag.setVisible(false);
                this.lbCanTwo.setVisible(true);
                this.lbCanCountTwo.setVisible(true);
                for (MxNode mxNode : this.cmbPriceType.getItems()) {
                    if (!"50".equals(mxNode.getRaw())) continue;
                    this.cmbPriceType.getSelectionModel().select((Object)mxNode);
                    break;
                }
                CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
                break;
            }
            case "13": {
                this.panelType = "margin_voucher";
                MxBindings.bindSi((Property)this.lbCanCount.textProperty(), (ObservableNumberValue)this.marginModel.getAccDisModel().canReturnQuantProperty());
                this.lbCanOne.setText("\u53ef\u8fd8\u6570\u91cf");
                MxBindings.bindSi((Property)this.lbCanCountTwo.textProperty(), (ObservableNumberValue)this.marginModel.getAccDisModel().notReturnQuantProperty());
                this.lbCanTwo.setText("\u878d\u5238\u8d1f\u503a\u6570\u91cf");
                this.canReturnCol.setText("\u53ef\u8fd8\u6570\u91cf");
                this.notReturnCol.setText("\u878d\u5238\u8d1f\u503a\u91d1\u989d");
                this.showTreeTableCol((TreeTableColumn<MarginAccountDistribution, Number>)this.canReturnCol, (TreeTableColumn<MarginAccountDistribution, Number>)this.notReturnCol, null);
                if (!this.stkPaneCommon.getChildren().contains((Object)this.hboxMoney)) {
                    this.stkPaneCommon.getChildren().add((Object)this.hboxMoney);
                    this.amtMag.visibleProperty().bind((ObservableValue)this.hboxMoney.visibleProperty());
                }
                this.lbPriceMoney.setText("\u4ef7\u683c");
                this.lbCanTwo.setVisible(true);
                this.lbCanCountTwo.setVisible(true);
                for (MxNode mxNode : this.cmbPriceType.getItems()) {
                    if (!"50".equals(mxNode.getRaw())) continue;
                    this.cmbPriceType.getSelectionModel().select((Object)mxNode);
                    break;
                }
                CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
                break;
            }
            case "10": {
                this.panelType = "margin_transfer";
                MxBindings.bindSI((Property)this.txtTransfer.textProperty(), (Property)this.marginModel.countProperty());
                this.showTreeTableCol(null, null, null);
                this.lbTransferQty.setText("\u5212\u5165\u6570\u91cf");
                break;
            }
            case "11": {
                this.panelType = "margin_transfer";
                MxBindings.bindSI((Property)this.txtTransfer.textProperty(), (Property)this.marginModel.countProperty());
                this.showTreeTableCol(null, null, null);
                this.lbTransferQty.setText("\u5212\u51fa\u6570\u91cf");
                break;
            }
        }
        this.marginModel.setCount(0L);
        this.vboxCompent.getChildren().setAll((Collection)this.panelMap.get(this.panelType));
        Platform.runLater(() -> {
            this.vboxCompent.requestFocus();
            this.check();
        });
        this.btnOrder.setText("\u6307\u4ee4\u6267\u884c");
        this.hide();
    }

    @PostConstruct
    public void init() {
        super.init();
        this.es.subscribe("instruction.set.on.pane.margin", this.hSetCodeApp);
    }

    @PreDestroy
    public void destroy() {
        this.es.unSubscribe("instruction.set.on.pane.margin", this.hSetCodeApp);
    }

    @Override
    public void setPrice(double price) {
        if ((this.marginModel.isLimitPrice() || this.marginModel.isAfterHoursPrice()) && !this.marginModel.isSpecify() && price > 0.0) {
            this.marginModel.setPrice(price);
            this.priceSpn.getValueFactory().setValue((Object)price);
            this.priceSpn.getEditor().requestFocus();
            this.priceSpn.getEditor().selectAll();
        }
    }

    private void hide() {
        this.lbCanOne.setVisible(false);
        this.lbCanTwo.setVisible(false);
        this.lbCanThree.setVisible(false);
        this.lbCanCount.setVisible(false);
        this.lbCanCountTwo.setVisible(false);
        this.lbCanCountThree.setVisible(false);
    }

    @Override
    protected void priceDisableBind() {
        this.priceSpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.marginModel.isLimitPrice() || this.marginModel.isSpecify() || this.marginModel.getAccDisModel().isActive(), (Observable[])new Observable[]{this.marginModel.priceStgProperty(), this.marginModel.priceTypeLimitedStgProperty(), this.marginModel.getAccDisModel().activeProperty()}));
    }

    @Override
    protected void submitOrder() {
        super.submitOrder();
        this.clearInfo();
    }

    @Override
    protected Result doAction() throws MException {
        return this.marginModel.submit(this.marginModel.getAccDisModel().getRoot(), this.instruction);
    }

    private boolean validOrderFill(ObSimpleInstruction ins) {
        return StringUtils.belongto((String)ins.getType(), (String[])new String[]{"SimpleDetail"});
    }

    private void doFill() {
        Platform.runLater(() -> {
            if (!this.initFinished.get() || this.instruction == null) {
                return;
            }
            try {
                this.fillInstruction();
                this.btnOrder.setDisable(false);
            }
            catch (MException e) {
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            }
        });
    }

    private void modifyQuantity() {
        if (this.instruction.getJobs() != null && this.instruction.getJobs().size() > 0) {
            ExecJob job = (ExecJob)this.instruction.getJobs().get(0);
            long effectiveQuantity = (long)job.getAvailOrderQty();
            if (this.marginModel.getCount() > effectiveQuantity) {
                this.marginModel.setCount(effectiveQuantity);
                this.quantitySpn.getEditor().requestFocus();
                this.quantitySpn.getEditor().selectAll();
            }
        }
    }

    @Override
    protected void onItemSelected(HandicapInfo now) {
        if (now != null) {
            if (this.marginModel.isUpLimit() || this.marginModel.isDownLimit() || this.marginModel.isUnlimited()) {
                this.setPrice(now.getPrice());
            }
            Platform.runLater(() -> this.clearSelection());
        }
    }
}

