/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.margin.view;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.EditTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.Result;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.strategy.api.TradeServiceApi;
import cms.tmx.http.api.strategy.dto.MarketIndicator;
import cms.tmx.http.api.strategy.dto.NewOrderSingle;
import cms.tmx.http.api.strategy.dto.ObPositionMargin;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.query.margin.models.MarginPositionModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.inject.Inject;

public class MarginTransferPositionQueryPart
extends MxPart {
    @Inject
    protected MarginPositionModel model;
    @Inject
    protected FundAccountMngServiceImpl accntModel;
    @Inject
    protected MxAlert alert;
    @Inject
    protected MEventService es;
    @Inject
    protected HttpBaseApi apiBase;
    @Inject
    protected TradeServiceApi api;
    @FXML
    private TableView<ObPositionMargin> tableView;
    @FXML
    private TableColumn<ObPositionMargin, Boolean> selected;
    @FXML
    private TableColumn<ObPositionMargin, String> colFund;
    @FXML
    private TableColumn<ObPositionMargin, String> colSec;
    @FXML
    private TableColumn<ObPositionMargin, MxNode> colMarket;
    @FXML
    private TableColumn<ObPositionMargin, String> colCode;
    @FXML
    private TableColumn<ObPositionMargin, String> colName;
    @FXML
    private TableColumn<ObPositionMargin, Number> colCanUse;
    @FXML
    private TableColumn<ObPositionMargin, Number> colTransfer;
    private MxList<ObPositionMargin> mxList = new MxList();
    private CheckBox checkBox = new CheckBox();
    private String investId = "";
    private InvalidationListener lstnModel = ob -> this.refreshList();
    private Predicate<ObPositionMargin> pd = t -> Objects.equals(this.investId, t.getInvestorId());

    @FXML
    private void initialize() {
        this.iniValue();
        this.createTable();
        this.bind();
        this.refresh();
    }

    private void bind() {
        this.model.changedProperty().addListener(this.lstnModel);
        this.es.subscribe("change.accnt", e -> this.refreshList());
        this.es.subscribe("margin.select.all", e -> this.selectAll(true));
        this.es.subscribe("margin.pledge.out", e -> this.pledgeOut(e));
        this.checkBox.selectedProperty().addListener((obv, old, now) -> this.selectAll((boolean)now));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectAll(boolean select) {
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            this.mxList.getList().forEach(e -> e.setSelected(select));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshList() {
        ArrayList newList = new ArrayList();
        ObservableList observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll(this.model.getList());
        }
        List collect = newList.stream().filter(item -> item.getSecBalance() > 0.0).collect(Collectors.toList());
        MEvent event = new MEvent();
        this.es.sendEvent("get.accnt", event);
        if (event.getStr("fundAccount") != null) {
            this.investId = event.getStr("fundAccount");
        }
        Platform.runLater(() -> {
            this.mxList.update(collect, this.pd);
            this.tableView.refresh();
        });
    }

    private void createTable() {
        TableUtils.isCheckBox(this.selected);
        this.selected.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).selectedProperty());
        this.selected.setGraphic((Node)this.checkBox);
        this.selected.setSortable(false);
        this.colFund.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).investorIdProperty());
        this.colSec.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).inverstorSecIdProperty());
        this.colCode.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).getInstrument().secIdProperty());
        this.colName.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).getInstrument().symbolProperty());
        this.colMarket.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).getInstrument().marketProperty());
        this.colCanUse.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).secBalanceProperty());
        this.colCanUse.setCellFactory(data -> new DoubleTableCell(0));
        this.colTransfer.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).secTransferProperty());
        this.colTransfer.setCellFactory(p -> new EditTableCell(0));
        this.tableView.setPlaceholder((Node)new Label());
        this.tableView.setItems(this.mxList.getList());
    }

    private void iniValue() {
        MEvent event = new MEvent();
        this.es.sendEvent("get.accnt", event);
        if (event.getStr("fundAccount") != null) {
            this.investId = event.getStr("fundAccount");
        }
        if (this.investId == null || this.investId.isEmpty()) {
            for (FundAccount fundAccount : this.accntModel.getMarginFundAccountList()) {
                if (!Objects.equals("99999-02-02", fundAccount.getCounterId())) continue;
                this.investId = fundAccount.getInvestId();
                break;
            }
        }
    }

    private void pledgeOut(MEvent event) {
        FilteredList list = this.mxList.getList().filtered(p -> p.isSelected());
        if (list.isEmpty()) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u9009\u62e9\u8981\u5212\u51fa\u7684\u6301\u4ed3");
            return;
        }
        FundAccount fundAccount = (FundAccount)FundAccount.class.cast(event.get((Object)"fundAccount"));
        Result result = new Result();
        for (ObPositionMargin position : list) {
            try {
                NewOrderSingle req = new NewOrderSingle();
                req.setOpUser(this.apiBase.getHttpOpUser());
                req.setExtCashAccntId(fundAccount.getNewCashAccntId());
                req.setExtSecAccntId(position.getPosAccnt().getSecAccntId());
                req.setInvestorId(fundAccount.getInvestId());
                req.setInvestorSecId(position.getInverstorSecId());
                Instrument inst = new Instrument();
                inst.setSecurityId(position.getInstrument().getSecId());
                inst.setMarket(position.getInstrument().getMarket().getRaw());
                inst.setSymbol(position.getInstrument().getSymbol());
                inst.setMarketIndicator(MarketIndicator.KCREDIT_PLEGDE_OUT.getValue());
                inst.setSecurityType(position.getInstrument().getSecType());
                inst.setApplId("750");
                inst.setMarketGroup("CCS");
                req.setInstrument(inst);
                req.setOrderQty(position.getSecTransfer());
                req.setPrice(1.0);
                req.setTradePlatformId(fundAccount.getCounterId());
                req.setListId(Long.toString(System.currentTimeMillis()));
                this.api.newOrderSingle(req);
                result.operate(true);
            }
            catch (MException | Exception e) {
                result.operate(false);
                result.getReason().append("\n\u63d0\u4ea4\u9519\u8bef\uff1a" + e.getMessage());
                this.logger.error((Object)e, e);
            }
        }
        if (result.failed > 0) {
            this.alert.alert(Alert.AlertType.WARNING, "\u63d0\u4ea4\u6210\u529f" + result.successd + "\u7b14" + " " + "\u5931\u8d25" + result.failed + "\u7b14 \u539f\u56e0\uff1a" + result.getReason().toString());
        } else {
            this.alert.alert(Alert.AlertType.INFORMATION, "\u63d0\u4ea4\u6210\u529f" + result.successd + "\u7b14" + " " + "\u5931\u8d25" + result.failed + "\u7b14");
        }
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithHead(this.tableView);
    }

    @FXML
    private void refresh() {
        this.exe.execute(() -> {
            try {
                this.model.query();
            }
            catch (Exception e) {
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        });
    }

    @FXML
    private void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableView, (String)"\u4fe1\u7528\u6301\u4ed3\u67e5\u8be2");
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }
}

