/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.margin.view;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.entity.FundAccount;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.strategy.api.TradeServiceApi;
import cms.tmx.http.api.strategy.dto.ObPositionMargin;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.query.margin.models.MarginPositionModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.inject.Inject;

public class MarginTransferPositionFileQueryPart
extends MxPart {
    @Inject
    protected MarginPositionModel model;
    @Inject
    protected FundAccountMngServiceImpl accntModel;
    @Inject
    protected MxAlert alert;
    @Inject
    protected MEventService es;
    @Inject
    protected HttpBaseApi apiBase;
    @Inject
    protected TradeServiceApi api;
    @FXML
    private TableView<ObPositionMargin> tableView;
    @FXML
    private TableColumn<ObPositionMargin, String> colFund;
    @FXML
    private TableColumn<ObPositionMargin, String> colSec;
    @FXML
    private TableColumn<ObPositionMargin, MxNode> colMarket;
    @FXML
    private TableColumn<ObPositionMargin, String> colCode;
    @FXML
    private TableColumn<ObPositionMargin, String> colName;
    @FXML
    private TableColumn<ObPositionMargin, Number> colCanUse;
    private MxList<ObPositionMargin> mxList = new MxList();
    private String investId = "";
    private boolean first = true;
    private InvalidationListener lstnModel = ob -> this.refreshList();
    private Predicate<ObPositionMargin> pd = t -> Objects.equals(this.investId, t.getInvestorId());

    @FXML
    private void initialize() {
        this.iniValue();
        this.createTable();
        this.bind();
        this.refresh();
    }

    private void bind() {
        this.model.changedProperty().addListener(this.lstnModel);
        this.es.subscribe("change.accnt.file", e -> this.refreshList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectAll(boolean select) {
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            this.mxList.getList().forEach(e -> e.setSelected(select));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshList() {
        ArrayList newList = new ArrayList();
        ObservableList observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll(this.model.getList());
        }
        MEvent event = new MEvent();
        this.es.sendEvent("get.accnt.file", event);
        if (event.getStr("fundAccount") != null) {
            this.investId = event.getStr("fundAccount");
        }
        List collect = newList.stream().filter(item -> item.getSecBalance() > 0.0).collect(Collectors.toList());
        Platform.runLater(() -> {
            this.mxList.update(collect, this.pd);
            if (this.first) {
                this.selectAll(true);
                this.first = false;
            }
            this.tableView.refresh();
        });
    }

    private void createTable() {
        this.colFund.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).investorIdProperty());
        this.colSec.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).inverstorSecIdProperty());
        this.colCode.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).getInstrument().secIdProperty());
        this.colName.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).getInstrument().symbolProperty());
        this.colMarket.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).getInstrument().marketProperty());
        this.colCanUse.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).secBalanceProperty());
        this.colCanUse.setCellFactory(data -> new DoubleTableCell());
        this.tableView.setPlaceholder((Node)new Label());
        this.tableView.setItems(this.mxList.getList());
    }

    private void iniValue() {
        MEvent event = new MEvent();
        this.es.sendEvent("get.accnt.file", event);
        if (event.getStr("fundAccount") != null) {
            this.investId = event.getStr("fundAccount");
        }
        if (this.investId == null || this.investId.isEmpty()) {
            for (FundAccount fundAccount : this.accntModel.getMarginFundAccountList()) {
                if (!Objects.equals("99999-02-02", fundAccount.getCounterId())) continue;
                this.investId = fundAccount.getInvestId();
                break;
            }
        }
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithHead(this.tableView);
    }

    @FXML
    private void refresh() {
        this.exe.execute(() -> {
            try {
                this.model.query();
            }
            catch (Exception e) {
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        });
    }

    @FXML
    private void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableView, (String)"\u4fe1\u7528\u6301\u4ed3\u67e5\u8be2");
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }
}

