/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.margin.view;

import cms.tmx.api.trade.ITransferFundApi;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.EditTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.Result;
import cms.tmx.entity.SecAccount;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.strategy.api.TradeServiceApi;
import cms.tmx.http.api.strategy.dto.MarketIndicator;
import cms.tmx.http.api.strategy.dto.NewOrderSingle;
import cms.tmx.http.api.strategy.dto.ObPositionMargin;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.margin.model.MarginNormalPositionModel;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.current.models.MarginAccountMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.inject.Inject;

public class MarginTransferNormaPositionQueryPart
extends MxPart {
    @Inject
    protected MarginNormalPositionModel model;
    @Inject
    protected FundAccountMngServiceImpl accntModel;
    @Inject
    protected MxAlert alert;
    @Inject
    protected MEventService es;
    @Inject
    protected HttpBaseApi apiBase;
    @Inject
    protected TradeServiceApi api;
    @Inject
    protected ITransferFundApi transferApi;
    @Inject
    protected CcsAccountMap ccsAccountMap;
    @Inject
    private MarginAccountMap marginAccountMap;
    @FXML
    private TableView<ObPositionMargin> tableView;
    @FXML
    private TableColumn<ObPositionMargin, Boolean> selected;
    @FXML
    private TableColumn<ObPositionMargin, String> colFund;
    @FXML
    private TableColumn<ObPositionMargin, String> colSec;
    @FXML
    private TableColumn<ObPositionMargin, MxNode> colMarket;
    @FXML
    private TableColumn<ObPositionMargin, String> colCode;
    @FXML
    private TableColumn<ObPositionMargin, String> colName;
    @FXML
    private TableColumn<ObPositionMargin, Number> colCanUse;
    @FXML
    private TableColumn<ObPositionMargin, Number> colTransfer;
    @FXML
    private ComboBox<FundAccount> combobox;
    protected Map<CcsFundAccount, List<SecAccount>> accountMap = new HashMap<CcsFundAccount, List<SecAccount>>();
    private MxList<ObPositionMargin> mxList = new MxList();
    private String investorId = "";
    private CheckBox checkBox = new CheckBox();
    protected int posiAvaId;
    private InvalidationListener lstnModel = ob -> this.refreshList();
    private Predicate<ObPositionMargin> pd = t -> Objects.equals(this.investorId, t.getInvestorId());

    @FXML
    private void initialize() {
        this.iniValue();
        this.createTable();
        this.bind();
        this.initPositions();
    }

    private void initPositions() {
        if (this.combobox.getSelectionModel().getSelectedItem() == null) {
            return;
        }
        try {
            this.model.getPositions(((FundAccount)this.combobox.getSelectionModel().getSelectedItem()).getInvestId());
        }
        catch (Exception e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void bind() {
        this.model.changedProperty().addListener(this.lstnModel);
        this.es.subscribe("normal.select.all", e -> this.selectAll(true));
        this.es.subscribe("margin.pledge.in", e -> this.pledgeIn(e));
        this.checkBox.selectedProperty().addListener((obv, old, now) -> this.selectAll((boolean)now));
        this.combobox.getSelectionModel().selectedItemProperty().addListener((ob, old, n) -> {
            try {
                this.investorId = ((FundAccount)this.combobox.getSelectionModel().getSelectedItem()).getInvestId();
                this.model.getPositions(this.investorId);
            }
            catch (Exception e) {
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectAll(boolean select) {
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            this.mxList.getList().forEach(e -> e.setSelected(select));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshList() {
        ArrayList<ObPositionMargin> newList = new ArrayList<ObPositionMargin>();
        ObservableList<ObPositionMargin> observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll((Collection<ObPositionMargin>)this.model.getList());
        }
        List collect = newList.stream().filter(item -> item.getSecAvail() > 0.0).collect(Collectors.toList());
        Platform.runLater(() -> this.mxList.update(collect, this.pd));
    }

    private void createTable() {
        TableUtils.isCheckBox(this.selected);
        this.selected.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).selectedProperty());
        this.selected.setGraphic((Node)this.checkBox);
        this.selected.setSortable(false);
        this.colFund.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).investorIdProperty());
        this.colSec.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).inverstorSecIdProperty());
        this.colCode.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).getInstrument().secIdProperty());
        this.colName.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).getInstrument().symbolProperty());
        this.colMarket.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).getInstrument().marketProperty());
        this.colCanUse.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).secAvailProperty());
        this.colCanUse.setCellFactory(data -> new DoubleTableCell(0));
        this.colTransfer.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).secTransferProperty());
        this.colTransfer.setCellFactory(p -> new EditTableCell(0));
        this.tableView.setPlaceholder((Node)new Label());
        this.tableView.setItems(this.mxList.getList());
    }

    private void iniValue() {
        try {
            this.accountMap = this.ccsAccountMap.getAccountMap();
            Set<CcsFundAccount> keySet = this.accountMap.keySet();
            if (!keySet.isEmpty()) {
                ObservableList ccsAccounts = FxUtils.newList();
                ccsAccounts.addAll(keySet);
                this.combobox.setItems(ccsAccounts);
                this.combobox.getSelectionModel().select(0);
                this.investorId = ((FundAccount)this.combobox.getSelectionModel().getSelectedItem()).getInvestId();
                this.model.setInvestorId(this.investorId);
            }
        }
        catch (MException | Exception e) {
            this.logger.error("\u878d\u8d44\u878d\u5238\u52a0\u8f7d\u62c5\u4fdd\u54c1\u5212\u8f6c\u8d44\u91d1\u8d26\u53f7\u548c\u80a1\u4e1c\u4ee3\u7801\u5931\u8d25", e);
        }
    }

    private void pledgeIn(MEvent event) {
        FilteredList list = this.mxList.getList().filtered(p -> p.isSelected());
        if (list.isEmpty()) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u9009\u62e9\u8981\u5212\u5165\u7684\u6301\u4ed3");
            return;
        }
        FundAccount fundAccount = (FundAccount)FundAccount.class.cast(event.get((Object)"fundAccount"));
        Result result = new Result();
        for (ObPositionMargin position : list) {
            try {
                NewOrderSingle req = new NewOrderSingle();
                req.setOpUser(this.apiBase.getHttpOpUser());
                req.setExtCashAccntId(fundAccount.getNewCashAccntId());
                req.setExtSecAccntId(position.getPosAccnt().getSecAccntId());
                req.setExtSecAccntId(this.marginAccountMap.getSecAccntByFundAccnt(fundAccount, position.getInstrument().getMarket().getRaw()).getNewSecAccntId());
                req.setInvestorId(fundAccount.getInvestId());
                req.setInvestorSecId(position.getInverstorSecId());
                Instrument inst = new Instrument();
                inst.setSecurityId(position.getInstrument().getSecId());
                inst.setMarket(position.getInstrument().getMarket().getRaw());
                inst.setSymbol(position.getInstrument().getSymbol());
                inst.setMarketIndicator(MarketIndicator.KCREDIT_PLEGDE_IN.getValue());
                inst.setSecurityType(position.getInstrument().getSecType());
                inst.setApplId("750");
                inst.setMarketGroup("CCS");
                req.setInstrument(inst);
                req.setOrderQty(position.getSecTransfer());
                req.setPrice(1.0);
                req.setTradePlatformId(fundAccount.getCounterId());
                req.setListId(Long.toString(System.currentTimeMillis()));
                req.setAttachment(position.getInverstorSecId());
                this.api.newOrderSingle(req);
                result.operate(true);
            }
            catch (MException | Exception e) {
                result.operate(false);
                result.getReason().append("\n\u63d0\u4ea4\u9519\u8bef\uff1a" + e.getMessage());
                this.logger.error((Object)e, e);
            }
        }
        if (result.failed > 0) {
            this.alert.alert(Alert.AlertType.WARNING, "\u63d0\u4ea4\u6210\u529f" + result.successd + "\u7b14" + " " + "\u5931\u8d25" + result.failed + "\u7b14 \u539f\u56e0\uff1a" + result.getReason().toString());
        } else {
            this.alert.alert(Alert.AlertType.INFORMATION, "\u63d0\u4ea4\u6210\u529f" + result.successd + "\u7b14" + " " + "\u5931\u8d25" + result.failed + "\u7b14");
        }
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithHead(this.tableView);
    }

    @FXML
    private void refresh() {
        if (this.combobox.getSelectionModel().getSelectedItem() == null) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u9009\u62e9\u8d44\u91d1\u8d26\u53f7");
        }
        try {
            this.model.getPositions(this.investorId);
        }
        catch (Exception e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @FXML
    private void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableView, (String)"\u666e\u901a\u6301\u4ed3\u67e5\u8be2");
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }
}

