/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.margin.view;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.EditTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.Result;
import cms.tmx.entity.SecAccount;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.strategy.api.TradeServiceApi;
import cms.tmx.http.api.strategy.dto.MarketIndicator;
import cms.tmx.http.api.strategy.dto.NewOrderSingle;
import cms.tmx.http.api.strategy.dto.ObPositionMargin;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.query.current.models.MarginAccountMap;
import cms.tmx.query.margin.models.MarginPositionModel;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.inject.Inject;

public class MarginTransferNormaPositionFileQueryPart
extends MxPart {
    @Inject
    protected MarginPositionModel model;
    @Inject
    protected FundAccountMngServiceImpl accntModel;
    @Inject
    protected MxAlert alert;
    @Inject
    protected MEventService es;
    @Inject
    protected HttpBaseApi apiBase;
    @Inject
    protected TradeServiceApi api;
    @Inject
    private MarginAccountMap accountMap;
    @FXML
    private TableView<ObPositionMargin> tableView;
    @FXML
    private TableColumn<ObPositionMargin, Boolean> selected;
    @FXML
    private TableColumn<ObPositionMargin, String> colFund;
    @FXML
    private TableColumn<ObPositionMargin, String> colSec;
    @FXML
    private TableColumn<ObPositionMargin, MxNode> colMarket;
    @FXML
    private TableColumn<ObPositionMargin, String> colCode;
    @FXML
    private TableColumn<ObPositionMargin, String> colName;
    @FXML
    private TableColumn<ObPositionMargin, Number> colTransfer;
    private MxList<ObPositionMargin> mxList = new MxList();
    private CheckBox checkBox = new CheckBox();

    @FXML
    private void initialize() {
        this.createTable();
        this.bind();
    }

    private void bind() {
        this.es.subscribe("margin.pledge.in.file", e -> this.pledgeIn(e));
        this.es.subscribe("upload.position", e -> this.upload(e));
        this.checkBox.selectedProperty().addListener((obv, old, now) -> this.selectAll((boolean)now));
    }

    private void upload(MEvent e) {
        Object object = e.get((Object)"data");
        List list = (List)List.class.cast(object);
        this.mxList.update(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectAll(boolean select) {
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            this.mxList.getList().forEach(e -> e.setSelected(select));
        }
    }

    private void createTable() {
        TableUtils.isCheckBox(this.selected);
        this.selected.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).selectedProperty());
        this.selected.setGraphic((Node)this.checkBox);
        this.selected.setSortable(false);
        this.colFund.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).investorIdProperty());
        this.colSec.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).inverstorSecIdProperty());
        this.colCode.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).getInstrument().secIdProperty());
        this.colName.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).getInstrument().symbolProperty());
        this.colMarket.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).getInstrument().marketProperty());
        this.colTransfer.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).secTransferProperty());
        this.colTransfer.setCellFactory(p -> new EditTableCell(2));
        this.tableView.setPlaceholder((Node)new Label());
        this.tableView.setItems(this.mxList.getList());
    }

    private void pledgeIn(MEvent event) {
        FilteredList list = this.mxList.getList().filtered(p -> p.isSelected());
        if (list.isEmpty()) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u9009\u62e9\u8981\u5212\u5165\u7684\u6301\u4ed3");
            return;
        }
        FundAccount fundAccount = (FundAccount)FundAccount.class.cast(event.get((Object)"fundAccount"));
        SecAccount secAccount = null;
        Result result = new Result();
        for (ObPositionMargin position : list) {
            try {
                List secAccounts = (List)this.accountMap.getAccountMap().get(fundAccount);
                for (SecAccount sec : secAccounts) {
                    if (!position.getInstrument().getMarket().getRaw().equals(sec.getExchange().getRaw())) continue;
                    secAccount = sec;
                    break;
                }
                if (secAccount == null) {
                    this.logger.error("\u8bc1\u5238\u4ee3\u7801:" + position.getInstrument().getSecId() + " \u6ca1\u6709\u627e\u5230\u8d44\u91d1\u8d26\u53f7:" + fundAccount.getInvestId() + " \u5bf9\u5e94\u5e02\u573a\u7684\u80a1\u4e1c\u8d26\u6237");
                    continue;
                }
                NewOrderSingle req = new NewOrderSingle();
                req.setOpUser(this.apiBase.getHttpOpUser());
                Instrument inst = new Instrument();
                inst.setSecurityId(position.getInstrument().getSecId());
                inst.setMarket(position.getInstrument().getMarket().getRaw());
                inst.setSymbol(position.getInstrument().getSymbol());
                inst.setMarketIndicator(MarketIndicator.KCREDIT_PLEGDE_IN.getValue());
                inst.setSecurityType(position.getInstrument().getSecType());
                inst.setApplId("750");
                inst.setMarketGroup("CCS");
                req.setExtCashAccntId(fundAccount.getNewCashAccntId());
                req.setExtSecAccntId(secAccount.getNewSecAccntId());
                req.setInvestorId(fundAccount.getInvestId());
                req.setInvestorSecId(secAccount.getInverstorSecId());
                req.setAttachment(position.getInverstorSecId());
                req.setInstrument(inst);
                req.setOrderQty(position.getSecTransfer());
                req.setPrice(1.0);
                req.setTradePlatformId(fundAccount.getCounterId());
                req.setListId(Long.toString(System.currentTimeMillis()));
                this.api.newOrderSingle(req);
                result.operate(true);
            }
            catch (MException | Exception e) {
                result.operate(false);
                result.getReason().append("\n\u63d0\u4ea4\u9519\u8bef\uff1a" + e.getMessage());
                this.logger.error((Object)e, e);
            }
        }
        if (result.failed > 0) {
            this.alert.alert(Alert.AlertType.WARNING, "\u63d0\u4ea4\u6210\u529f" + result.successd + "\u7b14" + " " + "\u5931\u8d25" + result.failed + "\u7b14 \u539f\u56e0\uff1a" + result.getReason().toString());
        } else {
            this.alert.alert(Alert.AlertType.INFORMATION, "\u63d0\u4ea4\u6210\u529f" + result.successd + "\u7b14" + " " + "\u5931\u8d25" + result.failed + "\u7b14");
        }
        this.mxList.clear();
        this.checkBox.setSelected(false);
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithHead(this.tableView);
    }

    @FXML
    private void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableView, (String)"\u6301\u4ed3\u67e5\u8be2");
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }
}

