/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.margin.view;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.MarginSingleEntrust;
import cms.tmx.http.api.strategy.dto.MarketIndicator;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.utils.StringUtils;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class MarginEntrustConfirmDialog
extends DialogObj {
    @FXML
    private TableView<MarginSingleEntrust> tableItems;
    @FXML
    private TableColumn<MarginSingleEntrust, String> index;
    @FXML
    private TableColumn<MarginSingleEntrust, String> colCode;
    @FXML
    private TableColumn<MarginSingleEntrust, String> colName;
    @FXML
    private TableColumn<MarginSingleEntrust, String> colMkt;
    @FXML
    private TableColumn<MarginSingleEntrust, String> colDirection;
    @FXML
    private TableColumn<MarginSingleEntrust, Number> colCount;
    @FXML
    private TableColumn<MarginSingleEntrust, String> colUnit;
    @FXML
    private TableColumn<MarginSingleEntrust, Number> colPrice;
    @FXML
    private TableColumn<MarginSingleEntrust, Number> colAmt;
    @FXML
    private TableColumn<MarginSingleEntrust, String> colAcc;
    @FXML
    private TableColumn<MarginSingleEntrust, String> colSecAcc;
    @FXML
    private TableColumn<MarginSingleEntrust, String> colTip;
    @FXML
    private Label lbTotalCount;
    @FXML
    private Label lbTotalAmt;
    @FXML
    private Label totalTip;
    @FXML
    private Label labInfo;
    @FXML
    private Tooltip tpTip;
    private ObservableList<MarginSingleEntrust> list = FxUtils.newList();
    private Map<FundAccount, Double> accCashBuyMap = new HashMap<FundAccount, Double>();
    private Map<FundAccount, Double> accBuyMap = new HashMap<FundAccount, Double>();
    public long totalCount = 0L;
    private double totalAmt = 0.0;
    private String strTip = "";
    public boolean triggered = false;
    private RefItem refItem;
    protected MarketItem mktItem;
    private MxNode priceStg;
    private BooleanProperty showCol = new SimpleBooleanProperty(true);
    private String type = "";
    private String unit = "";
    private boolean showWarning = true;
    private MxNode priceTypeLimitedStg;
    private MxNode priceTypeMktStg;
    private MxNode priceTypeBidAskStg;
    private boolean isInstruction = false;
    private boolean isExecution = false;
    private String instructionPanelType = "";
    private String instructionPrifix = "";
    private static final String GEM_BUY_TIP = "\u8fde\u7eed\u7ade\u4ef7\u9636\u6bb5\uff0c\u60a8\u7684\u4e70\u5165\u7533\u62a5\u82e5\u4ef7\u683c\u9ad8\u4e8e\u57fa\u51c6\u4ef7\u7684102%,\u5c06\u4f1a\u88ab\u6682\u5b58,\u5f53\u80a1\u4ef7\u8fdb\u5165\u6709\u6548\u7ade\u4ef7\u8303\u56f4\u65b9\u53ef\u53c2\u4e0e\u7ade\u4ef7\uff0c\u8bf7\u6ce8\u610f\u67e5\u770b\u59d4\u6258\u72b6\u6001.";
    private static final String GEM_SELL_TIP = "\u8fde\u7eed\u7ade\u4ef7\u9636\u6bb5\uff0c\u60a8\u7684\u5356\u51fa\u7533\u62a5\u82e5\u4ef7\u683c\u4f4e\u4e8e\u57fa\u51c6\u4ef7\u768498%,\u5c06\u4f1a\u88ab\u6682\u5b58,\u5f53\u80a1\u4ef7\u8fdb\u5165\u6709\u6548\u7ade\u4ef7\u8303\u56f4\u65b9\u53ef\u53c2\u4e0e\u7ade\u4ef7\uff0c\u8bf7\u6ce8\u610f\u67e5\u770b\u59d4\u6258\u72b6\u6001.";
    private String approveSymbol = "\u5ba1\u6279\u901a\u8fc7";

    @FXML
    public void initialize() {
        this.createTable();
        this.calTotalInfo();
        this.initControl();
        this.showGemTip();
    }

    private void showGemTip() {
        for (MarginSingleEntrust item : this.list) {
            if (!this.isGem(item)) continue;
            if (MarketIndicator.KCREDIT_PLEGDE_BUY.getDesc().equals(item.getMarketIndicateShow())) {
                this.labInfo.setText(GEM_BUY_TIP);
                break;
            }
            if (!MarketIndicator.KCREDIT_PLEGDE_SELL.getDesc().equals(item.getMarketIndicateShow())) continue;
            this.labInfo.setText(GEM_SELL_TIP);
            break;
        }
    }

    private boolean isGem(MarginSingleEntrust item) {
        return item.getSec().startsWith("30") && "XSHE".equals(item.getMarket());
    }

    protected void initControl() {
        if (!this.countIsEmpty()) {
            this.lbTotalCount.setText(this.totalCount == 0L ? "" : StringUtils.toThousands((String)String.valueOf(this.totalCount)));
        }
        this.lbTotalAmt.setText(this.totalAmt == 0.0 ? "" : StringUtils.toPriceStr((double)this.totalAmt, (int)2));
        this.totalTip.getStyleClass().add((Object)"priceTag");
        this.totalTip.setText(this.strTip);
        CssUtils.makeRise((Control)this.totalTip);
        this.tpTip.setText(this.strTip);
    }

    private void calTotalInfo() {
        for (MarginSingleEntrust item : this.list) {
            Double num;
            double money = this.getMoney(item);
            if (this.isCashBuy(item)) {
                num = this.accCashBuyMap.get(item.getFundAccount());
                this.accCashBuyMap.put(item.getFundAccount(), num == null ? money : num + money);
            }
            if (this.isBuy(item)) {
                num = this.accBuyMap.get(item.getFundAccount());
                this.accBuyMap.put(item.getFundAccount(), num == null ? money : num + money);
            }
            if (!MarketIndicator.KCREDIT_CASH_PAYOFF.getValue().equals(item.getMarketIndicate())) {
                this.totalCount += item.getQuantity();
            }
            this.totalAmt += money;
            if (!this.showWarning || !this.checkSufficient(item)) continue;
            this.triggered = true;
        }
        if (this.triggered) {
            this.strTip = "\u8bf7\u6ce8\u610f\u5907\u6ce8\u4fe1\u606f\u63d0\u793a\n";
            return;
        }
        StringBuilder bld = new StringBuilder();
        if (!this.showWarning) {
            return;
        }
        for (FundAccount acc : this.accCashBuyMap.keySet()) {
            if (!(acc.getAvailableNew() < this.accCashBuyMap.get(acc))) continue;
            bld.append(acc.getInvestId());
            bld.append("\u8d26\u53f7\u53ef\u7528\u8d44\u91d1\u4e0d\u8db3\t");
        }
        for (FundAccount acc : this.accBuyMap.keySet()) {
            if (!(acc.getMarginAvlNew() < this.accBuyMap.get(acc)) || !(acc.getDcreditAvlNew() < this.accBuyMap.get(acc)) && !(acc.getFcreditAvlNew() < this.accBuyMap.get(acc))) continue;
            bld.append(acc.getInvestId());
            bld.append("\u8d26\u53f7\u53ef\u7528\u4fdd\u8bc1\u91d1\u4ee5\u53ca\u878d\u8d44\u878d\u5238\u53ef\u7528\u989d\u5ea6\u4e0d\u8db3\t");
        }
        this.strTip = bld.toString();
    }

    private boolean checkSufficient(MarginSingleEntrust item) {
        switch (item.getMarketIndicate()) {
            case "CASH_BUY": {
                item.setInsufficient(this.getMoney(item) > item.getFundAccount().getFcreditAvlNew() && this.getMoney(item) > item.getFundAccount().getMarginAvlNew());
                item.setTip(item.isInsufficient() ? "\u878d\u8d44\u53ef\u7528\u989d\u5ea6\u548c\u53ef\u7528\u4fdd\u8bc1\u91d1\u4e0d\u8db3" : "");
                break;
            }
            case "POS_SELL": {
                item.setInsufficient(this.getMoney(item) > item.getFundAccount().getFcreditAvlNew() && this.getMoney(item) > item.getFundAccount().getMarginAvlNew());
                item.setTip(item.isInsufficient() ? "\u878d\u5238\u53ef\u7528\u989d\u5ea6\u548c\u53ef\u7528\u4fdd\u8bc1\u91d1\u4e0d\u8db3" : "");
                break;
            }
            case "PLEDGE_BUY": 
            case "POS_BUY_PAYOFF": 
            case "CASH_PAYOFF": {
                item.setInsufficient(this.getMoney(item) > item.getFundAccount().getAvailableNew());
                item.setTip(item.isInsufficient() ? "\u53ef\u7528\u8d44\u91d1\u4e0d\u8db3" : "");
                break;
            }
            case "PLEDGE_SELL": {
                item.setInsufficient(item.getQuantity() > item.getCanSell());
                item.setTip(item.isInsufficient() ? "\u53ef\u5356\u6570\u4e0d\u8db3" : "");
                break;
            }
            case "VOUCHER_PAYOFF": 
            case "CASH_SELL_PAYOFF": {
                item.setInsufficient(item.getQuantity() > item.getCanReturnCount());
                item.setTip(item.isInsufficient() ? "\u53ef\u8fd8\u6570\u4e0d\u8db3" : "");
            }
        }
        return item.isInsufficient();
    }

    protected void createTable() {
        MxNode node = MxNodeFactory.create((String)"market_code", (String)"");
        this.index.setCellValueFactory(data -> new ReadOnlyStringWrapper(String.valueOf(data.getTableView().getItems().indexOf(data.getValue()) + 1)));
        if (!this.priceIsEmpty()) {
            this.colCode.setCellValueFactory(m -> ((MarginSingleEntrust)m.getValue()).secProperty());
            this.colName.setCellValueFactory(m -> ((MarginSingleEntrust)m.getValue()).secNameProperty());
            this.colMkt.setCellValueFactory(m -> new SimpleStringProperty(node.getNode(((MarginSingleEntrust)m.getValue()).getMarket()).getValue()));
        }
        this.colDirection.setCellFactory(cell -> new MarketIndicateSell());
        this.colDirection.setCellValueFactory(m -> ((MarginSingleEntrust)m.getValue()).marketIndicateShowProperty());
        if (!this.countIsEmpty()) {
            this.colCount.setCellValueFactory(m -> ((MarginSingleEntrust)m.getValue()).quantityProperty());
            this.colCount.setCellFactory(cell -> new NumberTableCell());
        }
        if (!this.unitIsEmpty()) {
            this.colUnit.setCellValueFactory(m -> {
                ((MarginSingleEntrust)m.getValue()).setUnit(this.unit);
                return ((MarginSingleEntrust)m.getValue()).unitProperty();
            });
        }
        if (!this.priceIsEmpty()) {
            this.colPrice.setCellFactory(cell -> new ItemPriceCell());
            this.colPrice.setCellValueFactory(m -> ((MarginSingleEntrust)m.getValue()).priceProperty());
        }
        this.colAmt.setCellFactory(cell -> new AmtDoubleTableCell());
        this.colAmt.setCellValueFactory(m -> new SimpleDoubleProperty(this.getMoney((MarginSingleEntrust)m.getValue())));
        this.colAcc.setCellValueFactory(m -> ((MarginSingleEntrust)m.getValue()).investorIdProperty());
        this.colSecAcc.setCellValueFactory(m -> ((MarginSingleEntrust)m.getValue()).investorSecIdProperty());
        this.colTip.setCellFactory(cell -> new TipCell());
        this.colTip.setCellValueFactory(m -> ((MarginSingleEntrust)m.getValue()).tipProperty());
        this.colCount.visibleProperty().bind((ObservableValue)this.showCol);
        this.colUnit.visibleProperty().bind((ObservableValue)this.showCol);
        this.colPrice.visibleProperty().bind((ObservableValue)this.showCol);
        this.colCode.visibleProperty().bind((ObservableValue)this.showCol);
        this.colName.visibleProperty().bind((ObservableValue)this.showCol);
        this.colMkt.visibleProperty().bind((ObservableValue)this.showCol);
        this.colSecAcc.visibleProperty().bind((ObservableValue)this.showCol);
        this.tableItems.setItems(this.list);
    }

    private boolean isCashBuy(MarginSingleEntrust item) {
        return MarketIndicator.KCREDIT_PLEGDE_BUY.getValue().equals(item.getMarketIndicate()) || MarketIndicator.KCREDIT_POS_BUY_PAYOFF.getValue().equals(item.getMarketIndicate()) || MarketIndicator.KCREDIT_CASH_PAYOFF.getValue().equals(item.getMarketIndicate());
    }

    private boolean isBuy(MarginSingleEntrust item) {
        return MarketIndicator.KCREDIT_CASH_BUY.getValue().equals(item.getMarketIndicate()) || MarketIndicator.KCREDIT_POS_SELL.getValue().equals(item.getMarketIndicate());
    }

    private double getMoney(MarginSingleEntrust item) {
        if (MarketIndicator.KCREDIT_VOUCHER_PAYOFF.getValue().equals(item.getMarketIndicate())) {
            if ("XSHG".equals(item.getMarket()) && "BOND".equals(item.getSecType())) {
                return (double)item.getQuantity() * this.mktItem.getNowPrice() * 10.0;
            }
            return (double)item.getQuantity() * this.mktItem.getNowPrice();
        }
        if (MarketIndicator.KCREDIT_CASH_PAYOFF.getValue().equals(item.getMarketIndicate())) {
            return item.getPrice();
        }
        if ("XSHG".equals(item.getMarket()) && "BOND".equals(item.getSecType())) {
            return (double)item.getQuantity() * item.getPrice() * 10.0;
        }
        return (double)item.getQuantity() * item.getPrice();
    }

    private boolean priceIsEmpty() {
        switch (this.type) {
            case "CASH_PAYOFF": {
                return true;
            }
        }
        return false;
    }

    private boolean unitIsEmpty() {
        switch (this.type) {
            case "CASH_PAYOFF": {
                return true;
            }
        }
        return false;
    }

    private boolean countIsEmpty() {
        switch (this.type) {
            case "CASH_PAYOFF": {
                return true;
            }
        }
        return false;
    }

    public void setRefItem(RefItem refItem) {
        this.refItem = refItem;
    }

    private RefItem getRefItem() {
        return this.refItem;
    }

    public void setPriceStg(MxNode priceStg) {
        this.priceStg = priceStg;
    }

    private MxNode getPriceStg() {
        return this.priceStg;
    }

    public void setList(List<MarginSingleEntrust> list) {
        this.list.setAll(list);
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isPlegde() {
        return this.type.equals("PLEDGE");
    }

    public boolean isAlgo() {
        return this.type.equals("ALGO");
    }

    public MxNode getPriceTypeLimitedStg() {
        return this.priceTypeLimitedStg;
    }

    public void setPriceTypeLimitedStg(MxNode priceTypeLimitedStg) {
        this.priceTypeLimitedStg = priceTypeLimitedStg;
    }

    public MxNode getPriceTypeMktStg() {
        return this.priceTypeMktStg;
    }

    public void setPriceTypeMktStg(MxNode priceTypeMktStg) {
        this.priceTypeMktStg = priceTypeMktStg;
    }

    public MxNode getPriceTypeBidAskStg() {
        return this.priceTypeBidAskStg;
    }

    public void setPriceTypeBidAskStg(MxNode priceTypeBidAskStg) {
        this.priceTypeBidAskStg = priceTypeBidAskStg;
    }

    public boolean isShowWarning() {
        return this.showWarning;
    }

    public void setShowWarning(boolean showWarning) {
        this.showWarning = showWarning;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public MarketItem getMktItem() {
        return this.mktItem;
    }

    public void setMktItem(MarketItem mktItem) {
        this.mktItem = mktItem;
    }

    public final BooleanProperty showColProperty() {
        return this.showCol;
    }

    public final boolean isShowCol() {
        return this.showColProperty().get();
    }

    public final void setShowCol(boolean showCol) {
        this.showColProperty().set(showCol);
    }

    public boolean isInstruction() {
        return this.isInstruction;
    }

    public void setInstruction(boolean isInstruction) {
        this.isInstruction = isInstruction;
    }

    public boolean isExecution() {
        return this.isExecution;
    }

    public void setExecution(boolean isExecution) {
        this.isExecution = isExecution;
    }

    public String getInstructionPanelType() {
        return this.instructionPanelType;
    }

    public void setInstructionPanelType(String instructionPanelType) {
        this.instructionPanelType = instructionPanelType;
    }

    public String getInstructionPrifix() {
        return this.instructionPrifix;
    }

    public void setInstructionPrifix(String instructionPrifix) {
        this.instructionPrifix = instructionPrifix;
    }

    public class AmtDoubleTableCell<S>
    extends TableCell<S, Number> {
        private DecimalFormat sDFPrice = new DecimalFormat(",##0.00");

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                if (item != null && item.doubleValue() != 0.0) {
                    this.setText(this.sDFPrice.format(item));
                } else {
                    this.setText(null);
                }
            } else {
                this.setText(null);
            }
        }
    }

    private class ItemPriceCell
    extends TableCell<MarginSingleEntrust, Number> {
        private final PseudoClass MARKET_PRICE = PseudoClass.getPseudoClass((String)"marketPrice");

        public void updateItem(Number value, boolean empty) {
            if (empty) {
                this.setText(null);
                return;
            }
            MarginSingleEntrust item = (MarginSingleEntrust)MarginSingleEntrust.class.cast(this.getTableRow().getItem());
            if (item == null) {
                this.setText(null);
                return;
            }
            if (MarginEntrustConfirmDialog.this.isInstruction) {
                if (item.getOrderType() == 49) {
                    this.setText(MarginEntrustConfirmDialog.this.getPriceStg() != null ? "\u5e02\u4ef7-" + MarginEntrustConfirmDialog.this.getPriceTypeMktStg().getValue() : "");
                    this.pseudoClassStateChanged(this.MARKET_PRICE, true);
                } else if (item.getOrderType() == 50 && item.getPlateLevels() == 0) {
                    double unit;
                    this.pseudoClassStateChanged(this.MARKET_PRICE, false);
                    double d = unit = MarginEntrustConfirmDialog.this.getRefItem() != null ? MarginEntrustConfirmDialog.this.getRefItem().getPriceUnit() : 2.0;
                    if (item.getMarket().equals("XHKG")) {
                        unit = 0.001;
                    }
                    String text = "";
                    if (value.doubleValue() != 0.0) {
                        if (MarginEntrustConfirmDialog.this.getPriceTypeLimitedStg() != null) {
                            text = "-";
                        }
                        text = String.valueOf(text) + StringUtils.toPriceStr((double)value.doubleValue(), (double)unit);
                    }
                    if (MarginEntrustConfirmDialog.this.getPriceTypeLimitedStg() != null && "3".equals(MarginEntrustConfirmDialog.this.getPriceTypeLimitedStg().getRaw())) {
                        text = "";
                    }
                    this.setText(String.valueOf(MarginEntrustConfirmDialog.this.getPriceTypeLimitedStg() != null ? MarginEntrustConfirmDialog.this.getPriceTypeLimitedStg().getValue() : "") + text);
                } else if (item.getOrderType() == 50 && item.getPlateLevels() != 0) {
                    this.setText(MarginEntrustConfirmDialog.this.getPriceTypeBidAskStg() != null ? "\u76d8\u53e3-" + MarginEntrustConfirmDialog.this.getPriceTypeBidAskStg().getValue() : "");
                    this.pseudoClassStateChanged(this.MARKET_PRICE, true);
                } else {
                    this.pseudoClassStateChanged(this.MARKET_PRICE, false);
                    double unit = MarginEntrustConfirmDialog.this.getRefItem() != null ? MarginEntrustConfirmDialog.this.getRefItem().getPriceUnit() : 2.0;
                    String text = StringUtils.toPriceStr((double)value.doubleValue(), (double)unit);
                    this.setText(text);
                }
            } else if (item.getOrderType() == 49) {
                if (MarginEntrustConfirmDialog.this.isExecution) {
                    this.setText(MarginEntrustConfirmDialog.this.getPriceStg() != null ? "\u5e02\u4ef7-" + MarginEntrustConfirmDialog.this.getPriceTypeMktStg().getValue() : "");
                    this.pseudoClassStateChanged(this.MARKET_PRICE, true);
                } else {
                    this.setText(MarginEntrustConfirmDialog.this.getPriceStg() != null ? "\u5e02\u4ef7-" + MarginEntrustConfirmDialog.this.getPriceStg().getValue() : "");
                    this.pseudoClassStateChanged(this.MARKET_PRICE, true);
                }
            } else {
                double unit;
                this.pseudoClassStateChanged(this.MARKET_PRICE, false);
                double d = unit = MarginEntrustConfirmDialog.this.getRefItem() != null ? MarginEntrustConfirmDialog.this.getRefItem().getPriceUnit() : 0.01;
                if (item.getMarket().equals("XHKG")) {
                    unit = 0.001;
                }
                String text = StringUtils.toPriceStr((double)value.doubleValue(), (double)unit);
                this.setText(text);
            }
        }
    }

    private class MarketIndicateSell
    extends TableCell<MarginSingleEntrust, String> {
        private Label label = new Label();

        private MarketIndicateSell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(String value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            this.label.setText(value);
            if (MarketIndicator.KCREDIT_PLEGDE_BUY.getDesc().equals(value) || MarketIndicator.KCREDIT_POS_BUY_PAYOFF.getDesc().equals(value) || MarketIndicator.KCREDIT_CASH_BUY.getDesc().equals(value) || MarketIndicator.KCREDIT_CASH_PAYOFF.getDesc().equals(value) || MarketIndicator.KCREDIT_VOUCHER_PAYOFF.getDesc().equals(value) || MarketIndicator.KCREDIT_PLEGDE_IN.getDesc().equals(value)) {
                CssUtils.makeRise((Control)this.label);
            } else {
                CssUtils.makeFall((Control)this.label);
            }
            if (MarginEntrustConfirmDialog.this.isInstruction) {
                this.label.setText(String.valueOf(MarginEntrustConfirmDialog.this.instructionPrifix) + this.label.getText());
                if ("2".equals(MarginEntrustConfirmDialog.this.instructionPanelType)) {
                    this.label.setText(MarginEntrustConfirmDialog.this.approveSymbol);
                }
            }
            this.setGraphic((Node)this.label);
        }
    }

    private class TipCell
    extends TableCell<MarginSingleEntrust, String> {
        private Label label = new Label();

        private TipCell() {
            this.label.getStyleClass().add((Object)"priceTag");
            CssUtils.makeRise((Control)this.label);
        }

        public void updateItem(String value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            this.label.setText(value);
            this.setGraphic((Node)this.label);
        }
    }
}

