/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.margin.view;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.IUIService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.entity.FundAccount;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javax.inject.Inject;

public class MarginBatchTransferPart
extends MxPart {
    @Inject
    private FundAccountMngServiceImpl accntModel;
    @Inject
    private MEventService es;
    @Inject
    protected IUIService uiService;
    @Inject
    private MxAlert alert;
    @FXML
    private ComboBox<FundAccount> cmbFund;
    @FXML
    private ComboBox<String> cmbType;
    @FXML
    private TextField txtSide;
    @FXML
    private Button btnConfirm;
    private static final String CONFIRM_IN = "\u786e\u5b9a\u5212\u5165";
    private static final String CONFIRM_OUT = "\u786e\u5b9a\u5212\u51fa";
    private static final String PLEDGE_IN = "\u62c5\u4fdd\u54c1\u5212\u5165";
    private static final String PLEDGE_OUT = "\u62c5\u4fdd\u54c1\u5212\u51fa";
    private static final String SIDE_IN = "\u666e\u901a\u8d26\u53f7 --> \u4fe1\u7528\u8d26\u53f7";
    private static final String SIDE_OUT = "\u4fe1\u7528\u8d26\u53f7 --> \u666e\u901a\u8d26\u53f7";
    private static final List<String> SIDES = Arrays.asList("\u62c5\u4fdd\u54c1\u5212\u5165", "\u62c5\u4fdd\u54c1\u5212\u51fa");
    private static final String NORMAL_POSITION = "cms.tmx.margin.part.pledge.normal.positionQueryPart";
    private static final String CREDIT_POSITION = "cms.tmx.margin.part.pledge.positionQueryPart";
    private ObservableList<FundAccount> fundAccounts = FxUtils.newList();

    @FXML
    private void initialize() {
        this.addListener();
        this.initValue();
    }

    private void addListener() {
        this.cmbType.getSelectionModel().selectedItemProperty().addListener((old, ob, newV) -> {
            if (Objects.equals(newV, PLEDGE_IN)) {
                this.txtSide.setText(SIDE_IN);
                this.btnConfirm.setText(CONFIRM_IN);
                this.uiService.showPart(NORMAL_POSITION);
            } else if (Objects.equals(newV, PLEDGE_OUT)) {
                this.txtSide.setText(SIDE_OUT);
                this.btnConfirm.setText(CONFIRM_OUT);
                this.uiService.showPart(CREDIT_POSITION);
            }
        });
        this.es.subscribe("get.accnt", e -> {
            if (this.cmbFund.getSelectionModel().getSelectedItem() != null) {
                e.put((Object)"fundAccount", (Object)((FundAccount)this.cmbFund.getSelectionModel().getSelectedItem()).getInvestId());
            }
        });
        this.cmbFund.getSelectionModel().selectedItemProperty().addListener((old, ob, newV) -> this.es.sendEvent("change.accnt", null));
    }

    private void initValue() {
        this.cmbType.setItems(FXCollections.observableList(SIDES));
        this.cmbType.getSelectionModel().select(0);
        for (FundAccount fundAccount : this.accntModel.getMarginFundAccountList()) {
            if (!Objects.equals("99999-02-02", fundAccount.getCounterId())) continue;
            this.fundAccounts.add((Object)fundAccount);
        }
        this.cmbFund.setItems(this.fundAccounts);
        if (!this.fundAccounts.isEmpty()) {
            this.cmbFund.getSelectionModel().select(0);
        }
    }

    @FXML
    private void selectAll() {
        String type = (String)this.cmbType.getSelectionModel().getSelectedItem();
        if (Objects.equals(type, PLEDGE_IN)) {
            this.uiService.showPart(NORMAL_POSITION);
            this.es.sendEvent("normal.select.all", null);
        } else if (Objects.equals(type, PLEDGE_OUT)) {
            this.uiService.showPart(CREDIT_POSITION);
            this.es.sendEvent("margin.select.all", null);
        }
    }

    @FXML
    private void confirm() {
        FundAccount fundAccount = (FundAccount)this.cmbFund.getSelectionModel().getSelectedItem();
        if (fundAccount == null) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u9009\u62e9\u8981\u5212\u8f6c\u7684\u4fe1\u7528\u8d26\u53f7");
        }
        String type = (String)this.cmbType.getSelectionModel().getSelectedItem();
        MEvent event = new MEvent();
        event.put((Object)"fundAccount", this.cmbFund.getSelectionModel().getSelectedItem());
        if (Objects.equals(type, PLEDGE_IN)) {
            this.es.sendEvent("margin.pledge.in", event);
        } else if (Objects.equals(type, PLEDGE_OUT)) {
            this.es.sendEvent("margin.pledge.out", event);
        }
    }
}

