/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.margin.view;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.control.utils.ImportExcel;
import cms.tmx.core.IUIService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.http.api.ObInstrument;
import cms.tmx.http.api.strategy.dto.ObPosAccnt;
import cms.tmx.http.api.strategy.dto.ObPositionMargin;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.utils.RegexUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.stage.FileChooser;
import javax.inject.Inject;

public class MarginBatchTransferFilePart
extends MxPart {
    @Inject
    private FundAccountMngServiceImpl accntModel;
    @Inject
    private MEventService es;
    @Inject
    protected IUIService uiService;
    @Inject
    private MxAlert alert;
    @Inject
    private IRefDataMng refMng;
    @FXML
    private ComboBox<FundAccount> cmbFund;
    @FXML
    private ComboBox<String> cmbType;
    @FXML
    private TextField txtSide;
    @FXML
    private Button btnConfirm;
    private static final String PLEDGE_IN = "\u62c5\u4fdd\u54c1\u5212\u5165";
    private static final String SIDE_IN = "\u666e\u901a\u8d26\u53f7 --> \u4fe1\u7528\u8d26\u53f7";
    private static final String XLSX = ".xlsx";
    private static final String XLS = ".xls";
    private static final String DELIMITER = ",";
    private static final List<String> SIDES = Arrays.asList("\u62c5\u4fdd\u54c1\u5212\u5165");
    private List<RefItem> refList = new LinkedList<RefItem>();
    private Map<String, RefItem> mapItem = new ConcurrentHashMap<String, RefItem>();
    private ObservableList<FundAccount> fundAccounts = FxUtils.newList();

    @FXML
    private void initialize() {
        this.addListener();
        this.initValue();
        this.initRefItem();
    }

    private void addListener() {
        this.es.subscribe("get.accnt.file", e -> {
            if (this.cmbFund.getSelectionModel().getSelectedItem() != null) {
                e.put((Object)"fundAccount", (Object)((FundAccount)this.cmbFund.getSelectionModel().getSelectedItem()).getInvestId());
            }
        });
        this.cmbFund.getSelectionModel().selectedItemProperty().addListener((old, ob, newV) -> this.es.sendEvent("change.accnt.file", null));
    }

    private void initValue() {
        this.cmbType.setItems(FXCollections.observableList(SIDES));
        this.cmbType.getSelectionModel().select(0);
        this.cmbType.setDisable(true);
        this.txtSide.setText(SIDE_IN);
        this.txtSide.setDisable(true);
        for (FundAccount fundAccount : this.accntModel.getMarginFundAccountList()) {
            if (!Objects.equals("99999-02-02", fundAccount.getCounterId())) continue;
            this.fundAccounts.add((Object)fundAccount);
        }
        this.cmbFund.setItems(this.fundAccounts);
        if (!this.fundAccounts.isEmpty()) {
            this.cmbFund.getSelectionModel().select(0);
        }
    }

    @FXML
    private void down() {
        InputStream fis = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("templete/templete.xlsx");
        try {
            ExcelUtils.saveFile((InputStream)fis, (String)"\u5bfc\u5165\u6a21\u677f.xlsx");
        }
        catch (Exception e) {
            this.logger.error((Object)e, (Throwable)e);
        }
        catch (MException mException) {
            this.logger.error("\u53d6\u6d88\u4e0b\u8f7d");
        }
    }

    @FXML
    private void upload() {
        FileChooser chooser = new FileChooser();
        File file = chooser.showOpenDialog(null);
        if (file == null) {
            return;
        }
        try {
            List<ObPositionMargin> list = this.checkAndImport(file);
            MEvent event = new MEvent();
            event.put((Object)"data", list);
            this.es.sendEvent("upload.position", event);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private void initRefItem() {
        Collection items = this.refMng.getItems(new String[]{"STOCK", "FUND", "BOND"});
        this.refList.addAll(items);
        for (RefItem item : this.refList) {
            String key = String.join((CharSequence)DELIMITER, item.getMarket(), item.getCode());
            RefItem ref = this.mapItem.get(key);
            if (ref != null) continue;
            this.mapItem.put(key, item);
        }
    }

    private List<ObPositionMargin> checkAndImport(File file) throws Exception {
        if (!file.getPath().endsWith(XLSX) && !file.getPath().endsWith(XLS)) {
            throw new Exception("\u5212\u8f6c\u6301\u4ed3\u5bfc\u5165\u5931\u8d25\uff0c\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        List positions = ImportExcel.read((String)file.getPath());
        if (positions == null) {
            throw new Exception("\u5212\u8f6c\u5931\u8d25\uff0c\u6587\u4ef6\u5185\u5bb9\u9519\u8bef");
        }
        if (!positions.isEmpty()) {
            positions.remove(0);
        }
        ObservableList list = FxUtils.newList();
        int j = 0;
        while (j < positions.size()) {
            int nullRow = 0;
            for (String str : (List)positions.get(j)) {
                if (str != null && !"".equals(str.trim())) continue;
                ++nullRow;
            }
            if (nullRow != ((List)positions.get(j)).size()) {
                ObPositionMargin item = new ObPositionMargin();
                ObInstrument instrument = new ObInstrument();
                int i = 0;
                while (i < ((List)positions.get(j)).size()) {
                    if (!((List)positions.get(j)).isEmpty()) {
                        String value = (String)((List)positions.get(j)).get(i);
                        switch (i) {
                            case 0: {
                                if (value.trim().isEmpty()) {
                                    throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c" + (j + 2) + "\u884c\u8d44\u91d1\u8d26\u53f7\u4e3a\u7a7a");
                                }
                                if (!RegexUtils.isFUND_ACCOUNT((String)value)) {
                                    throw new Exception("\u5bfc\u5165\u5931\u8d25 \uff0c\u7b2c" + (j + 2) + "\u884c\u8d44\u91d1\u8d26\u53f7 " + value + "\u683c\u5f0f\u6821\u9a8c\u9519\u8bef");
                                }
                                item.setInvestorId(value);
                                break;
                            }
                            case 1: {
                                if (value.trim().isEmpty()) {
                                    throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c" + (j + 2) + "\u884c\u80a1\u4e1c\u4ee3\u7801\u4e3a\u7a7a");
                                }
                                if (!RegexUtils.isSTOCKHOLDER_CODE((String)value)) {
                                    throw new Exception("\u5bfc\u5165\u5931\u8d25 \uff0c\u7b2c" + (j + 2) + "\u884c\u80a1\u4e1c\u4ee3\u7801 " + value + "\u683c\u5f0f\u6821\u9a8c\u9519\u8bef");
                                }
                                item.setInverstorSecId(value);
                                ObPosAccnt obPosAccnt = new ObPosAccnt();
                                obPosAccnt.setSecAccntId(value);
                                item.setPosAccnt(obPosAccnt);
                                break;
                            }
                            case 2: {
                                if (value.trim().isEmpty()) {
                                    throw new Exception("\u5bfc\u5165\u5931\u8d25\uff0c\u7b2c" + (j + 2) + "\u884c\u8bc1\u5238\u4ee3\u7801\u4e3a\u7a7a");
                                }
                                if (!StringUtils.isNumeric((String)value)) {
                                    throw new Exception("\u5bfc\u5165\u5931\u8d25 \uff0c\u7b2c" + (j + 2) + "\u884c\u8bc1\u5238\u4ee3\u7801 " + value + "\u9519\u8bef");
                                }
                                instrument.setSecId(value);
                                break;
                            }
                            case 3: {
                                boolean flag;
                                boolean bl = flag = "".equals(value) || !"XSHG".equals(value) && !"XSHE".equals(value);
                                if (flag) {
                                    throw new Exception("\u5bfc\u5165\u5931\u8d25 \uff0c\u7b2c" + (j + 2) + "\u884c\u5e02\u573a\u4ee3\u7801\u9519\u8bef");
                                }
                                String key = String.join((CharSequence)DELIMITER, value, instrument.getSecId());
                                RefItem ref = this.mapItem.get(key);
                                if (ref == null) {
                                    throw new Exception("\u5bfc\u5165\u5931\u8d25 \uff0c\u7b2c" + (j + 2) + "\u884c" + instrument.getSecId() + value + "\u8be5\u54c1\u79cd\u4e0d\u5b58\u5728");
                                }
                                instrument.getMarket().setRaw(value);
                                instrument.setSecType(ref.getType());
                                instrument.setSymbol(ref.getName());
                                break;
                            }
                            case 4: {
                                boolean len;
                                BigDecimal b1;
                                if (value.isEmpty()) {
                                    value = "0";
                                }
                                try {
                                    b1 = new BigDecimal(value);
                                }
                                catch (Exception e) {
                                    this.logger.error("import failed", (Throwable)e);
                                    throw new Exception("\u5bfc\u5165\u5931\u8d25 \uff0c\u7b2c" + (j + 2) + "\u884c" + instrument.getSecId() + " \u5212\u8f6c\u6570\u91cf\u5fc5\u987b\u4e3a\u6574\u6570\uff0c\u4e14\u4e0d\u5927\u4e8e9\u4f4d");
                                }
                                value = b1.toString();
                                boolean isDouble = StringUtils.isDouble((String)value);
                                if (isDouble) {
                                    if (Double.parseDouble(value) % 1.0 > 0.0) {
                                        isDouble = false;
                                    }
                                    value = String.valueOf(StringUtils.parseLong((String)value));
                                }
                                boolean ntn = StringUtils.isInt((String)value);
                                boolean bl = len = value.length() > 9;
                                if (!isDouble || len || !ntn) {
                                    throw new Exception("\u5bfc\u5165\u5931\u8d25 \uff0c\u7b2c" + (j + 2) + "\u884c" + instrument.getSecId() + " \u5212\u8f6c\u6570\u91cf\u5fc5\u987b\u4e3a\u6574\u6570\uff0c\u4e14\u4e0d\u5927\u4e8e9\u4f4d");
                                }
                                item.setSecTransfer((double)StringUtils.parseLong((String)value));
                                break;
                            }
                        }
                    }
                    ++i;
                }
                item.setInstrument(instrument);
                list.add((Object)item);
            }
            ++j;
        }
        return list;
    }

    @FXML
    private void confirm() {
        FundAccount fundAccount = (FundAccount)this.cmbFund.getSelectionModel().getSelectedItem();
        if (fundAccount == null) {
            this.alert.alert(Alert.AlertType.ERROR, "\u8bf7\u9009\u62e9\u8981\u5212\u8f6c\u7684\u4fe1\u7528\u8d26\u53f7");
        }
        MEvent event = new MEvent();
        event.put((Object)"fundAccount", this.cmbFund.getSelectionModel().getSelectedItem());
        this.es.sendEvent("margin.pledge.in.file", event);
    }
}

