/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.margin.view;

import cms.tmx.entity.trade.Algorithm;
import cms.tmx.http.api.strategy.dto.AlgoBaseOrder;
import cms.tmx.margin.view.MarginAlgoNode;
import java.net.URL;
import java.util.List;
import javafx.fxml.FXML;
import javax.annotation.PostConstruct;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class MarginAlogNodeDialog
extends MarginAlgoNode {
    private AlgoBaseOrder order;

    @Override
    public List<Algorithm> getAlgos(String engine, Boolean isBuy) {
        return super.getAlgos(engine);
    }

    @Override
    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource("MarginAlgoNode.fxml");
        }
        return url;
    }

    @Override
    @PostConstruct
    public void init() {
        this.setValue(this.order);
        this.setEdit();
    }

    private void setEdit() {
        this.cmbEngine.setVisible(false);
        this.cmbAlgo.setVisible(false);
        this.lbAlgoDesc.setVisible(false);
        this.txtCode.setDisable(true);
        this.cmbBuy.setDisable(true);
        this.cmbSell.setDisable(true);
        this.spnQty.setDisable(true);
        this.txtPercent.setDisable(true);
        this.spnMaxPriceDiff.setDisable(true);
        this.spnSlippage.setDisable(true);
        this.txtRollInterval.setDisable(true);
        this.txtStartHour.setDisable(true);
        this.txtStartMinute.setDisable(true);
    }

    private void setValue(AlgoBaseOrder o) {
        this.txtCode.setText(o.getSecurity());
        if ("".equals(o.getSide())) {
            this.cmbBuy.setItems(this.nodeBuy.getNodes());
            this.cmbSell.setItems(this.nodeSell.getNodes());
            this.cmbBuy.setValue((Object)this.nodeBuy);
            this.nodeSell.clear();
            this.cmbSell.setValue((Object)this.nodeSell);
        } else {
            this.cmbBuy.setItems(this.nodeBuy.getNodes());
            this.cmbSell.setItems(this.nodeSell.getNodes());
            this.cmbSell.setValue((Object)this.nodeBuy);
            this.nodeBuy.clear();
            this.cmbBuy.setValue((Object)this.nodeSell);
        }
        this.spnQty.getEditor().setText(String.valueOf(o.getQty()));
        this.txtPercent.setText(String.valueOf(o.getMktRatio()));
        this.spnMaxPriceDiff.getEditor().setText("" + o.getMaxCost());
        this.spnSlippage.getEditor().setText("" + o.getSlippage());
        this.txtRollInterval.setText("" + o.getRollInterval());
        this.txtStartHour.setText(o.getEntrustTime().substring(0, 2));
        this.txtStartMinute.setText(o.getEntrustTime().substring(2, 3));
        this.btnOrder.setText("\u5173\u95ed");
    }

    public void setAlgoBaseOrder(AlgoBaseOrder o) {
        this.order = o;
    }

    @Override
    @FXML
    public void order() {
    }
}

