/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.margin.view;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.Algorithm;
import cms.tmx.entity.trade.MarginSingleEntrust;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.margin.model.MarginAlgoModel;
import cms.tmx.margin.model.MarginTradeModel;
import cms.tmx.margin.view.MarginAlgoConfirmDialog;
import cms.tmx.margin.view.MarginAlgoNode;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.settings.UserPreOrderTips;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.MouseEvent;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class MarginAlgoTrade
extends MarginAlgoNode {
    @Inject
    private MarginAlgoModel model;
    @Inject
    protected UserPreOrderTips setTips;
    private List<MarginSingleEntrust> entrustsAll = new ArrayList<MarginSingleEntrust>();

    @FXML
    public void initialize() {
        this.model.baseModel = (MarginTradeModel)this.of.create(MarginTradeModel.class);
        this.initAlgo();
        super.initControl();
        this.initControl();
        this.checks();
    }

    @Override
    public void initControl() {
        ObservableList engineList = FxUtils.newList();
        engineList.add((Object)"Mise\u5f15\u64ce");
        this.cmbEngine.setItems(engineList);
        ObservableList algoList = FxUtils.newList();
        Algorithm algo = new Algorithm();
        algo.setType(24);
        algo.setName("Marstag");
        algoList.add((Object)algo);
        this.cmbAlgo.setItems(algoList);
        this.cmbAlgo.getSelectionModel().select(0);
        this.cmbAlgo.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.selectedAlgo((Algorithm)now));
        this.txtCode.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtCode.selectAll());
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        this.txtCode.focusedProperty().addListener((ob, old, newV) -> this.loseFocus((Boolean)newV));
        CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
        this.cmbEngine.getSelectionModel().select(0);
    }

    @Override
    public void order() {
        this.txtCode.requestFocus();
        if (!this.valid()) {
            this.alert.alert(Alert.AlertType.WARNING, "\u53c2\u6570\u8bbe\u7f6e\u9519\u8bef\uff01");
            return;
        }
        if (this.model.baseModel.getMI() != null && this.model.baseModel.getMI().getStop().getValue().booleanValue()) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bc1\u5238\u505c\u724c");
            return;
        }
        this.submitParam();
        String tip2 = "\u8f67\u5e73\u95f4\u9694\u9700\u5927\u4e8e0\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165";
        if (!this.alert.check(this.model.getRollInterval() > 0, Alert.AlertType.WARNING, tip2)) {
            return;
        }
        String tip3 = "\u4ef7\u683c\u6ed1\u70b9\u9700\u5927\u4e8e0\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165";
        if (!this.alert.check(this.model.getPriceSlip() > 0.0, Alert.AlertType.WARNING, tip3)) {
            return;
        }
        String tip4 = "\u672a\u9009\u62e9\u8bc1\u5238\u8d26\u53f7";
        if (!this.alert.check(this.model.baseModel.getAccDisModel().getSelectedNum() >= 1, Alert.AlertType.WARNING, tip4)) {
            return;
        }
        List<MarginSingleEntrust> entrusts = this.model.getEntrustList(false);
        MarginAlgoConfirmDialog obj = (MarginAlgoConfirmDialog)((Object)this.of.create(MarginAlgoConfirmDialog.class));
        this.entrustsAll.clear();
        for (MarginSingleEntrust buyEn : entrusts) {
            if (buyEn.getMarketIndicateShow() != null) continue;
            buyEn.setMarketIndicateShow(this.model.getBuyStg().equals("CASH_BUY") ? "\u878d\u8d44\u4e70\u5165" : "\u62c5\u4fdd\u54c1\u4e70\u5165");
            buyEn.setMarket(this.model.baseModel.getMI().getRefItem().getMarket());
            buyEn.setPrice(this.model.getPrice());
            buyEn.setAlgoName("Marstag\u7b97\u6cd5");
            this.entrustsAll.add(buyEn);
            MarginSingleEntrust sellEn = new MarginSingleEntrust();
            sellEn.setSec(buyEn.getSec());
            sellEn.setSecType(buyEn.getSecType());
            sellEn.setSecName(buyEn.getSecName());
            sellEn.setMarketIndicateShow("\u878d\u5238\u5356\u51fa");
            sellEn.setMarket(this.model.baseModel.getMI().getRefItem().getMarket());
            sellEn.setQuantity(buyEn.getQuantity());
            sellEn.setPrice(this.model.getPrice());
            sellEn.setAlgoName("Marstag\u7b97\u6cd5");
            sellEn.setInvestorId(buyEn.getInvestorId());
            sellEn.setInvestorSecId(buyEn.getInvestorSecId());
            this.entrustsAll.add(sellEn);
        }
        obj.setMktItem(this.model.baseModel.getMI());
        obj.setRefItem(this.model.baseModel.getMI().getRefItem());
        obj.setUnit(this.lbUnit.getText());
        obj.setList(this.entrustsAll);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u4e0b\u5355\u786e\u8ba4");
        if (dialog.launch() == ButtonType.OK) {
            this.submitOrder();
        }
    }

    private void submitOrder() {
        try {
            String errorMsg;
            ObservableList<Boolean> listCont = this.model.submitMise();
            String string = errorMsg = StringUtils.isEmpty((String)this.model.getRespMsg()) ? "" : this.model.getRespMsg();
            if (listCont.filtered(each -> each == false).size() > 0) {
                this.alert.alert(Alert.AlertType.ERROR, "\u63d0\u4ea4\u6210\u529f" + listCont.filtered(each -> each).size() + "\u7b14" + " " + "\u5931\u8d25" + listCont.filtered(each -> each == false).size() + "\u7b14" + " " + errorMsg);
            } else {
                this.alert.alert(Alert.AlertType.INFORMATION, "\u63d0\u4ea4\u6210\u529f" + listCont.filtered(each -> each).size() + "\u7b14" + " " + "\u5931\u8d25" + listCont.filtered(each -> each == false).size() + "\u7b14" + " " + errorMsg);
            }
        }
        catch (Exception e) {
            Platform.runLater(() -> {
                boolean bl = this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            });
        }
        this.layout();
    }

    protected void submitParam() {
        RefItem refItem = this.model.baseModel.getMI().getRefItem();
        super.submitParam(refItem);
    }

    @Override
    public List<Algorithm> getAlgos(String engine, Boolean isBuy) {
        List list = this.algoFunc.getRegularAlgo(engine, isBuy);
        return list;
    }

    public void setBaseModel(MarginTradeModel baseModel) {
        this.model.baseModel = baseModel;
    }

    public TextField getTxtCode() {
        return this.txtCode;
    }
}

