/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.margin.view;

import cms.tmx.entity.trade.Algorithm;
import cms.tmx.http.api.strategy.dto.AlgoBaseOrder;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.margin.view.MarginAlgoNode;
import cms.tmx.query.utils.QueryUtils;
import cmx.tmx.data.IMarketDataMng;
import java.net.URL;
import java.util.List;
import javafx.fxml.FXML;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class MarginAlgoNodePart
extends MarginAlgoNode {
    private AlgoBaseOrder order;
    @Inject
    private IMarketDataMng mktMng;

    @Override
    public List<Algorithm> getAlgos(String engine, Boolean isBuy) {
        return super.getAlgos(engine);
    }

    @Override
    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource("MarginAlgoNode.fxml");
        }
        return url;
    }

    @FXML
    public void initialize() {
        super.initControl();
        this.getRefItems();
    }

    public void setEdit() {
        this.cmbEngine.setVisible(false);
        this.cmbAlgo.setVisible(false);
        this.lbAlgoDesc.setVisible(false);
        this.txtCode.setDisable(true);
        this.cmbBuy.setDisable(true);
        this.cmbSell.setDisable(true);
        this.spnQty.setDisable(true);
        this.txtPercent.setDisable(true);
        this.spnMaxPriceDiff.setDisable(true);
        this.spnSlippage.setDisable(true);
        this.txtRollInterval.setDisable(true);
        this.txtStartHour.setDisable(true);
        this.txtStartMinute.setDisable(true);
        this.btnOrder.setVisible(false);
    }

    public void setValue() {
        String unit = QueryUtils.getUnit((String)this.getOrder().getSecType(), (String)this.getOrder().getMarket());
        this.txtCode.setText(this.getOrder().getSecurity());
        this.nodeSell = MxNodeFactory.create((String)"margin_type", (String)"POS_SELL");
        this.nodeBuy = MxNodeFactory.create((String)"margin_type", (String)"CASH_BUY");
        this.lbUnit.setText(unit);
        if ("SIDE_BUY".equals(this.getOrder().getSideStr())) {
            this.cmbBuy.setItems(this.nodeBuy.getNodes());
            this.cmbSell.setItems(this.nodeSell.getNodes());
            this.cmbBuy.setValue((Object)this.getOrder().getTradeType());
            this.nodeSell.setRaw(this.getOrder().getOtherType());
            this.cmbSell.setValue((Object)this.nodeSell);
        } else {
            this.cmbBuy.setItems(this.nodeBuy.getNodes());
            this.cmbSell.setItems(this.nodeSell.getNodes());
            this.cmbSell.setValue((Object)this.getOrder().getTradeType());
            this.nodeBuy.setRaw(this.getOrder().getOtherType());
            this.cmbBuy.setValue((Object)this.nodeBuy);
        }
        this.spnQty.getEditor().setText(String.valueOf(this.getOrder().getQty()));
        this.txtPercent.setText(String.valueOf((int)(this.getOrder().getMktRatio() * 100.0)));
        this.spnMaxPriceDiff.getEditor().setText("" + this.getOrder().getMaxCost());
        this.spnSlippage.getEditor().setText("" + this.getOrder().getSlippage());
        this.txtRollInterval.setText("" + this.getOrder().getRollInterval());
        this.txtStartHour.setText(this.getOrder().getStartTime().substring(0, 2));
        this.txtStartMinute.setText(this.getOrder().getStartTime().substring(2, 4));
        this.btnOrder.setText("\u5173\u95ed");
    }

    public AlgoBaseOrder getOrder() {
        return this.order;
    }

    public void setOrder(AlgoBaseOrder order) {
        this.order = order;
    }
}

