/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.margin.view;

import cms.tmx.algorithm.models.AlgoConfControls;
import cms.tmx.algorithm.models.AlgoModel;
import cms.tmx.algorithm.viewers.AlgoAnnotationDialog;
import cms.tmx.algorithm.viewers.AlgoUtils;
import cms.tmx.control.dialog.BaseValid;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.search.AutoCompletion;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.core.IUIService;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.Algorithm;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.margin.model.MarginAlgoModel;
import cms.tmx.margin.model.MarginTradeModel;
import cms.tmx.margin.view.LoadPartModel;
import cms.tmx.query.current.models.portfolio.AlgoFuncControl;
import cms.tmx.query.current.models.portfolio.AlgoQueryModel;
import cms.tmx.query.margin.models.UnderlyingModel;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public abstract class MarginAlgoNode
extends MxPart
implements BaseValid {
    @FXML
    public ComboBox<String> cmbEngine;
    @FXML
    public ComboBox<Algorithm> cmbAlgo;
    @FXML
    public Label lbAlgoDesc;
    @FXML
    public TextField txtCode;
    @FXML
    protected Label lbName;
    @FXML
    public Label lbUnit;
    @FXML
    protected VBox vboxAlgo;
    @FXML
    public Button btnOrder;
    @FXML
    public ComboBox<MxNode> cmbBuy;
    @FXML
    public ComboBox<MxNode> cmbSell;
    @FXML
    public Spinner<Integer> spnQty;
    @FXML
    public TextField txtPercent;
    @FXML
    public Spinner<Double> spnMaxPriceDiff;
    @FXML
    public Spinner<Double> spnSlippage;
    @FXML
    public TextField txtRollInterval;
    @FXML
    public TextField txtStartHour;
    @FXML
    public TextField txtStartMinute;
    @FXML
    protected Label lbAlgoErr;
    @FXML
    protected Label lbCodeErr;
    @FXML
    protected Label lbQtyErr;
    @FXML
    protected Label lbPercentErr;
    @FXML
    protected Label lbPriceMostErr;
    @FXML
    protected Label lbSliceErr;
    @FXML
    protected Label lbRollIntervalErr;
    @FXML
    protected Label lbStartErr;
    @FXML
    protected Label qtyMag;
    @Inject
    public AlgoQueryModel algo;
    @Inject
    protected MObjFactory of;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    protected MxAlert alert;
    @Inject
    protected DialogFactory df;
    @Inject
    protected IUIService uiService;
    @Inject
    protected AlgoFuncControl algoFunc;
    @Inject
    protected AlgoConfControls algoConf;
    protected Map<Integer, List<Node>> mapAlgo = new HashMap<Integer, List<Node>>();
    protected DoubleSpinnerCtrl ctrlPriceMost = new DoubleSpinnerCtrl(true, 6, 2);
    protected IntSpinnerCtrl ctrlCount = new IntSpinnerCtrl(true, 9, 100);
    protected DoubleSpinnerCtrl ctrlSlip = new DoubleSpinnerCtrl(true, 6, 2);
    protected IntSpinnerCtrl ctrlMinute = new IntSpinnerCtrl(true, 1, 1);
    protected ToggleGroup group = new ToggleGroup();
    protected SecSuggest spCode = new SecSuggest();
    protected SecConverter secCvt;
    protected static final Logger logger = LogManager.getLogger(MarginAlgoNode.class);
    public static final int miseMarstag = 24;
    public int scale = 0;
    public RefItem refItem = null;
    public Boolean isBuy = null;
    @Inject
    protected LoadPartModel load;
    @Inject
    protected MarginTradeModel marginModel;
    @Inject
    protected MarginAlgoModel algoModel;
    public MxNode nodeBuy = null;
    public MxNode nodeSell = null;
    public MxNode nodeInterval = null;
    public MxNode nodeMinute = null;
    private ObservableList<Algorithm> algoList = FxUtils.newList();
    protected AutoCompletion<RefItem> autoCompletionNormal;
    private InvalidationListener listener = ob -> {
        Collection<RefItem> list = this.getRefItems();
        this.spCode.setAllSuggestions(list);
    };
    protected Map<ObservableBooleanValue, Node> mapValid = new LinkedHashMap<ObservableBooleanValue, Node>();
    protected MarketItem mktItem;
    @Inject
    protected UnderlyingModel underlyModel;
    protected int sliceMin = 0;
    private String startTime = "";

    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource("MarginAlgoNode.fxml");
        }
        return url;
    }

    @PostConstruct
    public void init() {
        try {
            this.loadFXML();
        }
        catch (IOException e) {
            logger.error("init part failed", (Throwable)e);
        }
    }

    protected Collection<RefItem> getRefItems() {
        return this.refMng.getItems(new String[]{"STOCK", "BOND", "FUND"});
    }

    protected void initControl() {
        this.refMng.changedProperty().addListener(this.listener);
        ObservableList engineList = FxUtils.newList();
        engineList.add((Object)"Mise\u5f15\u64ce");
        this.cmbEngine.setItems(engineList);
        this.cmbAlgo.setItems(this.algoList);
        this.cmbAlgo.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.selectedAlgo((Algorithm)now));
        this.cmbEngine.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            this.cmbAlgo.getItems().removeAll(this.algoList);
            this.algoList.clear();
            this.cmbAlgo.setItems(this.algoList);
            this.cmbAlgo.show();
            this.cmbAlgo.hide();
            this.cmbAlgo.getSelectionModel().select(0);
        });
        this.lbAlgoDesc.setOnMouseClicked(event -> {
            AlgoAnnotationDialog obj = (AlgoAnnotationDialog)this.of.create(AlgoAnnotationDialog.class);
            MxDialog dialog = this.df.create((DialogObj)obj, "\u7b97\u6cd5\u6ce8\u91ca");
            dialog.launch();
        });
        this.nodeBuy = MxNodeFactory.create((String)"margin_trade_algo_buy", (String)"1");
        this.cmbBuy.setItems(this.nodeBuy.getNodes());
        this.cmbBuy.setValue((Object)this.nodeBuy);
        this.nodeSell = MxNodeFactory.create((String)"margin_trade_algo_sell", (String)"1");
        this.cmbSell.setItems(this.nodeSell.getNodes());
        this.cmbSell.setValue((Object)this.nodeSell);
        this.ctrlPriceMost.ctrl(this.spnMaxPriceDiff);
        this.spnQty.getEditor().focusedProperty().addListener((ob, oldV, newV) -> {
            int max = this.getInt(this.spnMaxPriceDiff.getEditor());
            int qty = this.getInt(this.spnQty.getEditor());
            if (max == 0 || qty == 0) {
                return;
            }
            double maxValue = (double)max / (double)qty > 0.01 ? (double)max / (double)qty : 0.01;
            String slipValue = this.convert(Math.floor(maxValue / 0.01) * 0.01 + 0.01, 2);
            this.spnSlippage.getEditor().setText(slipValue);
        });
        this.spnMaxPriceDiff.getEditor().focusedProperty().addListener((ob, oldV, newV) -> {
            int max = this.getInt(this.spnMaxPriceDiff.getEditor());
            int qty = this.getInt(this.spnQty.getEditor());
            if (max == 0 || qty == 0) {
                return;
            }
            double maxValue = (double)max / (double)qty > 0.01 ? (double)max / (double)qty : 0.01;
            String slipValue = this.convert(Math.floor(maxValue / 0.01) * 0.01 + 0.01, 2);
            this.spnSlippage.getEditor().setText(slipValue);
        });
        this.ctrlSlip.ctrl(this.spnSlippage);
        this.txtPercent.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtPercent.selectAll());
        String percent = "^(([0-9]|([1-9][0-9])|(100)))?$";
        this.txtPercent.setTextFormatter((TextFormatter)new MxFormatter(percent, 2));
        this.txtStartHour.setTextFormatter((TextFormatter)new MxFormatter("^((|[0-9]{0,1})|([0-1][0-9])|(2[0-3]))$", 2));
        this.txtStartMinute.setTextFormatter((TextFormatter)new MxFormatter("^(([0-9]{0,1})|([0-5][0-9]))$", 2));
        this.txtStartHour.textProperty().addListener(ob -> this.sliceChange());
        this.txtStartMinute.textProperty().addListener(ob -> this.sliceChange());
        this.txtStartHour.focusedProperty().addListener(ob -> this.sliceCheck(this.txtStartHour));
        this.txtStartMinute.focusedProperty().addListener(ob -> this.sliceCheck(this.txtStartMinute));
        this.txtStartHour.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtStartHour.selectAll());
        this.txtStartMinute.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtStartMinute.selectAll());
        this.algoModel.timeLimit(this.txtStartHour, this.txtStartMinute);
        SpinnerUtils.arrowsStyle(this.spnQty);
        SpinnerUtils.arrowsStyle(this.spnMaxPriceDiff);
        SpinnerUtils.arrowsStyle(this.spnSlippage);
        this.txtRollInterval.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 5));
        this.txtRollInterval.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtRollInterval.selectAll());
        this.cmbEngine.getSelectionModel().select(0);
    }

    private String convert(double num, int scale) {
        BigDecimal big = new BigDecimal(num);
        double decimal = big.setScale(scale, 4).doubleValue();
        return StringUtils.toStr((double)decimal, (int)scale);
    }

    public void codeKeyPress(KeyEvent key) {
        key.consume();
    }

    protected void checks() {
        this.registerCheck((Node)this.lbCodeErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!this.txtCode.isFocused()) {
                if (this.txtCode.getText().isEmpty()) {
                    this.lbCodeErr.setText("\u8bf7\u8f93\u5165\u8bc1\u5238\u4ee3\u7801");
                    return false;
                }
                if (this.lbName.getText().isEmpty()) {
                    this.lbCodeErr.setText("\u8f93\u5165\u7684\u4ee3\u7801\u65e0\u6548");
                    return false;
                }
            }
            return true;
        }, (Observable[])new Observable[]{this.txtCode.focusedProperty()}));
        this.registerCheck((Node)this.lbCodeErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtCode.getText().isEmpty()) {
                this.lbCodeErr.setText("\u8bf7\u8f93\u5165\u8bc1\u5238\u4ee3\u7801");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtCode.textProperty(), this.lbName.textProperty()}));
        this.registerCheck((Node)this.lbPriceMostErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!StringUtils.isDouble((String)this.spnMaxPriceDiff.getEditor().getText())) {
                return false;
            }
            if (this.getDouble(this.spnMaxPriceDiff) == 0.0) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.spnMaxPriceDiff.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbPercentErr, (ObservableBooleanValue)this.txtPercent.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbPercentErr, (ObservableBooleanValue)this.txtPercent.textProperty().isNotEqualTo("0"));
        this.registerCheck((Node)this.lbQtyErr, (ObservableBooleanValue)this.spnQty.getEditor().textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbQtyErr, (ObservableBooleanValue)this.spnQty.getEditor().textProperty().isNotEqualTo("0"));
        this.registerCheck((Node)this.lbSliceErr, (ObservableBooleanValue)this.spnSlippage.getEditor().textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbSliceErr, (ObservableBooleanValue)this.spnSlippage.getEditor().textProperty().isNotEqualTo("0"));
        this.registerCheck((Node)this.lbRollIntervalErr, (ObservableBooleanValue)this.txtRollInterval.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbRollIntervalErr, (ObservableBooleanValue)this.txtRollInterval.textProperty().isNotEqualTo("0"));
        if (this.algoConf.limitTime()) {
            this.registerCheck((Node)this.lbStartErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
                boolean isRepo;
                int start = this.getInt(this.txtStartHour) * 60 + this.getInt(this.txtStartMinute);
                if (!AlgoModel.timeIsValid((int)start, (boolean)(isRepo = AlgoUtils.isRepo((RefItem)this.refItem)))) {
                    if (isRepo) {
                        this.lbStartErr.setText("\u8303\u56f4 09:30-11:29 13:00-15:29");
                    } else {
                        this.lbStartErr.setText("\u8303\u56f4 09:30-11:29 13:00-14:59");
                    }
                    return false;
                }
                return true;
            }, (Observable[])new Observable[]{this.txtStartHour.textProperty(), this.txtStartMinute.textProperty()}));
        }
    }

    protected void initAlgo() {
        this.vboxAlgo.getChildren().clear();
        List<Node> list = this.getItems(new Node[]{this.cmbBuy, this.cmbSell, this.spnQty, this.txtPercent, this.spnMaxPriceDiff, this.spnSlippage, this.txtRollInterval, this.txtStartHour});
        this.mapAlgo.put(24, list);
    }

    protected List<Node> getItems(Node ... nodes) {
        LinkedList<Node> list = new LinkedList<Node>();
        Node[] nodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            list.add((Node)node.getParent().getParent());
            ++n2;
        }
        return list;
    }

    public ObservableList<Node> getChildren() {
        return ((VBox)VBox.class.cast(this.content)).getChildren();
    }

    public boolean valid() {
        ObservableList list = this.vboxAlgo.getChildren();
        for (Map.Entry<ObservableBooleanValue, Node> entry : this.mapValid.entrySet()) {
            this.checkNode(entry.getValue(), entry.getKey());
            if (!list.contains(entry.getValue().getParent()) && !entry.getValue().equals(this.lbCodeErr) && !entry.getValue().equals(this.lbAlgoErr) || entry.getKey().get()) continue;
            return false;
        }
        return true;
    }

    public Map<ObservableBooleanValue, Node> getValids() {
        return this.mapValid;
    }

    public void selectedAlgo(Algorithm now) {
        if (now == null) {
            return;
        }
        int type = now.getType();
        this.vboxAlgo.getChildren().setAll((Collection)this.mapAlgo.get(type));
        this.clear(true);
    }

    protected void clear(boolean isAlgo) {
        this.spnMaxPriceDiff.getEditor().clear();
        this.spnQty.getEditor().clear();
        this.spnSlippage.getEditor().clear();
        this.txtPercent.clear();
        this.txtRollInterval.clear();
        this.cmbBuy.getSelectionModel().select(0);
        this.cmbSell.getSelectionModel().select(0);
        this.txtPercent.setText("20");
        this.txtRollInterval.setText("10");
        this.setDefTime();
        if (isAlgo) {
            this.lbCodeErr.setOpacity(0.0);
        }
        this.lbPriceMostErr.setOpacity(0.0);
        this.lbPercentErr.setOpacity(0.0);
        this.lbQtyErr.setOpacity(0.0);
        this.lbStartErr.setOpacity(0.0);
        this.lbSliceErr.setOpacity(0.0);
    }

    public List<Algorithm> getAlgos(String engine) {
        return this.getAlgos(engine, null);
    }

    public abstract List<Algorithm> getAlgos(String var1, Boolean var2);

    protected void loseFocus(Boolean val) {
    }

    protected void sliceChange() {
    }

    protected void sliceCheck(TextField tf) {
        if (tf.isFocused()) {
            tf.selectAll();
            return;
        }
        String slice = tf.getText();
        if (StringUtils.patternCheck((String)"[0-9]?", (String)slice)) {
            tf.insertText(0, "0");
        }
    }

    protected int getInt(TextField txt) {
        return txt.getText().isEmpty() ? 0 : StringUtils.parseInt((String)txt.getText());
    }

    protected double getDouble(Spinner<?> spn) {
        String txt = spn.getEditor().getText();
        return txt.isEmpty() ? 0.0 : StringUtils.parseDouble((String)txt);
    }

    protected double getDouble(TextField tf) {
        String txt = tf.getText();
        return txt.isEmpty() ? 0.0 : StringUtils.parseDouble((String)txt);
    }

    protected void enterKeyOrder(KeyEvent key) {
        if (KeyCode.ENTER == key.getCode()) {
            this.order();
            key.consume();
        }
    }

    public void order() {
        System.out.println("===========================start");
    }

    public void setDefTime() {
        if (this.startTime.isEmpty()) {
            return;
        }
        int first = this.startTime.indexOf(":");
        int second = this.startTime.indexOf(":", first + 1);
        this.txtStartHour.setText(this.startTime.substring(0, first));
        this.txtStartMinute.setText(this.startTime.substring(first + 1, second));
    }

    protected void submitParam(RefItem refItem) {
        MarginAlgoModel model = (MarginAlgoModel)((Object)this.of.create(MarginAlgoModel.class));
        model.setMarket("XSHG".equals(refItem.getMarket()) ? "1" : "2");
        model.setType(refItem.getType());
        model.setCode(refItem.getCode());
        model.setName(refItem.getName());
        model.setQty(this.getInt(this.spnQty.getEditor()));
        model.setMarketPer(this.getDouble(this.txtPercent) / 100.0);
        model.setBuyStg(this.cmbBuy.getSelectionModel().getSelectedIndex() == 0 ? "CASH_BUY" : "PLEDGE_BUY");
        model.setSellStg("POS_SELL");
        model.setMaxPriceDiff(this.getDouble(this.spnMaxPriceDiff.getEditor()));
        model.setPriceSlip(this.getDouble(this.spnSlippage.getEditor()));
        model.setRollInterval(Integer.valueOf(this.txtRollInterval.getText()));
        model.setStartTime(String.valueOf(this.txtStartHour.getText()) + this.txtStartMinute.getText() + "00");
    }
}

