/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.margin.models.basket;

import cms.tmx.core.MException;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.trade.basket.Basket;
import cms.tmx.entity.trade.basket.BasketSubmitResult;
import cms.tmx.entity.trade.basket.BasketTradeItem;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.strategy.dto.MarketIndicator;
import cms.tmx.http.api.strategy.dto.OrdType;
import cms.tmx.http.base.AccntLevel;
import cms.tmx.http.xt.XtAccount;
import cms.tmx.http.xt.XtNewOrderBatch;
import cms.tmx.http.xt.XtNewOrderBatchResp;
import cms.tmx.http.xt.XtNewOrderSingle;
import cms.tmx.http.xt.XtTradeDetail;
import cms.tmx.http.xt.api.XtSecurityServiceApi;
import cms.tmx.javafx.MxModel;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class MarginBatchEntrust
extends MxModel {
    @Inject
    private XtSecurityServiceApi xtApi;

    public BasketSubmitResult submit(List<BasketTradeItem> tradeItemList, Basket basket, String marketIndicator) throws MException {
        BasketSubmitResult result = new BasketSubmitResult();
        if (tradeItemList == null) {
            return result;
        }
        Map<FundAccount, List<BasketTradeItem>> map = tradeItemList.stream().collect(Collectors.groupingBy(BasketTradeItem::getAcc));
        for (FundAccount accnt : map.keySet()) {
            String listId = "";
            try {
                XtNewOrderBatch batchReq = new XtNewOrderBatch();
                for (BasketTradeItem basketTradeItem : map.get(accnt)) {
                    XtNewOrderSingle order = new XtNewOrderSingle();
                    XtAccount account = new XtAccount();
                    account.setCashAccntId(accnt.getNewCashAccntId());
                    account.setSecAccntId(basketTradeItem.getSecAcc().getNewSecAccntId());
                    account.setInvestorId(accnt.getInvestId());
                    account.setInvestorSecId(basketTradeItem.getSecAcc().getInverstorSecId());
                    account.setAccntLevel(AccntLevel.ACCNT_LEVEL_EXT.getValue());
                    account.setBrokerId(accnt.getBrokerId());
                    XtTradeDetail tradeDetail = new XtTradeDetail();
                    String side = basketTradeItem.getBsTrade().getRaw();
                    tradeDetail.setOrderQty(new BigDecimal(basketTradeItem.getCount(side.equals("49"))).intValue());
                    tradeDetail.setPrice(basketTradeItem.getPrice(side.equals("49")));
                    tradeDetail.setPlatformId(accnt.getBrokerId());
                    Instrument inst = new Instrument();
                    inst.setSecurityId(basketTradeItem.getItem().getSecurityId());
                    inst.setMarket(basketTradeItem.getItem().getMarket().getRaw());
                    inst.setMarketIndicator(marketIndicator);
                    inst.setSymbol(basketTradeItem.getItem().getSecurityName());
                    inst.setSecurityType(basketTradeItem.getItem().getSecurityType());
                    inst.setApplId("760");
                    inst.setMarketGroup(accnt.getMarketGrp());
                    tradeDetail.setOrderType(Integer.parseInt(OrdType.ORD_TYPE_LIMIT.getValue()));
                    order.setAccount(account);
                    order.setInstrument(inst);
                    order.setTradeDetai(tradeDetail);
                    order.setTradeType(MarketIndicator.KCREDIT_PLEGDE_BUY.getValue());
                    batchReq.getOrders().add(order);
                }
                XtNewOrderBatchResp resp = this.xtApi.newBatEntrust(batchReq);
                if (resp != null) {
                    listId = resp.getBasketID();
                    result.getSuccessedIds().add(listId);
                    result.getSuccessedTimes().getAndIncrement();
                    continue;
                }
                result.getFailedTimes().getAndIncrement();
                result.setDesc("\n" + result.getDesc() + "\u54cd\u5e94\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
                this.logger.error("basket sumbit fail \u54cd\u5e94\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
            }
            catch (MException e) {
                result.getFailedTimes().getAndIncrement();
                result.setDesc("\n" + result.getDesc() + e.getMessage());
                this.logger.error("basket sumbit fail", (Throwable)e);
            }
        }
        return result;
    }
}

