/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.margin.models.basket;

import cms.tmx.core.MException;
import cms.tmx.define.MxDict;
import cms.tmx.entity.trade.basket.BasketTradeItem;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.margin.models.basket.MarginBasketInfoExecution;
import cms.tmx.margin.models.basket.MarginBasketTradeModel;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class MarginBasketExecutionModel
extends MarginBasketTradeModel {
    @Inject
    private MarginBasketInfoExecution bi;

    @Override
    @PostConstruct
    public void init() {
        this.setBi(this.bi);
        super.init();
    }

    public void execute(Instruction instruction) throws MException {
        this.setInstruction(instruction);
        this.insModel.execute(instruction, MxDict.WORKFLOW_EXECUTE, "");
    }

    @Override
    protected void calCount() {
        for (BasketTradeItem item2 : this.getItems().filtered(item -> item.isSelected())) {
            if ("50".equals(item2.getBsTrade().getRaw()) && this.getExeRatio() == 100.0) {
                item2.setCount(false, Long.valueOf(item2.getAvailableQty()).intValue());
                continue;
            }
            this.setDownCount(item2, this.getExeRatio());
        }
    }

    @Override
    protected void checkItemDisable(BasketTradeItem item, String filterFlag) {
        if (item.isUnPickInAdvice()) {
            return;
        }
        super.checkItemDisable(item, filterFlag);
    }

    @Override
    protected void checkAllItemDisable(BasketTradeItem item) {
        if (item.isUnPickInAdvice()) {
            return;
        }
        super.checkAllItemDisable(item);
    }
}

