/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.margin.model.xt;

import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.entity.web.workflow.ComplateTaskResp;
import cms.tmx.entity.web.workflow.WorkflowAttachment;
import cms.tmx.entity.web.workflow.WorkflowTask;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.instruction.dto.SimpleDetail;
import cms.tmx.http.workflow.api.WorkflowServiceApi;
import cms.tmx.http.workflow.dto.CompleteTaskNewReq;
import cms.tmx.http.workflow.dto.HttpInsPushMessage;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.margin.model.xt.MarginInstructionMng;
import cms.tmx.query.current.models.NeeqInstructionModel;
import com.google.gson.JsonObject;
import com.google.gson.internal.LinkedTreeMap;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class MarginInstructionQueryModel
extends NeeqInstructionModel {
    @Inject
    protected MarginInstructionMng marginMng;
    @Inject
    private WorkflowServiceApi api;
    @Inject
    private HttpBaseApi httpBaseApi;

    protected void fullQuery() throws MException {
        this.getList().update(this.getInsMng().query(this.fundAccService.getMarginFundAccountList(), "CCS"));
        this.changed();
    }

    public MarginInstructionMng getInsMng() {
        return this.marginMng;
    }

    protected void onInstructionPush(MEvent event) {
        JsonObject pushMsg = (JsonObject)event.getObj(JsonObject.class);
        this.logger.info("instruction push :" + pushMsg.toString());
        HttpInsPushMessage insPushMsg = (HttpInsPushMessage)this.gson.fromJson(pushMsg.toString(), HttpInsPushMessage.class);
        if (insPushMsg != null && insPushMsg.getInstruction() != null && "SimpleDetail".equals(insPushMsg.getInstruction().getType())) {
            if (insPushMsg.getInstruction().getDetail() instanceof LinkedTreeMap) {
                SimpleDetail ordDetail;
                LinkedTreeMap cfr_ignored_0 = (LinkedTreeMap)LinkedTreeMap.class.cast(insPushMsg.getInstruction().getDetail());
                if ("SimpleDetail".equals(insPushMsg.getInstruction().getType()) && "800".equals((ordDetail = (SimpleDetail)this.gson.fromJson(this.gson.toJson(insPushMsg.getInstruction().getDetail()), SimpleDetail.class)).getInstrument().getApplId())) {
                    return;
                }
            }
            ObSimpleInstruction obIns = new ObSimpleInstruction();
            obIns.setId(insPushMsg.getInstruction().getId());
            ObSimpleInstruction obNeeqInstruction = (ObSimpleInstruction)this.list.get((MxObject)obIns);
            if ("OTC".equals(insPushMsg.getMarketGroup())) {
                return;
            }
            if (obNeeqInstruction != null) {
                obNeeqInstruction.update((Object)insPushMsg);
            }
            this.getInsMng().addToBeQuery(obIns);
            this.runSpecQuery();
        }
    }

    public void cancel(ObSimpleInstruction instruction) throws MException {
        CompleteTaskNewReq req = new CompleteTaskNewReq();
        req.setWorkflowId(instruction.getEntryId());
        req.setOpUser(this.httpBaseApi.getHttpOpUser());
        req.setOperate("100");
        this.api.cancelWorkflowNew(Arrays.asList(req));
    }

    public void complateTask(ObSimpleInstruction instruction, String action, WorkflowTask task, List<WorkflowAttachment> attachments) throws MException {
        String resp;
        ComplateTaskResp auditRes;
        CompleteTaskNewReq req = new CompleteTaskNewReq();
        req.setTaskId(task.getTaskId());
        req.setOpUser(this.httpBaseApi.getHttpOpUser());
        req.setOperate(action);
        req.setWorkflowId(instruction.getEntryId());
        if (attachments != null) {
            req.setAttachment(this.gson.toJson(attachments));
        }
        if (!(auditRes = (ComplateTaskResp)this.gson.fromJson(resp = this.api.complateTaskNew(Arrays.asList(req)), ComplateTaskResp.class)).isApproved()) {
            return;
        }
        ObSimpleInstruction obIns = new ObSimpleInstruction();
        obIns.setId(instruction.getId());
        this.insMng.addToBeQuery(obIns);
        this.runSpecQuery();
    }
}

