/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.margin.model.xt;

import cms.tmx.core.MException;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.entity.web.workflow.Node;
import cms.tmx.entity.web.workflow.WorkflowOptEnum;
import cms.tmx.entity.web.workflow.WorkflowTask;
import cms.tmx.http.api.strategy.dto.MarketIndicator;
import cms.tmx.http.api.strategy.dto.OrdType;
import cms.tmx.http.base.AccountId;
import cms.tmx.http.instruction.dto.AccntSecInfo;
import cms.tmx.http.instruction.dto.GetInstructionsReq;
import cms.tmx.http.instruction.dto.Instruction;
import cms.tmx.http.workflow.api.WorkflowServiceApi;
import cms.tmx.http.workflow.dto.WorkflowTaskListNew;
import cms.tmx.http.workflow.dto.WorkflowTaskNew;
import cms.tmx.query.current.mng.NeeqInstructionMng;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class MarginInstructionMng
extends NeeqInstructionMng {
    @Inject
    private WorkflowServiceApi api;

    protected void getWorkflow(List<ObSimpleInstruction> instructionList) throws MException {
        List workflowIds = instructionList.stream().map(item -> item.getEntryId()).collect(Collectors.toList());
        Map workflowCurrentTasks = this.api.getWorkflowCurrentTasksNew(workflowIds);
        for (ObSimpleInstruction ins : instructionList) {
            try {
                if (ins.getEntryId() == null || workflowCurrentTasks.get(ins.getEntryId()) == null) {
                    this.transferField(ins);
                    continue;
                }
                ins.setCanCancel(((WorkflowTaskListNew)workflowCurrentTasks.get(ins.getEntryId())).isCanCancel());
                List taskList = ((WorkflowTaskListNew)workflowCurrentTasks.get(ins.getEntryId())).getTaskList();
                LinkedList<WorkflowTask> list = new LinkedList<WorkflowTask>();
                for (WorkflowTaskNew newTask : taskList) {
                    WorkflowTask task = new WorkflowTask();
                    task.setComments(newTask.getComments());
                    task.setPermissibleList(newTask.getPermissibleList());
                    task.setTaskId(newTask.getTaskId());
                    task.setTaskName(newTask.getTaskName());
                    task.setWorkflowId(newTask.getWorkflowId());
                    Node node = new Node();
                    node.setDistributionType(newTask.getNode().getDistributionType());
                    node.setFastApprove(newTask.getNode().getFastApprove());
                    node.setFrozenCapital(newTask.getNode().getFastApprove());
                    node.setFrozenVouchers(newTask.getNode().getFrozenVouchers());
                    node.setInstanceId(newTask.getNode().getInstanceId());
                    node.setNodeId(newTask.getNode().getNodeId());
                    node.setNodeName(newTask.getNode().getNodeName());
                    node.setOrderType(newTask.getNode().getOrderType());
                    node.setPermissibleList(newTask.getNode().getPermissibleList());
                    node.setProcessId(newTask.getNode().getBaseProcessId());
                    node.setSendOa(newTask.getNode().getSendOa());
                    node.setSeq(newTask.getNode().getSeq());
                    task.setNode(node);
                    list.add(task);
                }
                ins.fillTask(list);
                this.transferField(ins);
            }
            catch (MException e) {
                logger.error(String.valueOf(ins.getId()) + " \u4fe1\u606f\u8f6c\u6362\u51fa\u9519\uff1a", (Throwable)e);
            }
        }
    }

    public List<ObSimpleInstruction> query(List<FundAccount> list, String marketGrp) throws MException {
        ArrayList<ObSimpleInstruction> instructionList = new ArrayList<ObSimpleInstruction>();
        if (list == null || list.isEmpty()) {
            return instructionList;
        }
        GetInstructionsReq req = new GetInstructionsReq();
        req.setMarketGroup(marketGrp);
        req.setApplId("760");
        List extCashAccntIds = list.stream().map(item -> item.getNewCashAccntId()).collect(Collectors.toList());
        req.setExtCashAccntId(extCashAccntIds);
        List instructions = this.ins.getInstructions(req);
        if (instructions == null) {
            return instructionList;
        }
        for (Instruction instruction : instructions) {
            ObSimpleInstruction obIns = new ObSimpleInstruction();
            instruction.setCreatorName((String)this.userService.getCreditUserName(instruction.getCreator()).get());
            obIns.update((Object)instruction);
            instructionList.add(obIns);
        }
        this.getWorkflow(instructionList);
        return instructionList;
    }

    protected void transferField(ObSimpleInstruction ins) throws MException {
        List workflowTasks = ins.getWorkflowTasks();
        for (WorkflowTask workflowTask : workflowTasks) {
            if (workflowTask.getPermissibleList().contains(WorkflowOptEnum.NEW_WORKFLOW_COMMON_EXECUTE.actionId)) {
                ins.setIsOrderStep(true);
                continue;
            }
            if (!workflowTask.getPermissibleList().contains("2") && !workflowTask.getPermissibleList().contains("6")) continue;
            ins.setIsApproveStep(true);
        }
        if (ins.getOrderDetail() == null) {
            return;
        }
        String marketGrp = MarketUtils.getMarketGroup((String)ins.getSecMarket());
        if (!ins.getOrderDetail().getAccntSecInfo().isEmpty()) {
            AccountId accountId = ((AccntSecInfo)ins.getOrderDetail().getAccntSecInfo().get(0)).getAccountId();
            FundAccount fundAcc = this.fundService.getFundAccountNew(accountId.getCashAccntId(), marketGrp);
            String investorId = "";
            if (fundAcc != null) {
                investorId = fundAcc.getInvestId();
            }
            if (ins.getProductId() != null && !ins.getProductId().isEmpty()) {
                ins.setBelongTo(String.valueOf(this.productService.getProductDetailFromCache(ins.getProductId()).getName()) + "(" + investorId + ")");
            }
        }
        if (ins.getAvgPx() != 0.0) {
            ins.setCumQty(ins.getCumAmount() / ins.getAvgPx());
        } else {
            ins.setCumQty(0.0);
        }
        if (ins.getOrderDetail().getPlateLevels() != 0) {
            ins.getOrderDetail().setPlateLevels(ins.getOrderDetail().getPlateLevels() - 11);
            ins.setInsPriceStr("\u76d8\u53e3-" + this.dictMap.get("instr_handicap", ins.getOrderDetail().getPlateLevels()));
            ins.getOrderDetail().setOrdType(OrdType.ORD_TYPE_UNDEFINED);
        } else if ("49".equals(ins.getOrderDetail().getOrdType().getValue())) {
            if (ins.getOrderDetail().getTif() != null) {
                String neeqMarketPriceType = MarketUtils.getNormalMarketPriceType((int)ins.getOrderDetail().getTif().getValue(), (int)ins.getOrderDetail().getMaxPriceLevels(), (String)ins.getSecMarket());
                ins.setInsPriceStr("\u5e02\u4ef7-" + this.dictMap.get("cstr_price_type_mkt", neeqMarketPriceType));
            }
        } else if ("50".equals(ins.getOrderDetail().getOrdType().getValue())) {
            if (ins.getOrderDetail().getPrice() > 0.0 && !"3".equals(Integer.toString(ins.getOrderDetail().getPriceRestriction()))) {
                ins.setInsPriceStr(String.valueOf(this.dictMap.get("cstr_price_type_limited", ins.getOrderDetail().getPriceRestriction())) + "-" + StringUtils.toStr((double)ins.getOrderDetail().getPrice(), (int)3));
            } else {
                ins.setInsPriceStr(this.dictMap.get("cstr_price_type_limited", ins.getOrderDetail().getPriceRestriction()));
            }
        } else if ("80".equals(ins.getOrderDetail().getOrdType().getValue())) {
            ins.setInsPriceStr("\u76d8\u540e\u56fa\u5b9a\u4ef7-" + ins.getOrderDetail().getPrice());
        }
        if (MarketIndicator.KCREDIT_PLEGDE_IN.getDesc().equals(ins.getMarketIndicate()) || MarketIndicator.KCREDIT_PLEGDE_OUT.getDesc().equals(ins.getMarketIndicate())) {
            ins.setInsPriceStr("");
        }
    }
}

