/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.margin.model.xt;

import cms.tmx.api.data.IRefItem;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.MarginAccountDistribution;
import cms.tmx.entity.trade.instruction.ObSimpleInstruction;
import cms.tmx.http.query.marginxt.GetNormalAccountReq;
import cms.tmx.http.query.marginxt.GetNormalAccountResp;
import cms.tmx.http.query.marginxt.XtPosition;
import cms.tmx.http.query.marginxt.XtUnderlyingSecurity;
import cms.tmx.http.query.marginxt.api.XtAccountServiceApi;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxTreeList;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.IPostService;
import cms.tmx.query.current.models.InstructionAccountModelNew;
import cms.tmx.query.current.models.MarginAccountMap;
import cms.tmx.query.margin.models.xt.ContractModel;
import cms.tmx.query.margin.models.xt.MarginPositionModel;
import cms.tmx.query.margin.models.xt.UnderlyingModel;
import cms.tmx.trade.utils.MarginAccountDistTreeList;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.MathUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IMarketDataMng;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.control.TreeItem;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class InstructionMarginAccountDistributionModel
extends MxModel {
    @Inject
    protected IMarketDataMng marketMng;
    @Inject
    protected MarginAccountMap accMng;
    @Inject
    protected IFundAccountService fundAccMng;
    @Inject
    protected IPostService postMng;
    @Inject
    private ContractModel contractModel;
    @Inject
    private UnderlyingModel underlyModel;
    @Inject
    protected MarginPositionModel posModel;
    @Inject
    protected XtAccountServiceApi accountApi;
    @Inject
    private MEventService es;
    @Inject
    private InstructionAccountModelNew instructionAccModel;
    protected TreeItem<MarginAccountDistribution> root = new TreeItem((Object)new MarginAccountDistribution());
    protected MxTreeList<MarginAccountDistribution> accMxList;
    protected Map<String, MxTreeList<MarginAccountDistribution>> mapSecDisMxList;
    protected Map<String, Long> mapQuantiy = new HashMap<String, Long>();
    protected Map<String, Integer> mapWeight = new HashMap<String, Integer>();
    private StringProperty countStg = new SimpleStringProperty("");
    private StringProperty distStg = new SimpleStringProperty("");
    private StringProperty accFilterStg = new SimpleStringProperty("");
    private StringProperty security = new SimpleStringProperty("");
    private StringProperty marginType = new SimpleStringProperty("");
    private DoubleProperty money = new SimpleDoubleProperty();
    private DoubleProperty price = new SimpleDoubleProperty();
    private DoubleProperty percent = new SimpleDoubleProperty();
    private final int MAP_CAP = 100;
    private final int INIT_UNIT = 100;
    private IntegerProperty unit = new SimpleIntegerProperty(100);
    private IntegerProperty unitConvert = new SimpleIntegerProperty(1);
    private LongProperty canBuy = new SimpleLongProperty();
    private LongProperty canSell = new SimpleLongProperty();
    private LongProperty canReturnQuant = new SimpleLongProperty();
    private LongProperty notReturnQuant = new SimpleLongProperty();
    private DoubleProperty canReturnMoney = new SimpleDoubleProperty();
    private DoubleProperty notReturnMoney = new SimpleDoubleProperty();
    private DoubleProperty debtContracts = new SimpleDoubleProperty();
    private LongProperty canMetal = new SimpleLongProperty();
    private Map<CcsFundAccount, List<SecAccount>> mapAccount;
    private IntegerProperty effectiveSecAccCount = new SimpleIntegerProperty();
    private IntegerProperty customSecAccCount = new SimpleIntegerProperty();
    private StringProperty searchSec = new SimpleStringProperty("");
    private boolean countValid = true;
    private BooleanProperty selected = new SimpleBooleanProperty(false);
    private BooleanProperty single = new SimpleBooleanProperty(false);
    private BooleanProperty normal = new SimpleBooleanProperty(true);
    protected RefItem refItem;
    private StringProperty instructPanelType = new SimpleStringProperty("");
    private BooleanProperty active = new SimpleBooleanProperty(true);
    private ObSimpleInstruction instruction;
    @Inject
    private ExecutorService exe;
    private InvalidationListener lstFund = ob -> this.onFundChange();
    protected InvalidationListener lstPosition = ob -> Platform.runLater(() -> {
        this.calAccountCanSell();
        this.calAccountCanRetrunQuant();
        this.filterAcc();
        this.calCanBuyByMarginTradeType();
    });
    protected InvalidationListener lstContract = ob -> Platform.runLater(() -> {
        if ("5".equals(this.marginType.getValue())) {
            this.calAccountnotRetrunMoney();
        } else if ("14".equals(this.marginType.getValue())) {
            this.calAccountnotRetrunCashMoney();
        } else if ("13".equals(this.marginType.getValue())) {
            this.calAccountnotRetrunQuant();
        } else if ("8".equals(this.marginType.getValue())) {
            this.calAccountnotRetrunQuant();
        }
        this.filterAcc();
        this.calCanBuyByMarginTradeType();
    });
    private Predicate<MarginAccountDistribution> pdShow = dist -> dist.isShow();

    public synchronized TreeItem<MarginAccountDistribution> create() throws MException {
        this.posModel.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstPosition));
        this.fundAccMng.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstFund));
        this.contractModel.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstContract));
        this.queryPostition();
        this.customSecAccCount.addListener(ob -> this.onCtmSecAccCountChange());
        this.effectiveSecAccCount.addListener(ob -> this.onEfSecAccCountChange());
        this.searchSec.addListener(ob -> this.onCtmSecAccCountChange());
        this.createTree();
        return this.root;
    }

    protected void createTree() {
        ((MarginAccountDistribution)this.root.getValue()).setSelected(this.isSelected());
        LinkedList<MarginAccountDistribution> accList = new LinkedList<MarginAccountDistribution>();
        this.mapSecDisMxList = new HashMap<String, MxTreeList<MarginAccountDistribution>>(100);
        this.accMxList = new MarginAccountDistTreeList(this.root, this.root.getChildren(), accList);
        if (this.getAccountMap() == null) {
            return;
        }
        this.mapAccount = new HashMap<CcsFundAccount, List<SecAccount>>(this.getAccountMap());
        HashSet<CcsFundAccount> accSet = new HashSet<CcsFundAccount>(this.mapAccount.keySet());
        for (FundAccount fundAccount : accSet) {
            CcsFundAccount fundAcc = (CcsFundAccount)CcsFundAccount.class.cast(fundAccount);
            MarginAccountDistribution accDst = new MarginAccountDistribution();
            accDst.setAcc(fundAcc);
            accDst.setSelected(this.isSelected());
            accDst.selectedProperty().addListener(ob -> this.onAccSelectChange());
            accDst.setWeight(this.mapWeight.get(fundAcc.getNewCashAccntId()) == null ? 0 : this.mapWeight.get(fundAcc.getNewCashAccntId()));
            accDst.setCount(this.mapQuantiy.get(fundAcc.getNewCashAccntId()) == null ? 0L : this.mapQuantiy.get(fundAcc.getNewCashAccntId()));
            accList.add(accDst);
            this.accMxList.update(accList);
            LinkedList<MarginAccountDistribution> secAccList = new LinkedList<MarginAccountDistribution>();
            for (SecAccount secAcc : this.mapAccount.get(fundAccount)) {
                MarginAccountDistribution secDst = new MarginAccountDistribution();
                secAccList.add(secDst);
                secDst.setIsSecAcc(true);
                secDst.setSecAcc(secAcc);
                secDst.setWeight(this.mapWeight.get(secAcc.getExtSecAccntId()) == null ? 1 : this.mapWeight.get(secAcc.getExtSecAccntId()));
                secDst.weightProperty().addListener(ob -> this.calCount());
                secDst.setSelected(this.isSelected());
                secDst.selectedProperty().addListener(ob -> this.calCount());
                secDst.setCount(this.mapQuantiy.get(secAcc.getExtSecAccntId()) == null ? 0L : this.mapQuantiy.get(secAcc.getExtSecAccntId()));
            }
            MarginAccountDistTreeList secMxList = new MarginAccountDistTreeList((TreeItem)this.root.getChildren().get(accList.size() - 1), ((TreeItem)this.root.getChildren().get(accList.size() - 1)).getChildren(), secAccList);
            this.mapSecDisMxList.put(fundAcc.getNewCashAccntId(), (MxTreeList<MarginAccountDistribution>)secMxList);
        }
        this.filterFundAcc();
        this.calEffectiveSecAccCount();
        this.checkSingle();
    }

    private void checkSingle() {
        this.setSingle(this.accMxList.getObList().size() == 1);
        if (!this.isSingle()) {
            return;
        }
        for (MxTreeList<MarginAccountDistribution> secMxList : this.mapSecDisMxList.values()) {
            int sh = secMxList.getOrList().filtered(pd -> pd.getSecAcc().getExchange().getRaw().equals("XSHG")).size();
            int sz = secMxList.getOrList().filtered(pd -> pd.getSecAcc().getExchange().getRaw().equals("XSHE")).size();
            this.setSingle(sh < 2);
            if (!this.isSingle()) {
                return;
            }
            this.setSingle(sz < 2);
            if (this.isSingle()) continue;
            return;
        }
        this.mapSecDisMxList.values().forEach(each -> each.getOrList().forEach(sec -> sec.setSelected(true)));
        this.accMxList.getObList().forEach(each -> ((MarginAccountDistribution)each.getValue()).setSelected(true));
    }

    public void filterAcc() {
        if (this.refItem == null) {
            this.mapSecDisMxList.keySet().forEach(each -> this.showAll(this.mapSecDisMxList.get(each)));
            this.showAll(this.accMxList);
        } else {
            this.filterSecAcc();
        }
        this.filterFundAcc();
        this.calEffectiveSecAccCount();
        this.filterCtmSec();
        this.filterSearchSec();
        this.filterFundAcc();
        this.calCount();
    }

    protected void filterSecAcc() {
        String exchange = this.refItem.getMarket();
        if (exchange.equals("XSHE")) {
            this.mapSecDisMxList.keySet().forEach(each -> this.showSZ(this.mapSecDisMxList.get(each)));
        } else if (exchange.equals("XSHG")) {
            this.mapSecDisMxList.keySet().forEach(each -> this.showSH(this.mapSecDisMxList.get(each)));
        } else {
            this.mapSecDisMxList.keySet().forEach(each -> this.showAll(this.mapSecDisMxList.get(each)));
        }
    }

    private void filterFundAcc() {
        this.showAll(this.accMxList);
        this.mapSecDisMxList.keySet().forEach(each -> {
            if (this.mapSecDisMxList.get(each).getObList().size() == 0) {
                this.accMxList.getOrList().forEach(accEach -> {
                    if (accEach.getAcc().getNewCashAccntId().equals(each) || accEach.getAcc().getExtAccntId().contains("HKD")) {
                        accEach.setShow(false);
                    }
                });
            }
        });
        this.accMxList.filter(this.pdShow);
    }

    private void calEffectiveSecAccCount() {
        int count = 0;
        for (TreeItem item : this.root.getChildren()) {
            count += item.getChildren().size();
        }
        this.setEffectiveSecAccCount(count);
    }

    private void onCtmSecAccCountChange() {
        this.filterAcc();
        this.filterCtmSec();
        this.filterSearchSec();
        this.filterFundAcc();
        this.calCount();
    }

    private void filterCtmSec() {
        int count = this.getCustomSecAccCount();
        for (String strEach : this.mapSecDisMxList.keySet()) {
            boolean accShow = false;
            for (MarginAccountDistribution dist : this.accMxList.getOrList()) {
                if (!dist.isShow() || !dist.getAcc().getNewCashAccntId().equals(strEach)) continue;
                accShow = true;
            }
            if (accShow) {
                int size = this.mapSecDisMxList.get(strEach).getOrList().filtered(pd -> pd.isShow()).size();
                FilteredList showList = this.mapSecDisMxList.get(strEach).getOrList().filtered(pd -> pd.isShow());
                if (count <= 0) {
                    showList.forEach(each -> each.setShow(false));
                } else if (count - size < 0) {
                    int i = count;
                    while (i < size) {
                        ((MarginAccountDistribution)showList.get(i)).setShow(false);
                        ++i;
                    }
                }
                count -= size;
            }
            this.mapSecDisMxList.get(strEach).filter(this.pdShow);
        }
    }

    private void filterSearchSec() {
        String search = this.getSearchSec();
        if (StringUtils.isEmpty((String)search)) {
            return;
        }
        for (String strEach : this.mapSecDisMxList.keySet()) {
            boolean accShow = false;
            for (MarginAccountDistribution dist : this.accMxList.getOrList()) {
                if (!dist.isShow() || !dist.getAcc().getNewCashAccntId().equals(strEach)) continue;
                accShow = true;
            }
            if (accShow) {
                FilteredList showList = this.mapSecDisMxList.get(strEach).getOrList().filtered(pd -> pd.isShow());
                showList.forEach(each -> {
                    if (!each.getSecAcc().getInverstorSecId().contains(search)) {
                        each.setShow(false);
                    }
                });
            }
            this.mapSecDisMxList.get(strEach).filter(this.pdShow);
        }
    }

    private void onEfSecAccCountChange() {
        if (this.getAccFilterStg().equals("1")) {
            this.setCustomSecAccCount(this.getEffectiveSecAccCount());
            return;
        }
        if (this.getEffectiveSecAccCount() < this.getCustomSecAccCount()) {
            this.setCustomSecAccCount(this.getEffectiveSecAccCount());
        }
    }

    private void showSZ(MxTreeList<MarginAccountDistribution> distList) {
        for (MarginAccountDistribution dist : distList.getOrList()) {
            if (!dist.getSecAcc().getExchange().getRaw().equals("XSHE")) {
                dist.setShow(false);
                continue;
            }
            dist.setShow(true);
        }
        distList.filter(this.pdShow);
    }

    private void showSH(MxTreeList<MarginAccountDistribution> distList) {
        for (MarginAccountDistribution dist : distList.getOrList()) {
            if (!dist.getSecAcc().getExchange().getRaw().equals("XSHG")) {
                dist.setShow(false);
                continue;
            }
            dist.setShow(true);
        }
        distList.filter(this.pdShow);
    }

    private void showAll(MxTreeList<MarginAccountDistribution> distList) {
        if (distList.getOrList() == null) {
            return;
        }
        distList.getOrList().forEach(each -> each.setShow(true));
        distList.filter(this.pdShow);
    }

    public void updateFund(CcsFundAccount praAcc) {
        this.accMxList.getOrList().forEach(each -> {
            if (each.getAcc().getNewCashAccntId().equals(praAcc.getNewCashAccntId())) {
                FundAccount acc = this.fundAccMng.getFundAccountNew(praAcc.getNewCashAccntId(), "CCS");
                if (acc == null) {
                    return;
                }
                each.getAcc().update((Object)acc);
                if (this.getPrice() > 0.0 && this.getUnit() != 0) {
                    if ("8".equals(this.marginType.getValue()) && this.refItem != null) {
                        long canBuy = (long)(each.getAcc().getPosBuyAvlXt() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getUnitConvert();
                        each.setCanBuy(canBuy);
                    } else {
                        long canBuy = (long)(each.getAcc().getAvailableNewXt() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getUnitConvert();
                        each.setCanBuy(canBuy);
                    }
                } else {
                    each.setCanBuy(0L);
                }
            }
        });
    }

    public void refresh() {
        this.fundAccMng.queryFundAccountList();
        this.posModel.query();
    }

    private void queryPostition() {
        this.exe.execute(() -> this.posModel.query());
    }

    public void onFundChange() {
        try {
            Platform.runLater(() -> {
                this.accMxList.getOrList().forEach(acc -> this.updateFund(acc.getAcc()));
                if ("5".equals(this.marginType.getValue())) {
                    this.calAccountnotRetrunMoney();
                    this.calAccountDebtContracts();
                } else if ("14".equals(this.marginType.getValue())) {
                    this.calAccountnotRetrunCashMoney();
                    this.calAccountDebtContracts();
                } else if ("3".equals(this.marginType.getValue()) || "6".equals(this.marginType.getValue())) {
                    this.calAccountCanMetal();
                } else if ("8".equals(this.marginType.getValue())) {
                    this.calAccountnotPosBuyPayoffMoney();
                } else if ("1".equals(this.marginType.getValue())) {
                    this.calAccountCanBuy();
                } else if ("2".equals(this.marginType.getValue())) {
                    this.calAccountCanSell();
                }
                this.calCanBuyByMarginTradeType();
            });
        }
        catch (Exception e) {
            this.logger.error("\u5237\u65b0\u73b0\u8d27\u8d44\u91d1\u8d26\u53f7\u53ca\u8ba1\u7b97\u53ef\u4e70\u51fa\u9519", (Throwable)e);
        }
    }

    public int getSelectedNum() {
        int i = 0;
        for (TreeItem item : this.root.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected())) {
            for (TreeItem subItem : item.getChildren()) {
                if (!((MarginAccountDistribution)subItem.getValue()).isSelected()) continue;
                ++i;
            }
        }
        return i;
    }

    public MarginAccountDistribution getSelectSecAccount() {
        if (this.getSelectedNum() == 1) {
            for (TreeItem item : this.root.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected())) {
                for (TreeItem subItem : item.getChildren()) {
                    if (!((MarginAccountDistribution)subItem.getValue()).isSelected()) continue;
                    return (MarginAccountDistribution)subItem.getValue();
                }
            }
        }
        return null;
    }

    public List<MarginAccountDistribution> getValidSecAcc() {
        LinkedList<MarginAccountDistribution> list = new LinkedList<MarginAccountDistribution>();
        int totalcount = 0;
        this.countValid = true;
        for (TreeItem item : this.root.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected())) {
            for (TreeItem each : item.getChildren()) {
                if (!((MarginAccountDistribution)each.getValue()).isSelected() || ((MarginAccountDistribution)each.getValue()).getCount() == 0L) continue;
                list.add((MarginAccountDistribution)each.getValue());
                totalcount = (int)((long)totalcount + ((MarginAccountDistribution)each.getValue()).getCount());
            }
        }
        if (totalcount == 0) {
            this.countValid = false;
        }
        return list;
    }

    private void onAccSelectChange() {
        int select = this.calSelectedFundAcc();
        try {
            if (select == 1 && ("11".equals(this.marginType.getValue()) || "10".equals(this.marginType.getValue()))) {
                TreeItem fundAccount = (TreeItem)this.root.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected()).get(0);
                GetNormalAccountResp ccsInvestorId = this.accountApi.getCcsInvestorId(new GetNormalAccountReq(((MarginAccountDistribution)fundAccount.getValue()).getAcc().getInvestId()));
                MEvent event = new MEvent();
                event.put((Object)"data", (Object)ccsInvestorId.getStockInvestorId());
                this.es.sendEvent("get.ccs.id", event);
            }
        }
        catch (MException e) {
            this.logger.error((Object)e, (Throwable)e);
        }
        this.calCount();
        this.calCanBuyByMarginTradeType();
    }

    private int calSelectedFundAcc() {
        int num = this.root.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected()).size();
        return num;
    }

    public XtPosition getPosition(MarginAccountDistribution mAccountDistribution) {
        String key = String.join((CharSequence)",", mAccountDistribution.getSecAcc().getInverstorSecId(), this.refItem.getCode(), this.refItem.getMarket(), this.refItem.getType());
        return (XtPosition)this.posModel.getMapList().get(key);
    }

    public void calCanBuyByMarginTradeType() {
        if (this.calSelectedFundAcc() != 1) {
            this.setCanBuy(0L);
            this.setCanSell(0L);
            this.setCanMetal(0L);
            this.setCanReturnMoney(0.0);
            this.setCanReturnQuant(0L);
            this.setNotReturnMoney(0.0);
            this.setNotReturnQuant(0L);
            this.setDebtContracts(0.0);
            return;
        }
        TreeItem item = (TreeItem)this.root.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected()).get(0);
        if (item == null) {
            return;
        }
        if ("1".equals(this.marginType.getValue())) {
            if (this.getPrice() <= 0.0 || this.getUnitConvert() <= 0 || this.getUnit() <= 0) {
                this.setCanBuy(0L);
                return;
            }
            long canBuy = (long)(((MarginAccountDistribution)item.getValue()).getAcc().getAvailableNewXt() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getUnitConvert();
            this.setCanBuy(canBuy);
        } else if ("2".equals(this.marginType.getValue())) {
            FilteredList subItemList = item.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected());
            if (subItemList.size() == 1) {
                TreeItem treeItem = (TreeItem)subItemList.get(0);
                if (((MarginAccountDistribution)treeItem.getValue()).getSecAcc() == null || this.refItem == null) {
                    this.setCanSell(0L);
                } else {
                    XtPosition position = this.getPosition((MarginAccountDistribution)treeItem.getValue());
                    if (position == null) {
                        this.setCanSell(0L);
                    } else {
                        this.setCanSell(new Double(position.getAvailable()).longValue());
                    }
                }
            } else {
                this.setCanSell(0L);
            }
        } else if ("3".equals(this.marginType.getValue())) {
            long canMetalOne;
            if (this.refItem == null) {
                this.setCanMetal(0L);
                return;
            }
            if (this.getPrice() <= 0.0 || this.getUnitConvert() <= 0 || this.getUnit() <= 0) {
                this.setCanMetal(0L);
                return;
            }
            long canMetalTwo = canMetalOne = (long)(((MarginAccountDistribution)item.getValue()).getAcc().getFcreditAvlNewXt() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getUnitConvert();
            if (this.refItem != null && this.underlyModel.getUnderlying(String.valueOf(this.refItem.getCode()) + MarketUtils.getMarketNameById((String)this.refItem.getMarket())) != null) {
                canMetalTwo = (long)(((MarginAccountDistribution)item.getValue()).getAcc().getMarginAvlNewXt() / this.getPrice() * this.underlyModel.getUnderlying(String.valueOf(this.refItem.getCode()) + MarketUtils.getMarketNameById((String)this.refItem.getMarket())).getMarginRateFund()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getUnitConvert();
            }
            this.setCanMetal(Math.min(canMetalOne, canMetalTwo));
        } else if ("6".equals(this.marginType.getValue())) {
            long canMetalOne;
            if (this.refItem == null) {
                this.setCanMetal(0L);
                return;
            }
            if (this.getPrice() <= 0.0 || this.getUnitConvert() <= 0 || this.getUnit() <= 0) {
                this.setCanMetal(0L);
                return;
            }
            long canMetalTwo = canMetalOne = (long)(((MarginAccountDistribution)item.getValue()).getAcc().getDcreditAvlNewXt() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getUnitConvert();
            if (this.refItem != null && this.underlyModel.getUnderlying(String.valueOf(this.refItem.getCode()) + MarketUtils.getMarketNameById((String)this.refItem.getMarket())) != null) {
                canMetalTwo = (long)(((MarginAccountDistribution)item.getValue()).getAcc().getMarginAvlNewXt() / this.getPrice() * this.underlyModel.getUnderlying(String.valueOf(this.refItem.getCode()) + MarketUtils.getMarketNameById((String)this.refItem.getMarket())).getMarginRateSec()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getUnitConvert();
            }
            this.setCanMetal(Math.min(canMetalOne, canMetalTwo));
        } else if ("5".equals(this.marginType.getValue())) {
            this.setNotReturnMoney(((MarginAccountDistribution)item.getValue()).getAcc().getFtotalOrgDebtsNewXt());
            FilteredList subItemList = item.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected());
            if (subItemList.size() == 1) {
                TreeItem treeItem = (TreeItem)subItemList.get(0);
                if (((MarginAccountDistribution)treeItem.getValue()).getSecAcc() == null || this.refItem == null) {
                    this.setCanReturnQuant(0L);
                } else {
                    XtPosition position = this.getPosition((MarginAccountDistribution)treeItem.getValue());
                    if (position == null) {
                        this.setCanReturnQuant(0L);
                    } else {
                        this.setCanReturnQuant(new Double(position.getAvailable()).longValue());
                    }
                }
            } else {
                this.setCanReturnQuant(0L);
            }
            this.setDebtContracts(((MarginAccountDistribution)item.getValue()).getAcc().getCreditFundFeeCanReturn() + ((MarginAccountDistribution)item.getValue()).getAcc().getCreditStockFeeCanReturn());
        } else if ("8".equals(this.marginType.getValue()) && this.refItem != null) {
            if (this.contractModel.getMapQty().get(String.valueOf(((MarginAccountDistribution)item.getValue()).getAcc().getNewCashAccntId()) + "," + this.refItem.getCode()) != null) {
                this.setNotReturnQuant(((Integer)this.contractModel.getMapQty().get(String.valueOf(((MarginAccountDistribution)item.getValue()).getAcc().getNewCashAccntId()) + "," + this.refItem.getCode())).intValue());
            }
            if (this.getPrice() <= 0.0 || this.getUnitConvert() <= 0 || this.getUnit() <= 0) {
                this.setCanBuy(0L);
                return;
            }
            long canBuy = (long)(((MarginAccountDistribution)item.getValue()).getAcc().getPosBuyAvlXt() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getUnitConvert();
            this.setCanBuy(canBuy);
        } else if ("13".equals(this.marginType.getValue()) && this.refItem != null) {
            FilteredList subItemList;
            if (this.contractModel.getMapQty().get(String.valueOf(((MarginAccountDistribution)item.getValue()).getAcc().getNewCashAccntId()) + "," + this.refItem.getCode()) != null) {
                this.setNotReturnQuant(((Integer)this.contractModel.getMapQty().get(String.valueOf(((MarginAccountDistribution)item.getValue()).getAcc().getNewCashAccntId()) + "," + this.refItem.getCode())).intValue());
            }
            if ((subItemList = item.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected())).size() == 1) {
                TreeItem treeItem = (TreeItem)subItemList.get(0);
                if (((MarginAccountDistribution)treeItem.getValue()).getSecAcc() == null || this.refItem == null) {
                    this.setCanReturnQuant(0L);
                } else {
                    XtPosition position = this.getPosition((MarginAccountDistribution)treeItem.getValue());
                    if (position == null) {
                        this.setCanReturnQuant(0L);
                    } else {
                        this.setCanReturnQuant(new Double(position.getBalance()).longValue());
                    }
                }
            } else {
                this.setCanReturnQuant(0L);
            }
        } else if ("14".equals(this.marginType.getValue())) {
            this.setCanReturnMoney(((MarginAccountDistribution)item.getValue()).getAcc().getAvailableNewXt());
            this.setNotReturnMoney(((MarginAccountDistribution)item.getValue()).getAcc().getFtotalOrgDebtsNewXt());
            this.setDebtContracts(((MarginAccountDistribution)item.getValue()).getAcc().getCreditFundFeeCanReturn() + ((MarginAccountDistribution)item.getValue()).getAcc().getCreditStockFeeCanReturn());
        }
    }

    public void calAccountCanSell() {
        if (this.mapSecDisMxList == null) {
            return;
        }
        for (String strEach : this.mapSecDisMxList.keySet()) {
            long canSellTotal = 0L;
            for (MarginAccountDistribution subItem : this.mapSecDisMxList.get(strEach).getOrList()) {
                XtPosition position;
                if (subItem.getSecAcc() == null || this.refItem == null || (position = this.getPosition(subItem)) == null) continue;
                long canSell = new Double(position.getAvailable()).longValue();
                subItem.setCanSell(canSell);
                canSellTotal += canSell;
            }
            for (MarginAccountDistribution accItem : this.accMxList.getOrList()) {
                if (!accItem.getAcc().getNewCashAccntId().equals(strEach)) continue;
                accItem.setCanSell(canSellTotal);
            }
        }
    }

    public void calAccountCanBuy() {
        for (MarginAccountDistribution accItem : this.accMxList.getOrList()) {
            if (this.getPrice() > 0.0 && this.getUnit() > 0) {
                long canBuy;
                if ("8".equals(this.marginType.getValue()) && this.refItem != null) {
                    canBuy = (long)(accItem.getAcc().getPosBuyAvlXt() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getUnitConvert();
                    accItem.setCanBuy(canBuy);
                    continue;
                }
                canBuy = (long)(accItem.getAcc().getAvailableNewXt() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getUnitConvert();
                accItem.setCanBuy(canBuy);
                continue;
            }
            accItem.setCanBuy(0L);
        }
    }

    public void calAccountDebtContracts() {
        if (Objects.equals("5", this.marginType.getValue()) || Objects.equals("14", this.marginType.getValue())) {
            for (MarginAccountDistribution accItem : this.accMxList.getOrList()) {
                accItem.setDebtContracts(accItem.getAcc().getCreditFundFeeCanReturn() + accItem.getAcc().getCreditStockFeeCanReturn());
            }
        }
    }

    public void calAccountCanMetal() {
        double rate = 1.0;
        boolean isFund = true;
        if (this.refItem == null) {
            return;
        }
        XtUnderlyingSecurity underlying = this.underlyModel.getUnderlying(String.valueOf(this.refItem.getCode()) + MarketUtils.getMarketNameById((String)this.refItem.getMarket()));
        if ("3".equals(this.marginType.getValue()) && this.refItem != null && underlying != null) {
            rate = underlying.getMarginRateFund();
        } else if ("6".equals(this.marginType.getValue()) && this.refItem != null && underlying != null) {
            rate = underlying.getMarginRateSec();
            isFund = false;
        }
        for (MarginAccountDistribution accItem : this.accMxList.getOrList()) {
            if (this.getPrice() > 0.0 && this.getUnit() > 0 && this.refItem != null) {
                long canMetalTwo;
                long canMetalOne;
                if (isFund) {
                    canMetalTwo = canMetalOne = (long)(accItem.getAcc().getFcreditAvlNewXt() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getUnitConvert();
                    canMetalTwo = (long)(accItem.getAcc().getMarginAvlNewXt() / this.getPrice() * rate) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getUnitConvert();
                    accItem.setCanMeltableCount(Math.min(canMetalOne, canMetalTwo));
                    continue;
                }
                canMetalTwo = canMetalOne = (long)(accItem.getAcc().getDcreditAvlNewXt() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getUnitConvert();
                canMetalTwo = (long)(accItem.getAcc().getMarginAvlNewXt() / this.getPrice() * rate) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getUnitConvert();
                accItem.setCanMeltableCount(Math.min(canMetalOne, canMetalTwo));
                continue;
            }
            accItem.setCanMeltableCount(0L);
        }
    }

    public void calAccountnotRetrunMoney() {
        for (MarginAccountDistribution accItem : this.accMxList.getOrList()) {
            accItem.setNotReturnPrice(0.0);
        }
        for (MarginAccountDistribution accItem : this.accMxList.getOrList()) {
            accItem.setNotReturnPrice(accItem.getAcc().getFtotalDebtsNewXt());
        }
    }

    public void calAccountnotPosBuyPayoffMoney() {
        for (MarginAccountDistribution accItem : this.accMxList.getOrList()) {
            accItem.getAcc().setPosBuyAvl(accItem.getAcc().getPosBuyAvlXt());
        }
    }

    public void calAccountnotRetrunCashMoney() {
        for (MarginAccountDistribution accItem : this.accMxList.getOrList()) {
            accItem.setNotReturnPrice(0.0);
        }
        for (MarginAccountDistribution accItem : this.accMxList.getOrList()) {
            accItem.setNotReturnPrice(accItem.getAcc().getFtotalDebtsNewXt());
        }
    }

    public void calAccountCanRetrunQuant() {
        if (this.mapSecDisMxList == null) {
            return;
        }
        for (String strEach : this.mapSecDisMxList.keySet()) {
            long canSellTotal = 0L;
            for (MarginAccountDistribution subItem : this.mapSecDisMxList.get(strEach).getOrList()) {
                XtPosition position;
                if (subItem.getSecAcc() == null || this.refItem == null || (position = this.getPosition(subItem)) == null) continue;
                long canSell = new Double(position.getBalance()).longValue();
                subItem.setCanReturnCount(canSell);
                canSellTotal += canSell;
            }
            for (MarginAccountDistribution accItem : this.accMxList.getOrList()) {
                if (!accItem.getAcc().getNewCashAccntId().equals(strEach)) continue;
                accItem.setCanReturnCount(canSellTotal);
            }
        }
    }

    public void calAccountnotRetrunQuant() {
        for (MarginAccountDistribution accItem : this.accMxList.getOrList()) {
            if (this.refItem == null || this.contractModel.getMapQty().get(String.valueOf(accItem.getAcc().getNewCashAccntId()) + "," + this.refItem.getCode()) == null) continue;
            accItem.setNotReturnCount((long)((Integer)this.contractModel.getMapQty().get(String.valueOf(accItem.getAcc().getNewCashAccntId()) + "," + this.refItem.getCode())).intValue());
        }
    }

    protected void calCount() {
        for (TreeItem accItem : this.root.getChildren()) {
            int weight = 0;
            for (TreeItem secAccItem : accItem.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected())) {
                weight += ((MarginAccountDistribution)secAccItem.getValue()).getWeight();
            }
            ((MarginAccountDistribution)accItem.getValue()).setWeight(weight);
        }
        this.changed();
    }

    public Number allocateCount() {
        this.clearCount(this.root);
        this.calCanBuyByMarginTradeType();
        long totalCount = 0L;
        double totalPrice = 0.0;
        if (this.getCountStg() == null) {
            return 0;
        }
        switch (this.getCountStg()) {
            case "1": {
                totalCount = this.calByCount(totalCount);
                break;
            }
            case "5": {
                if ("14".equals(this.marginType.getValue())) {
                    totalPrice = this.calByMoneyDouble(totalPrice);
                    break;
                }
                if ("13".equals(this.marginType.getValue())) {
                    totalCount = this.calByMoneyVoucher(totalCount);
                    break;
                }
                totalCount = this.calByMoney(totalCount);
                break;
            }
            case "2": {
                if ("14".equals(this.marginType.getValue())) {
                    totalPrice = this.calByAssetDouble(totalPrice);
                    break;
                }
                if ("13".equals(this.marginType.getValue())) {
                    totalCount = this.calByAssetVoucher(totalCount);
                    break;
                }
                totalCount = this.calByAsset(totalCount);
                break;
            }
            case "3": {
                totalCount = this.calByCanBuy(totalCount);
                break;
            }
            case "4": {
                totalCount = this.calByCanSell(totalCount);
                break;
            }
            case "8": {
                totalCount = this.calByCanMeltable(totalCount);
                break;
            }
            case "9": {
                totalCount = this.calByCanMeltableSell(totalCount);
                break;
            }
            case "6": {
                if ("14".equals(this.marginType.getValue())) {
                    totalPrice = this.calByLiabilitiesRatePrice(totalPrice);
                    break;
                }
                if ("5".equals(this.marginType.getValue())) {
                    totalCount = this.calByLiabilitiesRateCount(totalCount);
                    break;
                }
                if ("13".equals(this.marginType.getValue())) {
                    totalCount = this.calByLiabilitiesRateNoReturnCount(totalCount);
                    break;
                }
                if (!"8".equals(this.marginType.getValue())) break;
                totalCount = this.calByLiabilitiesRateNoReturnCount(totalCount);
                break;
            }
            case "7": {
                totalPrice = this.calByCashAvl(totalPrice);
                break;
            }
            default: {
                this.clearCount(this.root);
            }
        }
        return totalCount == 0L ? totalPrice : (double)totalCount;
    }

    private double calByCashAvl(double totalPrice) {
        for (TreeItem each : this.root.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<MarginAccountDistribution>)ad) != false)) {
            MarginAccountDistribution item = (MarginAccountDistribution)each.getValue();
            double price = item.getAcc().getAvailableNewXt() * this.getPercent();
            totalPrice += price;
            this.doQuantityAllocate((TreeItem<MarginAccountDistribution>)each);
        }
        return totalPrice;
    }

    private long calByLiabilitiesRateCount(long total) {
        if (this.getPrice() <= 0.0) {
            return 0L;
        }
        for (TreeItem each : this.root.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<MarginAccountDistribution>)ad) != false)) {
            MarginAccountDistribution item = (MarginAccountDistribution)each.getValue();
            long count = (long)(item.getAcc().getRepayCashAvlXt() * this.getPercent() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getUnitConvert();
            ((MarginAccountDistribution)each.getValue()).setCount(count);
            total += item.getCount();
            this.doQuantityAllocate((TreeItem<MarginAccountDistribution>)each);
        }
        return total;
    }

    private double calByLiabilitiesRatePrice(double totalPrice) {
        for (TreeItem each : this.root.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<MarginAccountDistribution>)ad) != false)) {
            MarginAccountDistribution item = (MarginAccountDistribution)each.getValue();
            double price = item.getAcc().getRepayCashAvlXt() * this.getPercent();
            totalPrice += price;
            this.doQuantityAllocate((TreeItem<MarginAccountDistribution>)each);
        }
        return totalPrice;
    }

    private long calByLiabilitiesRateNoReturnCount(long totalCount) {
        for (TreeItem each : this.root.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<MarginAccountDistribution>)ad) != false)) {
            MarginAccountDistribution item = (MarginAccountDistribution)each.getValue();
            long count = new Double((double)item.getNotReturnCount() * this.getPercent()).longValue();
            ((MarginAccountDistribution)each.getValue()).setCount(count);
            totalCount += count;
            this.doQuantityAllocate((TreeItem<MarginAccountDistribution>)each);
        }
        return totalCount;
    }

    private long calByCanMeltableSell(long totalCount) {
        if (this.getPrice() <= 0.0) {
            return 0L;
        }
        for (TreeItem each : this.root.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<MarginAccountDistribution>)ad) != false)) {
            long count1;
            MarginAccountDistribution item = (MarginAccountDistribution)each.getValue();
            long count2 = count1 = (long)(item.getAcc().getDcreditAvlNewXt() * this.getPercent() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getUnitConvert();
            if (this.refItem != null && this.underlyModel.getUnderlying(String.valueOf(this.refItem.getCode()) + MarketUtils.getMarketNameById((String)this.refItem.getMarket())) != null) {
                count2 = (long)(item.getAcc().getMarginAvlNewXt() * this.getPercent() / (this.getPrice() * this.underlyModel.getUnderlying(String.valueOf(this.refItem.getCode()) + MarketUtils.getMarketNameById((String)this.refItem.getMarket())).getMarginRateSec()));
            }
            ((MarginAccountDistribution)each.getValue()).setCount(Math.min(count1, count2));
            totalCount += item.getCount();
            this.doQuantityAllocate((TreeItem<MarginAccountDistribution>)each);
        }
        return totalCount;
    }

    private long calByCanMeltable(long totalCount) {
        if (this.getPrice() <= 0.0) {
            return 0L;
        }
        for (TreeItem each : this.root.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<MarginAccountDistribution>)ad) != false)) {
            long count1;
            MarginAccountDistribution item = (MarginAccountDistribution)each.getValue();
            long count2 = count1 = (long)(item.getAcc().getFcreditAvlNewXt() * this.getPercent() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getUnitConvert();
            if (this.refItem != null && this.underlyModel.getUnderlying(String.valueOf(this.refItem.getCode()) + MarketUtils.getMarketNameById((String)this.refItem.getMarket())) != null) {
                count2 = (long)(item.getAcc().getMarginAvlNewXt() * this.getPercent() / (this.getPrice() * this.underlyModel.getUnderlying(String.valueOf(this.refItem.getCode()) + MarketUtils.getMarketNameById((String)this.refItem.getMarket())).getMarginRateFund()));
            }
            ((MarginAccountDistribution)each.getValue()).setCount(Math.min(count1, count2));
            totalCount += item.getCount();
            this.doQuantityAllocate((TreeItem<MarginAccountDistribution>)each);
        }
        return totalCount;
    }

    private long calByCount(long totalCount) {
        totalCount = this.doQuantityAllocate(this.root);
        this.root.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected()).forEach(each -> this.doQuantityAllocate((TreeItem<MarginAccountDistribution>)each));
        return totalCount;
    }

    private long calByMoney(long totalCount) {
        if (!"14".equals(this.marginType.getValue())) {
            if (this.getPrice() <= 0.0) {
                this.clearCount(this.root);
                return 0L;
            }
            long count = (long)(this.getMoney() / this.getPrice());
            totalCount = count / (long)this.getUnit() * (long)this.getUnit() / (long)this.getUnitConvert();
            totalCount = this.doQuantityAllocate(this.root, totalCount);
            this.root.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<MarginAccountDistribution>)ad) != false).forEach(each -> this.doQuantityAllocate((TreeItem<MarginAccountDistribution>)each));
        }
        return totalCount;
    }

    private long calByMoneyVoucher(long totalCount) {
        if (this.refItem == null) {
            return 0L;
        }
        MarketItem marketItem = this.marketMng.getInfo((IRefItem)this.refItem);
        if (marketItem == null) {
            return 0L;
        }
        long count = (long)(this.getMoney() / marketItem.getNowPrice());
        totalCount = count / (long)this.getUnit() * (long)this.getUnit() / (long)this.getUnitConvert();
        totalCount = this.doQuantityAllocate(this.root, totalCount);
        this.root.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<MarginAccountDistribution>)ad) != false).forEach(each -> this.doQuantityAllocate((TreeItem<MarginAccountDistribution>)each));
        return totalCount;
    }

    private double calByMoneyDouble(double totalPrice) {
        double price = this.getPrice();
        return totalPrice += new Double(price).doubleValue();
    }

    private long calByAssetVoucher(long totalCount) {
        if (this.refItem == null) {
            return 0L;
        }
        MarketItem marketItem = this.marketMng.getInfo((IRefItem)this.refItem);
        if (marketItem == null) {
            return 0L;
        }
        for (TreeItem each : this.root.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<MarginAccountDistribution>)ad) != false)) {
            MarginAccountDistribution item = (MarginAccountDistribution)each.getValue();
            long count = (long)(item.getAcc().getTotalAssetNewXt() * this.getPercent() / marketItem.getNowPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getUnitConvert();
            ((MarginAccountDistribution)each.getValue()).setCount(count);
            totalCount += item.getCount();
            this.doQuantityAllocate((TreeItem<MarginAccountDistribution>)each);
        }
        return totalCount;
    }

    private long calByAsset(long totalCount) {
        if (!"14".equals(this.marginType.getValue())) {
            if (this.getPrice() <= 0.0) {
                return 0L;
            }
            for (TreeItem each : this.root.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<MarginAccountDistribution>)ad) != false)) {
                MarginAccountDistribution item = (MarginAccountDistribution)each.getValue();
                long count = (long)(item.getAcc().getTotalAssetNewXt() * this.getPercent() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getUnitConvert();
                ((MarginAccountDistribution)each.getValue()).setCount(count);
                totalCount += item.getCount();
                this.doQuantityAllocate((TreeItem<MarginAccountDistribution>)each);
            }
        }
        return totalCount;
    }

    private double calByAssetDouble(double totalPrice) {
        for (TreeItem each : this.root.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<MarginAccountDistribution>)ad) != false)) {
            MarginAccountDistribution item = (MarginAccountDistribution)each.getValue();
            double price = item.getAcc().getTotalAssetNewXt() * this.getPercent();
            totalPrice += new Double(price).doubleValue();
            this.doQuantityAllocate((TreeItem<MarginAccountDistribution>)each);
        }
        return totalPrice;
    }

    protected long calByCanBuy(long totalCount) {
        if (this.getPrice() <= 0.0) {
            return 0L;
        }
        for (TreeItem each : this.root.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<MarginAccountDistribution>)ad) != false)) {
            MarginAccountDistribution item = (MarginAccountDistribution)each.getValue();
            long count = (long)(item.getAcc().getAvailableNewXt() * this.getPercent() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getUnitConvert();
            ((MarginAccountDistribution)each.getValue()).setCount(count);
            totalCount += item.getCount();
            this.doQuantityAllocate((TreeItem<MarginAccountDistribution>)each);
        }
        return totalCount;
    }

    protected long calByCanSell(long totalCount) {
        for (TreeItem each : this.root.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<MarginAccountDistribution>)ad) != false)) {
            long count = 0L;
            for (TreeItem eachSub : each.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected())) {
                XtPosition position;
                MarginAccountDistribution secAccItem = (MarginAccountDistribution)eachSub.getValue();
                if (secAccItem.getSecAcc() == null || this.refItem == null || (position = this.getPosition(secAccItem)) == null) continue;
                long canSell = new Double(position.getAvailable()).longValue();
                if (this.getPercent() == 1.0) {
                    secAccItem.setCount((long)((double)canSell * this.getPercent()));
                } else if ("13".equals(this.marginType.getValue()) && this.refItem != null) {
                    secAccItem.setCount((long)((double)canSell * this.getPercent()));
                } else {
                    secAccItem.setCount((long)((double)canSell * this.getPercent()) / (long)this.getUnit() * (long)this.getUnit());
                }
                count += secAccItem.getCount();
                totalCount += secAccItem.getCount();
            }
            ((MarginAccountDistribution)each.getValue()).setCount(count);
        }
        return totalCount;
    }

    private long doQuantityAllocate(TreeItem<MarginAccountDistribution> parent, long pTotal) {
        int totalWeight = 0;
        long totalCount = pTotal;
        this.clearCount(parent);
        int countAcc = this.getCalChildren(parent).size();
        for (TreeItem ad : this.getCalChildren(parent)) {
            totalWeight += 100 * ((MarginAccountDistribution)ad.getValue()).getWeight();
        }
        long assigned = 0L;
        if (this.getDistStg().equals("3")) {
            return this.doAllocateByMin(parent, totalCount);
        }
        Iterator it = this.getCalChildren(parent).iterator();
        while (it.hasNext()) {
            TreeItem ad = (TreeItem)it.next();
            if (!it.hasNext()) {
                long count = MathUtils.calCount((long)(totalCount - assigned), (int)1);
                ((MarginAccountDistribution)ad.getValue()).setCount(count);
                assigned += count;
                break;
            }
            long target = 0L;
            if (this.getDistStg().equals("1")) {
                target = totalCount / (long)countAcc;
            } else if (this.getDistStg().equals("2") && totalWeight != 0) {
                target = totalCount * (long)((MarginAccountDistribution)ad.getValue()).getWeight() * 100L / (long)totalWeight;
            }
            long count = MathUtils.calCount((long)target, (int)this.getUnit());
            if (((String)this.security.get()).startsWith("688") && count < 200L) {
                count = 0L;
            }
            assigned += count;
            ((MarginAccountDistribution)ad.getValue()).setCount(count);
        }
        return assigned;
    }

    protected long doQuantityAllocate(TreeItem<MarginAccountDistribution> parent) {
        return this.doQuantityAllocate(parent, ((MarginAccountDistribution)parent.getValue()).getCount());
    }

    protected long doAllocateByMin(TreeItem<MarginAccountDistribution> parent, long totalCount) {
        long assigned = 0L;
        LinkedList<TreeItem<MarginAccountDistribution>> list = new LinkedList<TreeItem<MarginAccountDistribution>>();
        parent.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<MarginAccountDistribution>)ad) != false).forEach(each -> each.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected()).forEach(subEach -> list.add((TreeItem<MarginAccountDistribution>)subEach)));
        list.sort(new CanSellComparator());
        Iterator it = list.iterator();
        while (it.hasNext()) {
            TreeItem ad2 = (TreeItem)it.next();
            if (!it.hasNext()) {
                long count = MathUtils.calCount((long)(totalCount - assigned), (int)1);
                ((MarginAccountDistribution)ad2.getValue()).setCount(count);
                assigned += count;
                long prCount = ((MarginAccountDistribution)ad2.getParent().getValue()).getCount() + ((MarginAccountDistribution)ad2.getValue()).getCount();
                ((MarginAccountDistribution)ad2.getParent().getValue()).setCount(prCount);
                break;
            }
            if (totalCount - assigned >= ((MarginAccountDistribution)ad2.getValue()).getCanSell()) {
                ((MarginAccountDistribution)ad2.getValue()).setCount(((MarginAccountDistribution)ad2.getValue()).getCanSell());
            } else {
                ((MarginAccountDistribution)ad2.getValue()).setCount(totalCount - assigned);
            }
            long prCount = ((MarginAccountDistribution)ad2.getParent().getValue()).getCount() + ((MarginAccountDistribution)ad2.getValue()).getCount();
            ((MarginAccountDistribution)ad2.getParent().getValue()).setCount(prCount);
            if ((assigned += ((MarginAccountDistribution)ad2.getValue()).getCount()) == totalCount) break;
        }
        return assigned;
    }

    public void clearCount(TreeItem<MarginAccountDistribution> parent) {
        parent.getChildren().forEach(each -> {
            ((MarginAccountDistribution)each.getValue()).setCount(0L);
            for (TreeItem sub : each.getChildren()) {
                if (sub == null) continue;
                ((MarginAccountDistribution)sub.getValue()).setCount(0L);
            }
        });
    }

    public void clearCanBuySell(TreeItem<MarginAccountDistribution> parent) {
        parent.getChildren().forEach(each -> {
            ((MarginAccountDistribution)each.getValue()).setCanBuy(0L);
            ((MarginAccountDistribution)each.getValue()).setCanSell(0L);
            ((MarginAccountDistribution)each.getValue()).setCanMeltableCount(0L);
            ((MarginAccountDistribution)each.getValue()).setCanReturnCount(0L);
            ((MarginAccountDistribution)each.getValue()).setNotReturnCount(0L);
            ((MarginAccountDistribution)each.getValue()).setNotReturnPrice(0.0);
            for (TreeItem sub : each.getChildren()) {
                if (sub == null) continue;
                ((MarginAccountDistribution)sub.getValue()).setCanBuy(0L);
                ((MarginAccountDistribution)sub.getValue()).setCanSell(0L);
                ((MarginAccountDistribution)sub.getValue()).setCanMeltableCount(0L);
                ((MarginAccountDistribution)sub.getValue()).setCanReturnCount(0L);
                ((MarginAccountDistribution)sub.getValue()).setNotReturnCount(0L);
                ((MarginAccountDistribution)sub.getValue()).setNotReturnPrice(0.0);
            }
        });
    }

    public void clearCanBuy(TreeItem<MarginAccountDistribution> parent) {
        parent.getChildren().forEach(each -> {
            ((MarginAccountDistribution)each.getValue()).setCanBuy(0L);
            for (TreeItem sub : each.getChildren()) {
                if (sub == null) continue;
                ((MarginAccountDistribution)sub.getValue()).setCanBuy(0L);
            }
        });
    }

    public void clearSelect() {
        if (this.accMxList != null) {
            this.accMxList.getOrList().forEach(each -> each.setSelected(false));
        }
        if (this.mapSecDisMxList != null) {
            this.mapSecDisMxList.keySet().forEach(each -> this.mapSecDisMxList.get(each).getOrList().forEach(subEach -> subEach.setSelected(false)));
        }
    }

    public void selectSecAcc(String secAcc, String mkt) {
        this.mapSecDisMxList.keySet().forEach(each -> {
            for (MarginAccountDistribution sub : this.mapSecDisMxList.get(each).getOrList()) {
                if (!sub.getSecAcc().getExtSecAccntId().equals(secAcc) || !sub.getSecAcc().getExchange().getRaw().equals(mkt)) continue;
                this.accMxList.getOrList().filtered(pd -> pd.isShow()).forEach(accEach -> {
                    if (accEach.getAcc().getNewCashAccntId().equals(each)) {
                        sub.setSelected(true);
                        accEach.setSelected(true);
                    }
                });
                break;
            }
        });
    }

    public void selectAllSecAcc() {
        this.mapSecDisMxList.keySet().forEach(each -> {
            for (MarginAccountDistribution sub : this.mapSecDisMxList.get(each).getOrList()) {
                this.accMxList.getOrList().filtered(pd -> pd.isShow()).forEach(accEach -> {
                    if (accEach.getAcc().getNewCashAccntId().equals(each)) {
                        sub.setSelected(true);
                        accEach.setSelected(true);
                    }
                });
            }
        });
    }

    protected Boolean hasSelectedChd(TreeItem<MarginAccountDistribution> parent) {
        if (!((MarginAccountDistribution)parent.getValue()).isIsSecAcc() && parent.isLeaf()) {
            return false;
        }
        if (!parent.isLeaf() && parent.getChildren().filtered(each -> ((MarginAccountDistribution)each.getValue()).isSelected()).size() == 0) {
            return false;
        }
        return true;
    }

    private ObservableList<TreeItem<MarginAccountDistribution>> getCalChildren(TreeItem<MarginAccountDistribution> parent) {
        if (this.getDistStg().equals("2")) {
            return parent.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<MarginAccountDistribution>)ad) != false && ((MarginAccountDistribution)ad.getValue()).getWeight() != 0);
        }
        return parent.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected() && this.hasSelectedChd((TreeItem<MarginAccountDistribution>)ad) != false);
    }

    public final StringProperty distStgProperty() {
        return this.distStg;
    }

    public final String getDistStg() {
        return (String)this.distStgProperty().get();
    }

    public final void setDistStg(String distStg) {
        this.distStgProperty().set((Object)distStg);
    }

    public final StringProperty countStgProperty() {
        return this.countStg;
    }

    public final String getCountStg() {
        return (String)this.countStgProperty().get();
    }

    public final void setCountStg(String countStg) {
        this.countStgProperty().set((Object)countStg);
    }

    public final DoubleProperty moneyProperty() {
        return this.money;
    }

    public final double getMoney() {
        return this.moneyProperty().get();
    }

    public final void setMoney(double money) {
        this.moneyProperty().set(money);
    }

    public final DoubleProperty priceProperty() {
        return this.price;
    }

    public final double getPrice() {
        return this.priceProperty().get();
    }

    public final void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public final IntegerProperty unitProperty() {
        return this.unit;
    }

    public final int getUnit() {
        return this.unitProperty().get();
    }

    public final void setUnit(int unit) {
        this.unitProperty().set(unit);
    }

    public final DoubleProperty percentProperty() {
        return this.percent;
    }

    public final double getPercent() {
        return this.percentProperty().get();
    }

    public final void setPercent(double percent) {
        this.percentProperty().set(percent);
    }

    public final StringProperty securityProperty() {
        return this.security;
    }

    public final String getSecurity() {
        return (String)this.securityProperty().get();
    }

    public final void setSecurity(String security) {
        this.securityProperty().set((Object)security);
    }

    public Boolean isCountValid() {
        return this.countValid;
    }

    public final IntegerProperty unitConvertProperty() {
        return this.unitConvert;
    }

    public final int getUnitConvert() {
        return this.unitConvertProperty().get();
    }

    public final void setUnitConvert(int unitConvert) {
        this.unitConvertProperty().set(unitConvert);
    }

    public final IntegerProperty effectiveSecAccCountProperty() {
        return this.effectiveSecAccCount;
    }

    public final int getEffectiveSecAccCount() {
        return this.effectiveSecAccCountProperty().get();
    }

    public final void setEffectiveSecAccCount(int effectiveSecAccCount) {
        this.effectiveSecAccCountProperty().set(effectiveSecAccCount);
    }

    public final IntegerProperty customSecAccCountProperty() {
        return this.customSecAccCount;
    }

    public final int getCustomSecAccCount() {
        return this.customSecAccCountProperty().get();
    }

    public final void setCustomSecAccCount(int customSecAccCount) {
        this.customSecAccCountProperty().set(customSecAccCount);
    }

    public final StringProperty accFilterStgProperty() {
        return this.accFilterStg;
    }

    public final String getAccFilterStg() {
        return (String)this.accFilterStgProperty().get();
    }

    public final void setAccFilterStg(String accFilterStg) {
        this.accFilterStgProperty().set((Object)accFilterStg);
    }

    public Map<CcsFundAccount, List<SecAccount>> getAccountMap() {
        if (this.isActive()) {
            return this.instructionAccModel.getMarginActiveAccMap(this.getInstructPanelType());
        }
        return this.instructionAccModel.getMarginPassiveAccMap(this.instruction);
    }

    public BooleanProperty selectedProperty() {
        return this.selected;
    }

    public boolean isSelected() {
        return this.selectedProperty().get();
    }

    public void setSelected(boolean selected) {
        this.selectedProperty().set(selected);
    }

    public final BooleanProperty singleProperty() {
        return this.single;
    }

    public final boolean isSingle() {
        return this.singleProperty().get();
    }

    public final void setSingle(boolean single) {
        this.singleProperty().set(single);
    }

    public final BooleanProperty normalProperty() {
        return this.normal;
    }

    public final boolean isNormal() {
        return this.normalProperty().get();
    }

    public final void setNormal(boolean normal) {
        this.normalProperty().set(normal);
    }

    public final StringProperty searchSecProperty() {
        return this.searchSec;
    }

    public final String getSearchSec() {
        return (String)this.searchSecProperty().get();
    }

    public final void setSearchSec(String searchSec) {
        this.searchSecProperty().set((Object)searchSec);
    }

    public void setRefItem(RefItem item) {
        this.refItem = item;
    }

    public RefItem getRefItem() {
        return this.refItem;
    }

    public TreeItem<MarginAccountDistribution> getRoot() {
        return this.root;
    }

    public final LongProperty canBuyProperty() {
        return this.canBuy;
    }

    public final long getCanBuy() {
        return this.canBuyProperty().get();
    }

    public final void setCanBuy(long canBuy) {
        this.canBuyProperty().set(canBuy);
    }

    public final LongProperty canSellProperty() {
        return this.canSell;
    }

    public final long getCanSell() {
        return this.canSellProperty().get();
    }

    public final void setCanSell(long canSell) {
        this.canSellProperty().set(canSell);
    }

    public final LongProperty canReturnQuantProperty() {
        return this.canReturnQuant;
    }

    public final long getCanReturnQuant() {
        return this.canReturnQuantProperty().get();
    }

    public final void setCanReturnQuant(long canReturnQuant) {
        this.canReturnQuantProperty().set(canReturnQuant);
    }

    public final LongProperty notReturnQuantProperty() {
        return this.notReturnQuant;
    }

    public final long getNotReturnQuant() {
        return this.notReturnQuantProperty().get();
    }

    public final void setNotReturnQuant(long notReturnQuant) {
        this.notReturnQuantProperty().set(notReturnQuant);
    }

    public final LongProperty canMetalProperty() {
        return this.canMetal;
    }

    public final long getCanMetal() {
        return this.canMetalProperty().get();
    }

    public final void setCanMetal(long canMetal) {
        this.canMetalProperty().set(canMetal);
    }

    public final StringProperty marginTypeProperty() {
        return this.marginType;
    }

    public final String getMarginType() {
        return (String)this.marginTypeProperty().get();
    }

    public final void setMarginType(String marginType) {
        this.marginTypeProperty().set((Object)marginType);
    }

    public final DoubleProperty canReturnMoneyProperty() {
        return this.canReturnMoney;
    }

    public final double getCanReturnMoney() {
        return this.canReturnMoneyProperty().get();
    }

    public final void setCanReturnMoney(double canReturnMoney) {
        this.canReturnMoneyProperty().set(canReturnMoney);
    }

    public final DoubleProperty notReturnMoneyProperty() {
        return this.notReturnMoney;
    }

    public final double getNotReturnMoney() {
        return this.notReturnMoneyProperty().get();
    }

    public final void setNotReturnMoney(double notReturnMoney) {
        this.notReturnMoneyProperty().set(notReturnMoney);
    }

    public void clearAll() {
        this.setCanBuy(0L);
        this.setCanSell(0L);
        this.setCanMetal(0L);
        this.setCanReturnMoney(0.0);
        this.setCanReturnQuant(0L);
        this.setNotReturnMoney(0.0);
        this.setNotReturnQuant(0L);
    }

    public final StringProperty instructPanelTypeProperty() {
        return this.instructPanelType;
    }

    public final String getInstructPanelType() {
        return (String)this.instructPanelTypeProperty().get();
    }

    public final void setInstructPanelType(String instructPanelType) {
        this.instructPanelTypeProperty().set((Object)instructPanelType);
    }

    public final BooleanProperty activeProperty() {
        return this.active;
    }

    public final boolean isActive() {
        return this.activeProperty().get();
    }

    public final void setActive(boolean active) {
        this.activeProperty().set(active);
    }

    public void fillAccount(ObSimpleInstruction instruction) {
        this.removeTree();
        this.mapQuantiy.clear();
        this.mapWeight.clear();
        this.instruction = instruction;
        List list = instruction.getOrderDetail().getAccntSecInfo();
        if (instruction.getIsOrderStep()) {
            list.forEach(accSec -> {
                long oldCount = 0L;
                int oldWeight = 0;
                if (this.mapQuantiy.get(accSec.getAccountId().getCashAccntId()) != null) {
                    oldCount = this.mapQuantiy.get(accSec.getAccountId().getCashAccntId());
                }
                this.mapQuantiy.put(accSec.getAccountId().getSecAccntId(), (long)accSec.getAvailableQty());
                this.mapQuantiy.put(accSec.getAccountId().getCashAccntId(), (long)(accSec.getAvailableQty() + (double)oldCount));
                this.mapWeight.put(accSec.getAccountId().getSecAccntId(), 1);
                this.mapWeight.put(accSec.getAccountId().getCashAccntId(), 1 + oldWeight);
            });
        } else {
            list.forEach(accSec -> {
                long oldCount = 0L;
                int oldWeight = 0;
                if (this.mapQuantiy.get(accSec.getAccountId().getCashAccntId()) != null) {
                    oldCount = this.mapQuantiy.get(accSec.getAccountId().getCashAccntId());
                }
                this.mapQuantiy.put(accSec.getAccountId().getSecAccntId(), (long)accSec.getOrderQty());
                this.mapQuantiy.put(accSec.getAccountId().getCashAccntId(), (long)(accSec.getOrderQty() + (double)oldCount));
                this.mapWeight.put(accSec.getAccountId().getSecAccntId(), 1);
                this.mapWeight.put(accSec.getAccountId().getCashAccntId(), 1 + oldWeight);
            });
        }
        this.setActive(false);
        this.setSelected(true);
        this.createTree();
    }

    public void removeTree() {
        this.root.getChildren().remove(0, this.root.getChildren().size());
    }

    public final DoubleProperty debtContractsProperty() {
        return this.debtContracts;
    }

    public final double getDebtContracts() {
        return this.debtContractsProperty().get();
    }

    public final void setDebtContracts(double debtContracts) {
        this.debtContractsProperty().set(debtContracts);
    }

    protected class CanSellComparator
    implements Comparator<TreeItem<MarginAccountDistribution>> {
        protected CanSellComparator() {
        }

        @Override
        public int compare(TreeItem<MarginAccountDistribution> o1, TreeItem<MarginAccountDistribution> o2) {
            if (((MarginAccountDistribution)o1.getValue()).getCanSell() == ((MarginAccountDistribution)o2.getValue()).getCanSell()) {
                return 0;
            }
            return ((MarginAccountDistribution)o1.getValue()).getCanSell() > ((MarginAccountDistribution)o2.getValue()).getCanSell() ? 1 : -1;
        }
    }
}

