/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.margin.model;

import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.data.RefItem;
import cms.tmx.margin.view.MarginTradePart;
import cms.tmx.trade.utils.TradeBindings;
import java.math.BigDecimal;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class MarginUserPreCtrl {
    @Inject
    protected MEventService es;
    private String funcPanelType;
    private String menuId;
    private MarginTradePart part;
    private static final int DEF_NUM = 4;
    private static int scale = 3;
    private boolean clearAfterOrder = true;
    private boolean popBeforeOrder = true;
    private boolean popBeforeCancel = true;
    private int priceChoose;
    private String buyPriceGear = "-1";
    private Double buyPriceFloat = 0.0;
    private String buyPriceUnit = "1";
    private String sellPriceGear;
    private Double sellPriceFloat;
    private String sellPriceUnit;
    private DoubleProperty upDownPriceFloat = new SimpleDoubleProperty(0.0);
    private DoubleProperty leftRightPriceFloat = new SimpleDoubleProperty(0.0);
    private Long buyQuantity;
    private Long sellQuantity;
    private LongProperty upDownQuantityFloat = new SimpleLongProperty(0L);
    private LongProperty leftRightQuantityFloat = new SimpleLongProperty(0L);
    private boolean autoSlice;
    private Long sliceCountMax;
    private Double buyMoney;
    private Double sellMoney;
    private DoubleProperty upDownMoneyFloat = new SimpleDoubleProperty(0.0);
    private DoubleProperty leftRightMoneyFloat = new SimpleDoubleProperty(0.0);
    private IntegerProperty[] commonQuantity = new SimpleIntegerProperty[4];
    private DoubleProperty[] commonAmount = new SimpleDoubleProperty[4];
    private DoubleProperty[] totalAssetRate = new SimpleDoubleProperty[4];
    private DoubleProperty[] canbuyRate = new SimpleDoubleProperty[4];
    private DoubleProperty[] cansellRate = new SimpleDoubleProperty[4];
    private DoubleProperty[] liabilittesRate = new SimpleDoubleProperty[4];
    private DoubleProperty[] avlRate = new SimpleDoubleProperty[4];
    private DoubleProperty[] canMeltableERate = new SimpleDoubleProperty[4];
    private DoubleProperty[] marginCanSellRate = new SimpleDoubleProperty[4];

    @PostConstruct
    public void init() {
        this.initSet();
    }

    @PreDestroy
    private void close() {
    }

    public void doSet() throws MException {
        if (this.funcPanelType == null || this.menuId == null) {
            this.initControls();
            return;
        }
    }

    public void initControls() {
        if (this.part == null) {
            return;
        }
        this.setPriceSpinner();
        SpinnerUtils.addDoubleArrowKeyHandler(this.getPart().getPriceSpn(), (ObservableNumberValue)this.upDownPriceFloatProperty(), (ObservableNumberValue)this.leftRightPriceFloatProperty());
        SpinnerUtils.addIntArrowKeyHandler(this.getPart().getQuantitySpn(), (ObservableNumberValue)this.upDownQuantityFloatProperty(), (ObservableNumberValue)this.leftRightQuantityFloatProperty());
        SpinnerUtils.addDoubleArrowKeyHandler(this.getPart().getMoneySpn(), (ObservableNumberValue)this.upDownMoneyFloatProperty(), (ObservableNumberValue)this.leftRightMoneyFloatProperty());
        TradeBindings.bindBigNumToInt((StringProperty)this.getPart().getLbCountOne().textProperty(), (ObservableNumberValue)this.getCommonQuantity()[0]);
        TradeBindings.bindBigNumToInt((StringProperty)this.getPart().getLbCountTwo().textProperty(), (ObservableNumberValue)this.getCommonQuantity()[1]);
        TradeBindings.bindBigNumToInt((StringProperty)this.getPart().getLbCountThree().textProperty(), (ObservableNumberValue)this.getCommonQuantity()[2]);
        TradeBindings.bindBigNumToInt((StringProperty)this.getPart().getLbCountFour().textProperty(), (ObservableNumberValue)this.getCommonQuantity()[3]);
        this.getPart().getLbCountOne().setOnMouseClicked(event -> this.getPart().setCount(this.getCommonQuantity()[0].longValue()));
        this.getPart().getLbCountTwo().setOnMouseClicked(event -> this.getPart().setCount(this.getCommonQuantity()[1].longValue()));
        this.getPart().getLbCountThree().setOnMouseClicked(event -> this.getPart().setCount(this.getCommonQuantity()[2].longValue()));
        this.getPart().getLbCountFour().setOnMouseClicked(event -> this.getPart().setCount(this.getCommonQuantity()[3].longValue()));
        Tooltip countTip1 = new Tooltip(Integer.toString(this.getCommonQuantity()[0].getValue()));
        countTip1.setFont(new Font("Arial", 14.0));
        this.getPart().getLbCountOne().setTooltip(countTip1);
        Tooltip countTip2 = new Tooltip(Integer.toString(this.getCommonQuantity()[1].getValue()));
        countTip2.setFont(new Font("Arial", 14.0));
        this.getPart().getLbCountTwo().setTooltip(countTip2);
        Tooltip countTip3 = new Tooltip(Integer.toString(this.getCommonQuantity()[2].getValue()));
        countTip3.setFont(new Font("Arial", 14.0));
        this.getPart().getLbCountThree().setTooltip(countTip3);
        Tooltip countTip4 = new Tooltip(Integer.toString(this.getCommonQuantity()[3].getValue()));
        countTip4.setFont(new Font("Arial", 14.0));
        this.getPart().getLbCountFour().setTooltip(countTip4);
        TradeBindings.bindBigNumToDouble((StringProperty)this.getPart().getLbAmountOne().textProperty(), (ObservableNumberValue)this.getCommonAmount()[0]);
        TradeBindings.bindBigNumToDouble((StringProperty)this.getPart().getLbAmountTwo().textProperty(), (ObservableNumberValue)this.getCommonAmount()[1]);
        TradeBindings.bindBigNumToDouble((StringProperty)this.getPart().getLbAmountThree().textProperty(), (ObservableNumberValue)this.getCommonAmount()[2]);
        TradeBindings.bindBigNumToDouble((StringProperty)this.getPart().getLbAmountFour().textProperty(), (ObservableNumberValue)this.getCommonAmount()[3]);
        this.getPart().getLbAmountOne().setOnMouseClicked(event -> this.getPart().setMoney(this.getCommonAmount()[0].getValue()));
        this.getPart().getLbAmountTwo().setOnMouseClicked(event -> this.getPart().setMoney(this.getCommonAmount()[1].getValue()));
        this.getPart().getLbAmountThree().setOnMouseClicked(event -> this.getPart().setMoney(this.getCommonAmount()[2].getValue()));
        this.getPart().getLbAmountFour().setOnMouseClicked(event -> this.getPart().setMoney(this.getCommonAmount()[3].getValue()));
        BigDecimal bd1 = new BigDecimal(this.getCommonAmount()[0].getValue()).setScale(2, 4);
        Tooltip amountTip1 = new Tooltip(bd1.toString());
        amountTip1.setFont(new Font("Arial", 14.0));
        this.getPart().getLbAmountOne().setTooltip(amountTip1);
        BigDecimal bd2 = new BigDecimal(this.getCommonAmount()[1].getValue()).setScale(2, 4);
        Tooltip amountTip2 = new Tooltip(bd2.toString());
        amountTip2.setFont(new Font("Arial", 14.0));
        this.getPart().getLbAmountTwo().setTooltip(amountTip2);
        BigDecimal bd3 = new BigDecimal(this.getCommonAmount()[2].getValue()).setScale(2, 4);
        Tooltip amountTip3 = new Tooltip(bd3.toString());
        amountTip3.setFont(new Font("Arial", 14.0));
        this.getPart().getLbAmountThree().setTooltip(amountTip3);
        BigDecimal bd = new BigDecimal(this.getCommonAmount()[3].getValue()).setScale(2, 4);
        Tooltip amountTip4 = new Tooltip(bd.toString());
        amountTip4.setFont(new Font("Arial", 14.0));
        this.getPart().getLbAmountFour().setTooltip(amountTip4);
        TradeBindings.bindToMoney((StringProperty)this.getPart().getLbTotalOne().textProperty(), (ObservableNumberValue)this.getTotalAssetRate()[0]);
        TradeBindings.bindToMoney((StringProperty)this.getPart().getLbTotalTwo().textProperty(), (ObservableNumberValue)this.getTotalAssetRate()[1]);
        TradeBindings.bindToMoney((StringProperty)this.getPart().getLbTotalThree().textProperty(), (ObservableNumberValue)this.getTotalAssetRate()[2]);
        TradeBindings.bindToMoney((StringProperty)this.getPart().getLbTotalFour().textProperty(), (ObservableNumberValue)this.getTotalAssetRate()[3]);
        this.getPart().getLbTotalOne().setOnMouseClicked(event -> this.getPart().setCountPer(this.getTotalAssetRate()[0].getValue()));
        this.getPart().getLbTotalTwo().setOnMouseClicked(event -> this.getPart().setCountPer(this.getTotalAssetRate()[1].getValue()));
        this.getPart().getLbTotalThree().setOnMouseClicked(event -> this.getPart().setCountPer(this.getTotalAssetRate()[2].getValue()));
        this.getPart().getLbTotalFour().setOnMouseClicked(event -> this.getPart().setCountPer(this.getTotalAssetRate()[3].getValue()));
        TradeBindings.bindToMoney((StringProperty)this.getPart().getLbCanbuyOne().textProperty(), (ObservableNumberValue)this.getCanbuyRate()[0]);
        TradeBindings.bindToMoney((StringProperty)this.getPart().getLbCanbuyTwo().textProperty(), (ObservableNumberValue)this.getCanbuyRate()[1]);
        TradeBindings.bindToMoney((StringProperty)this.getPart().getLbCanbuyThree().textProperty(), (ObservableNumberValue)this.getCanbuyRate()[2]);
        TradeBindings.bindToMoney((StringProperty)this.getPart().getLbCanbuyFour().textProperty(), (ObservableNumberValue)this.getCanbuyRate()[3]);
        this.getPart().getLbCanbuyOne().setOnMouseClicked(event -> this.getPart().setCountPer(this.getCanbuyRate()[0].getValue()));
        this.getPart().getLbCanbuyTwo().setOnMouseClicked(event -> this.getPart().setCountPer(this.getCanbuyRate()[1].getValue()));
        this.getPart().getLbCanbuyThree().setOnMouseClicked(event -> this.getPart().setCountPer(this.getCanbuyRate()[2].getValue()));
        this.getPart().getLbCanbuyFour().setOnMouseClicked(event -> this.getPart().setCountPer(this.getCanbuyRate()[3].getValue()));
        TradeBindings.bindToMoney((StringProperty)this.getPart().getLbCansellOne().textProperty(), (ObservableNumberValue)this.getCansellRate()[0]);
        TradeBindings.bindToMoney((StringProperty)this.getPart().getLbCansellTwo().textProperty(), (ObservableNumberValue)this.getCansellRate()[1]);
        TradeBindings.bindToMoney((StringProperty)this.getPart().getLbCansellThree().textProperty(), (ObservableNumberValue)this.getCansellRate()[2]);
        TradeBindings.bindToMoney((StringProperty)this.getPart().getLbCansellFour().textProperty(), (ObservableNumberValue)this.getCansellRate()[3]);
        this.getPart().getLbCansellOne().setOnMouseClicked(event -> this.getPart().setCountPer(this.getCansellRate()[0].getValue()));
        this.getPart().getLbCansellTwo().setOnMouseClicked(event -> this.getPart().setCountPer(this.getCansellRate()[1].getValue()));
        this.getPart().getLbCansellThree().setOnMouseClicked(event -> this.getPart().setCountPer(this.getCansellRate()[2].getValue()));
        this.getPart().getLbCansellFour().setOnMouseClicked(event -> this.getPart().setCountPer(this.getCansellRate()[3].getValue()));
        TradeBindings.bindToMoney((StringProperty)this.getPart().getLbLiabilitiesOne().textProperty(), (ObservableNumberValue)this.getLiabilittesRate()[0]);
        TradeBindings.bindToMoney((StringProperty)this.getPart().getLbLiabilitiesTwo().textProperty(), (ObservableNumberValue)this.getLiabilittesRate()[1]);
        TradeBindings.bindToMoney((StringProperty)this.getPart().getLbLiabilitiesThree().textProperty(), (ObservableNumberValue)this.getLiabilittesRate()[2]);
        TradeBindings.bindToMoney((StringProperty)this.getPart().getLbLiabilitiesFour().textProperty(), (ObservableNumberValue)this.getLiabilittesRate()[3]);
        this.getPart().getLbLiabilitiesOne().setOnMouseClicked(event -> this.getPart().setCountPer(this.getLiabilittesRate()[0].getValue()));
        this.getPart().getLbLiabilitiesTwo().setOnMouseClicked(event -> this.getPart().setCountPer(this.getLiabilittesRate()[1].getValue()));
        this.getPart().getLbLiabilitiesThree().setOnMouseClicked(event -> this.getPart().setCountPer(this.getLiabilittesRate()[2].getValue()));
        this.getPart().getLbLiabilitiesFour().setOnMouseClicked(event -> this.getPart().setCountPer(this.getLiabilittesRate()[3].getValue()));
        TradeBindings.bindToMoney((StringProperty)this.getPart().getLbAvlRateOne().textProperty(), (ObservableNumberValue)this.getAvlRate()[0]);
        TradeBindings.bindToMoney((StringProperty)this.getPart().getLbAvlRateTwo().textProperty(), (ObservableNumberValue)this.getAvlRate()[1]);
        TradeBindings.bindToMoney((StringProperty)this.getPart().getLbAvlRateThree().textProperty(), (ObservableNumberValue)this.getAvlRate()[2]);
        TradeBindings.bindToMoney((StringProperty)this.getPart().getLbAvlRateFour().textProperty(), (ObservableNumberValue)this.getAvlRate()[3]);
        this.getPart().getLbAvlRateOne().setOnMouseClicked(event -> this.getPart().setCountPer(this.getAvlRate()[0].getValue()));
        this.getPart().getLbAvlRateTwo().setOnMouseClicked(event -> this.getPart().setCountPer(this.getAvlRate()[1].getValue()));
        this.getPart().getLbAvlRateThree().setOnMouseClicked(event -> this.getPart().setCountPer(this.getAvlRate()[2].getValue()));
        this.getPart().getLbAvlRateFour().setOnMouseClicked(event -> this.getPart().setCountPer(this.getAvlRate()[3].getValue()));
        TradeBindings.bindToMoney((StringProperty)this.getPart().getLbMeltableOne().textProperty(), (ObservableNumberValue)this.getCanMeltableERate()[0]);
        TradeBindings.bindToMoney((StringProperty)this.getPart().getLbMeltableTwo().textProperty(), (ObservableNumberValue)this.getCanMeltableERate()[1]);
        TradeBindings.bindToMoney((StringProperty)this.getPart().getLbMeltableThree().textProperty(), (ObservableNumberValue)this.getCanMeltableERate()[2]);
        TradeBindings.bindToMoney((StringProperty)this.getPart().getLbMeltableFour().textProperty(), (ObservableNumberValue)this.getCanMeltableERate()[3]);
        this.getPart().getLbMeltableOne().setOnMouseClicked(event -> this.getPart().setCountPer(this.getCanMeltableERate()[0].getValue()));
        this.getPart().getLbMeltableTwo().setOnMouseClicked(event -> this.getPart().setCountPer(this.getCanMeltableERate()[1].getValue()));
        this.getPart().getLbMeltableThree().setOnMouseClicked(event -> this.getPart().setCountPer(this.getCanMeltableERate()[2].getValue()));
        this.getPart().getLbMeltableFour().setOnMouseClicked(event -> this.getPart().setCountPer(this.getCanMeltableERate()[3].getValue()));
        TradeBindings.bindToMoney((StringProperty)this.getPart().getLbMarginCansellOne().textProperty(), (ObservableNumberValue)this.getMarginCanSellRate()[0]);
        TradeBindings.bindToMoney((StringProperty)this.getPart().getLbMarginCansellTwo().textProperty(), (ObservableNumberValue)this.getMarginCanSellRate()[1]);
        TradeBindings.bindToMoney((StringProperty)this.getPart().getLbMarginCansellThree().textProperty(), (ObservableNumberValue)this.getMarginCanSellRate()[2]);
        TradeBindings.bindToMoney((StringProperty)this.getPart().getLbMarginCansellFour().textProperty(), (ObservableNumberValue)this.getMarginCanSellRate()[3]);
        this.getPart().getLbMarginCansellOne().setOnMouseClicked(event -> this.getPart().setCountPer(this.getMarginCanSellRate()[0].getValue()));
        this.getPart().getLbMarginCansellTwo().setOnMouseClicked(event -> this.getPart().setCountPer(this.getMarginCanSellRate()[1].getValue()));
        this.getPart().getLbMarginCansellThree().setOnMouseClicked(event -> this.getPart().setCountPer(this.getMarginCanSellRate()[2].getValue()));
        this.getPart().getLbMarginCansellFour().setOnMouseClicked(event -> this.getPart().setCountPer(this.getMarginCanSellRate()[3].getValue()));
        this.getPart().setAutoSlice(this.isAutoSlice(), this.getSliceCountMax());
    }

    public void selectTwoOrAllPriceDecimal() {
        TextFieldUtils.selectTwoOrNoPriceDecimal((int)this.priceChoose, (TextField)this.part.getPriceSpn().getEditor());
    }

    public void selectTwoOrAllProtectedPriceDecimal() {
        TextFieldUtils.selectTwoOrNoPriceDecimal((int)this.priceChoose, (TextField)this.part.getProtectedPriceSpn().getEditor());
    }

    public void onBsChange(boolean buy) {
    }

    public void onCountStgChange(boolean buy) {
    }

    private void setPriceSpinner() {
        if (this.part == null) {
            return;
        }
        RefItem refItem = this.getPart().getValidRef();
        if (refItem != null && this.getUpDownPriceFloat() < refItem.getPriceUnit()) {
            this.setUpDownPriceFloat(refItem.getPriceUnit());
        }
        if (refItem != null && this.getLeftRightPriceFloat() < refItem.getPriceUnit()) {
            this.setLeftRightPriceFloat(refItem.getPriceUnit());
        }
    }

    public double getDefPrice(boolean buy) {
        double price;
        if (this.getPart().getMarketItem().getRefItem() != null) {
            scale = this.getPart().getMarketItem().getRefItem().getScale();
        }
        if (buy) {
            int gear = this.getBuyPriceGear() == null ? -1 : Integer.parseInt(this.getBuyPriceGear());
            price = this.getPrice(gear);
            if (price <= 0.0) {
                return 0.0;
            }
            BigDecimal bg = new BigDecimal(String.valueOf(price));
            price = bg.setScale(scale, 4).doubleValue();
            double adjust = this.getBuyPriceFloat() == null ? 0.0 : this.getBuyPriceFloat();
            bg = "2".equals(this.getBuyPriceUnit()) ? new BigDecimal(String.valueOf(price *= 1.0 + adjust / 100.0)) : bg.add(new BigDecimal(String.valueOf(adjust)));
            price = bg.setScale(scale, 1).doubleValue();
        } else {
            int gear = this.getSellPriceGear() == null ? 1 : Integer.parseInt(this.getSellPriceGear());
            price = this.getPrice(gear);
            if (price <= 0.0) {
                return price;
            }
            BigDecimal bg = new BigDecimal(String.valueOf(price));
            price = bg.setScale(scale, 4).doubleValue();
            double adjust = this.getSellPriceFloat() == null ? 0.0 : this.getSellPriceFloat();
            bg = "2".equals(this.getSellPriceUnit()) ? new BigDecimal(String.valueOf(price *= 1.0 + adjust / 100.0)) : bg.add(new BigDecimal(String.valueOf(adjust)));
            price = bg.setScale(scale, 0).doubleValue();
        }
        return price;
    }

    public double getPrice(int gear) {
        switch (gear) {
            case 0: {
                return this.getPart().getMarketItem().getNowPrice();
            }
            case 100: {
                return this.getPart().getMarketItem().getUpLimitPrice();
            }
            case -100: {
                return this.getPart().getMarketItem().getDownLimitPrice();
            }
        }
        if (this.getPart() != null) {
            return this.getFitablePrice(gear);
        }
        return 0.0;
    }

    private double getFitablePrice(int raw) {
        double price = 0.0;
        if (raw > 0) {
            while (price <= 0.0 && raw > 0 && raw <= 10) {
                price = this.getPart().getMarketItem().getBuyPrice(raw - 1);
                --raw;
            }
        }
        if (raw < 0) {
            raw = Math.abs(raw);
            while (price <= 0.0 && raw > 0 && raw <= 10) {
                price = this.getPart().getMarketItem().getSellPrice(raw - 1);
                --raw;
            }
        }
        if (price <= 0.0) {
            price = this.getPart().getMarketItem().getNowPrice() == 0.0 ? this.getPart().getMarketItem().getClosePrice() : this.getPart().getMarketItem().getNowPrice();
        }
        return price;
    }

    private void initSet() {
        this.setClearAfterOrder(true);
        this.setPopBeforeOrder(true);
        this.setPopBeforeCancel(true);
        this.setPriceChoose(1);
        this.setUpDownPriceFloat(0.01);
        this.setLeftRightPriceFloat(0.05);
        this.setUpDownQuantityFloat(1000L);
        this.setLeftRightQuantityFloat(5000L);
        this.setUpDownMoneyFloat(10000.0);
        this.setLeftRightMoneyFloat(50000.0);
        this.setBuyPriceGear(Integer.toString(-1));
        this.setBuyPriceFloat(0.0);
        this.setBuyPriceUnit("2");
        this.setSellPriceGear(Integer.toString(1));
        this.setSellPriceFloat(0.0);
        this.setSellPriceUnit("2");
        this.setBuyQuantity(0L);
        this.setSellQuantity(0L);
        this.setAutoSlice(false);
        this.setSliceCountMax(1000000L);
        this.setBuyMoney(0.0);
        this.setSellMoney(0.0);
        int i = 0;
        while (i < 4) {
            this.commonQuantity[i] = new SimpleIntegerProperty();
            this.commonAmount[i] = new SimpleDoubleProperty();
            this.totalAssetRate[i] = new SimpleDoubleProperty();
            this.canbuyRate[i] = new SimpleDoubleProperty();
            this.cansellRate[i] = new SimpleDoubleProperty();
            this.liabilittesRate[i] = new SimpleDoubleProperty();
            this.avlRate[i] = new SimpleDoubleProperty();
            this.canMeltableERate[i] = new SimpleDoubleProperty();
            this.marginCanSellRate[i] = new SimpleDoubleProperty();
            ++i;
        }
        this.commonQuantity[0].set(100000);
        this.commonQuantity[1].set(50000);
        this.commonQuantity[2].set(20000);
        this.commonQuantity[3].set(10000);
        this.commonAmount[0].set(100000.0);
        this.commonAmount[1].set(50000.0);
        this.commonAmount[2].set(20000.0);
        this.commonAmount[3].set(10000.0);
        this.totalAssetRate[0].set(100.0);
        this.totalAssetRate[1].set(50.0);
        this.totalAssetRate[2].set(33.33);
        this.totalAssetRate[3].set(25.0);
        this.canbuyRate[0].set(100.0);
        this.canbuyRate[1].set(50.0);
        this.canbuyRate[2].set(33.33);
        this.canbuyRate[3].set(25.0);
        this.cansellRate[0].set(100.0);
        this.cansellRate[1].set(50.0);
        this.cansellRate[2].set(33.33);
        this.cansellRate[3].set(25.0);
        this.liabilittesRate[0].set(100.0);
        this.liabilittesRate[1].set(50.0);
        this.liabilittesRate[2].set(33.33);
        this.liabilittesRate[3].set(25.0);
        this.avlRate[0].set(100.0);
        this.avlRate[1].set(50.0);
        this.avlRate[2].set(33.33);
        this.avlRate[3].set(25.0);
        this.canMeltableERate[0].set(100.0);
        this.canMeltableERate[1].set(50.0);
        this.canMeltableERate[2].set(33.33);
        this.canMeltableERate[3].set(25.0);
        this.marginCanSellRate[0].set(100.0);
        this.marginCanSellRate[1].set(50.0);
        this.marginCanSellRate[2].set(33.33);
        this.marginCanSellRate[3].set(25.0);
    }

    public void setType(String funcPanelType, String menuId) {
        this.funcPanelType = funcPanelType;
        this.menuId = menuId;
    }

    public MarginTradePart getPart() {
        return this.part;
    }

    public void setPart(MarginTradePart part) {
        this.part = part;
    }

    public final DoubleProperty upDownPriceFloatProperty() {
        return this.upDownPriceFloat;
    }

    public final double getUpDownPriceFloat() {
        return this.upDownPriceFloatProperty().get();
    }

    public final void setUpDownPriceFloat(double upDownPriceFloat) {
        this.upDownPriceFloatProperty().set(upDownPriceFloat);
    }

    public final DoubleProperty leftRightPriceFloatProperty() {
        return this.leftRightPriceFloat;
    }

    public final double getLeftRightPriceFloat() {
        return this.leftRightPriceFloatProperty().get();
    }

    public final void setLeftRightPriceFloat(double leftRightPriceFloat) {
        this.leftRightPriceFloatProperty().set(leftRightPriceFloat);
    }

    public final LongProperty upDownQuantityFloatProperty() {
        return this.upDownQuantityFloat;
    }

    public final long getUpDownQuantityFloat() {
        return this.upDownQuantityFloatProperty().get();
    }

    public final void setUpDownQuantityFloat(long upDownQuantityFloat) {
        this.upDownQuantityFloatProperty().set(upDownQuantityFloat);
    }

    public final LongProperty leftRightQuantityFloatProperty() {
        return this.leftRightQuantityFloat;
    }

    public final long getLeftRightQuantityFloat() {
        return this.leftRightQuantityFloatProperty().get();
    }

    public final void setLeftRightQuantityFloat(long leftRightQuantityFloat) {
        this.leftRightQuantityFloatProperty().set(leftRightQuantityFloat);
    }

    public final DoubleProperty upDownMoneyFloatProperty() {
        return this.upDownMoneyFloat;
    }

    public final double getUpDownMoneyFloat() {
        return this.upDownMoneyFloatProperty().get();
    }

    public final void setUpDownMoneyFloat(double upDownMoneyFloat) {
        this.upDownMoneyFloatProperty().set(upDownMoneyFloat);
    }

    public final DoubleProperty leftRightMoneyFloatProperty() {
        return this.leftRightMoneyFloat;
    }

    public final double getLeftRightMoneyFloat() {
        return this.leftRightMoneyFloatProperty().get();
    }

    public final void setLeftRightMoneyFloat(double leftRightMoneyFloat) {
        this.leftRightMoneyFloatProperty().set(leftRightMoneyFloat);
    }

    public boolean isPopBeforeOrder() {
        return this.popBeforeOrder;
    }

    public void setPopBeforeOrder(boolean popBeforeOrder) {
        this.popBeforeOrder = popBeforeOrder;
    }

    public boolean isPopBeforeCancel() {
        return this.popBeforeCancel;
    }

    public void setPopBeforeCancel(boolean popBeforeCancel) {
        this.popBeforeCancel = popBeforeCancel;
    }

    public String getBuyPriceGear() {
        return this.buyPriceGear;
    }

    public void setBuyPriceGear(String buyPriceGear) {
        this.buyPriceGear = buyPriceGear;
    }

    public Double getBuyPriceFloat() {
        return this.buyPriceFloat;
    }

    public void setBuyPriceFloat(Double buyPriceFloat) {
        this.buyPriceFloat = buyPriceFloat;
    }

    public String getBuyPriceUnit() {
        return this.buyPriceUnit;
    }

    public void setBuyPriceUnit(String buyPriceUnit) {
        this.buyPriceUnit = buyPriceUnit;
    }

    public String getSellPriceGear() {
        return this.sellPriceGear;
    }

    public void setSellPriceGear(String sellPriceGear) {
        this.sellPriceGear = sellPriceGear;
    }

    public Double getSellPriceFloat() {
        return this.sellPriceFloat;
    }

    public void setSellPriceFloat(Double sellPriceFloat) {
        this.sellPriceFloat = sellPriceFloat;
    }

    public String getSellPriceUnit() {
        return this.sellPriceUnit;
    }

    public void setSellPriceUnit(String sellPriceUnit) {
        this.sellPriceUnit = sellPriceUnit;
    }

    public Long getBuyQuantity() {
        return this.buyQuantity;
    }

    public void setBuyQuantity(Long buyQuantity) {
        this.buyQuantity = buyQuantity;
    }

    public Long getSellQuantity() {
        return this.sellQuantity;
    }

    public void setSellQuantity(Long sellQuantity) {
        this.sellQuantity = sellQuantity;
    }

    public boolean isAutoSlice() {
        return this.autoSlice;
    }

    public void setAutoSlice(boolean autoSlice) {
        this.autoSlice = autoSlice;
    }

    public Long getSliceCountMax() {
        return this.sliceCountMax;
    }

    public void setSliceCountMax(Long sliceCountMax) {
        this.sliceCountMax = sliceCountMax;
    }

    public Double getBuyMoney() {
        return this.buyMoney;
    }

    public void setBuyMoney(Double buyMoney) {
        this.buyMoney = buyMoney;
    }

    public Double getSellMoney() {
        return this.sellMoney;
    }

    public void setSellMoney(Double sellMoney) {
        this.sellMoney = sellMoney;
    }

    public IntegerProperty[] getCommonQuantity() {
        return this.commonQuantity;
    }

    public void setCommonQuantity(IntegerProperty[] commonQuantity) {
        this.commonQuantity = commonQuantity;
    }

    public DoubleProperty[] getCommonAmount() {
        return this.commonAmount;
    }

    public void setCommonAmount(DoubleProperty[] commonAmount) {
        this.commonAmount = commonAmount;
    }

    public DoubleProperty[] getTotalAssetRate() {
        return this.totalAssetRate;
    }

    public void setTotalAssetRate(DoubleProperty[] totalAssetRate) {
        this.totalAssetRate = totalAssetRate;
    }

    public DoubleProperty[] getCanbuyRate() {
        return this.canbuyRate;
    }

    public void setCanbuyRate(DoubleProperty[] canbuyRate) {
        this.canbuyRate = canbuyRate;
    }

    public DoubleProperty[] getCansellRate() {
        return this.cansellRate;
    }

    public void setCansellRate(DoubleProperty[] cansellRate) {
        this.cansellRate = cansellRate;
    }

    public String getFuncPanelType() {
        return this.funcPanelType;
    }

    public void setFuncPanelType(String funcPanelType) {
        this.funcPanelType = funcPanelType;
    }

    public int getPriceChoose() {
        return this.priceChoose;
    }

    public void setPriceChoose(int priceChoose) {
        this.priceChoose = priceChoose;
    }

    public boolean isClearAfterOrder() {
        return this.clearAfterOrder;
    }

    public void setClearAfterOrder(boolean clearAfterOrder) {
        this.clearAfterOrder = clearAfterOrder;
    }

    public DoubleProperty[] getLiabilittesRate() {
        return this.liabilittesRate;
    }

    public void setLiabilittesRate(DoubleProperty[] liabilittesRate) {
        this.liabilittesRate = liabilittesRate;
    }

    public DoubleProperty[] getAvlRate() {
        return this.avlRate;
    }

    public void setAvlRate(DoubleProperty[] avlRate) {
        this.avlRate = avlRate;
    }

    public DoubleProperty[] getCanMeltableERate() {
        return this.canMeltableERate;
    }

    public void setCanMeltableERate(DoubleProperty[] canMeltableERate) {
        this.canMeltableERate = canMeltableERate;
    }

    public DoubleProperty[] getMarginCanSellRate() {
        return this.marginCanSellRate;
    }

    public void setMarginCanSellRate(DoubleProperty[] marginCanSellRate) {
        this.marginCanSellRate = marginCanSellRate;
    }
}

