/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.margin.model;

import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.Result;
import cms.tmx.entity.WorkFlowDescriptor;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.MarginAccountDistribution;
import cms.tmx.entity.trade.MarginSingleEntrust;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.OrderAdvice;
import cms.tmx.http.api.strategy.dto.MarketIndicator;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.IAccountService;
import cms.tmx.margin.api.ITradeModel;
import cms.tmx.margin.factory.MarginSingleEntrustFactory;
import cms.tmx.margin.model.MarginAccountDistributionModel;
import cms.tmx.query.margin.models.UnderlyingModel;
import cms.tmx.trade.models.CcsEntrustSplitModel;
import cms.tmx.utils.MarketUtils;
import cmx.tmx.data.IMarketDataMng;
import java.util.LinkedList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class MarginTradeModel
extends MxModel
implements ITradeModel {
    private StringProperty security = new SimpleStringProperty("");
    private StringProperty name = new SimpleStringProperty("");
    private DoubleProperty price = new SimpleDoubleProperty();
    private LongProperty count = new SimpleLongProperty();
    private DoubleProperty priceProtected = new SimpleDoubleProperty();
    private ObjectProperty<MxNode> priceStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> countStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> distStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> accFilterStg = new SimpleObjectProperty();
    private DoubleProperty countPer = new SimpleDoubleProperty();
    private DoubleProperty money = new SimpleDoubleProperty();
    private BooleanProperty autoSlice = new SimpleBooleanProperty(false);
    private LongProperty sliceSize = new SimpleLongProperty();
    private ObjectProperty<MxNode> priceTypeLimitedStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> priceTypeMktStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> priceTypeBidAskStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> priceTypeAfterHours = new SimpleObjectProperty();
    private ObjectProperty<MxNode> businessType = new SimpleObjectProperty();
    private BooleanProperty selectChange = new SimpleBooleanProperty(false);
    private final int INIT_UNIT = 100;
    private static final Logger logger = LogManager.getLogger(MarginTradeModel.class);
    @Inject
    private MObjFactory of;
    @Inject
    private IMarketDataMng mktMng;
    @Inject
    protected MarginAccountDistributionModel accTreeModel;
    @Inject
    protected MarginSingleEntrustFactory ef;
    @Inject
    protected CcsEntrustSplitModel entrustSplit;
    @Inject
    protected IAccountService accountService;
    @Inject
    private UnderlyingModel underlyModel;
    protected MarketItem mktItem;
    protected String transferSecAccountId = "";

    @PostConstruct
    public void init() {
        this.getAccDisModel().securityProperty().bind((ObservableValue)this.security);
        this.mktItem = this.mktMng.createItem(10);
        MxNode node = ((MxNode)this.of.create(MxNode.class)).load("margin_trade_count_stg", "1");
        this.countStg.addListener(ob -> this.onCountStgChange());
        this.countStgBuy(node);
        node = ((MxNode)this.of.create(MxNode.class)).load("acc_dist_mode", "1");
        this.distStgBuy(node);
        this.distStg.addListener(ob -> this.onDistStgChange());
        this.setDistStg(node);
        node = ((MxNode)this.of.create(MxNode.class)).load("cstr_price_type", "50");
        this.setPriceStg(node);
        this.priceStg.addListener(ob -> this.onPriceStgChange());
        node = ((MxNode)this.of.create(MxNode.class)).load("cstr_price_type_limited", "1");
        this.setPriceTypeLimitedStg(node);
        this.limitStgBuy(node);
        node = ((MxNode)this.of.create(MxNode.class)).load("instr_handicap", "-1");
        this.initPriceGear(node);
        this.setPriceTypeBidAskStg(node);
        this.priceTypeBidAskStg.addListener(ob -> this.onPriceStgChange());
        node = ((MxNode)this.of.create(MxNode.class)).load("cstr_price_type_mkt", "0");
        this.initMarketType(node);
        this.setPriceTypeMktStg(node);
        node = ((MxNode)this.of.create(MxNode.class)).load("cstr_price_type_after_hours", "1");
        this.initAfterHoursType(node);
        node = ((MxNode)this.of.create(MxNode.class)).load("acc_count_filter", "1");
        this.accFilterStg.addListener(ob -> this.onAccFilterStgChange());
        this.setAccFilterStg(node);
        node = ((MxNode)this.of.create(MxNode.class)).load("margin_trade_strategy", "1");
        this.getAccDisModel().setMarginType("1");
        this.setBusinessType(node);
        this.businessType.addListener(ob -> this.onBusinessChange());
        this.count.addListener(ob -> this.onCountChange());
        this.price.addListener(ob -> this.onPriceChange());
        this.priceProtected.addListener(ob -> this.onPriceChange());
        this.getAccDisModel().moneyProperty().bind((ObservableValue)this.money);
        this.money.addListener(ob -> this.onMoneyChange());
        this.getAccDisModel().percentProperty().bind((ObservableValue)Bindings.multiply((double)0.01, (ObservableNumberValue)this.countPer));
        this.countPer.addListener(ob -> this.onCountPerChange());
        this.getAccDisModel().changedProperty().addListener(ob -> this.calCountDistribution());
    }

    private void initAfterHoursType(MxNode node) {
        this.setPriceTypeAfterHours(node);
    }

    public void clearAll() {
        this.accTreeModel.clearAll();
    }

    public void onSecChange() {
        this.mktMng.dyeSyc(this.mktItem);
        if (!this.mktItem.getStop().getValue().booleanValue()) {
            this.setName(this.mktItem.getRefItem().getName());
        }
        this.filterAcc();
        this.changePriceStg();
        this.changeMarketPriceType();
        this.changeQuantityUnit();
        this.setMktPrice();
        this.setBidAskPrice();
        this.setAfterHoursPrice();
    }

    public final MarketItem getMI() {
        return this.mktItem;
    }

    private void onDistStgChange() {
        this.getAccDisModel().setDistStg(this.getDistStg().getRaw());
        this.calCountDistribution();
    }

    private void onCountStgChange() {
        if (this.getCountStg() == null) {
            return;
        }
        this.getAccDisModel().setCountStg(this.getCountStg().getRaw());
        if (this.getCountStg().getRaw().equals("5")) {
            if (this.isStar() && this.isMktPrice()) {
                this.setCount(this.getPriceProtected() != 0.0 ? (long)(this.getMoney() / this.getPriceProtected()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt() : 0L);
            } else {
                this.setCount(this.getPrice() != 0.0 ? (long)(this.getMoney() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt() : 0L);
            }
            return;
        }
        this.calCountDistribution();
    }

    private void onCountChange() {
        ((MarginAccountDistribution)this.getAccDisModel().getRoot().getValue()).setCount(this.getCount());
        if (this.getCount() == 0L) {
            this.getAccDisModel().clearCount(this.getAccDisModel().getRoot());
            return;
        }
        this.calCountDistribution();
    }

    private void setAfterHoursPrice() {
        if (!this.isAfterHoursPrice()) {
            return;
        }
        double price = this.mktItem.getNowPrice() == 0.0 ? this.mktItem.getClosePrice() : this.mktItem.getNowPrice();
        this.setPrice(price);
    }

    public void setBidAskPrice() {
        if (!this.isBidAskPrice()) {
            return;
        }
        int raw = Integer.parseInt(this.getPriceTypeBidAskStg().getRaw());
        double price = 0.0;
        if (raw > 0) {
            while (price <= 0.0 && raw > 0 && raw <= 10) {
                price = this.mktItem.getBuyPrice(raw - 1);
                --raw;
            }
        }
        if (raw < 0) {
            raw = Math.abs(raw);
            while (price <= 0.0 && raw > 0 && raw <= 10) {
                price = this.mktItem.getSellPrice(raw - 1);
                --raw;
            }
        }
        if (price <= 0.0) {
            price = this.mktItem.getNowPrice() == 0.0 ? this.mktItem.getClosePrice() : this.mktItem.getNowPrice();
        }
        this.setPrice(price);
    }

    public void setMktPrice() {
        block19: {
            String raw;
            if (!this.isMktPrice() || !this.isValidRef()) break block19;
            MxNode type = this.getBusinessType();
            if (type == null) {
                return;
            }
            switch (raw = type.getRaw()) {
                case "1": 
                case "3": 
                case "8": {
                    this.setPrice(this.mktItem.getUpLimitPrice());
                    break;
                }
                case "2": 
                case "5": {
                    this.setPrice(this.mktItem.getDownLimitPrice());
                    break;
                }
            }
            if (this.isStar() && this.isMktPrice()) {
                this.setPrice(this.getPriceProtected());
            }
            if (this.isGemFirst()) {
                this.setPrice(0.0);
            }
        }
    }

    public boolean isGemFirst() {
        if (this.mktItem.getRefItem().getStatus() == null) {
            return false;
        }
        return this.mktItem.getRefItem().getStatus().contains("\u4e0a\u5e02\u521d\u671f") || this.mktItem.getRefItem().getStatus().contains("\u4e0a\u5e02\u9996\u65e5");
    }

    private void onPriceStgChange() {
        this.getAccDisModel().setCountStg(this.getCountStg().getRaw());
        if (this.isMktPrice() && this.isValidRef()) {
            this.setMktPrice();
        } else if (this.isBidAskPrice()) {
            this.setBidAskPrice();
        } else if (this.isAfterHoursPrice()) {
            this.setAfterHoursPrice();
        } else {
            this.setPrice(0.0);
        }
    }

    public void onPriceChange() {
        Platform.runLater(() -> {
            if (this.isStar() && this.isMktPrice()) {
                this.getAccDisModel().setPrice(this.getPriceProtected());
            } else {
                this.getAccDisModel().setPrice(this.getPrice());
            }
            this.filterAcc();
            boolean clear = false;
            if (this.isStar() && this.isMktPrice()) {
                clear = this.getPriceProtected() == 0.0;
            } else {
                boolean bl = clear = this.getPrice() == 0.0 && !this.isUnlimited();
            }
            if (clear && !this.isGemFirst()) {
                this.getAccDisModel().clearCount(this.getAccDisModel().getRoot());
                this.getAccDisModel().clearCanBuy(this.getAccDisModel().getRoot());
                return;
            }
            if (this.getCountStg().getRaw().equals("5")) {
                this.setCount((long)(this.getMoney() / this.getAccDisModel().getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt());
                return;
            }
            if (!"14".equals(this.getBusinessType().getRaw())) {
                this.calCountDistribution();
            }
        });
    }

    private void onMoneyChange() {
        if (this.isStar() && this.isMktPrice()) {
            if (this.getPriceProtected() != 0.0) {
                this.setCount((long)(this.getMoney() / this.getPriceProtected()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt());
            }
        } else if (this.getPrice() != 0.0) {
            this.setCount((long)(this.getMoney() / this.getPrice()) / (long)this.getUnit() * (long)this.getUnit() / (long)this.getCvt());
        } else if ("13".equals(this.getBusinessType().getRaw()) && this.mktItem != null) {
            this.setCount((long)(this.getMoney() / this.mktItem.getNowPrice()));
        }
        if ("14".equals(this.getBusinessType().getRaw())) {
            this.getAccDisModel().setPrice(this.getMoney());
        }
        this.calCountDistribution();
    }

    private void onCountPerChange() {
        this.calCountDistribution();
    }

    private void onAccFilterStgChange() {
        this.getAccDisModel().setAccFilterStg(this.getAccFilterStg().getRaw());
        this.getAccDisModel().setCustomSecAccCount(this.getAccDisModel().getEffectiveSecAccCount());
    }

    protected void calCountDistribution() {
        if (!this.isValidRef() && this.getBusinessType() != null && !"14".equals(this.getBusinessType().getRaw())) {
            this.getAccDisModel().clearCount(this.getAccDisModel().getRoot());
            return;
        }
        Number total = this.getAccDisModel().allocateCount();
        if (this.setCaledCount()) {
            this.setCount(total.longValue());
        } else if (this.setCaledPrice()) {
            this.setPrice(total.doubleValue());
        }
    }

    public void filterAcc() {
        MxNode type = this.getBusinessType();
        if (!this.isValidRef()) {
            this.getAccDisModel().setRefItem(null);
            this.getAccDisModel().clearCanBuySell(this.getAccDisModel().getRoot());
            this.getAccDisModel().filterAcc();
            if (type != null && "14".equals(type.getRaw())) {
                this.getAccDisModel().calAccountnotRetrunCashMoney();
            }
            return;
        }
        this.getAccDisModel().setRefItem(this.getValidRef());
        if (type == null || !this.underlyModel.isUnderlying(String.valueOf(this.getAccDisModel().getRefItem().getCode()) + MarketUtils.getMarketNameById((String)this.getAccDisModel().getRefItem().getMarket())).booleanValue() && this.getBusinessType() != null && ("3".equals(this.getBusinessType().getRaw()) || "6".equals(this.getBusinessType().getRaw()) || "8".equals(this.getBusinessType().getRaw()) || "13".equals(this.getBusinessType().getRaw()))) {
            return;
        }
        switch (type.getRaw()) {
            case "1": {
                this.getAccDisModel().calAccountCanBuy();
                break;
            }
            case "2": {
                this.getAccDisModel().calAccountCanSell();
                break;
            }
            case "8": {
                this.getAccDisModel().calAccountCanBuy();
                this.getAccDisModel().calAccountnotRetrunQuant();
                break;
            }
            case "5": {
                this.getAccDisModel().calAccountCanRetrunQuant();
                this.getAccDisModel().calAccountnotRetrunMoney();
                break;
            }
            case "3": {
                this.getAccDisModel().calAccountCanMetal();
                break;
            }
            case "6": {
                this.getAccDisModel().calAccountCanMetal();
                break;
            }
            case "14": {
                this.getAccDisModel().calAccountnotRetrunCashMoney();
                break;
            }
            case "13": {
                this.getAccDisModel().calAccountCanRetrunQuant();
                this.getAccDisModel().calAccountnotRetrunQuant();
                break;
            }
        }
        this.getAccDisModel().filterAcc();
    }

    protected void changeQuantityUnit() {
        if (this.isValidRef()) {
            this.getAccDisModel().setUnit(this.mktItem.getRefItem().getBuyUnit());
            this.setCvt();
        } else {
            this.getAccDisModel().setUnit(100);
        }
    }

    public ObjectProperty<MxNode> countStgProperty() {
        return this.countStg;
    }

    public MxNode getCountStg() {
        return (MxNode)this.countStgProperty().get();
    }

    public void setCountStg(MxNode countStg) {
        this.countStgProperty().set((Object)countStg);
    }

    public synchronized Result submit(TreeItem<MarginAccountDistribution> root) {
        Result result = new Result();
        for (MarginSingleEntrust en : this.getEntrustList(true)) {
            try {
                if ("VOUCHER_PAYOFF".equals(en.getMarketIndicate()) || "CASH_PAYOFF".equals(en.getMarketIndicate())) {
                    en.newTransPos();
                } else {
                    en.setApplId("750");
                    en.setMarketGroup("CCS");
                    en.newOrderSingle();
                }
                result.operate(true);
            }
            catch (MException e) {
                result.operate(false);
                result.getReason().append("\n\u63d0\u4ea4\u9519\u8bef\uff1a" + e.getCode() + "\uff1a" + e.getDesc());
                logger.error("\u4e8c\u878d\u59d4\u6258\u63d0\u4ea4\u51fa\u9519" + e.getCode() + e.getDesc(), (Throwable)e);
            }
        }
        return result;
    }

    public synchronized ObservableList<Boolean> submitAdvice() throws MException {
        return null;
    }

    public final ObjectProperty<MxNode> distStgProperty() {
        return this.distStg;
    }

    public final MxNode getDistStg() {
        return (MxNode)this.distStgProperty().get();
    }

    public final void setDistStg(MxNode distStg) {
        this.distStgProperty().set((Object)distStg);
    }

    public boolean isLimitPrice() {
        if (this.getPriceStg() == null) {
            return false;
        }
        return this.getPriceStg().is(Integer.toString(50));
    }

    protected void changeMarketPriceType() {
        MxNode node = this.getPriceTypeMktStg();
        if (node == null) {
            return;
        }
        if (this.mktItem.getRefItem().getMarket().equals("XSHG")) {
            this.shMarket(node);
        } else if (this.mktItem.getRefItem().getMarket().equals("XSHE")) {
            this.szMarket(node);
        } else {
            this.initMarketType(node);
        }
    }

    private void changePriceStg() {
        MxNode node = this.getPriceStg();
        if (node == null) {
            return;
        }
        String old = node.getRaw();
        if (this.isBond() && this.isMktPrice()) {
            node.removeOthers("50");
            node.addNode("0");
            node.setRaw("50");
        } else if (this.isBond()) {
            node.removeNode("49");
            node.removeNode("99");
            if (old.equals("49") || old.equals("99")) {
                node.setRaw("50");
            }
        } else {
            this.getPriceStg().addNode("49");
            if (!this.isGem()) {
                node.removeNode("99");
                if (old.equals("99")) {
                    node.setRaw("50");
                }
            } else if (this.getBusinessType() != null) {
                if ("1".equals(this.getBusinessType().getRaw()) || "2".equals(this.getBusinessType().getRaw())) {
                    node.addNode("99");
                } else {
                    node.removeNode("99");
                    if (old.equals("99")) {
                        node.setRaw("50");
                    }
                }
            }
        }
        if (this.getBusinessType() != null) {
            if ("6".equals(this.getBusinessType().getRaw())) {
                if (node.constains("49")) {
                    node.removeNode("49");
                    if (old.equals("49")) {
                        node.setRaw("50");
                    }
                }
            } else if (!this.isBond()) {
                node.addNode("49");
            }
        }
        this.setPriceStg(node);
    }

    public boolean isStar() {
        return this.mktItem.isValidRef() && this.mktItem.getRefItem().getCode().startsWith("688");
    }

    public boolean isGem() {
        return this.mktItem.isValidRef() && this.mktItem.getRefItem().isGem();
    }

    protected void countStgBuy(MxNode node) {
        if (node == null) {
            return;
        }
        String oldNodeRaw = node.getRaw();
        node.removeOthers("1");
        node.addNode("5");
        node.addNode("3");
        node.addNode("2");
        node.setRaw(oldNodeRaw.equals("4") ? "3" : oldNodeRaw);
        this.setCountStg(node);
    }

    protected void distStgBuy(MxNode node) {
        node.removeNode("3");
        node.removeNode("4");
    }

    protected void distStgSell(MxNode node) {
        node.addNode("3");
    }

    public DoubleProperty countPerProperty() {
        return this.countPer;
    }

    public double getCountPer() {
        return this.countPerProperty().get();
    }

    public void setCountPer(double countPer) {
        this.countPerProperty().set(countPer);
    }

    public DoubleProperty moneyProperty() {
        return this.money;
    }

    public double getMoney() {
        return this.moneyProperty().get();
    }

    public void setMoney(double money) {
        this.moneyProperty().set(money);
    }

    public boolean isValidRef() {
        if (this.mktItem.getRefItem() == null) {
            return false;
        }
        return !this.mktItem.getRefItem().getType().isEmpty();
    }

    public RefItem getValidRef() {
        RefItem item = this.mktItem.getRefItem();
        if (item == null || item.getType().isEmpty()) {
            return null;
        }
        return item;
    }

    private int getUnit() {
        return this.getAccDisModel().getUnit();
    }

    protected int getCvt() {
        return this.getAccDisModel().getUnitConvert();
    }

    private void setCvt() {
        this.getAccDisModel().setUnitConvert(this.isSHbond() ? 10 : 1);
    }

    public boolean isSHbond() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.isBond() && this.mktItem.getRefItem().getMarket().equals("XSHG");
    }

    public boolean isReverseRepo() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("REPO");
    }

    public boolean isBond() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("BOND") || this.getValidRef().getType().equals("REPO");
    }

    public boolean isStock() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("STOCK");
    }

    public boolean isFund() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("FUND");
    }

    private boolean setCaledCount() {
        if (this.getCountStg().getRaw().equals("4") || this.getCountStg().getRaw().equals("3") || this.getCountStg().getRaw().equals("9") || this.getCountStg().getRaw().equals("8") || this.getCountStg().getRaw().equals("2") && this.getBusinessType() != null && !"14".equals(this.getBusinessType().getRaw())) {
            return true;
        }
        return this.getCountStg().getRaw().equals("6") && this.getBusinessType() != null && ("5".equals(this.getBusinessType().getRaw()) || "8".equals(this.getBusinessType().getRaw()) || "13".equals(this.getBusinessType().getRaw()));
    }

    private boolean setCaledPrice() {
        return this.getCountStg().getRaw().equals("6") || this.getCountStg().getRaw().equals("7") || this.getCountStg().getRaw().equals("2") || this.getCountStg().getRaw().equals("5") && this.getBusinessType() != null && "14".equals(this.getBusinessType().getRaw());
    }

    protected boolean isCountOrSell() {
        return this.getCountStg().getRaw().equals("4") || this.getCountStg().getRaw().equals("1");
    }

    protected void onBusinessChange() {
        MxNode type = this.getBusinessType();
        MxNode node = this.getCountStg();
        if (type == null || node == null) {
            return;
        }
        String newType = type.getRaw();
        this.getAccDisModel().setMarginType(newType);
        switch (newType) {
            case "1": {
                node.addNode("1");
                node.removeOthers("1");
                node.setRaw("1");
                this.setCountStg(node);
                node.addNode("5");
                node.addNode("3");
                node.addNode("2");
                this.setCountStg(node);
                this.limitStgBuy(this.getPriceTypeLimitedStg());
                break;
            }
            case "2": {
                node.addNode("1");
                node.removeOthers("1");
                node.setRaw("1");
                this.setCountStg(node);
                node.addNode("5");
                node.addNode("4");
                node.addNode("2");
                this.setCountStg(node);
                this.limitStgSell(this.getPriceTypeLimitedStg());
                break;
            }
            case "8": {
                node.addNode("1");
                node.removeOthers("1");
                node.setRaw("1");
                this.setCountStg(node);
                node.addNode("5");
                node.addNode("3");
                node.addNode("2");
                node.addNode("6");
                this.setCountStg(node);
                this.limitStgBuy(this.getPriceTypeLimitedStg());
                break;
            }
            case "5": {
                node.addNode("1");
                node.removeOthers("1");
                node.setRaw("1");
                this.setCountStg(node);
                node.addNode("5");
                node.addNode("4");
                node.addNode("2");
                node.addNode("6");
                this.setCountStg(node);
                this.limitStgSell(this.getPriceTypeLimitedStg());
                break;
            }
            case "3": {
                node.addNode("1");
                node.removeOthers("1");
                node.setRaw("1");
                this.setCountStg(node);
                node.addNode("5");
                node.addNode("8");
                node.addNode("2");
                this.setCountStg(node);
                this.limitStgBuy(this.getPriceTypeLimitedStg());
                break;
            }
            case "6": {
                node.addNode("1");
                node.removeOthers("1");
                node.setRaw("1");
                this.setCountStg(node);
                node.addNode("5");
                node.addNode("9");
                node.addNode("2");
                this.setCountStg(node);
                this.limitStgSell(this.getPriceTypeLimitedStg());
                break;
            }
            case "14": {
                node.addNode("5");
                node.removeOthers("5");
                node.setRaw("5");
                this.setCountStg(node);
                node.addNode("2");
                node.addNode("7");
                node.addNode("6");
                this.setCountStg(node);
                this.setPrice(0.0);
                this.limitStgBuy(this.getPriceTypeLimitedStg());
                break;
            }
            case "13": {
                node.addNode("1");
                node.removeOthers("1");
                node.setRaw("1");
                this.setCountStg(node);
                node.addNode("5");
                node.addNode("2");
                node.addNode("4");
                node.addNode("6");
                this.setCountStg(node);
                this.setPrice(0.0);
                this.limitStgBuy(this.getPriceTypeLimitedStg());
                break;
            }
        }
        this.changed();
        this.filterAcc();
        this.changePriceStg();
        this.calCountDistribution();
        if (!this.isBidAskPrice()) {
            this.setPrice(0.0);
        }
        if (this.isMktPrice() && this.isValidRef()) {
            this.setMktPrice();
        }
    }

    @Override
    public MarginSingleEntrust createEntrust(String acc, String secAcc) {
        return this.ef.createCcsSingle(acc, secAcc);
    }

    @Override
    public final StringProperty securityProperty() {
        return this.security;
    }

    @Override
    public final String getSecurity() {
        return (String)this.securityProperty().get();
    }

    @Override
    public final void setSecurity(String security) {
        this.securityProperty().set((Object)security);
    }

    @Override
    public final StringProperty nameProperty() {
        return this.name;
    }

    @Override
    public final String getName() {
        return (String)this.nameProperty().get();
    }

    @Override
    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    @Override
    public DoubleProperty priceProperty() {
        return this.price;
    }

    @Override
    public double getPrice() {
        return this.priceProperty().get();
    }

    @Override
    public void setPrice(double price) {
        this.priceProperty().set(price);
    }

    @Override
    public ObjectProperty<MxNode> priceStgProperty() {
        return this.priceStg;
    }

    @Override
    public MxNode getPriceStg() {
        return (MxNode)this.priceStgProperty().get();
    }

    @Override
    public void setPriceStg(MxNode priceStg) {
        this.priceStgProperty().set((Object)priceStg);
    }

    @Override
    public LongProperty countProperty() {
        return this.count;
    }

    @Override
    public long getCount() {
        return this.countProperty().get();
    }

    @Override
    public void setCount(long count) {
        this.countProperty().set(count);
    }

    public final ObjectProperty<MxNode> accFilterStgProperty() {
        return this.accFilterStg;
    }

    public final MxNode getAccFilterStg() {
        return (MxNode)this.accFilterStgProperty().get();
    }

    public final void setAccFilterStg(MxNode accFilterStg) {
        this.accFilterStgProperty().set((Object)accFilterStg);
    }

    public void setPstAcct(String secAcc, String mkt) {
    }

    public void setPresetPstAcct(String secAcc, String mkt) {
    }

    public List<MarginSingleEntrust> getEntrustList(boolean isOrder) {
        LinkedList<MarginSingleEntrust> enList = new LinkedList<MarginSingleEntrust>();
        MxNode type = this.getBusinessType();
        if (type == null) {
            return enList;
        }
        String typeValue = type.getRaw();
        block22: for (TreeItem acc : this.getAccDisModel().getRoot().getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected())) {
            for (TreeItem secAcc : acc.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected())) {
                MarginSingleEntrust en;
                block37: {
                    block39: {
                        block38: {
                            block36: {
                                if (((MarginAccountDistribution)acc.getValue()).getCount() == 0L && !"14".equals(typeValue)) continue block22;
                                en = this.createEntrust(((MarginAccountDistribution)acc.getValue()).getAcc().getNewCashAccntId(), ((MarginAccountDistribution)secAcc.getValue()).getSecAcc().getExtSecAccntId());
                                en.setFundAccount((FundAccount)((MarginAccountDistribution)acc.getValue()).getAcc());
                                en.setSecAccount(((MarginAccountDistribution)secAcc.getValue()).getSecAcc());
                                en.setInvestorId(((MarginAccountDistribution)acc.getValue()).getAcc().getInvestId());
                                en.setInvestorSecId(((MarginAccountDistribution)secAcc.getValue()).getSecAcc().getInverstorSecId());
                                en.setMarketIndicate(MarketIndicator.getValue((String)this.getBusinessType().getRaw()));
                                en.setMarketIndicateShow(this.getBusinessType().getValue());
                                en.setTransferSecAccountId(this.getTransferSecAccountId());
                                en.setQuantity(((MarginAccountDistribution)secAcc.getValue()).getCount());
                                en.setCanSell(((MarginAccountDistribution)secAcc.getValue()).getCanSell());
                                en.setCanReturnCount(((MarginAccountDistribution)secAcc.getValue()).getCanReturnCount());
                                en.setMarket(this.mktItem.getRefItem() == null ? "" : this.mktItem.getRefItem().getMarket());
                                en.setSecType(this.mktItem.getRefItem() == null ? "" : this.mktItem.getRefItem().getType());
                                en.setPrice(this.getPrice());
                                if (!"50".equals(this.getPriceStg().getRaw())) break block36;
                                en.setOrderType(50);
                                en.setPrice(this.getPrice());
                                break block37;
                            }
                            if (!"0".equals(this.getPriceStg().getRaw())) break block38;
                            en.setOrderType(0);
                            en.setPrice(this.getPrice());
                            break block37;
                        }
                        if (!"99".equals(this.getPriceStg().getRaw())) break block39;
                        en.setOrderType(80);
                        en.setPrice(this.getPrice());
                        break block37;
                    }
                    en.setOrderType(49);
                    switch (this.getPriceTypeMktStg().getRaw()) {
                        case "SH1": {
                            en.setMaxLevels(5);
                            en.setTif(48);
                            break;
                        }
                        case "SH2": {
                            en.setTif(51);
                            en.setMaxLevels(5);
                            break;
                        }
                        case "SH3": {
                            en.setMaxLevels(1);
                            en.setTif(48);
                            break;
                        }
                        case "SH4": {
                            en.setMaxLevels(0);
                            en.setTif(48);
                            break;
                        }
                        case "SZ1": {
                            en.setTif(48);
                            en.setMaxLevels(1);
                            break;
                        }
                        case "SZ2": {
                            en.setTif(48);
                            en.setMaxLevels(0);
                            break;
                        }
                        case "SZ3": {
                            en.setTif(51);
                            en.setMaxLevels(0);
                            break;
                        }
                        case "SZ4": {
                            en.setTif(51);
                            en.setMaxLevels(5);
                            break;
                        }
                        case "SZ5": {
                            en.setTif(52);
                            en.setMaxLevels(0);
                            break;
                        }
                    }
                    if (this.isStar()) {
                        en.setPrice(this.getPriceProtected());
                    }
                }
                en.setSec(this.mktItem.getRefItem() == null ? "" : this.mktItem.getRefItem().getCode());
                en.setSecName(this.mktItem.getRefItem() == null ? "" : this.mktItem.getRefItem().getName());
                if ("13".equals(typeValue)) {
                    en.setPrice(this.mktItem.getNowPrice());
                }
                enList.add(en);
                if ("14".equals(typeValue)) continue block22;
            }
        }
        return enList;
    }

    public List<OrderAdvice> getOrderAdvices() throws MException {
        return null;
    }

    public WorkFlowDescriptor getWorkFlowByFundAccount(FundAccount fundAcc) {
        return null;
    }

    public BooleanProperty autoSliceProperty() {
        return this.autoSlice;
    }

    public boolean isAutoSlice() {
        return this.autoSliceProperty().get();
    }

    public void setAutoSlice(boolean autoSlice) {
        this.autoSliceProperty().set(autoSlice);
    }

    public LongProperty sliceSizeProperty() {
        return this.sliceSize;
    }

    public long getSliceSize() {
        return this.sliceSizeProperty().get();
    }

    public void setSliceSize(long sliceSize) {
        this.sliceSizeProperty().set(sliceSize);
    }

    public List<TreeItem<MarginAccountDistribution>> getSelectedItems(TreeItem<MarginAccountDistribution> tree) {
        return tree.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected());
    }

    public List<TreeItem<MarginAccountDistribution>> getNoZeroItems(TreeItem<MarginAccountDistribution> tree) {
        return tree.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected() && ((MarginAccountDistribution)ad.getValue()).getCount() != 0L);
    }

    public void create(String instructType) {
        try {
            this.getAccDisModel().create();
        }
        catch (MException e) {
            logger.error(e.getMessage());
        }
    }

    public ObjectProperty<MxNode> priceTypeLimitedStgProperty() {
        return this.priceTypeLimitedStg;
    }

    public MxNode getPriceTypeLimitedStg() {
        return (MxNode)this.priceTypeLimitedStgProperty().get();
    }

    public void setPriceTypeLimitedStg(MxNode priceTypeLimitedStg) {
        this.priceTypeLimitedStgProperty().set((Object)priceTypeLimitedStg);
    }

    public ObjectProperty<MxNode> priceTypeMktStgProperty() {
        return this.priceTypeMktStg;
    }

    public MxNode getPriceTypeMktStg() {
        return (MxNode)this.priceTypeMktStgProperty().get();
    }

    public void setPriceTypeMktStg(MxNode priceTypeMktStg) {
        this.priceTypeMktStgProperty().set((Object)priceTypeMktStg);
    }

    public ObjectProperty<MxNode> priceTypeBidAskStgProperty() {
        return this.priceTypeBidAskStg;
    }

    public MxNode getPriceTypeBidAskStg() {
        return (MxNode)this.priceTypeBidAskStgProperty().get();
    }

    public void setPriceTypeBidAskStg(MxNode priceTypeBidAskStg) {
        this.priceTypeBidAskStgProperty().set((Object)priceTypeBidAskStg);
    }

    public boolean isUnlimited() {
        if (this.getPriceTypeLimitedStg() == null || !this.isLimitPrice()) {
            return false;
        }
        return this.getPriceTypeLimitedStg().is("3");
    }

    public boolean isSpecify() {
        if (this.getPriceTypeLimitedStg() == null || !this.isLimitPrice()) {
            return false;
        }
        return this.getPriceTypeLimitedStg().is("2");
    }

    public boolean isAfterHours() {
        if (this.getPriceStg() == null) {
            return false;
        }
        return this.getPriceStg().is("99");
    }

    public boolean isUpLimit() {
        if (this.getPriceTypeLimitedStg() == null || !this.isLimitPrice()) {
            return false;
        }
        return this.getPriceTypeLimitedStg().is("1");
    }

    public boolean isDownLimit() {
        if (this.getPriceTypeLimitedStg() == null || !this.isLimitPrice()) {
            return false;
        }
        return this.getPriceTypeLimitedStg().is("4");
    }

    private void limitStgBuy(MxNode node) {
        if (node == null) {
            return;
        }
        String oldNodeRaw = node.getRaw();
        node.removeOthers("2");
        node.setRaw(oldNodeRaw.equals("4") ? "1" : "2");
        this.setPriceTypeLimitedStg(node);
    }

    private void limitStgSell(MxNode node) {
        if (node == null) {
            return;
        }
        String oldNodeRaw = node.getRaw();
        node.removeOthers("2");
        node.addNode("4");
        node.setRaw(oldNodeRaw.equals("1") ? "4" : oldNodeRaw);
        this.setPriceTypeLimitedStg(node);
    }

    private void initPriceGear(MxNode node) {
        node.removeOthers("-10");
        node.addNode("-9");
        node.addNode("-8");
        node.addNode("-7");
        node.addNode("-6");
        node.addNode("-5");
        node.addNode("-4");
        node.addNode("-3");
        node.addNode("-2");
        node.addNode("-1");
        node.addNode("0");
        node.addNode("1");
        node.addNode("2");
        node.addNode("3");
        node.addNode("4");
        node.addNode("5");
        node.addNode("6");
        node.addNode("7");
        node.addNode("8");
        node.addNode("9");
        node.addNode("10");
    }

    private MxNode initMarketType(MxNode node) {
        node.addNode("0");
        node.removeOthers("0");
        node.setRaw("0");
        this.setPriceTypeMktStg(node);
        return node;
    }

    private MxNode shMarket(MxNode node) {
        node.addNode("0");
        node.removeOthers("0");
        node.addNode("SH1");
        node.addNode("SH2");
        if (this.isStar()) {
            node.addNode("SH3");
            node.addNode("SH4");
        }
        node.removeNode("0");
        node.setRaw("SH1");
        this.setPriceTypeMktStg(node);
        return node;
    }

    private MxNode szMarket(MxNode node) {
        node.addNode("0");
        node.removeOthers("0");
        node.addNode("SZ1");
        node.addNode("SZ2");
        node.addNode("SZ3");
        node.addNode("SZ4");
        node.addNode("SZ5");
        node.removeNode("0");
        node.setRaw("SZ1");
        this.setPriceTypeMktStg(node);
        return node;
    }

    public boolean isMktPrice() {
        if (this.getPriceStg() == null) {
            return false;
        }
        return this.getPriceStg().is("49");
    }

    public boolean isBidAskPrice() {
        if (this.getPriceStg() == null) {
            return false;
        }
        return this.getPriceStg().is("0");
    }

    public boolean isAfterHoursPrice() {
        if (this.getPriceStg() == null) {
            return false;
        }
        return this.getPriceStg().is("99");
    }

    public ObservableList<Boolean> submitApprove(Instruction instruction) throws MException {
        ObservableList returnList = FxUtils.newList();
        return returnList;
    }

    public void execute(Instruction instruction) throws MException {
    }

    public ObjectProperty<MxNode> priceTypeAfterHoursProperty() {
        return this.priceTypeAfterHours;
    }

    public MxNode getPriceTypeAfterHours() {
        return (MxNode)this.priceTypeAfterHoursProperty().get();
    }

    public void setPriceTypeAfterHours(MxNode priceTypeAfterHours) {
        this.priceTypeAfterHoursProperty().set((Object)priceTypeAfterHours);
    }

    public final ObjectProperty<MxNode> businessTypeProperty() {
        return this.businessType;
    }

    public final MxNode getBusinessType() {
        return (MxNode)this.businessTypeProperty().get();
    }

    public final void setBusinessType(MxNode businessType) {
        this.businessTypeProperty().set((Object)businessType);
    }

    public MarginAccountDistributionModel getAccDisModel() {
        return this.accTreeModel;
    }

    public final DoubleProperty priceProtectedProperty() {
        return this.priceProtected;
    }

    public final double getPriceProtected() {
        return this.priceProtectedProperty().get();
    }

    public final void setPriceProtected(double priceProtected) {
        this.priceProtectedProperty().set(priceProtected);
    }

    public String getTransferSecAccountId() {
        return this.transferSecAccountId;
    }

    public void setTransferSecAccountId(String transferSecAccountId) {
        this.transferSecAccountId = transferSecAccountId;
    }

    public final BooleanProperty selectChangeProperty() {
        return this.selectChange;
    }

    public final boolean isSelectChange() {
        return this.selectChangeProperty().get();
    }

    public final void setSelectChange(boolean selectChange) {
        this.selectChangeProperty().set(selectChange);
    }
}

