/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.margin.model;

import cms.tmx.api.trade.ITransferFundApi;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.entity.trade.Position;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.strategy.dto.ObPositionMargin;
import cms.tmx.http.statement.api.MarginPositionServiceApi;
import cms.tmx.javafx.MxListDirty;
import cms.tmx.javafx.MxModel;
import cms.tmx.query.current.models.CcsPositionModel;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class MarginNormalPositionModel
extends MxModel {
    @Inject
    protected ITransferFundApi transferApi;
    @Inject
    protected MScheduler sdFullQuery;
    @Inject
    protected MarginPositionServiceApi positionServiceApi;
    @Inject
    protected HttpBaseApi api;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    private CcsPositionModel model;
    private String investorId = "";
    private MxListDirty<ObPositionMargin> list = new MxListDirty();
    private static final Logger logger = LogManager.getLogger(MarginNormalPositionModel.class);
    private static final int FULL_QUERY_INTERVAL = 8000;
    protected InvalidationListener lstnModel = ob -> {
        ArrayList newList = new ArrayList();
        ObservableList observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll(this.model.getList());
        }
        ArrayList<ObPositionMargin> listOb = new ArrayList<ObPositionMargin>();
        for (Position po : newList) {
            ObPositionMargin o = new ObPositionMargin();
            o.setInvestorId(po.getInvestorId());
            o.setInverstorSecId(po.getInverstorSecId());
            o.getInstrument().setSecId(po.getSecId());
            o.getInstrument().setSymbol(po.getSecName());
            o.getInstrument().setSecType(po.getSecType());
            o.getInstrument().getMarket().setRaw(po.getMarket().getRaw());
            o.setSecAvail((double)((CcsPosition)CcsPosition.class.cast(po)).getCanVol());
            o.setSecTransfer(o.getSecAvail());
            listOb.add(o);
        }
        this.update(listOb);
    };

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(8000);
        this.model.changedProperty().addListener(this.lstnModel);
    }

    public void query(FundAccount fundAccount) {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery(fundAccount);
            }
            catch (MException | Exception e) {
                logger.error("margin ccs position query failed", e);
            }
        });
    }

    private void fullQuery(FundAccount fundAccount) throws MException {
        this.model.query();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getPositions(String investorId) {
        ArrayList newList = new ArrayList();
        ObservableList observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll(this.model.getList());
        }
        ArrayList<ObPositionMargin> listOb = new ArrayList<ObPositionMargin>();
        List collect = newList.stream().filter(item -> Objects.equals(investorId, item.getInvestorId())).collect(Collectors.toList());
        for (CcsPosition po : collect) {
            ObPositionMargin o = new ObPositionMargin();
            o.setInvestorId(po.getInvestorId());
            o.setInverstorSecId(po.getInverstorSecId());
            o.getInstrument().setSecId(po.getSecId());
            o.getInstrument().setSymbol(po.getSecName());
            o.getInstrument().getMarket().setRaw(po.getMarket().getRaw());
            o.getInstrument().setSecType(po.getSecType());
            o.setSecAvail((double)po.getCanVol());
            o.setSecTransfer(o.getSecAvail());
            listOb.add(o);
        }
        this.update(listOb);
    }

    private synchronized void update(List<ObPositionMargin> listQuery) {
        this.list.update(listQuery);
        this.changed();
    }

    public ObservableList<ObPositionMargin> getList() {
        return this.list.getList();
    }

    public String getInvestorId() {
        return this.investorId;
    }

    public void setInvestorId(String investorId) {
        this.investorId = investorId;
    }
}

