/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.margin.model;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.core.MException;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.trade.MarginAccountDistribution;
import cms.tmx.entity.trade.MarginSingleEntrust;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.strategy.api.AlgoOrderServiceApi;
import cms.tmx.http.api.strategy.dto.BaseAlgoOrderReq;
import cms.tmx.http.api.strategy.dto.Basket;
import cms.tmx.http.api.strategy.dto.Detail;
import cms.tmx.http.api.strategy.dto.MarginAlgoParams;
import cms.tmx.http.api.strategy.dto.StockMargin;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.margin.factory.MarginSingleEntrustFactory;
import cms.tmx.margin.model.MarginTradeModel;
import cms.tmx.utils.StringUtils;
import java.io.IOException;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class MarginAlgoModel
extends MxModel {
    public MarginTradeModel baseModel;
    @Inject
    private AlgoOrderServiceApi algoApi;
    @Inject
    protected IBaseApi baseApi;
    @Inject
    protected HttpBaseApi apiBase;
    private String code;
    private String market;
    private String type;
    private int qty;
    private String name;
    private double price;
    private String buyStg;
    private String sellStg;
    private double marketPer;
    private double maxPriceDiff;
    private double priceSlip;
    private int rollInterval;
    private String startTime;
    private String respMsg;
    @Inject
    protected MarginSingleEntrustFactory ef;
    private static final Logger logger = LogManager.getLogger(MarginAlgoModel.class);

    public List<MarginSingleEntrust> getEntrustList(boolean isOrder) {
        LinkedList<MarginSingleEntrust> enList = new LinkedList<MarginSingleEntrust>();
        for (TreeItem acc : this.baseModel.getAccDisModel().getRoot().getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected())) {
            for (TreeItem secAcc : acc.getChildren().filtered(ad -> ((MarginAccountDistribution)ad.getValue()).isSelected())) {
                MarginSingleEntrust en = this.baseModel.createEntrust(((MarginAccountDistribution)acc.getValue()).getAcc().getNewCashAccntId(), ((MarginAccountDistribution)secAcc.getValue()).getSecAcc().getExtSecAccntId());
                en.setFundAccount((FundAccount)((MarginAccountDistribution)acc.getValue()).getAcc());
                en.setSecAccount(((MarginAccountDistribution)secAcc.getValue()).getSecAcc());
                en.setInvestorId(((MarginAccountDistribution)acc.getValue()).getAcc().getInvestId());
                en.setInvestorSecId(((MarginAccountDistribution)secAcc.getValue()).getSecAcc().getInverstorSecId());
                en.setQuantity(((MarginAccountDistribution)secAcc.getValue()).getCount());
                en.setCanSell(((MarginAccountDistribution)secAcc.getValue()).getCanSell());
                en.setCanReturnCount(((MarginAccountDistribution)secAcc.getValue()).getCanReturnCount());
                en.setMarket(this.getMarket());
                en.setSecType(this.getType());
                en.setPrice(this.getPrice());
                en.setSec(this.getCode());
                en.setSecName(this.getName());
                en.setPrice(this.getMaxPriceDiff());
                enList.add(en);
            }
        }
        return enList;
    }

    public ObservableList<Boolean> submitMise() {
        ObservableList returnList = FxUtils.newList();
        for (MarginSingleEntrust en : this.getEntrustList(true)) {
            String investorId = en.getInvestorId();
            String secId = en.getInvestorSecId();
            String cashAccnt = en.getAcc();
            String secAccnt = en.getSecAcc();
            String platformId = en.getFundAccount().getCounterId();
            String accountId = en.getFundAccount().getParentId();
            String secType = en.getSecType();
            BaseAlgoOrderReq req = new BaseAlgoOrderReq();
            req.setAlgoName("MARSTAG");
            req.setEngineName("b");
            req.setReqId("");
            req.setOpUser(this.apiBase.getHttpOpUser());
            Detail detail = new Detail();
            detail.setUserId(this.baseApi.getUserId());
            detail.setAccount(accountId);
            detail.setUserData(this.baseApi.getUserId());
            detail.setCashAccnt(cashAccnt);
            detail.setSecAccnt(secAccnt);
            detail.setTradePlatformId(platformId);
            MarginAlgoParams algoParams = new MarginAlgoParams();
            algoParams.setMaxCost(this.getMaxPriceDiff());
            algoParams.setMktRatio(this.getMarketPer());
            algoParams.setRollInterval(this.getRollInterval());
            algoParams.setSlippage(this.getPriceSlip());
            algoParams.setStartTime(this.getStartTime());
            detail.setAlgoParams(algoParams);
            String branchNo = "";
            String reserved1 = "MARSTAG#" + this.code + "#" + this.name;
            String appID = "750";
            String reserved2 = String.valueOf(this.type) + "#" + appID + "#" + investorId + "#" + cashAccnt + "#" + secAccnt;
            LinkedList<Basket> basketList = new LinkedList<Basket>();
            Basket buyBask = new Basket();
            buyBask.setMarket(this.getMarket());
            buyBask.setSecurity(this.getCode());
            buyBask.setSecAccntId(secId);
            buyBask.setQty((int)en.getQuantity());
            buyBask.setSide("01");
            buyBask.setTradeType(this.getBuyStg());
            buyBask.setReserved1(reserved1);
            buyBask.setReserved2(reserved2);
            buyBask.setSymbol(this.getName());
            buyBask.setSecType(secType);
            basketList.add(buyBask);
            Basket sellBask = new Basket();
            sellBask.setMarket(this.market);
            sellBask.setSecurity(this.code.toString());
            sellBask.setSecAccntId(secId);
            sellBask.setQty((int)en.getQuantity());
            sellBask.setSide("02");
            sellBask.setTradeType(this.getSellStg());
            sellBask.setReserved1(reserved1);
            sellBask.setReserved2(reserved2);
            sellBask.setSymbol(this.getName());
            sellBask.setSecType(secType);
            basketList.add(sellBask);
            StockMargin stockMargin = new StockMargin();
            stockMargin.setGatewayId("1");
            stockMargin.setBizAcct(investorId);
            stockMargin.setBranchNo(branchNo);
            stockMargin.setBasket(basketList);
            detail.setStockMargin(stockMargin);
            req.setDetail(detail);
            try {
                this.respMsg = "";
                this.algoApi.algoNew(req, accountId);
                returnList.add((Object)true);
            }
            catch (MException | IOException e) {
                logger.error("\u4e24\u878d\u7b97\u6cd5\u4e0b\u5355\u5931\u8d25\uff1a" + e.getMessage());
                this.respMsg = e.getMessage();
                returnList.add((Object)false);
            }
        }
        return returnList;
    }

    public void timeLimit(TextField startHour, TextField startMinute) {
        Calendar calender = Calendar.getInstance();
        startHour.setText(MarginAlgoModel.complement(calender.get(11)));
        startMinute.setText(MarginAlgoModel.complement(calender.get(12)));
    }

    public static String complement(Object obj) {
        String str = obj.toString();
        if (StringUtils.patternCheck((String)"[0-9]?", (String)str)) {
            str = "0" + str;
        }
        return str;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getMarket() {
        return this.market;
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public String getBuyStg() {
        return this.buyStg;
    }

    public void setBuyStg(String buyStg) {
        this.buyStg = buyStg;
    }

    public String getSellStg() {
        return this.sellStg;
    }

    public void setSellStg(String sellStg) {
        this.sellStg = sellStg;
    }

    public double getMarketPer() {
        return this.marketPer;
    }

    public void setMarketPer(double marketPer) {
        this.marketPer = marketPer;
    }

    public double getPriceSlip() {
        return this.priceSlip;
    }

    public void setPriceSlip(double priceSlip) {
        this.priceSlip = priceSlip;
    }

    public int getRollInterval() {
        return this.rollInterval;
    }

    public void setRollInterval(int rollInterval) {
        this.rollInterval = rollInterval;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public double getMaxPriceDiff() {
        return this.maxPriceDiff;
    }

    public void setMaxPriceDiff(double maxPriceDiff) {
        this.maxPriceDiff = maxPriceDiff;
    }

    public int getQty() {
        return this.qty;
    }

    public void setQty(int qty) {
        this.qty = qty;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getRespMsg() {
        return this.respMsg;
    }

    public void setRespMsg(String respMsg) {
        this.respMsg = respMsg;
    }
}

