/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.condition.views;

import cms.tmx.condition.model.ConditionQueryModel;
import cms.tmx.condition.model.ConditionTradeModel;
import cms.tmx.condition.model.TimeControls;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.Search;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.table.EditTreeTableCell;
import cms.tmx.control.table.NumberTreeTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.DatePickerUtils;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.entity.trade.instruction.RespResult;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.trade.utils.TradeAcctCountFilter;
import cms.tmx.trade.utils.TradeBindings;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.inject.Inject;

public class ConditionTradePart
extends MxPart {
    @FXML
    private ComboBox<MxNode> cmbType;
    @FXML
    protected DatePicker dpValid;
    @FXML
    private ComboBox<MxNode> cmbTriggerCond;
    @FXML
    private ComboBox<MxNode> cmbJudge;
    @FXML
    private Spinner<Double> spnCondPrice;
    @FXML
    private Spinner<Double> spnCondPct;
    @FXML
    private HBox hboxCondPrice;
    @FXML
    private HBox hboxCondTime;
    @FXML
    private HBox hboxPrice;
    @FXML
    private HBox hboxFloat;
    @FXML
    private TextField txtHour;
    @FXML
    private TextField txtMinute;
    @FXML
    private TextField txtSecond;
    @FXML
    private TextField txtCode;
    @FXML
    private Label lbName;
    @FXML
    private Label lbNowPrc;
    @FXML
    private Label lbNowPrice;
    @FXML
    private ComboBox<MxNode> cmbSide;
    @FXML
    private ComboBox<MxNode> cmbPrice;
    @FXML
    private Spinner<Double> spnPriceFloat;
    @FXML
    private Spinner<Double> spnPrice;
    @FXML
    private Spinner<Integer> spnCount;
    @FXML
    protected ComboBox<MxNode> cmbDist;
    @FXML
    protected ComboBox<MxNode> cmbAccFilter;
    @FXML
    private HBox hBoxPartlyAccCount;
    @FXML
    private Label lbSecAccCount;
    @FXML
    private TextField textAccCount;
    @FXML
    protected TextField txtSearch;
    @FXML
    protected TreeTableView<CcsAccountDistribution> acctTreeTable;
    @FXML
    private TreeTableColumn<CcsAccountDistribution, Boolean> checkBoxCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, CcsFundAccount> accountCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, SecAccount> secAcctCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> availableCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> assetCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> weightCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> amountCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> canBuyCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, Number> canSellCol;
    @FXML
    protected TreeTableColumn<CcsAccountDistribution, String> productCol;
    @Inject
    protected MObjFactory of;
    @Inject
    protected IRefDataMng refMng;
    @Inject
    private ConditionTradeModel model;
    @Inject
    private ConditionQueryModel queryModel;
    @Inject
    private TimeControls timeControls;
    @Inject
    protected MxAlert alert;
    protected SecSuggest spCode = new SecSuggest();
    private SecConverter secCvt;
    protected DoubleSpinnerCtrl ctrlPrice = new DoubleSpinnerCtrl(true, 3, 3);
    protected DoubleSpinnerCtrl ctrlCondPrice = new DoubleSpinnerCtrl(false, 3, 3);
    protected DoubleSpinnerCtrl ctrlPct = new DoubleSpinnerCtrl(false, 2, 2);
    protected IntSpinnerCtrl ctrlCount = new IntSpinnerCtrl(true, 9, 100);
    private static final PseudoClass pcMxSelected = PseudoClass.getPseudoClass((String)"mselected");
    private static final PseudoClass LEAF = PseudoClass.getPseudoClass((String)"treeLeaf");
    private static final PseudoClass NOT_LEAF = PseudoClass.getPseudoClass((String)"treeNotLeaf");
    private static final String INVALID_CODE = "\u65e0\u6548\u4ee3\u7801";
    protected MarketItem mktItem;
    private InvalidationListener lstnRefMng = ob -> {
        Collection<RefItem> list = this.getRefItems();
        this.spCode.setAllSuggestions(list);
    };
    private static int amB = 34200;
    private static int amE = 41399;
    private static int pmB = 46800;
    private static int pmE = 53999;
    private static int pmERepo = 55799;
    private Callback<TreeTableColumn<CcsAccountDistribution, Boolean>, TreeTableCell<CcsAccountDistribution, Boolean>> checkBoxFactory = p -> new TreeTableCell<CcsAccountDistribution, Boolean>(){

        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setText(null);
                this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, false);
                this.getTreeTableRow().pseudoClassStateChanged(LEAF, false);
                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, false);
            } else {
                this.setText(null);
                if (this.getTreeTableRow().getItem() != null) {
                    CheckBox checkBox = new CheckBox();
                    checkBox.selectedProperty().bindBidirectional((Property)((CcsAccountDistribution)this.getTreeTableRow().getItem()).selectedProperty());
                    TreeItem treeItem = this.getTreeTableRow().getTreeItem();
                    if (treeItem == null) {
                        return;
                    }
                    treeItem.getChildren().addListener(ConditionTradePart.this.lst);
                    if (treeItem.isLeaf()) {
                        checkBox.selectedProperty().addListener((ob, old, newV) -> {
                            if (newV.booleanValue() && treeItem.getParent() != null && treeItem.getParent().getValue() != null) {
                                ((CcsAccountDistribution)treeItem.getParent().getValue()).setSelected(newV.booleanValue());
                                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, newV != false && treeItem.getParent().isExpanded());
                            } else {
                                this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, false);
                            }
                        });
                        checkBox.setOnMouseClicked(event -> ConditionTradePart.this.doCheckChildrenSelected((TreeItem<CcsAccountDistribution>)treeItem));
                        ConditionTradePart.this.doCheckChildrenSelected((TreeItem<CcsAccountDistribution>)treeItem);
                        this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, ((CcsAccountDistribution)treeItem.getValue()).isSelected() && treeItem.getParent().isExpanded());
                        this.getTreeTableRow().pseudoClassStateChanged(LEAF, true);
                        this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, false);
                    } else {
                        checkBox.selectedProperty().addListener((ob, old, newV) -> {
                            this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, newV.booleanValue());
                            if (newV.booleanValue()) {
                                ConditionTradePart.this.acctTreeTable.refresh();
                            }
                        });
                        treeItem.expandedProperty().addListener((ob, old, newV) -> ConditionTradePart.this.acctTreeTable.refresh());
                        checkBox.setOnMouseClicked(event -> treeItem.getChildren().forEach(each -> ((CcsAccountDistribution)each.getValue()).setSelected(((CcsAccountDistribution)treeItem.getValue()).isSelected())));
                        this.getTreeTableRow().pseudoClassStateChanged(pcMxSelected, ((CcsAccountDistribution)treeItem.getValue()).isSelected());
                        this.getTreeTableRow().pseudoClassStateChanged(NOT_LEAF, true);
                        this.getTreeTableRow().pseudoClassStateChanged(LEAF, false);
                    }
                    this.setGraphic((Node)checkBox);
                }
            }
        }
    };
    private ListChangeListener<TreeItem<CcsAccountDistribution>> lst = ob -> {
        if (ob.getList().size() != 0) {
            this.doCheckChildrenSelected((TreeItem<CcsAccountDistribution>)((TreeItem)ob.getList().get(0)));
        }
    };

    @FXML
    private void initialize() {
        this.mktItem = this.model.getMI();
        this.mktItem.refItemProperty().addListener(ob -> Platform.runLater(() -> this.onRefChange()));
        this.refMng.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnRefMng));
        this.initControls();
        this.createTreeTable();
    }

    private void onRefChange() {
        TradeBindings.priceBinding((Property)this.lbNowPrice.textProperty(), (ObservableNumberValue)this.mktItem.nowPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().priceUnitProperty());
    }

    private void initControls() {
        this.spCode.setAllSuggestions(this.getRefItems());
        this.secCvt = (SecConverter)this.of.create(SecConverter.class);
        Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.spCode, (StringConverter)this.secCvt).changedProperty().addListener((ob, oldV, newV) -> Platform.runLater(() -> {
            this.onSecurityChange(this.txtCode, (String)newV);
            this.acctTreeTable.refresh();
            this.layout();
        }));
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        this.txtCode.focusedProperty().addListener((ob, old, newV) -> this.loseFocus((Boolean)newV));
        this.txtCode.textProperty().bindBidirectional((Property)this.model.securityProperty());
        this.lbName.textProperty().bindBidirectional((Property)this.model.nameProperty());
        Tooltip tooltip = new Tooltip();
        tooltip.textProperty().bind((ObservableValue)this.lbName.textProperty());
        this.lbName.setTooltip(tooltip);
        this.lbNowPrc.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.mktItem.getNowPrice() != 0.0 && !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        this.lbNowPrice.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.mktItem.getNowPrice() != 0.0 && !this.mktItem.isClear(), (Observable[])new Observable[]{this.mktItem.changedProperty()}));
        this.cmbType.setItems(this.model.getCondType().getNodes());
        this.cmbType.valueProperty().bindBidirectional(this.model.condTypeProperty());
        this.cmbType.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.typeChanged((MxNode)now));
        String FORMAT = "yyyy-MM-dd";
        DatePickerUtils.setFormat((DatePicker)this.dpValid, (String)FORMAT);
        LocalDate ldNow = LocalDate.now();
        DatePickerUtils.setDaysLaterTrading((DatePicker)this.dpValid, (String)ldNow.toString());
        this.dpValid.getEditor().setDisable(true);
        this.dpValid.setValue((Object)ldNow);
        MxNode node = MxNodeFactory.create((String)"trigger_condition", (String)"1");
        this.cmbTriggerCond.setItems(node.getNodes());
        this.cmbTriggerCond.setValue((Object)node);
        this.cmbTriggerCond.setDisable(true);
        this.cmbJudge.setItems(this.model.getCondJudge().getNodes());
        this.cmbJudge.setValue((Object)this.model.getCondJudge());
        this.cmbJudge.valueProperty().bindBidirectional(this.model.condJudgeProperty());
        this.ctrlCondPrice.ctrl(this.spnCondPrice);
        this.spnCondPrice.getEditor().setOnMouseClicked(event -> TextFieldUtils.selectTwoOrNoPriceDecimal((int)3, (TextField)this.spnCondPrice.getEditor()));
        this.spnCondPrice.getEditor().setText("");
        MxBindings.bindSD((Property)this.spnCondPrice.getEditor().textProperty(), (Property)this.model.condPriceProperty());
        this.ctrlPct.ctrl(this.spnCondPct);
        this.spnCondPct.getEditor().setOnMouseClicked(event -> TextFieldUtils.selectTwoOrNoPriceDecimal((int)3, (TextField)this.spnCondPrice.getEditor()));
        this.spnCondPct.getEditor().setText("3");
        this.ctrlPct.ctrl(this.spnPriceFloat);
        this.spnPriceFloat.getEditor().setOnMouseClicked(event -> TextFieldUtils.selectTwoOrNoPriceDecimal((int)3, (TextField)this.spnPriceFloat.getEditor()));
        this.spnPriceFloat.getEditor().setText("");
        this.spnPriceFloat.getEditor().textProperty().addListener((ob, old, now) -> this.model.setFloatRatio(Double.parseDouble(now)));
        node = MxNodeFactory.create((String)"condition_side", (String)"49");
        this.cmbSide.setItems(node.getNodes());
        this.cmbSide.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.onBSChange((MxNode)now));
        this.cmbSide.setValue((Object)node);
        this.txtHour.setTextFormatter((TextFormatter)new MxFormatter("^((|[0-9]{0,1})|([0-1][0-9])|(2[0-3]))$", 2));
        this.txtMinute.setTextFormatter((TextFormatter)new MxFormatter("^(([0-9]{0,1})|([0-5][0-9]))$", 2));
        this.txtSecond.setTextFormatter((TextFormatter)new MxFormatter("^(([0-9]{0,1})|([0-5][0-9]))$", 2));
        this.txtHour.focusedProperty().addListener(ob -> this.sliceCheck(this.txtHour));
        this.txtMinute.focusedProperty().addListener(ob -> this.sliceCheck(this.txtMinute));
        this.txtSecond.focusedProperty().addListener(ob -> this.sliceCheck(this.txtSecond));
        this.txtHour.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtHour.selectAll());
        this.txtMinute.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtMinute.selectAll());
        this.txtSecond.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtSecond.selectAll());
        this.cmbPrice.setItems(this.model.getPriceStg().getNodes());
        this.cmbPrice.setValue((Object)this.model.getPriceStg());
        this.cmbPrice.valueProperty().bindBidirectional(this.model.priceStgProperty());
        this.cmbPrice.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.priceChanged((MxNode)now));
        this.ctrlPrice.ctrl(this.spnPrice);
        MxBindings.bindSD((Property)this.spnPrice.getEditor().textProperty(), (Property)this.model.priceProperty());
        this.ctrlCount.ctrl(this.spnCount);
        MxBindings.bindSI((Property)this.spnCount.getEditor().textProperty(), (Property)this.model.countProperty());
        this.spnCount.getEditor().setOnMouseClicked(event -> TextFieldUtils.selectTwoOrNoPriceDecimal((int)3, (TextField)this.spnCount.getEditor()));
        this.spnCount.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.quantityKeyPress((KeyEvent)event));
        SpinnerUtils.arrowsStyle(this.spnCondPrice);
        SpinnerUtils.arrowsStyle(this.spnPriceFloat);
        SpinnerUtils.arrowsStyle(this.spnPrice);
        SpinnerUtils.arrowsStyle(this.spnCount);
    }

    protected void sliceCheck(TextField tf) {
        if (tf.isFocused()) {
            tf.selectAll();
            return;
        }
        String slice = tf.getText();
        if (slice.isEmpty()) {
            tf.setText("00");
        } else if (StringUtils.patternCheck((String)"[0-9]", (String)slice)) {
            tf.insertText(0, "0");
        }
    }

    private void createTreeTable() {
        this.cmbDist.setItems(this.model.getDistStg().getNodes());
        this.cmbDist.valueProperty().bindBidirectional(this.model.distStgProperty());
        this.cmbAccFilter.setItems(this.model.getAccFilterStg().getNodes());
        this.cmbAccFilter.valueProperty().bindBidirectional(this.model.accFilterStgProperty());
        this.hBoxPartlyAccCount.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.model.getAccFilterStg().getRaw().equals("1"), (Observable[])new Observable[]{this.model.accFilterStgProperty()}));
        MxBindings.bindSI((Property)this.lbSecAccCount.textProperty(), (Property)this.model.getAccDisModel().effectiveSecAccCountProperty());
        MxBindings.bindSI((Property)this.textAccCount.textProperty(), (Property)this.model.getAccDisModel().customSecAccCountProperty());
        this.textAccCount.setTextFormatter(new TextFormatter((UnaryOperator)new TradeAcctCountFilter(true, 9, this.model.getAccDisModel().effectiveSecAccCountProperty())));
        this.txtSearch.textProperty().bindBidirectional((Property)this.model.getAccDisModel().searchSecProperty());
        this.txtSearch.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9]+", 16));
        this.accountCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).accProperty());
        this.accountCol.setCellFactory(p -> new AccountCollapseCell());
        this.secAcctCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).secAccProperty());
        this.availableCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleDoubleProperty(0.0) : ((CcsAccountDistribution)data.getValue().getValue()).getAcc().availableProperty());
        this.availableCol.setCellFactory(p -> new MoneyCell(2));
        this.canBuyCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).canBuyProperty());
        this.canSellCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).canSellProperty());
        this.canSellCol.setCellFactory(p -> new NumberTreeTableCell());
        this.canBuyCol.setEditable(false);
        this.canSellCol.setEditable(false);
        this.assetCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleDoubleProperty(0.0) : ((CcsAccountDistribution)data.getValue().getValue()).getAcc().assetAmtProperty());
        this.assetCol.setCellFactory(p -> new MoneyCell(2));
        this.model.getAccDisModel().repoProperty().addListener((ob, old, newV) -> {
            this.canBuyCol.setVisible(newV == false);
            this.canSellCol.setVisible(newV == false);
        });
        this.weightCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).weightProperty());
        this.weightCol.setCellFactory(p -> new WeightCell(0));
        this.amountCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).countProperty());
        this.amountCol.setCellFactory(p -> new NumberTreeTableCell());
        this.productCol.setCellValueFactory(data -> ((CcsAccountDistribution)data.getValue().getValue()).getAcc() == null ? new SimpleStringProperty("") : ((CcsAccountDistribution)data.getValue().getValue()).getAcc().productNameProperty());
        this.checkBoxCol.setCellFactory(this.checkBoxFactory);
        this.acctTreeTable.setRoot(this.model.getAccDisModel().getRoot());
        this.acctTreeTable.setShowRoot(false);
        this.acctTreeTable.sort();
        this.acctTreeTable.refresh();
        this.acctTreeTable.setPlaceholder((Node)new Label());
        this.acctTreeTable.setEditable(true);
        this.availableCol.setEditable(false);
        this.assetCol.setEditable(false);
        ContextMenu menu = new ContextMenu();
        MenuItem itemCopy = new MenuItem("\u590d\u5236");
        MenuItem itemRefresh = new MenuItem("\u5237\u65b0");
        menu.getItems().add((Object)itemCopy);
        menu.getItems().add((Object)itemRefresh);
        this.acctTreeTable.setContextMenu(menu);
        itemRefresh.setOnAction(event -> this.model.getAccDisModel().refresh());
        itemCopy.setOnAction(event -> this.copy());
        this.acctTreeSupplement();
    }

    protected void acctTreeSupplement() {
        this.model.countStgProperty().addListener(ob -> {
            String stg = this.model.getCountStg().getRaw();
            if (stg.equals("1") || stg.equals("5")) {
                this.cmbDist.setDisable(false);
            } else {
                this.cmbDist.setDisable(true);
            }
        });
        this.canBuyCol.setCellFactory(p -> new MoneyCell(0));
        TableUtils.orgnizeClmWidth(this.acctTreeTable);
    }

    protected void onBSChange(MxNode node) {
        boolean isBuy = node.getRaw().equals("49");
        this.model.setBuy(isBuy);
    }

    protected void onSecurityChange(TextField txtCode, String newText) {
        this.txtCode.setText(txtCode.getText());
        RefItem refItem = null;
        Object obj = txtCode.getUserData();
        if (obj instanceof RefItem) {
            refItem = (RefItem)RefItem.class.cast(obj);
        }
        long beginChange = System.currentTimeMillis();
        this.doChange(refItem, newText);
        this.logger.info("dochange:" + (System.currentTimeMillis() - beginChange));
    }

    protected void doChange(RefItem refItem, String newText) {
        this.model.getMI().setRefItem(refItem);
        this.spnCount.getEditor().clear();
        if (this.model.isValidRef()) {
            this.ctrlPrice.setScale(refItem.getScale());
            this.ctrlCondPrice.setScale(refItem.getScale());
        }
        this.model.onSecChange();
        this.txtCode.selectEnd();
        this.txtCode.deselect();
        if (newText.length() >= 6) {
            this.check();
        }
        this.layout();
    }

    private void check() {
        Timer timer = new Timer();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (ConditionTradePart.this.txtCode.getText().length() < 6) {
                    return;
                }
                RefItem ref = ConditionTradePart.this.mktItem.getRefItem();
                Platform.runLater(() -> {
                    if (ref == null || ref.getName().equals("") || ConditionTradePart.this.model.getValidRef() == null) {
                        ConditionTradePart.this.lbName.setText(ConditionTradePart.INVALID_CODE);
                    } else if (ConditionTradePart.this.mktItem.getStop().getValue().booleanValue()) {
                        ConditionTradePart.this.lbName.setText(ConditionTradePart.this.mktItem.getStatus());
                    } else {
                        ConditionTradePart.this.lbName.setText(ref.getName());
                    }
                });
            }
        };
        timer.schedule(task, 500L);
    }

    @FXML
    private void reset() {
        this.txtCode.requestFocus();
        this.lbName.setText("");
        this.txtCode.clear();
        this.dpValid.setValue((Object)LocalDate.now());
        this.cmbTriggerCond.getSelectionModel().select(0);
        this.cmbJudge.getSelectionModel().select(0);
        this.spnCondPrice.getEditor().setText("0");
        this.spnCondPct.getEditor().setText("0");
        this.txtHour.clear();
        this.txtMinute.clear();
        this.txtSecond.clear();
        this.cmbSide.getSelectionModel().select(0);
        this.cmbPrice.getSelectionModel().select((Object)((MxNode)this.cmbPrice.getValue()).getNode("0"));
        this.spnPriceFloat.getEditor().clear();
        this.spnPrice.getEditor().clear();
        this.spnCount.getEditor().clear();
    }

    @FXML
    private void help() {
        String tip = "\u6761\u4ef6\u5355\u76ee\u524d\u6682\u4e0d\u652f\u6301\u79d1\u521b\u677f\u7b49\u54c1\u79cd\u7684\u76d8\u540e\u56fa\u5b9a\u4ef7\u4ea4\u6613\uff0c\u4ee5\u53ca\u9006\u56de\u8d2d\u4ea4\u6613";
        this.alert.alert(Alert.AlertType.INFORMATION, tip);
    }

    @FXML
    public void order() {
        if (!this.valid()) {
            return;
        }
        if (!this.alert.alert(Alert.AlertType.CONFIRMATION, "\u662f\u5426\u786e\u8ba4\u4e0b\u5355\uff1f")) {
            return;
        }
        try {
            this.model.setCondDate(((LocalDate)this.dpValid.getValue()).toString());
            this.model.setCondTime(this.getTime());
            RespResult result = this.model.submit();
            Alert.AlertType aType = result.hasFailed() ? Alert.AlertType.ERROR : Alert.AlertType.INFORMATION;
            this.alert.alert(aType, result.getDesc("\u63d0\u4ea4"));
            this.queryModel.query();
        }
        catch (MException e) {
            this.logger.error((Object)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
        this.layout();
    }

    private String getTime() {
        String hour = this.txtHour.getText();
        String minue = this.txtMinute.getText();
        String second = this.txtSecond.getText();
        StringBuffer time = new StringBuffer("");
        time.append(hour).append(":");
        time.append(minue).append(":");
        time.append(second);
        return time.toString();
    }

    public boolean valid() {
        boolean condValid;
        String tip1 = "\u8bf7\u8f93\u5165\u6709\u6548\u4ee3\u7801";
        if (!this.alert.check(this.model.isValidRef(), Alert.AlertType.WARNING, tip1)) {
            return false;
        }
        String tip3 = "\u6761\u4ef6\u5355\u6682\u65f6\u4e0d\u652f\u6301\u9006\u56de\u8d2d\u4ea4\u6613";
        boolean isRepo = this.model.getValidRef().getType().equals("REPO");
        if (!this.alert.check(!isRepo, Alert.AlertType.WARNING, tip3)) {
            return false;
        }
        String tip2 = "\u672a\u8f93\u5165\u89e6\u53d1\u6761\u4ef6\u4ef7\u683c";
        boolean isTimeCond = this.model.getCondType().getRaw().equals("1");
        boolean bl = condValid = this.model.getCondPrice() != 0.0;
        if (isTimeCond) {
            condValid = true;
        }
        if (!this.alert.check(condValid, Alert.AlertType.WARNING, tip2)) {
            return false;
        }
        String tip5 = "\u4ea4\u6613\u6570\u91cf\u4e0d\u5408\u6cd5";
        if (!this.alert.check(this.model.getCount() > 0L && this.model.getAccDisModel().isCountValid() != false, Alert.AlertType.WARNING, tip5)) {
            return false;
        }
        String tip4 = "\u672a\u9009\u62e9\u8bc1\u5238\u8d26\u53f7";
        return this.alert.check(this.model.getAccDisModel().getSelectedNum() >= 1, Alert.AlertType.WARNING, tip4);
    }

    private String checkTime() {
        int start = this.getTime(this.txtHour) * 60 * 60 + this.getTime(this.txtMinute) * 60 + this.getTime(this.txtSecond);
        boolean isRepo = this.mktItem.getRefItem().getType().equals("REPO");
        String check = "";
        if (this.timeControls.limitTime() && !ConditionTradePart.timeIsValid(start, isRepo)) {
            check = isRepo ? "\u89e6\u53d1\u6761\u4ef6\u8303\u56f4  09:30-11:29 13:00-15:29" : "\u89e6\u53d1\u6761\u4ef6\u8303\u56f4  09:30-11:29 13:00-14:59";
        }
        return check;
    }

    protected int getTime(TextField txt) {
        if (txt.getText().isEmpty()) {
            txt.setText("00");
        } else if (StringUtils.patternCheck((String)"[0-9]?", (String)txt.getText())) {
            txt.insertText(0, "0");
        }
        return StringUtils.parseInt((String)txt.getText());
    }

    public static boolean timeIsValid(int time, boolean isRepo) {
        if (time >= amB && time <= amE) {
            return true;
        }
        return time >= pmB && time <= (isRepo ? pmERepo : pmE);
    }

    protected void quantityKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.txtCode.requestFocus();
            this.txtCode.selectAll();
            key.consume();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.order();
            key.consume();
        }
    }

    private void doCheckChildrenSelected(TreeItem<CcsAccountDistribution> treeItem) {
        TreeItem prtItem = treeItem.getParent();
        Boolean isSelected = false;
        if (prtItem != null && prtItem.getValue() != null) {
            for (TreeItem eachItem : prtItem.getChildren()) {
                if (!((CcsAccountDistribution)eachItem.getValue()).isSelected()) continue;
                isSelected = true;
                break;
            }
            ((CcsAccountDistribution)prtItem.getValue()).setSelected(isSelected.booleanValue());
        }
    }

    protected void copy() {
        StringBuilder clipboardString = new StringBuilder();
        clipboardString.append(String.valueOf(this.accountCol.getText()) + "\t" + this.secAcctCol.getText() + "\t" + this.availableCol.getText() + "\t" + this.assetCol.getText() + "\t" + this.weightCol.getText() + "\t" + this.amountCol.getText() + "\t" + this.canBuyCol.getText() + "\t" + this.canSellCol.getText() + "\t" + this.productCol.getText() + "\t" + '\n');
        for (TreeItem item : this.model.getAccDisModel().getRoot().getChildren()) {
            CcsAccountDistribution accDis = (CcsAccountDistribution)item.getValue();
            clipboardString.append(accDis.getAcc() + "\t" + "\t" + accDis.getAcc().getAvailable() + "\t" + accDis.getAcc().getAssetAmt() + "\t" + accDis.getWeight() + "\t" + accDis.getCount() + "\t" + accDis.getCanBuy() + "\t" + accDis.getCanSell() + "\t" + accDis.getAcc().getProductName() + "\t" + '\n');
            for (TreeItem subItem : item.getChildren()) {
                CcsAccountDistribution secAccDis = (CcsAccountDistribution)subItem.getValue();
                clipboardString.append("\t" + secAccDis.getSecAcc() + "\t" + "\t" + "\t" + secAccDis.getWeight() + "\t" + secAccDis.getCount() + "\t" + "\t" + secAccDis.getCanSell() + "\t" + "\t" + '\n');
            }
        }
        ClipboardContent content = new ClipboardContent();
        content.putString(clipboardString.toString());
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    public void typeChanged(MxNode type) {
        boolean isPriceType = "2".equals(type.getRaw());
        this.hboxCondPrice.setVisible(isPriceType);
        this.hboxCondTime.setVisible(!isPriceType);
    }

    public void priceChanged(MxNode price) {
        if (price == null) {
            return;
        }
        boolean isSpecified = "11".equals(price.getRaw());
        this.hboxPrice.setVisible(isSpecified);
        this.hboxFloat.setVisible(!isSpecified);
    }

    protected Collection<RefItem> getRefItems() {
        return this.refMng.getItems(new String[]{"STOCK", "BOND", "FUND", "REPO"});
    }

    private void loseFocus(Boolean val) {
        if (!val.booleanValue() && this.txtCode.getText().length() > 0) {
            this.check();
        } else if (val.booleanValue()) {
            Platform.runLater(() -> this.txtCode.selectAll());
        }
    }

    private class AccountCollapseCell<S>
    extends TreeTableCell<S, CcsFundAccount> {
        AccountCollapseCell() {
        }

        public void updateItem(CcsFundAccount item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                this.setOnMouseClicked(event -> {
                    TreeItem treeItem = this.getTreeTableView().getTreeItem(this.getIndex());
                    if (treeItem != null) {
                        if (treeItem.isExpanded()) {
                            treeItem.setExpanded(false);
                        } else {
                            treeItem.setExpanded(true);
                        }
                    }
                });
                this.setText(item == null ? null : String.valueOf(item));
            } else {
                this.setText(null);
            }
        }
    }

    private class MoneyCell
    extends EditTreeTableCell<CcsAccountDistribution> {
        MoneyCell(int i) {
            super(i);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            CcsAccountDistribution accItem = (CcsAccountDistribution)this.getTreeTableRow().getItem();
            if (!empty && accItem != null && accItem.isIsSecAcc()) {
                this.setText("");
            }
        }
    }

    private class WeightCell
    extends EditTreeTableCell<CcsAccountDistribution> {
        WeightCell(int i) {
            super(i);
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && this.getTreeTableRow().getItem() != null) {
                this.editableProperty().bind((ObservableValue)((CcsAccountDistribution)this.getTreeTableRow().getItem()).isSecAccProperty());
            }
        }
    }
}

