/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.condition.views;

import cms.tmx.condition.model.ConditionQueryModel;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.Condition;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.rights.IUiRightService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.CheckBoxTableCell;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConditionQueryPart
extends MxPart {
    private static final Logger logger = LogManager.getLogger(ConditionQueryPart.class);
    @FXML
    private TableView<Condition> tableCond;
    @FXML
    private TableColumn<Condition, Boolean> selected;
    @FXML
    private TableColumn<Condition, MxNode> side;
    @FXML
    private TableColumn<Condition, String> condOrdId;
    @FXML
    protected CheckBox cboxAll;
    @FXML
    private Button btnCancel;
    @FXML
    protected TextField searchText;
    @Inject
    private ConditionQueryModel model;
    @Inject
    private IUiRightService rightModel;
    @Inject
    protected MxAlert alert;
    private MxList<Condition> mlist = new MxList();
    protected Predicate<Condition> pd = en -> {
        String text = this.searchText.getText().trim();
        if (en.getSecId().contains(text) || en.getSecName().contains(text)) {
            return true;
        }
        return en.getEntrustId() != null && en.getEntrustId().contains(text);
    };
    private InvalidationListener lstnSearch = ob -> {
        this.mlist.filter(this.model.getList(), this.pd);
        this.tableCond.refresh();
        this.tableCond.sort();
    };
    private InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        List<Condition> newList = Collections.synchronizedList(new ArrayList());
        ObservableList<Condition> observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll((Collection<Condition>)this.model.getList());
        }
        this.mlist.update(newList, this.pd);
        this.tableCond.refresh();
        this.tableCond.sort();
    });

    @FXML
    public void initialize() {
        if (!this.rightModel.registerCheck(new String[]{"cms.tmx.condition.part.query_cancel"})) {
            this.btnCancel.setVisible(false);
        }
        this.cboxAll.selectedProperty().addListener((ob, old, now) -> this.tableCond.getItems().forEach(cond -> {
            if (cond.canOperation()) {
                cond.setSelected(now.booleanValue());
            }
        }));
        this.createTable();
        this.listener();
        this.refresh();
    }

    protected void listener() {
        this.model.changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.lstnSearch);
    }

    private void createTable() {
        TableUtils.initValueFactory(this.tableCond);
        this.selected.setCellFactory(data -> new MxCheckBoxTableCell());
        this.selected.setSortable(false);
        this.side.setCellFactory(cell -> new SideCell());
        this.tableCond.setItems(this.mlist.getList());
        this.tableCond.setPlaceholder((Node)new Label());
        TableUtils.doubleClicked(this.tableCond, cond -> {
            if (this.btnCancel.isVisible() && cond.canOperation()) {
                cond.setSelected(true);
                this.cancel((Condition)cond);
            }
            return true;
        });
    }

    protected void afterTableRestore() {
        super.afterTableRestore();
        this.condOrdId.setSortType(TableColumn.SortType.DESCENDING);
        this.tableCond.getSortOrder().add(this.condOrdId);
        this.tableCond.sort();
    }

    @FXML
    private void cancel() {
        FilteredList list = this.tableCond.getItems().filtered(cond -> cond.isSelected());
        if (list.size() == 0) {
            this.alert.alert(Alert.AlertType.INFORMATION, "\u8bf7\u9009\u62e9\u9700\u8981\u64a4\u9500\u7684\u6761\u4ef6\u5355\uff01");
            return;
        }
        if (!this.alert.alert(Alert.AlertType.CONFIRMATION, "\u662f\u5426\u64a4\u9500\u9009\u4e2d\u7684" + list.size() + "\u7b14\u6761\u4ef6\u5355\uff1f")) {
            return;
        }
        try {
            this.model.cancelList((List<Condition>)list);
            String info = list.size() == 1 ? ((Condition)list.get(0)).getCondOrdId() : String.valueOf(list.size()) + "\u7b14";
            this.alert.alert(Alert.AlertType.INFORMATION, "\u64a4\u9500\u6210\u529f" + info);
            this.refresh();
        }
        catch (MException e) {
            logger.error((Object)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private void cancel(Condition cond) {
        if (!this.alert.alert(Alert.AlertType.CONFIRMATION, "\u662f\u5426\u64a4\u9500" + cond.getCondOrdId() + "\uff1f")) {
            return;
        }
        try {
            this.model.cancel(cond);
            this.alert.alert(Alert.AlertType.INFORMATION, "\u64a4\u9500\u6210\u529f" + cond.getCondOrdId());
            this.refresh();
        }
        catch (MException e) {
            logger.error((Object)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    private void refresh() {
        this.model.query();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableCond);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableCond, (String)"\u6761\u4ef6\u5355\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private class MxCheckBoxTableCell
    extends CheckBoxTableCell<Condition, Boolean> {
        public void updateItem(Boolean item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                Condition cond = (Condition)Condition.class.cast(this.getTableRow().getItem());
                if (cond == null) {
                    return;
                }
                if (!cond.canOperation()) {
                    cond.setSelected(false);
                }
                this.setDisable(!cond.canOperation());
            }
        }
    }

    private class SideCell
    extends TableCell<Condition, MxNode> {
        private Label label = new Label();

        private SideCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(MxNode value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            Condition cond = (Condition)this.getTableRow().getItem();
            if (cond == null) {
                return;
            }
            if ("49".equals(cond.getSide().getRaw())) {
                CssUtils.makeRise((Control)this.label);
            } else {
                CssUtils.makeFall((Control)this.label);
            }
            this.label.setText(value.getValue());
            this.setGraphic((Node)this.label);
        }
    }
}

