/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.condition.model;

import cms.tmx.condition.model.ConditionAccountDistributionModel;
import cms.tmx.core.MException;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsAccountDistribution;
import cms.tmx.entity.trade.instruction.RespResult;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.strategy.dto.OrdType;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.http.condition.api.CondOrderServiceApi;
import cms.tmx.http.condition.dto.ConditionType;
import cms.tmx.http.condition.dto.ConditionalOrder;
import cms.tmx.http.condition.dto.NewOrderConditional;
import cms.tmx.http.condition.dto.PriceCondition;
import cms.tmx.http.condition.dto.PriceLevel;
import cms.tmx.http.condition.dto.TimeCondition;
import cms.tmx.http.query.Condition;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.trade.models.CcsAccountDistributionModel;
import cmx.tmx.data.IMarketDataMng;
import java.util.Iterator;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TreeItem;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class ConditionTradeModel
extends MxModel {
    private static final Logger logger = LogManager.getLogger(ConditionTradeModel.class);
    private StringProperty security = new SimpleStringProperty("");
    private StringProperty name = new SimpleStringProperty("");
    private BooleanProperty buy = new SimpleBooleanProperty(true);
    private DoubleProperty price = new SimpleDoubleProperty();
    private LongProperty count = new SimpleLongProperty();
    private ObjectProperty<MxNode> condType = new SimpleObjectProperty();
    private ObjectProperty<MxNode> condJudge = new SimpleObjectProperty();
    private DoubleProperty condPrice = new SimpleDoubleProperty();
    private StringProperty condDate = new SimpleStringProperty("");
    private StringProperty condTime = new SimpleStringProperty("");
    private ObjectProperty<MxNode> priceStg = new SimpleObjectProperty();
    private DoubleProperty floatRatio = new SimpleDoubleProperty();
    private ObjectProperty<MxNode> countStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> distStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> accFilterStg = new SimpleObjectProperty();
    protected MarketItem mktItem;
    private final int INIT_UNIT = 100;
    @Inject
    protected ConditionAccountDistributionModel accTreeModel;
    @Inject
    private IMarketDataMng mktMng;
    @Inject
    private CondOrderServiceApi csApi;
    MxNode clonePriceStg = MxNodeFactory.createNew((String)"condition_price", (String)"0");

    @PostConstruct
    public void init() {
        try {
            this.getAccDisModel().create();
        }
        catch (MException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        this.getAccDisModel().securityProperty().bind((ObservableValue)this.security);
        this.mktItem = this.mktMng.createItem(10);
        this.getAccDisModel().buyProperty().bind((ObservableValue)this.buy);
        this.buy.addListener(ob -> this.onBsChange());
        MxNode node = MxNodeFactory.create((String)"condition_type", (String)"2");
        this.setCondType(node);
        node = MxNodeFactory.create((String)"condition_judge", (String)"6");
        this.setCondJudge(node);
        node = MxNodeFactory.create((String)"trade_count_stg", (String)"1");
        this.countStg.addListener(ob -> this.onCountStgChange());
        this.countStgBuy(node);
        node = MxNodeFactory.createNew((String)"condition_price", (String)"0");
        this.setPriceStg(node);
        this.priceStg.addListener(ob -> this.onPriceStgChange());
        node = MxNodeFactory.create((String)"acc_dist_mode", (String)"1");
        this.distStgBuy(node);
        this.distStg.addListener(ob -> this.onDistStgChange());
        this.setDistStg(node);
        node = MxNodeFactory.create((String)"acc_count_filter", (String)"1");
        this.accFilterStg.addListener(ob -> this.onAccFilterStgChange());
        this.setAccFilterStg(node);
        this.count.addListener(ob -> this.onCountChange());
        this.getAccDisModel().priceProperty().bind((ObservableValue)this.price);
        this.getAccDisModel().changedProperty().addListener(ob -> this.calCountDistribution());
    }

    public void onSecChange() {
        this.getAccDisModel().setRepo(this.isReverseRepo());
        this.mktMng.dye(this.mktItem);
        if (!this.mktItem.getStop().getValue().booleanValue()) {
            this.setName(this.mktItem.getRefItem().getName());
        }
        this.filterAcc();
        this.changeQuantityUnit();
        this.checkRefChange(this.mktItem.getRefItem());
        this.onPriceStgChange();
    }

    protected void changeQuantityUnit() {
        if (this.isValidRef()) {
            this.getAccDisModel().setUnit(this.mktItem.getRefItem().getBuyUnit());
            this.setCvt();
        } else {
            this.getAccDisModel().setUnit(100);
        }
    }

    private void setCvt() {
        this.getAccDisModel().setUnitConvert(this.isSHbond() ? 10 : 1);
    }

    public boolean isSHbond() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.isBond() && this.mktItem.getRefItem().getMarket().equals("XSHG");
    }

    public boolean isReverseRepo() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("REPO");
    }

    public boolean isBond() {
        if (!this.isValidRef()) {
            return false;
        }
        return this.getValidRef().getType().equals("BOND") || this.getValidRef().getType().equals("REPO");
    }

    public final void checkRefChange(RefItem item) {
        if (item == null) {
            return;
        }
        MxNode node = this.getPriceStg();
        node.getNodes().clear();
        this.clonePriceStg.getNodes().forEach(n -> node.addNode(n.getRaw()));
        if (item != null && item.getType().equals("BOND")) {
            node.removeNode("99");
            node.removeNode("100");
        }
        node.setRaw("0");
        this.setPriceStg(node);
    }

    public void onPriceStgChange() {
        if (this.getPriceStg() == null) {
            return;
        }
        if ("11".equals(this.getPriceStg().getRaw())) {
            return;
        }
        double price = this.mktItem.getNowPrice();
        price = price == 0.0 ? this.mktItem.getClosePrice() : price;
        this.setPrice(price);
    }

    public final MarketItem getMI() {
        return this.mktItem;
    }

    protected void onBsChange() {
        MxNode nodeCountStg = this.getCountStg();
        MxNode nodeDistStg = this.getDistStg();
        if (this.isBuy()) {
            this.countStgBuy(nodeCountStg);
            this.distStgBuy(nodeDistStg);
        } else {
            this.countStgSell(nodeCountStg);
            this.distStgSell(nodeDistStg);
        }
        this.filterAcc();
    }

    protected void filterAcc() {
        if (!this.isValidRef()) {
            this.getAccDisModel().setRefItem(null);
            this.getAccDisModel().clearCanBuySell(this.getAccDisModel().getRoot());
            this.getAccDisModel().filterAcc();
            return;
        }
        this.getAccDisModel().setRefItem(this.getValidRef());
        this.getAccDisModel().calAccountCanBuy();
        this.getAccDisModel().calAccountCanSell();
        this.getAccDisModel().filterAcc();
    }

    public boolean isValidRef() {
        if (this.mktItem.getRefItem() == null) {
            return false;
        }
        return !this.mktItem.getRefItem().getType().isEmpty();
    }

    public RefItem getValidRef() {
        RefItem item = this.mktItem.getRefItem();
        if (item == null || item.getType().isEmpty()) {
            return null;
        }
        return item;
    }

    private void onCountChange() {
        ((CcsAccountDistribution)this.getAccDisModel().getRoot().getValue()).setCount(this.getCount());
        if (this.getCount() == 0L) {
            this.getAccDisModel().clearCount(this.getAccDisModel().getRoot());
            return;
        }
        this.calCountDistribution();
        this.getAccDisModel().allocateCount();
    }

    private void onAccFilterStgChange() {
        this.getAccDisModel().setAccFilterStg(this.getAccFilterStg().getRaw());
        this.getAccDisModel().setCustomSecAccCount(this.getAccDisModel().getEffectiveSecAccCount());
    }

    protected void countStgBuy(MxNode node) {
        String oldNodeRaw = node.getRaw();
        this.removeOthers(node, "1");
        node.addNode("3");
        node.addNode("5");
        node.addNode("2");
        node.setRaw(oldNodeRaw.equals("4") ? "3" : oldNodeRaw);
        this.setCountStg(node);
    }

    protected void countStgSell(MxNode node) {
        String oldNodeRaw = node.getRaw();
        this.removeOthers(node, "1");
        node.addNode("4");
        node.addNode("5");
        node.addNode("2");
        node.setRaw(oldNodeRaw.equals("3") ? "4" : oldNodeRaw);
        this.setCountStg(node);
    }

    protected void distStgBuy(MxNode node) {
        if (node.getRaw().equals("3")) {
            this.removeOthers(node, "1");
            node.addNode("2");
        } else {
            node.removeNode("3");
        }
    }

    private void onCountStgChange() {
        this.getAccDisModel().setCountStg(this.getCountStg().getRaw());
        this.getCountStg().getRaw().equals("5");
        this.calCountDistribution();
    }

    private void onDistStgChange() {
        this.getAccDisModel().setDistStg(this.getDistStg().getRaw());
        this.calCountDistribution();
    }

    protected void calCountDistribution() {
        if (!this.isValidRef()) {
            this.getAccDisModel().clearCount(this.getAccDisModel().getRoot());
            return;
        }
        long total = this.getAccDisModel().allocateCount();
        if (this.setCaledCount()) {
            this.setCount(total);
        }
    }

    private boolean setCaledCount() {
        return this.getCountStg().getRaw().equals("4") || this.getCountStg().getRaw().equals("3") || this.getCountStg().getRaw().equals("2");
    }

    public CcsAccountDistributionModel getAccDisModel() {
        return this.accTreeModel;
    }

    protected void distStgSell(MxNode node) {
        node.addNode("3");
    }

    public void removeOthers(MxNode rowNode, String raw) {
        Iterator it = rowNode.getNodes().iterator();
        while (it.hasNext()) {
            MxNode node = (MxNode)it.next();
            if (node.getRaw().equals(raw)) continue;
            it.remove();
        }
    }

    public List<TreeItem<CcsAccountDistribution>> getSelectedItems(TreeItem<CcsAccountDistribution> tree) {
        return tree.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected());
    }

    public List<TreeItem<CcsAccountDistribution>> getNoZeroItems(TreeItem<CcsAccountDistribution> tree) {
        return tree.getChildren().filtered(ad -> ((CcsAccountDistribution)ad.getValue()).isSelected() && ((CcsAccountDistribution)ad.getValue()).getCount() != 0L);
    }

    public RespResult submit() throws MException {
        RespResult result = new RespResult();
        for (TreeItem<CcsAccountDistribution> acc : this.getSelectedItems((TreeItem<CcsAccountDistribution>)this.getAccDisModel().getRoot())) {
            for (TreeItem<CcsAccountDistribution> secAcc : this.getNoZeroItems(acc)) {
                NewOrderConditional newOrder = new NewOrderConditional();
                ConditionalOrder order = new ConditionalOrder();
                order.setCondType(ConditionType.getObj((String)this.getCondType().getRaw()));
                if (ConditionType.kCondTypePrice == order.getCondType()) {
                    PriceCondition priceCond = new PriceCondition();
                    priceCond.setType("1");
                    Condition cond = new Condition();
                    cond.setDoubleVal(this.getCondPrice());
                    cond.setOp(this.getOp());
                    priceCond.setCond(cond);
                    order.setPriceCond(priceCond);
                } else {
                    TimeCondition timeCond = new TimeCondition();
                    timeCond.setExecDate(this.getCondDate());
                    timeCond.setExecTime(this.getCondTime());
                    order.setTimeCond(timeCond);
                }
                order.setExpireDate(this.getCondDate());
                Instrument inst = new Instrument();
                inst.setSecurityId(this.mktItem.getRefItem().getCode());
                inst.setSecurityType(this.mktItem.getRefItem().getType());
                inst.setMarket(this.mktItem.getRefItem().getMarket());
                inst.setSymbol(this.mktItem.getRefItem().getName());
                inst.setApplId("010");
                order.setInstrument(inst);
                order.setSide(this.isBuy() ? Side.SIDE_BUY : Side.SIDE_SELL);
                order.setOrdType(OrdType.ORD_TYPE_LIMIT);
                PriceLevel level = this.getPriceLevel();
                if (level != null) {
                    order.setPriceLevel(level.getValue());
                    order.setFloatRatio(this.getFloatRatio());
                } else {
                    order.setPrice(this.getPrice());
                }
                order.setPriceUnit(this.mktItem.getRefItem().getPriceUnit());
                order.setOrderQty((double)((CcsAccountDistribution)secAcc.getValue()).getCount());
                newOrder.setAccount(((CcsAccountDistribution)acc.getValue()).getAcc().getParentId());
                newOrder.setExtCashAccntId(((CcsAccountDistribution)acc.getValue()).getAcc().getExtAccntId());
                newOrder.setExtSecAccntId(((CcsAccountDistribution)secAcc.getValue()).getSecAcc().getExtSecAccntId());
                newOrder.setOrder(order);
                try {
                    this.csApi.newOrderConditional(newOrder);
                    result.incrementSuccessed();
                }
                catch (MException e) {
                    logger.error("basket algo order faild", (Throwable)e);
                    result.incrementFailed(String.valueOf(e.getMessage()) + " " + e.getEvent().getObj());
                }
            }
        }
        return result;
    }

    private PriceLevel getPriceLevel() {
        switch (this.getPriceStg().getRaw()) {
            case "0": {
                return PriceLevel.PRICE_LAST_PRICE;
            }
            case "100": {
                return PriceLevel.PRICE_MAX;
            }
            case "99": {
                return PriceLevel.PRICE_MIN;
            }
            case "1": {
                return PriceLevel.PRICE_BUY_1;
            }
            case "2": {
                return PriceLevel.PRICE_BUY_2;
            }
            case "3": {
                return PriceLevel.PRICE_BUY_3;
            }
            case "4": {
                return PriceLevel.PRICE_BUY_4;
            }
            case "5": {
                return PriceLevel.PRICE_BUY_5;
            }
            case "-1": {
                return PriceLevel.PRICE_SELL_1;
            }
            case "-2": {
                return PriceLevel.PRICE_SELL_2;
            }
            case "-3": {
                return PriceLevel.PRICE_SELL_3;
            }
            case "-4": {
                return PriceLevel.PRICE_SELL_4;
            }
            case "-5": {
                return PriceLevel.PRICE_SELL_5;
            }
        }
        return null;
    }

    private Condition.OP getOp() {
        String raw;
        switch (raw = this.getCondJudge().getRaw()) {
            case "1": {
                return Condition.OP.GT;
            }
            case "2": {
                return Condition.OP.GE;
            }
            case "3": {
                return Condition.OP.LT;
            }
            case "4": {
                return Condition.OP.LE;
            }
            case "6": {
                return Condition.OP.EQ;
            }
        }
        return null;
    }

    public final StringProperty securityProperty() {
        return this.security;
    }

    public final String getSecurity() {
        return (String)this.securityProperty().get();
    }

    public final void setSecurity(String security) {
        this.securityProperty().set((Object)security);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public final String getName() {
        return (String)this.nameProperty().get();
    }

    public final void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public final BooleanProperty buyProperty() {
        return this.buy;
    }

    public final boolean isBuy() {
        return this.buyProperty().get();
    }

    public final void setBuy(boolean buy) {
        this.buyProperty().set(buy);
    }

    public final DoubleProperty priceProperty() {
        return this.price;
    }

    public final double getPrice() {
        return this.priceProperty().get();
    }

    public final void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public final LongProperty countProperty() {
        return this.count;
    }

    public final long getCount() {
        return this.countProperty().get();
    }

    public final void setCount(long count) {
        this.countProperty().set(count);
    }

    public final ObjectProperty<MxNode> priceStgProperty() {
        return this.priceStg;
    }

    public final MxNode getPriceStg() {
        return (MxNode)this.priceStgProperty().get();
    }

    public final void setPriceStg(MxNode priceStg) {
        this.priceStgProperty().set((Object)priceStg);
    }

    public final ObjectProperty<MxNode> countStgProperty() {
        return this.countStg;
    }

    public final MxNode getCountStg() {
        return (MxNode)this.countStgProperty().get();
    }

    public final void setCountStg(MxNode countStg) {
        this.countStgProperty().set((Object)countStg);
    }

    public final ObjectProperty<MxNode> distStgProperty() {
        return this.distStg;
    }

    public final MxNode getDistStg() {
        return (MxNode)this.distStgProperty().get();
    }

    public final void setDistStg(MxNode distStg) {
        this.distStgProperty().set((Object)distStg);
    }

    public final ObjectProperty<MxNode> accFilterStgProperty() {
        return this.accFilterStg;
    }

    public final MxNode getAccFilterStg() {
        return (MxNode)this.accFilterStgProperty().get();
    }

    public final void setAccFilterStg(MxNode accFilterStg) {
        this.accFilterStgProperty().set((Object)accFilterStg);
    }

    public final ObjectProperty<MxNode> condTypeProperty() {
        return this.condType;
    }

    public final MxNode getCondType() {
        return (MxNode)this.condTypeProperty().get();
    }

    public final void setCondType(MxNode condType) {
        this.condTypeProperty().set((Object)condType);
    }

    public final ObjectProperty<MxNode> condJudgeProperty() {
        return this.condJudge;
    }

    public final MxNode getCondJudge() {
        return (MxNode)this.condJudgeProperty().get();
    }

    public final void setCondJudge(MxNode condJudge) {
        this.condJudgeProperty().set((Object)condJudge);
    }

    public final StringProperty condDateProperty() {
        return this.condDate;
    }

    public final String getCondDate() {
        return (String)this.condDateProperty().get();
    }

    public final void setCondDate(String condDate) {
        this.condDateProperty().set((Object)condDate);
    }

    public final StringProperty condTimeProperty() {
        return this.condTime;
    }

    public final String getCondTime() {
        return (String)this.condTimeProperty().get();
    }

    public final void setCondTime(String condTime) {
        this.condTimeProperty().set((Object)condTime);
    }

    public final DoubleProperty floatRatioProperty() {
        return this.floatRatio;
    }

    public final double getFloatRatio() {
        return this.floatRatioProperty().get();
    }

    public final void setFloatRatio(double floatRatio) {
        this.floatRatioProperty().set(floatRatio);
    }

    public final DoubleProperty condPriceProperty() {
        return this.condPrice;
    }

    public final double getCondPrice() {
        return this.condPriceProperty().get();
    }

    public final void setCondPrice(double condPrice) {
        this.condPriceProperty().set(condPrice);
    }
}

