/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.condition.model;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.Condition;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.condition.api.CondOrderServiceApi;
import cms.tmx.http.condition.dto.ConditionalCancelRequest;
import cms.tmx.http.condition.dto.ConditionalOrderEvent;
import cms.tmx.http.condition.dto.GetCondtionalOrderRequest;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.utils.QueryModel;
import cmx.tmx.data.IRefDataMng;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class ConditionQueryModel
extends MxModel {
    ObservableList<Condition> list = FxUtils.newList();
    private Gson gson = new Gson();
    @Inject
    private CondOrderServiceApi csApi;
    @Inject
    private CcsAccountMap accountMap;
    @Inject
    private MEventService es;
    @Inject
    private QueryModel queryMod;
    @Inject
    protected MScheduler sdFullQuery;
    @Inject
    protected MxAlert alert;
    @Inject
    private IRefDataMng refMng;
    private static final int FULL_QUERY_INTERVAL = 3000;
    private InvalidationListener lstnRefMng = ob -> {
        try {
            this.fullQuery();
        }
        catch (MException e) {
            this.logger.error("condition query failed", (Throwable)e);
        }
        this.removeListener();
    };

    @PostConstruct
    public void init() {
        this.es.subscribe("uap.push.ComplexEvent", event -> this.httpCondReport(event));
        this.refMng.doneProperty().addListener(this.lstnRefMng);
        this.sdFullQuery.setInterval(3000);
    }

    private void removeListener() {
        this.refMng.changedProperty().removeListener(this.lstnRefMng);
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException | Exception e) {
                this.logger.error("condition query failed", e);
                Platform.runLater(() -> {
                    boolean bl = this.alert.alert(Alert.AlertType.ERROR, "\u6761\u4ef6\u5355\u67e5\u8be2\u5931\u8d25\uff1a" + e.getMessage());
                });
            }
        });
    }

    private void fullQuery() throws MException {
        List listAcc = this.accountMap.getExtAccList();
        if (listAcc.isEmpty()) {
            this.logger.error("condition query faild: account is empty");
            return;
        }
        GetCondtionalOrderRequest request = new GetCondtionalOrderRequest();
        request.setExtCashAccntId(listAcc);
        List listOrder = this.csApi.getCondtionalOrder(request);
        LinkedList listCond = new LinkedList();
        if (listOrder == null) {
            return;
        }
        listOrder.forEach(order -> {
            Condition cond = new Condition();
            Instrument inst = order.getOrder().getInstrument();
            RefItem refItem = this.refMng.getItem(inst.getSecurityType(), inst.getMarket(), inst.getSecurityId());
            cond.setRefItem(refItem);
            cond.update(order);
            this.queryMod.afterUpdate(cond);
            listCond.add(cond);
        });
        this.list.setAll(listCond);
        this.changed();
    }

    public void query(String acc, String id) throws MException {
        GetCondtionalOrderRequest request = new GetCondtionalOrderRequest();
        LinkedList<String> listAcc = new LinkedList<String>();
        listAcc.add(acc);
        request.setExtCashAccntId(listAcc);
        LinkedList<String> listId = new LinkedList<String>();
        listId.add(id);
        request.setCondOrderId(listId);
        List listOrder = this.csApi.getCondtionalOrder(request);
        LinkedList<Condition> listCond = new LinkedList<Condition>();
        if (listOrder == null) {
            return;
        }
        if (listOrder.size() == 1) {
            Condition cond = new Condition();
            cond.update(listOrder.get(0));
            listCond.add(cond);
            this.list.add(0, (Object)cond);
        }
    }

    public void cancel(Condition cond) throws MException {
        ConditionalCancelRequest request = new ConditionalCancelRequest();
        LinkedList<String> listId = new LinkedList<String>();
        listId.add(cond.getCondOrdId());
        request.setCondOrdId(listId);
        this.csApi.cancelCondtion(request);
        this.changed();
    }

    public void cancelList(List<Condition> list) throws MException {
        ConditionalCancelRequest request = new ConditionalCancelRequest();
        LinkedList listId = new LinkedList();
        list.forEach(cond -> {
            boolean bl = listId.add(cond.getCondOrdId());
        });
        request.setCondOrdId(listId);
        this.csApi.cancelCondtion(request);
        this.changed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void httpCondReport(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        ConditionalOrderEvent orderEvent = (ConditionalOrderEvent)this.gson.fromJson((JsonElement)obj, ConditionalOrderEvent.class);
        ObservableList<Condition> observableList = this.list;
        synchronized (observableList) {
            for (Condition cond : this.list) {
                if (!orderEvent.getCondOrderId().equals(cond.getCondOrdId())) continue;
                Platform.runLater(() -> cond.update((Object)orderEvent));
            }
        }
        this.logger(orderEvent);
        this.changed();
    }

    private void logger(ConditionalOrderEvent event) {
        Condition cond = new Condition();
        cond.update((Object)event);
        String info = String.valueOf(cond.getCondOrdId()) + "," + cond.getStatus();
        this.logger.info("condition push \uff1a" + info);
    }

    public ObservableList<Condition> getList() {
        return this.list;
    }
}

