/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.fund.views;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.Search;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.EtfStrategy;
import cms.tmx.fund.models.EtfAutoMktMakerMng;
import cms.tmx.fund.models.UserEtfAutoPreCtrl;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.inject.Inject;

public class StrategyDialog
extends DialogObj {
    protected static final String INVALID_CODE = "\u65e0\u6548\u4ee3\u7801";
    private static final String BASEPRICE_TYPE = "ref_price_custom";
    private static final String TYPE_CROSS = "1";
    private static final String TYPE_SLICE = "2";
    @FXML
    private GridPane tvCross;
    @FXML
    private GridPane tvSlice;
    @FXML
    protected ComboBox<String> cmbAcct;
    @FXML
    protected ComboBox<String> cmbSecAcct;
    @FXML
    protected TextField txtCode;
    @FXML
    protected Label lbName;
    @FXML
    protected ComboBox<MxNode> cmbType;
    @FXML
    protected TextField txtName;
    @FXML
    protected ComboBox<MxNode> cmbBase;
    @FXML
    private Spinner<Double> spnThreshold;
    @FXML
    private Spinner<Double> spnDiffBuy;
    @FXML
    private Spinner<Double> spnDiffSell;
    @FXML
    private Spinner<Integer> spnQtyBuy;
    @FXML
    private Spinner<Integer> spnQtySell;
    @FXML
    private TextField txtDiffMax;
    @FXML
    private TextField txtDiffMin;
    @FXML
    private Spinner<Integer> spnQtyEntrust;
    @FXML
    private Spinner<Integer> spnQtySlice;
    @FXML
    private Spinner<Double> spnBasePoint;
    @FXML
    private Label lbAcctErr;
    @FXML
    private Label lbSecAcctErr;
    @FXML
    protected Label lbCodeErr;
    @FXML
    private Label lbNameErr;
    @FXML
    private Label lbThresholdErr;
    @FXML
    private Label lbDiffBuyErr;
    @FXML
    private Label lbDiffSellErr;
    @FXML
    private Label lbQtyBuyErr;
    @FXML
    private Label lbQtySellErr;
    @FXML
    private Label lbDiffMaxErr;
    @FXML
    private Label lbDiffMinErr;
    @FXML
    private Label lbQtyEntrustErr;
    @FXML
    private Label lbQtySliceErr;
    @FXML
    private Label lbBasePointErr;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private MObjFactory of;
    @Inject
    protected EtfAutoMktMakerMng model;
    @Inject
    protected UserEtfAutoPreCtrl preModel;
    @Inject
    protected MxAlert alert;
    private StringProperty partType = new SimpleStringProperty("FUND");
    private DoubleSpinnerCtrl ctrlThreshold = new DoubleSpinnerCtrl(true, 6, 3);
    private DoubleSpinnerCtrl ctrlDiffBuy = new DoubleSpinnerCtrl(true, 6, 3);
    private DoubleSpinnerCtrl ctrlDiffSell = new DoubleSpinnerCtrl(true, 6, 3);
    private IntSpinnerCtrl ctrlCountBuy = new IntSpinnerCtrl(true, 9, 100);
    private IntSpinnerCtrl ctrlCountSell = new IntSpinnerCtrl(true, 9, 100);
    private IntSpinnerCtrl ctrlCountEntrust = new IntSpinnerCtrl(true, 9, 100);
    private IntSpinnerCtrl ctrlCountSlice = new IntSpinnerCtrl(true, 9, 1);
    private DoubleSpinnerCtrl ctrlBasePoint = new DoubleSpinnerCtrl(true, 6, 3);
    private SecSuggest spCode = new SecSuggest();
    private RefItem refItem = null;
    public List<String> nameList = new ArrayList<String>();
    private SecSuggest.StrSuggest suggestFund = SecSuggest.getStrSuggest();
    private SecSuggest.StrSuggest suggestSec = SecSuggest.getStrSuggest();
    protected EtfStrategy stg;
    private ChangeListener<? super Boolean> refListener = (ob, old, now) -> this.spCode.setAllSuggestions(this.refMng.getItems(new String[]{this.partType.getValue()}));
    private ObservableList<String> secList = FxUtils.newList();
    private String oldSec;
    private String oldSH;
    private String oldSZ;
    @Inject
    private CcsAccountMap accMng;
    private Map<CcsFundAccount, List<SecAccount>> accountMap = FxUtils.newMap();

    public StrategyDialog() {
        super("AddStrategyDialog.fxml");
    }

    public void bind() {
        this.txtCode.textProperty().bindBidirectional((Property)this.stg.securityProperty());
        this.lbName.textProperty().bind((ObservableValue)this.stg.secNameProperty());
        this.txtName.textProperty().bindBidirectional((Property)this.stg.nameProperty());
        this.cmbAcct.valueProperty().bind((ObservableValue)this.stg.investorIdProperty());
        this.cmbSecAcct.valueProperty().bind((ObservableValue)this.stg.investorSecIdProperty());
        MxBindings.bindSD((Property)this.spnThreshold.getEditor().textProperty(), (Property)this.stg.priceSlipProperty());
        MxBindings.bindSD((Property)this.spnDiffBuy.getEditor().textProperty(), (Property)this.stg.bidSpreadProperty());
        MxBindings.bindSD((Property)this.spnDiffSell.getEditor().textProperty(), (Property)this.stg.askSpreadProperty());
        MxBindings.bindSD((Property)this.spnQtyBuy.getEditor().textProperty(), (Property)this.stg.bidQtyProperty());
        MxBindings.bindSD((Property)this.spnQtySell.getEditor().textProperty(), (Property)this.stg.askQtyProperty());
        this.cmbType.valueProperty().bindBidirectional((Property)this.stg.tacticsTypeProperty());
        String str = this.stg.getRefPriceCustom().getRaw();
        if (str.contains(".")) {
            MxNode node = new MxNode();
            String refRow = str.substring(str.indexOf(".") + 1, str.length());
            node.setRaw(refRow);
            this.cmbBase.getSelectionModel().select((Object)node);
        }
    }

    protected void preBind() {
        MxBindings.bindSD((Property)this.spnThreshold.getEditor().textProperty(), (Property)this.preModel.buyPriceFloatProperty());
        MxBindings.bindSD((Property)this.spnDiffBuy.getEditor().textProperty(), (Property)this.preModel.defBuyDiffProperty());
        MxBindings.bindSD((Property)this.spnDiffSell.getEditor().textProperty(), (Property)this.preModel.defSellDiffProperty());
        MxBindings.bindSD((Property)this.spnQtyBuy.getEditor().textProperty(), (Property)this.preModel.buyQuantityProperty());
        MxBindings.bindSD((Property)this.spnQtySell.getEditor().textProperty(), (Property)this.preModel.sellQuantityProperty());
    }

    public void onFinished(ButtonType bt) {
        this.refMng.changedProperty().removeListener(this.refListener);
    }

    @FXML
    public void initialize() {
        this.initUserPre();
        try {
            this.accountMap = this.accMng.getAccountMap();
        }
        catch (MException e) {
            e.printStackTrace();
        }
        this.refMng.changedProperty().addListener(this.refListener);
        this.initControls();
        this.preBind();
        Map<String, String> map = this.initCmbBase();
        MxNode node = null;
        node = !this.preModel.getDefBenchmark().isEmpty() ? MxNodeFactory.create((String)BASEPRICE_TYPE, (String)map.get(this.preModel.getDefBenchmark())) : MxNodeFactory.create((String)BASEPRICE_TYPE, (String)"LAST");
        this.initCmbBaseType(node);
        this.cmbBase.setItems(node.getNodes());
        this.cmbBase.setValue((Object)node);
        node = MxNodeFactory.create((String)"type_strategy", (String)TYPE_CROSS);
        this.cmbType.setItems(node.getNodes());
        this.cmbType.setValue((Object)node);
        this.registerCheck();
        this.cmbType.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (TYPE_CROSS.equals(now.getRaw())) {
                this.tvCross.setVisible(true);
                this.tvSlice.setVisible(false);
            } else {
                this.tvCross.setVisible(false);
                this.tvSlice.setVisible(true);
            }
            this.registerCheck();
        });
    }

    private void registerCheck() {
        this.mapValid.clear();
        this.registerCheck((Node)this.lbAcctErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.cmbAcct.getEditor().getText().isEmpty()) {
                this.lbAcctErr.setText("\u8bf7\u8f93\u5165\u8d44\u91d1\u8d26\u6237");
                return false;
            }
            if (this.accMng.getFundAcc(this.cmbAcct.getEditor().getText()) == null) {
                this.lbAcctErr.setText("\u8d44\u91d1\u8d26\u6237\u4e0d\u5b58\u5728");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.cmbAcct.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbSecAcctErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.cmbSecAcct.getEditor().getText().isEmpty()) {
                this.lbSecAcctErr.setText("\u8bf7\u8f93\u5165\u8bc1\u5238\u8d26\u6237");
                return false;
            }
            if (this.accMng.getSecAcc(this.cmbSecAcct.getEditor().getText(), "") == null) {
                this.lbSecAcctErr.setText("\u8bc1\u5238\u8d26\u6237\u4e0d\u5b58\u5728");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.cmbSecAcct.getEditor().textProperty()}));
        this.registerCheck((Node)this.lbCodeErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.lbName.getText().isEmpty()) {
                this.lbCodeErr.setText("\u8bf7\u8f93\u5165\u8bc1\u5238\u4ee3\u7801");
                return false;
            }
            if (INVALID_CODE.equals(this.lbName.getText())) {
                this.lbCodeErr.setText("\u8f93\u5165\u7684\u4ee3\u7801\u65e0\u6548");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.lbName.textProperty()}));
        this.registerCheck((Node)this.lbNameErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtName.getText().isEmpty()) {
                this.lbNameErr.setText("\u8bf7\u8f93\u5165\u7b56\u7565\u540d\u79f0");
                return false;
            }
            if (this.nameList.contains(this.txtName.getText())) {
                this.lbNameErr.setText("\u6b64\u540d\u79f0\u5df2\u5b58\u5728");
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtName.textProperty()}));
        this.registerCheck((Node)this.lbThresholdErr, (ObservableBooleanValue)this.spnThreshold.getEditor().textProperty().isNotEmpty());
        if (((MxNode)this.cmbType.getSelectionModel().getSelectedItem()).getRaw().equals(TYPE_CROSS)) {
            this.registerCheck((Node)this.lbDiffBuyErr, (ObservableBooleanValue)this.spnDiffBuy.getEditor().textProperty().isNotEmpty());
            this.registerCheck((Node)this.lbDiffSellErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
                if (this.spnDiffSell.getEditor().getText().isEmpty()) {
                    this.lbDiffSellErr.setText("\u8bf7\u8f93\u5165\u5356\u4ef7\u70b9\u5dee");
                    return false;
                }
                if (this.spnDiffBuy.getEditor().getText().isEmpty()) {
                    return true;
                }
                if (Double.valueOf(this.spnDiffBuy.getEditor().getText().replaceAll(",", "")) == 0.0 && Double.valueOf(this.spnDiffSell.getEditor().getText().replaceAll(",", "")) == 0.0) {
                    this.lbDiffSellErr.setText("\u4e70\u5356\u70b9\u5dee\u4e0d\u53ef\u540c\u65f6\u4e3a0");
                    return false;
                }
                return true;
            }, (Observable[])new Observable[]{this.spnDiffBuy.getEditor().textProperty(), this.spnDiffSell.getEditor().textProperty()}));
            this.registerCheck((Node)this.lbQtyBuyErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
                if (this.spnQtyBuy.getEditor().getText().isEmpty()) {
                    this.lbQtyBuyErr.setText("\u8bf7\u8f93\u5165\u4e70\u5165\u6570\u91cf");
                    return false;
                }
                int num = Integer.valueOf(this.spnQtyBuy.getEditor().getText().replaceAll(",", "")) % 100;
                if (num != 0) {
                    this.lbQtyBuyErr.setText("\u4e70\u5165\u6570\u91cf\u5e94\u4e3a100\u7684\u6574\u6570\u500d");
                    return false;
                }
                if (Integer.valueOf(this.spnQtyBuy.getEditor().getText().replaceAll(",", "")) == 0) {
                    this.lbQtyBuyErr.setText("\u4e70\u5165\u6570\u91cf\u4e0d\u53ef\u4e3a0");
                    return false;
                }
                return true;
            }, (Observable[])new Observable[]{this.spnQtyBuy.getEditor().textProperty()}));
            this.registerCheck((Node)this.lbQtySellErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
                if (this.spnQtySell.getEditor().getText().isEmpty()) {
                    this.lbQtySellErr.setText("\u8bf7\u8f93\u5165\u5356\u51fa\u6570\u91cf");
                    return false;
                }
                int num = Integer.valueOf(this.spnQtySell.getEditor().getText().replaceAll(",", "")) % 100;
                if (num != 0) {
                    this.lbQtySellErr.setText("\u5356\u51fa\u6570\u91cf\u5e94\u4e3a100\u7684\u6574\u6570\u500d");
                    return false;
                }
                if (Integer.valueOf(this.spnQtySell.getEditor().getText().replaceAll(",", "")) == 0) {
                    this.lbQtySellErr.setText("\u5356\u51fa\u6570\u91cf\u4e0d\u53ef\u4e3a0");
                    return false;
                }
                return true;
            }, (Observable[])new Observable[]{this.spnQtySell.getEditor().textProperty()}));
        }
        if (((MxNode)this.cmbType.getSelectionModel().getSelectedItem()).getRaw().equals(TYPE_SLICE)) {
            this.registerCheck((Node)this.lbDiffMaxErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
                if (this.txtDiffMax.getText().isEmpty()) {
                    this.lbDiffMaxErr.setText("\u8bf7\u8f93\u5165\u6700\u5927\u4ef7\u5dee");
                    return false;
                }
                double num = Double.valueOf(this.txtDiffMax.getText());
                if (num <= 0.0 || num > 100.0) {
                    this.lbDiffMaxErr.setText("\u6700\u5927\u4ef7\u5dee\u5fc5\u987b\u5927\u4e8e0\u4e14\u4e0d\u5927\u4e8e100");
                    return false;
                }
                return true;
            }, (Observable[])new Observable[]{this.txtDiffMax.textProperty()}));
            this.registerCheck((Node)this.lbDiffMinErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
                if (this.txtDiffMax.getText().isEmpty()) {
                    return true;
                }
                if (this.txtDiffMin.getText().isEmpty()) {
                    this.lbDiffMinErr.setText("\u8bf7\u8f93\u5165\u6700\u5c0f\u4ef7\u5dee");
                    return false;
                }
                double num = Double.valueOf(this.txtDiffMin.getText());
                if (Double.valueOf(this.txtDiffMax.getText()) <= num) {
                    this.lbDiffMinErr.setText("\u6700\u5c0f\u4ef7\u5dee\u5e94\u5c0f\u4e8e\u6700\u5927\u4ef7\u5dee");
                    return false;
                }
                if (num < 0.0 || num > 100.0) {
                    this.lbDiffMinErr.setText("\u6700\u5c0f\u4ef7\u5dee\u4e0d\u5c0f\u4e8e0\u4e14\u5c0f\u4e8e100");
                    return false;
                }
                return true;
            }, (Observable[])new Observable[]{this.txtDiffMax.textProperty(), this.txtDiffMin.textProperty()}));
            this.registerCheck((Node)this.lbQtyEntrustErr, (ObservableBooleanValue)this.spnQtyEntrust.getEditor().textProperty().isNotEmpty());
            this.registerCheck((Node)this.lbQtySliceErr, (ObservableBooleanValue)this.spnQtySlice.getEditor().textProperty().isNotEmpty());
            this.registerCheck((Node)this.lbBasePointErr, (ObservableBooleanValue)this.spnBasePoint.getEditor().textProperty().isNotEmpty());
        }
    }

    protected EtfStrategy getAddStrategy() {
        EtfStrategy strategy = (EtfStrategy)this.of.create(EtfStrategy.class);
        CcsFundAccount fund = this.accMng.getFundAcc(this.cmbAcct.getEditor().getText());
        strategy.setExtFundAccntId(fund.getExtAccntId());
        SecAccount sec = this.accMng.getSecAcc(this.cmbSecAcct.getEditor().getText(), "");
        strategy.setExtSecAccntId(sec.getExtSecAccntId());
        strategy.setMarket(this.refItem.getMarket());
        strategy.setSecurity(this.txtCode.getText());
        strategy.setSecurityType(this.refItem.getType());
        strategy.setRefPriceCustom((MxNode)this.cmbBase.getSelectionModel().getSelectedItem());
        strategy.setPriceSlip(Double.valueOf(this.spnThreshold.getEditor().getText().replaceAll(",", "")).doubleValue());
        strategy.setTacticsType((MxNode)this.cmbType.getSelectionModel().getSelectedItem());
        strategy.setName(this.txtName.getText());
        if (((MxNode)this.cmbType.getSelectionModel().getSelectedItem()).getRaw().equals(TYPE_CROSS)) {
            strategy.setBidSpread(Double.valueOf(this.spnDiffBuy.getEditor().getText().replaceAll(",", "")).doubleValue());
            strategy.setAskSpread(Double.valueOf(this.spnDiffSell.getEditor().getText().replaceAll(",", "")).doubleValue());
            strategy.setBidQty(Integer.valueOf(this.spnQtyBuy.getEditor().getText().replaceAll(",", "")).intValue());
            strategy.setAskQty(Integer.valueOf(this.spnQtySell.getEditor().getText().replaceAll(",", "")).intValue());
        }
        return strategy;
    }

    private void initCmbBaseType(MxNode node) {
        this.removeOthers(node, "100");
        node.addNode("ASK_10");
        node.addNode("ASK_9");
        node.addNode("ASK_8");
        node.addNode("ASK_7");
        node.addNode("ASK_6");
        node.addNode("ASK_5");
        node.addNode("ASK_4");
        node.addNode("ASK_3");
        node.addNode("ASK_2");
        node.addNode("ASK_1");
        node.addNode("BID_10");
        node.addNode("BID_9");
        node.addNode("BID_8");
        node.addNode("BID_7");
        node.addNode("BID_6");
        node.addNode("BID_5");
        node.addNode("BID_4");
        node.addNode("BID_3");
        node.addNode("BID_2");
        node.addNode("BID_1");
        node.addNode("LAST");
        node.addNode("AVG");
    }

    public void removeOthers(MxNode mxNode, String raw) {
        Iterator it = mxNode.getNodes().iterator();
        while (it.hasNext()) {
            MxNode node = (MxNode)it.next();
            if (node.getRaw().equals(raw)) continue;
            it.remove();
        }
    }

    protected EtfStrategy getUpdateStrategy() {
        EtfStrategy strategy = (EtfStrategy)this.of.create(EtfStrategy.class);
        strategy.setContextId(this.stg.getContextId());
        strategy.setMarket(this.stg.getMarket());
        strategy.setTacticsType(this.stg.getTacticsType());
        strategy.setExtFundAccntId(this.stg.getExtFundAccntId());
        strategy.setExtSecAccntId(this.stg.getExtSecAccntId());
        strategy.setSecurity(this.stg.getSecurity());
        strategy.setSecurityType(this.stg.getSecurityType());
        strategy.setRefPriceCustom((MxNode)this.cmbBase.getSelectionModel().getSelectedItem());
        strategy.setPriceSlip(Double.valueOf(this.spnThreshold.getEditor().getText().replaceAll(",", "")).doubleValue());
        strategy.setName(this.txtName.getText());
        if (((MxNode)this.cmbType.getSelectionModel().getSelectedItem()).getRaw().equals(TYPE_CROSS)) {
            strategy.setBidSpread(Double.valueOf(this.spnDiffBuy.getEditor().getText().replaceAll(",", "")).doubleValue());
            strategy.setAskSpread(Double.valueOf(this.spnDiffSell.getEditor().getText().replaceAll(",", "")).doubleValue());
            strategy.setBidQty(Integer.valueOf(this.spnQtyBuy.getEditor().getText().replaceAll(",", "")).intValue());
            strategy.setAskQty(Integer.valueOf(this.spnQtySell.getEditor().getText().replaceAll(",", "")).intValue());
        }
        return strategy;
    }

    protected void initControls() {
        this.cmbAcct.getItems().addAll((Collection)this.accMng.getFundAccList());
        if (!StringUtils.isEmpty((String)this.preModel.getFundAccnt())) {
            this.cmbAcct.getSelectionModel().select((Object)this.preModel.getFundAccnt());
        } else {
            this.cmbAcct.getSelectionModel().select(0);
        }
        this.suggestFund.addPossibleSuggestions((Collection)this.accMng.getFundAccList());
        Search.bindAutoCompletion((TextField)this.cmbAcct.getEditor(), (Callback)this.suggestFund);
        Search.bindAutoCompletion((TextField)this.cmbSecAcct.getEditor(), (Callback)this.suggestSec);
        this.cmbAcct.getEditor().setTextFormatter((TextFormatter)new MxFormatter("[0-9]+", 16));
        this.cmbAcct.getEditor().textProperty().addListener((ob, old, now) -> {
            this.cmbAcct.getSelectionModel().select(now);
            this.cmbAcct.hide();
            this.onFundChange();
        });
        this.cmbSecAcct.getEditor().setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9]+", 16));
        this.cmbSecAcct.getEditor().textProperty().addListener((ob, old, now) -> {
            this.cmbSecAcct.getSelectionModel().select(now);
            this.cmbSecAcct.hide();
            if (this.secList.contains(this.cmbSecAcct.getSelectionModel().getSelectedItem())) {
                SecAccount sec = this.accMng.getSecAcc((String)this.cmbSecAcct.getSelectionModel().getSelectedItem(), "");
                if (sec.getExchange().getRaw().equals("XSHE")) {
                    this.oldSec = this.oldSZ = sec.getInverstorSecId();
                } else if (sec.getExchange().getRaw().equals("XSHG")) {
                    this.oldSec = this.oldSH = sec.getInverstorSecId();
                }
            }
        });
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        this.spCode.addPossibleSuggestions(this.refMng.getItems(new String[]{this.partType.getValue()}));
        Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.spCode, (StringConverter)((StringConverter)this.of.create(SecConverter.class))).changedProperty().addListener((ob, oldV, newV) -> {
            this.refItem = (RefItem)this.txtCode.getUserData();
            if (this.refItem == null || this.refItem.getName().equals("")) {
                this.lbName.setText(INVALID_CODE);
            } else {
                this.lbName.setText(this.refItem.getName());
            }
            if (this.txtCode.getText().isEmpty()) {
                this.lbName.setText("");
            }
            this.updateSecAcctList();
        });
        this.txtCode.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtCode.selectAll());
        this.txtName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5\\.]*", 32));
        this.txtDiffMax.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,})?$", 9));
        this.txtDiffMin.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,})?$", 9));
        this.ctrlThreshold.ctrl(this.spnThreshold);
        this.spnThreshold.getEditor().setOnMouseClicked(event -> this.preModel.selectTwoOrAllPriceDecimal());
        this.ctrlDiffBuy.ctrl(this.spnDiffBuy);
        this.spnDiffBuy.getEditor().setOnMouseClicked(event -> this.preModel.selectTwoOrAllPriceDecimal());
        this.ctrlDiffSell.ctrl(this.spnDiffSell);
        if (((String)this.partType.get()).equals("STOCK")) {
            this.ctrlDiffSell.setScale(2);
        }
        this.spnDiffSell.getEditor().setOnMouseClicked(event -> this.preModel.selectTwoOrAllPriceDecimal());
        this.ctrlCountBuy.ctrl(this.spnQtyBuy);
        this.spnQtyBuy.getEditor().setOnMouseClicked(event -> this.spnQtyBuy.getEditor().selectAll());
        this.ctrlCountSell.ctrl(this.spnQtySell);
        this.spnQtySell.getEditor().setOnMouseClicked(event -> this.spnQtySell.getEditor().selectAll());
        this.ctrlCountEntrust.ctrl(this.spnQtyEntrust);
        this.spnQtyEntrust.getEditor().setOnMouseClicked(event -> this.spnQtyEntrust.getEditor().selectAll());
        this.ctrlCountSlice.ctrl(this.spnQtySlice);
        this.spnQtySlice.getEditor().setOnMouseClicked(event -> this.spnQtyEntrust.getEditor().selectAll());
        this.ctrlBasePoint.ctrl(this.spnBasePoint);
    }

    public void onFundChange() {
        CcsFundAccount fund = this.accMng.getFundAcc(this.cmbAcct.getEditor().getText());
        if (fund == null) {
            this.cmbSecAcct.getItems().clear();
            this.cmbSecAcct.getEditor().clear();
            return;
        }
        this.secList.clear();
        if (this.refItem == null) {
            this.accountMap.get(fund).forEach(each -> {
                boolean bl = this.secList.add((Object)each.getInverstorSecId());
            });
        } else {
            for (SecAccount sec : this.accountMap.get(fund)) {
                if (!sec.getExchange().getRaw().equals(this.refItem.getMarket())) continue;
                this.secList.add((Object)sec.getInverstorSecId());
            }
        }
        this.cmbSecAcct.setItems(this.secList);
        if (!StringUtils.isEmpty((String)this.preModel.getSecAccnt()) && this.secList.contains((Object)this.preModel.getSecAccnt())) {
            this.cmbSecAcct.getSelectionModel().select((Object)this.preModel.getSecAccnt());
        } else {
            this.cmbSecAcct.getSelectionModel().select((Object)((String)this.secList.get(0)));
        }
        this.suggestSec.setAllSuggestions(this.secList);
    }

    private void updateSecAcctList() {
        CcsFundAccount fund = this.accMng.getFundAcc(this.cmbAcct.getEditor().getText());
        if (this.refItem == null || this.refItem.getName().equals("")) {
            this.secList.clear();
            this.accountMap.get(fund).forEach(each -> {
                boolean bl = this.secList.add((Object)each.getInverstorSecId());
            });
            if (this.secList.contains((Object)this.oldSec)) {
                this.cmbSecAcct.getSelectionModel().select((Object)this.oldSec);
            }
        } else {
            ArrayList<String> listTemp = new ArrayList<String>();
            for (SecAccount sec : this.accountMap.get(fund)) {
                if (!sec.getExchange().getRaw().equals(this.refItem.getMarket())) continue;
                listTemp.add(sec.getInverstorSecId());
            }
            this.secList.clear();
            this.secList.addAll(listTemp);
            if (this.secList.contains((Object)this.oldSH)) {
                this.cmbSecAcct.getSelectionModel().select((Object)this.oldSH);
                this.oldSec = this.oldSH;
            } else if (this.secList.contains((Object)this.oldSZ)) {
                this.cmbSecAcct.getSelectionModel().select((Object)this.oldSZ);
                this.oldSec = this.oldSZ;
            } else {
                this.cmbSecAcct.getSelectionModel().select(0);
            }
        }
        this.suggestSec.setAllSuggestions(this.secList);
    }

    public void initUserPre() {
        this.preModel.setType(TYPE_SLICE, "200006");
        this.preModel.setStrategyDialog(this);
        try {
            this.preModel.doSet();
        }
        catch (MException mException) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u67e5\u8be2\u7528\u6237\u8bbe\u7f6e\u5931\u8d25"));
        }
    }

    private Map<String, String> initCmbBase() {
        HashMap<String, String> basePriceMap = new HashMap<String, String>();
        basePriceMap.put("-10", "ASK_10");
        basePriceMap.put("-9", "ASK_9");
        basePriceMap.put("-8", "ASK_8");
        basePriceMap.put("-7", "ASK_7");
        basePriceMap.put("-6", "ASK_6");
        basePriceMap.put("-5", "ASK_5");
        basePriceMap.put("-4", "ASK_4");
        basePriceMap.put("-3", "ASK_3");
        basePriceMap.put("-2", "ASK_2");
        basePriceMap.put("-1", "ASK_1");
        basePriceMap.put(TYPE_CROSS, "BID_1");
        basePriceMap.put(TYPE_SLICE, "BID_2");
        basePriceMap.put("3", "BID_3");
        basePriceMap.put("4", "BID_4");
        basePriceMap.put("5", "BID_5");
        basePriceMap.put("6", "BID_6");
        basePriceMap.put("7", "BID_7");
        basePriceMap.put("8", "BID_8");
        basePriceMap.put("9", "BID_9");
        basePriceMap.put("10", "BID_10");
        basePriceMap.put("0", "LAST");
        basePriceMap.put("20", "AVG");
        return basePriceMap;
    }

    public Spinner<Double> getSpnThreshold() {
        return this.spnThreshold;
    }

    public void setSpnThreshold(Spinner<Double> spnThreshold) {
        this.spnThreshold = spnThreshold;
    }

    public Spinner<Double> getSpnDiffBuy() {
        return this.spnDiffBuy;
    }

    public void setSpnDiffBuy(Spinner<Double> spnDiffBuy) {
        this.spnDiffBuy = spnDiffBuy;
    }

    public Spinner<Double> getSpnDiffSell() {
        return this.spnDiffSell;
    }

    public void setSpnDiffSell(Spinner<Double> spnDiffSell) {
        this.spnDiffSell = spnDiffSell;
    }

    public Spinner<Integer> getSpnQtyBuy() {
        return this.spnQtyBuy;
    }

    public void setSpnQtyBuy(Spinner<Integer> spnQtyBuy) {
        this.spnQtyBuy = spnQtyBuy;
    }

    public Spinner<Integer> getSpnQtySell() {
        return this.spnQtySell;
    }

    public void setSpnQtySell(Spinner<Integer> spnQtySell) {
        this.spnQtySell = spnQtySell;
    }
}

