/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.fund.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.Search;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.HandicapCountCell;
import cms.tmx.data.utils.PriceCell;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CrossOrder;
import cms.tmx.entity.trade.Instrument;
import cms.tmx.fund.api.IEtfTradeModel;
import cms.tmx.fund.api.IEtfTradePart;
import cms.tmx.fund.models.EtfAutoMktMakerMng;
import cms.tmx.fund.models.EtfEntrustConfirmParam;
import cms.tmx.fund.models.EtfManualTradeModel;
import cms.tmx.fund.models.UserEtfManualPreCtrl;
import cms.tmx.fund.views.BasePrice;
import cms.tmx.fund.views.EtfEntrustConfirmDialog;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.ISecAccountService;
import cms.tmx.query.current.mng.EtfManualMng;
import cms.tmx.query.current.models.CcsPositionModel;
import cms.tmx.trade.utils.TradeBindings;
import cms.tmx.utils.DecimalUtils;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.settings.UserPreOrderTips;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EtfTradePart
extends MxPart
implements IEtfTradePart {
    @FXML
    private TextField txtCode;
    @FXML
    private Spinner<Double> spnBasePrice;
    @FXML
    private Spinner<Double> spnDiffBuy;
    @FXML
    private Spinner<Double> spnDiffSell;
    @FXML
    private Label lbName;
    @FXML
    private ComboBox<BasePrice> cmbBase;
    @FXML
    private Spinner<Double> spnPriceBuy;
    @FXML
    private Spinner<Double> spnPriceSell;
    @FXML
    private Spinner<Integer> spnQtyBuy;
    @FXML
    private Spinner<Integer> spnQtySell;
    @FXML
    private Label lbRate;
    @FXML
    private Label lbLatest;
    @FXML
    private Label lbUpLimit;
    @FXML
    private Label lbDownLimit;
    @FXML
    private TableColumn<String, String> indexBuy;
    @FXML
    private TableColumn<String, String> indexSell;
    @FXML
    private TableView<HandicapInfo> tableMarketSell;
    @FXML
    private TableColumn<HandicapInfo, String> mktSellPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellCount;
    @FXML
    private TableView<HandicapInfo> tableMarketBuy;
    @FXML
    private TableColumn<HandicapInfo, String> mktBuyPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyCount;
    @Inject
    private UserPreOrderTips setTips;
    @FXML
    private TableColumn<CrossOrder, Boolean> checkBoxCol;
    @FXML
    private Label lbCountOne;
    @FXML
    private Label lbCountTwo;
    @FXML
    private Label lbCountThree;
    @FXML
    private Label lbCountFour;
    @FXML
    private ComboBox<String> cmbAcct;
    @FXML
    private ComboBox<SecAccount> cmbSecAcct;
    @Inject
    private EtfAutoMktMakerMng autoMng;
    @FXML
    private Button btnOrder;
    @FXML
    private HBox forceBtnBox;
    @FXML
    private Label forceToggle;
    @Inject
    private EtfManualTradeModel model;
    @Inject
    @Named(value="core_event")
    protected MEvent eCore;
    @Inject
    private IRefDataMng refMng;
    @Inject
    protected MEventService es;
    @Inject
    private MxAlert alert;
    @Inject
    private IFundAccountService fundAccMng;
    @Inject
    private MObjFactory of;
    @Inject
    private EtfManualMng etfMng;
    @Inject
    private ISecAccountService secAcctMng;
    @Inject
    private CcsPositionModel postionModel;
    private double orderPriceBuy;
    private double orderPriceSell;
    protected SecSuggest.StrSuggest spFund = SecSuggest.getStrSuggest();
    protected SecSuggest.StrSuggest spSec = SecSuggest.getStrSuggest();
    @Inject
    protected DialogFactory df;
    private static final String INVALID_CODE = "\u65e0\u6548\u4ee3\u7801";
    private MarketItem mktItem;
    private static final Logger logger = LogManager.getLogger(EtfTradePart.class);
    private DoubleSpinnerCtrl ctrlBasePrice = new DoubleSpinnerCtrl(true, 6, 3);
    private DoubleSpinnerCtrl ctrlDiffBuy = new DoubleSpinnerCtrl(true, 6, 3);
    private DoubleSpinnerCtrl ctrlDiffSell = new DoubleSpinnerCtrl(true, 6, 3);
    private DoubleSpinnerCtrl ctrlPriceBuy = new DoubleSpinnerCtrl(true, 6, 3);
    private DoubleSpinnerCtrl ctrlPriceSell = new DoubleSpinnerCtrl(true, 6, 3);
    private IntSpinnerCtrl ctrlCountBuy = new IntSpinnerCtrl(true, 9, 100);
    private IntSpinnerCtrl ctrlCountSell = new IntSpinnerCtrl(true, 9, 100);
    private SecSuggest spCode = new SecSuggest();
    private static final double INITPRICE = 0.0;
    private SecAccount oldSH;
    private SecAccount oldSZ;
    private SecConverter secCvt;
    private RefItem refItem = null;
    private Map<String, BasePrice> baseMap = new HashMap<String, BasePrice>();
    private Map<String, SecAccount> mapSec = new HashMap<String, SecAccount>();
    private static final String BASE_AVG = "20";
    private static final String BASE_ASSIGN = "19";
    private MxNode node;
    @Inject
    protected UserEtfManualPreCtrl preModel;
    private InvalidationListener lstnMarketItem = ob -> this.onRefChange();
    private InvalidationListener lstnRefMng = ob -> {
        Collection list = this.refMng.getItems(new String[]{this.model.getTradeType()});
        this.spCode.setAllSuggestions(list);
    };
    private ObservableList<SecAccount> secList = FxUtils.newList();
    private List<SecAccount> secListCopy = new ArrayList<SecAccount>();
    @Inject
    private IRefDataMng ref;
    private List<CrossOrder> oldList = new LinkedList<CrossOrder>();
    private ObservableMap<String, List<CrossOrder>> map = FxUtils.newMap();
    private ObservableList<CrossOrder> legOverOrders = FxUtils.newList();
    private ObservableList<CrossOrder> legPendingOrders = FxUtils.newList();
    private boolean isOldOrder = true;

    private boolean checkOrderStatus(int crossOrderStatus) {
        int firstLegStatus = crossOrderStatus / 100;
        int secondLegStatus = crossOrderStatus % 100;
        return this.legPendingCancel(firstLegStatus) || this.legPendingCancel(secondLegStatus);
    }

    private boolean legPendingCancel(int legOrderStatus) {
        return legOrderStatus == Integer.valueOf("54");
    }

    @FXML
    public void forceToggle() {
        String toggleStyleClassUp = this.forceBtnBox.isVisible() ? "forceToggleUp" : "forceToggleDown";
        String toggleStyleClassDown = this.forceBtnBox.isVisible() ? "forceToggleDown" : "forceToggleUp";
        this.forceToggle.getStyleClass().removeAll((Object[])new String[]{toggleStyleClassUp});
        this.forceToggle.getStyleClass().add((Object)toggleStyleClassDown);
        this.forceBtnBox.setVisible(!this.forceBtnBox.isVisible());
    }

    @FXML
    public void initialize() {
        this.mktItem = this.model.getMI();
        this.mktItem.refItemProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnMarketItem));
        this.refMng.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnRefMng));
        this.createMarketTable();
        this.initUserPre();
        this.initControls();
        this.initPosition();
        this.node = MxNodeFactory.create((String)"market_code", (String)"");
    }

    @PreDestroy
    private void close() {
    }

    private void initPosition() {
        this.fxmlDone = true;
        this.postionModel.initQuery();
    }

    private void initControls() {
        HashMap<String, FundAccount> mapFund = new HashMap<String, FundAccount>(1000);
        ObservableList fundStrList = FxUtils.newList();
        for (FundAccount fund : this.fundAccMng.getFundAccountList().filtered(each -> each.getMarketGrp().equals("CCS") && each.getExtAccntId().contains("CNY"))) {
            mapFund.put(fund.getInvestId(), fund);
            if (!"1".equals(Integer.toString(fund.getFlags()))) continue;
            fundStrList.add((Object)fund.getInvestId());
        }
        this.cmbAcct.setItems(fundStrList);
        if (!StringUtils.isEmpty((String)this.preModel.getFundAccnt())) {
            this.cmbAcct.getSelectionModel().select((Object)this.preModel.getFundAccnt());
        } else {
            this.cmbAcct.getSelectionModel().select(0);
        }
        FilteredList obList = this.fundAccMng.getFundAccountList().filtered(each -> each.getMarketGrp().equals("CCS") && each.getExtAccntId().contains("CNY"));
        ArrayList spFundList = new ArrayList();
        obList.forEach(m -> spFundList.add(m.getInvestId()));
        this.spFund.addPossibleSuggestions(spFundList);
        Search.bindAutoCompletion((TextField)this.cmbAcct.getEditor(), (Callback)this.spFund);
        Search.bindAutoCompletion((TextField)this.cmbSecAcct.getEditor(), (Callback)this.spSec);
        this.cmbAcct.getEditor().setTextFormatter((TextFormatter)new MxFormatter("[0-9]+", 16));
        this.cmbAcct.getEditor().textProperty().addListener((ob, old, now) -> {
            this.cmbAcct.getSelectionModel().select(now);
            this.cmbAcct.hide();
            FundAccount fundAcc = (FundAccount)mapFund.get(now);
            this.model.setFundAcct(fundAcc);
            if (fundAcc == null) {
                this.cmbSecAcct.getEditor().setText("");
                return;
            }
            try {
                this.secList.clear();
                this.mapSec.clear();
                this.secListCopy.clear();
                this.secList.addAll((Collection)this.secAcctMng.querySecAccountList(fundAcc));
                this.secListCopy.addAll((Collection<SecAccount>)this.secList);
                for (SecAccount sec : this.secList) {
                    this.mapSec.put(sec.getInverstorSecId(), sec);
                }
                this.cmbSecAcct.setItems(this.secList);
                this.getFilterSecAccntList();
                ArrayList spList = new ArrayList();
                this.spSec.clearSuggestions();
                this.secList.forEach(m -> spList.add(m.getInverstorSecId()));
                this.spSec.addPossibleSuggestions(spList);
            }
            catch (MException e) {
                logger.error((Object)e, (Throwable)e);
            }
        });
        this.cmbSecAcct.getEditor().setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9]+", 16));
        this.cmbSecAcct.getEditor().textProperty().addListener((ob, old, now) -> {
            this.cmbSecAcct.hide();
            if (this.secList.contains(this.cmbSecAcct.getSelectionModel().getSelectedItem())) {
                SecAccount sec = (SecAccount)this.cmbSecAcct.getSelectionModel().getSelectedItem();
                if (sec.getExchange().getRaw().equals("XSHE")) {
                    this.oldSZ = sec;
                } else if (sec.getExchange().getRaw().equals("XSHG")) {
                    this.oldSH = sec;
                }
            }
            this.model.setSecAcct((SecAccount)this.cmbSecAcct.getSelectionModel().getSelectedItem());
        });
        this.secCvt = (SecConverter)this.of.create(SecConverter.class);
        this.spCode.addPossibleSuggestions(this.refMng.getItems(new String[]{this.model.getTradeType()}));
        Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.spCode, (StringConverter)this.secCvt).changedProperty().addListener((ob, oldV, newV) -> this.onSecurityChange());
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        this.txtCode.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.codeKeyPress((KeyEvent)event));
        this.txtCode.focusedProperty().addListener((ob, old, newV) -> this.loseFocus((Boolean)newV));
        this.txtCode.textProperty().bindBidirectional((Property)this.model.securityProperty());
        ObservableList priceBases = FxUtils.newList();
        Map<String, String> initMap = this.initCmbBase();
        initMap.keySet().forEach(b -> {
            BasePrice basePrice = new BasePrice();
            basePrice.setKey((String)b);
            basePrice.setValue((String)initMap.get(b));
            priceBases.add((Object)basePrice);
        });
        this.baseMap.clear();
        priceBases.forEach(base -> this.baseMap.put(base.getKey(), (BasePrice)base));
        this.cmbBase.setItems(priceBases);
        if (!StringUtils.isEmpty((String)this.preModel.getDefBenchmark())) {
            this.cmbBase.getSelectionModel().select((Object)this.baseMap.get(this.preModel.getDefBenchmark()));
        }
        this.cmbBase.valueProperty().addListener((ob, old, now) -> {
            if (now != null) {
                this.buildBasePrice(now.getKey());
            }
        });
        this.ctrlBasePrice.ctrl(this.spnBasePrice);
        MxBindings.bindSDFormat((Property)this.spnBasePrice.getEditor().textProperty(), (Property)this.model.basePriceProperty());
        this.spnBasePrice.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.basePricePress((KeyEvent)event));
        this.spnBasePrice.getEditor().textProperty().addListener((ob, old, now) -> {
            if (!now.isEmpty()) {
                double sell = Double.valueOf(now) + this.preModel.getDefSellDiff();
                double buy = Double.valueOf(now) - this.preModel.getDefBuyDiff();
                if (this.mktItem.getRefItem() != null && sell > 0.0 && buy > 0.0) {
                    this.model.setPriceBuy(Double.valueOf(String.format("%." + this.mktItem.getRefItem().getScale() + "f", buy)));
                    this.model.setPriceSell(Double.valueOf(String.format("%." + this.mktItem.getRefItem().getScale() + "f", sell)));
                    if (this.spnBasePrice.isFocused()) {
                        this.cmbBase.getSelectionModel().select((Object)this.baseMap.get(BASE_ASSIGN));
                    }
                }
            }
        });
        this.spnBasePrice.getEditor().setOnMouseClicked(event -> this.preModel.selectTwoOrAllPriceDecimal());
        this.ctrlDiffBuy.ctrl(this.spnDiffBuy);
        MxBindings.bindSD((Property)this.spnDiffBuy.getEditor().textProperty(), (Property)this.preModel.defBuyDiffProperty());
        this.spnDiffBuy.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.diffBuyPress((KeyEvent)event));
        this.spnDiffBuy.getEditor().textProperty().addListener((ob, old, now) -> {
            Double d = this.model.getBasePrice() - this.getDouble((String)now);
            if (this.spnDiffBuy.isFocused()) {
                double priceBuy = this.getDouble(this.spnPriceBuy.getEditor().getText().replaceAll(",", ""));
                if (d != priceBuy && !this.spnPriceBuy.isFocused()) {
                    this.spnPriceBuy.getEditor().setText(StringUtils.toStr((double)this.correctDouble(d), (int)3));
                }
            }
        });
        this.spnDiffBuy.getEditor().setOnMouseClicked(event -> this.preModel.selectTwoOrAllPriceDecimal());
        this.spnDiffBuy.focusedProperty().addListener((ob, old, now) -> {
            if (!now.booleanValue()) {
                double diff = this.getDouble(this.spnDiffBuy.getEditor().getText().replaceAll(",", ""));
                this.spnDiffBuy.getEditor().setText(StringUtils.toStr((double)diff, (int)3));
            }
        });
        this.ctrlDiffSell.ctrl(this.spnDiffSell);
        if (this.model.getTradeType().equals("STOCK")) {
            this.ctrlDiffSell.setScale(2);
        }
        MxBindings.bindSD((Property)this.spnDiffSell.getEditor().textProperty(), (Property)this.preModel.defSellDiffProperty());
        this.spnDiffSell.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.diffSellPress((KeyEvent)event));
        this.spnDiffSell.getEditor().textProperty().addListener((ob, old, now) -> {
            double priceSell;
            double d = this.model.getBasePrice() + this.getDouble((String)now);
            if (this.spnDiffSell.isFocused() && d != (priceSell = this.getDouble(this.spnPriceSell.getEditor().getText().replaceAll(",", ""))) && !this.spnPriceSell.isFocused()) {
                this.spnPriceSell.getEditor().setText(StringUtils.toStr((double)d, (int)3));
            }
        });
        this.spnDiffSell.focusedProperty().addListener((ob, old, now) -> {
            if (!now.booleanValue()) {
                double diff = this.getDouble(this.spnDiffSell.getEditor().getText().replaceAll(",", ""));
                this.spnDiffSell.getEditor().setText(StringUtils.toStr((double)diff, (int)3));
            }
        });
        this.spnDiffSell.getEditor().setOnMouseClicked(event -> this.preModel.selectTwoOrAllPriceDecimal());
        this.lbName.textProperty().bindBidirectional((Property)this.model.nameProperty());
        this.ctrlPriceBuy.ctrl(this.spnPriceBuy);
        if (this.model.getTradeType().equals("STOCK")) {
            this.ctrlPriceBuy.setScale(2);
        }
        TradeBindings.bindSDFormat((Property)this.spnPriceBuy.getEditor().textProperty(), (Property)this.model.priceBuyProperty());
        this.spnPriceBuy.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.priceBuyPress((KeyEvent)event));
        this.spnPriceBuy.getEditor().setOnMouseClicked(event -> this.preModel.selectTwoOrAllPriceDecimal());
        this.spnPriceBuy.getEditor().textProperty().addListener((ob, old, now) -> {
            Double d = this.model.getBasePrice() - this.getDouble((String)now);
            double diffSell = this.getDouble(this.spnDiffBuy.getEditor().getText().replaceAll(",", ""));
            if (d != diffSell && !this.spnDiffBuy.isFocused() && this.spnPriceBuy.isFocused()) {
                this.spnDiffBuy.getEditor().setText(StringUtils.toStr((double)this.correctDouble(d), (int)3));
            }
        });
        this.spnPriceBuy.focusedProperty().addListener((ob, old, now) -> {
            if (!now.booleanValue()) {
                double priceBuy = this.model.getPriceBuy();
                if (priceBuy > this.model.getBasePrice() && this.model.getBasePrice() > 0.0) {
                    priceBuy = this.model.getBasePrice();
                    this.spnPriceBuy.getEditor().setText(StringUtils.toStr((double)priceBuy, (int)3));
                    this.spnPriceBuy.requestFocus();
                    this.spnPriceBuy.getEditor().selectAll();
                } else {
                    this.spnPriceBuy.getEditor().setText(StringUtils.toStr((double)priceBuy, (int)3));
                }
            }
        });
        this.ctrlPriceSell.ctrl(this.spnPriceSell);
        TradeBindings.bindSDFormat((Property)this.spnPriceSell.getEditor().textProperty(), (Property)this.model.priceSellProperty());
        this.spnPriceSell.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.priceSellPress((KeyEvent)event));
        this.spnPriceSell.getEditor().setOnMouseClicked(event -> this.preModel.selectTwoOrAllPriceDecimal());
        this.spnPriceSell.getEditor().textProperty().addListener((ob, old, now) -> {
            Double d = this.getDouble((String)now) - this.model.getBasePrice();
            double diffSell = this.getDouble(this.spnDiffSell.getEditor().getText().replaceAll(",", ""));
            if (d != diffSell && !this.spnDiffSell.isFocused() && this.spnPriceSell.isFocused()) {
                this.spnDiffSell.getEditor().setText(StringUtils.toStr((double)this.correctDouble(d), (int)3));
            }
        });
        this.spnPriceSell.focusedProperty().addListener((ob, old, now) -> {
            if (!now.booleanValue()) {
                double priceBuy = this.model.getPriceSell();
                if (priceBuy < this.model.getBasePrice()) {
                    priceBuy = this.model.getBasePrice();
                    this.spnPriceSell.getEditor().setText(StringUtils.toStr((double)priceBuy, (int)3));
                } else {
                    this.spnPriceSell.getEditor().setText(StringUtils.toStr((double)priceBuy, (int)3));
                }
            }
        });
        this.ctrlCountBuy.ctrl(this.spnQtyBuy);
        this.spnQtyBuy.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.qtyBuyKeyPress((KeyEvent)event));
        MxBindings.bindSI((Property)this.spnQtyBuy.getEditor().textProperty(), (Property)this.preModel.buyQuantityProperty());
        this.spnQtyBuy.getEditor().setOnMouseClicked(event -> this.spnQtyBuy.getEditor().selectAll());
        this.ctrlCountSell.ctrl(this.spnQtySell);
        MxBindings.bindSI((Property)this.spnQtySell.getEditor().textProperty(), (Property)this.preModel.sellQuantityProperty());
        this.spnQtySell.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.qtySellKeyPress((KeyEvent)event));
        this.spnQtySell.getEditor().setOnMouseClicked(event -> this.spnQtySell.getEditor().selectAll());
        this.spnQtySell.getEditor().textProperty().addListener((ob, old, now) -> {
            if (StringUtils.isEmpty((String)now)) {
                this.model.setCountSell(Integer.valueOf(now).intValue());
            }
        });
        this.lbCountOne.setOnMouseClicked(event -> {
            this.spnQtyBuy.getEditor().setText(this.lbCountOne.getText());
            this.spnQtySell.getEditor().setText(this.lbCountOne.getText());
        });
        this.lbCountTwo.setOnMouseClicked(event -> {
            this.spnQtyBuy.getEditor().setText(this.lbCountTwo.getText());
            this.spnQtySell.getEditor().setText(this.lbCountTwo.getText());
        });
        this.lbCountThree.setOnMouseClicked(event -> {
            this.spnQtyBuy.getEditor().setText(this.lbCountThree.getText());
            this.spnQtySell.getEditor().setText(this.lbCountThree.getText());
        });
        this.lbCountFour.setOnMouseClicked(event -> {
            this.spnQtyBuy.getEditor().setText(this.lbCountFour.getText());
            this.spnQtySell.getEditor().setText(this.lbCountFour.getText());
        });
    }

    private Map<String, String> initCmbBase() {
        LinkedHashMap<String, String> basePriceMap = new LinkedHashMap<String, String>();
        basePriceMap.put("-10", "\u5356\u5341");
        basePriceMap.put("-9", "\u5356\u4e5d");
        basePriceMap.put("-8", "\u5356\u516b");
        basePriceMap.put("-7", "\u5356\u4e03");
        basePriceMap.put("-6", "\u5356\u516d");
        basePriceMap.put("-5", "\u5356\u4e94");
        basePriceMap.put("-4", "\u5356\u56db");
        basePriceMap.put("-3", "\u5356\u4e09");
        basePriceMap.put("-2", "\u5356\u4e8c");
        basePriceMap.put("-1", "\u5356\u4e00");
        basePriceMap.put("1", "\u4e70\u4e00");
        basePriceMap.put("2", "\u4e70\u4e8c");
        basePriceMap.put("3", "\u4e70\u4e09");
        basePriceMap.put("4", "\u4e70\u56db");
        basePriceMap.put("5", "\u4e70\u4e94");
        basePriceMap.put("6", "\u4e70\u516d");
        basePriceMap.put("7", "\u4e70\u4e03");
        basePriceMap.put("8", "\u4e70\u516b");
        basePriceMap.put("9", "\u4e70\u4e5d");
        basePriceMap.put("10", "\u4e70\u5341");
        basePriceMap.put("0", "\u6700\u65b0");
        basePriceMap.put(BASE_AVG, "\u6302\u5355\u5747\u4ef7");
        basePriceMap.put(BASE_ASSIGN, "\u6307\u5b9a\u4ef7");
        return basePriceMap;
    }

    private void createMarketTable() {
        this.indexBuy.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u4e70").append(StringUtils.numToChinese((int)(this.tableMarketBuy.getItems().indexOf(p.getValue()) + 1))))));
        this.mktBuyPrice.setCellFactory(cell -> new PriceCell(this.mktItem));
        this.mktBuyPrice.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).priceStrProperty());
        this.colBuyCount.setCellFactory(cell -> new HandicapCountCell(this.mktItem));
        this.colBuyCount.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).countProperty());
        this.tableMarketBuy.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.onItemBuySelected((HandicapInfo)now));
        this.tableMarketBuy.setItems(this.mktItem.getListBuyHandicap());
        this.tableMarketBuy.setPlaceholder((Node)new Label());
        this.indexSell.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u5356").append(StringUtils.numToChinese((int)(this.tableMarketSell.getItems().size() - this.tableMarketSell.getItems().indexOf(p.getValue())))))));
        this.mktSellPrice.setCellFactory(cell -> new PriceCell(this.mktItem));
        this.mktSellPrice.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).priceStrProperty());
        this.colSellCount.setCellFactory(cell -> new HandicapCountCell(this.mktItem));
        this.colSellCount.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).countProperty());
        this.tableMarketSell.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.onItemSellSelected((HandicapInfo)now));
        this.tableMarketSell.setItems((ObservableList)this.mktItem.getListSellHandicap().sorted((h1, h2) -> h1.getIndex() > h2.getIndex() ? -1 : 1));
        this.tableMarketSell.setPlaceholder((Node)new Label());
        this.lbLatest.setOnMouseClicked(event -> this.setNowPrice(this.mktItem.getNowPrice()));
        this.lbUpLimit.setOnMouseClicked(event -> this.setPrice(this.mktItem.getUpLimitPrice()));
        this.lbDownLimit.setOnMouseClicked(event -> this.setPrice(this.mktItem.getDownLimitPrice()));
        MxBindings.bindVisible((Control)this.lbLatest, (ObservableBooleanValue)this.mktItem.clearProperty().not());
        MxBindings.bindVisible((Control)this.lbUpLimit, (ObservableBooleanValue)this.mktItem.clearProperty().not());
        MxBindings.bindVisible((Control)this.lbRate, (ObservableBooleanValue)this.mktItem.clearProperty().not());
        MxBindings.bindVisible((Control)this.lbDownLimit, (ObservableBooleanValue)this.mktItem.clearProperty().not());
        MxBindings.percentBinding((Property)this.lbRate.textProperty(), (ObservableNumberValue)this.mktItem.pctProperty(), (int)2);
        CssUtils.makeRise((Control)this.lbUpLimit);
        CssUtils.makeFall((Control)this.lbDownLimit);
        this.mktItem.changedProperty().addListener(obs -> {
            if (this.mktItem.getRefItem() != null) {
                if (this.cmbBase.getSelectionModel().getSelectedItem() != null) {
                    this.buildBasePrice(((BasePrice)this.cmbBase.getSelectionModel().getSelectedItem()).getKey());
                } else {
                    this.cmbBase.getSelectionModel().select((Object)this.baseMap.get(BASE_AVG));
                    this.buildBasePrice(BASE_AVG);
                }
            }
            CssUtils.checkPrice((Control)this.lbLatest, (double)this.mktItem.getClosePrice(), (double)this.mktItem.getNowPrice());
            CssUtils.checkPrice((Control)this.lbRate, (double)this.mktItem.getClosePrice(), (double)this.mktItem.getNowPrice());
        });
    }

    private void buildBasePrice(String now) {
        switch (now) {
            case "20": {
                double priceSell = ((HandicapInfo)this.tableMarketSell.getItems().get(9)).getPrice();
                double priceBuy = ((HandicapInfo)this.tableMarketBuy.getItems().get(0)).getPrice();
                double d = (priceSell + priceBuy) / 2.0;
                if (!(d > 0.0)) break;
                this.model.setBasePrice(Double.valueOf(String.format("%." + this.mktItem.getRefItem().getScale() + "f", d)));
                break;
            }
            case "-10": {
                double sellTen = ((HandicapInfo)this.tableMarketSell.getItems().get(0)).getPrice();
                this.setPrice(Double.valueOf(String.format("%." + this.mktItem.getRefItem().getScale() + "f", sellTen)));
                break;
            }
            case "-9": {
                double sellNine = ((HandicapInfo)this.tableMarketSell.getItems().get(1)).getPrice();
                this.setPrice(Double.valueOf(String.format("%." + this.mktItem.getRefItem().getScale() + "f", sellNine)));
                break;
            }
            case "-8": {
                double sellEight = ((HandicapInfo)this.tableMarketSell.getItems().get(2)).getPrice();
                this.setPrice(Double.valueOf(String.format("%." + this.mktItem.getRefItem().getScale() + "f", sellEight)));
                break;
            }
            case "-7": {
                double sellSeven = ((HandicapInfo)this.tableMarketSell.getItems().get(3)).getPrice();
                this.setPrice(Double.valueOf(String.format("%." + this.mktItem.getRefItem().getScale() + "f", sellSeven)));
                break;
            }
            case "-6": {
                double sellSix = ((HandicapInfo)this.tableMarketSell.getItems().get(4)).getPrice();
                this.setPrice(Double.valueOf(String.format("%." + this.mktItem.getRefItem().getScale() + "f", sellSix)));
                break;
            }
            case "-5": {
                double sellFive = ((HandicapInfo)this.tableMarketSell.getItems().get(5)).getPrice();
                this.setPrice(Double.valueOf(String.format("%." + this.mktItem.getRefItem().getScale() + "f", sellFive)));
                break;
            }
            case "-4": {
                double sellfour = ((HandicapInfo)this.tableMarketSell.getItems().get(6)).getPrice();
                this.setPrice(Double.valueOf(String.format("%." + this.mktItem.getRefItem().getScale() + "f", sellfour)));
                break;
            }
            case "-3": {
                double sellThree = ((HandicapInfo)this.tableMarketSell.getItems().get(7)).getPrice();
                this.setPrice(Double.valueOf(String.format("%." + this.mktItem.getRefItem().getScale() + "f", sellThree)));
                break;
            }
            case "-2": {
                double sellTwo = ((HandicapInfo)this.tableMarketSell.getItems().get(8)).getPrice();
                this.setPrice(Double.valueOf(String.format("%." + this.mktItem.getRefItem().getScale() + "f", sellTwo)));
                break;
            }
            case "-1": {
                double sellOne = ((HandicapInfo)this.tableMarketSell.getItems().get(9)).getPrice();
                this.setPrice(Double.valueOf(String.format("%." + this.mktItem.getRefItem().getScale() + "f", sellOne)));
                break;
            }
            case "0": {
                double nowPrice = this.mktItem.getNowPrice();
                this.model.setBasePrice(Double.valueOf(String.format("%." + this.mktItem.getRefItem().getScale() + "f", nowPrice)));
                break;
            }
            case "1": {
                double buyOne = ((HandicapInfo)this.tableMarketBuy.getItems().get(0)).getPrice();
                this.setPrice(Double.valueOf(String.format("%." + this.mktItem.getRefItem().getScale() + "f", buyOne)));
                break;
            }
            case "2": {
                double buyTwo = ((HandicapInfo)this.tableMarketBuy.getItems().get(1)).getPrice();
                this.setPrice(Double.valueOf(String.format("%." + this.mktItem.getRefItem().getScale() + "f", buyTwo)));
                break;
            }
            case "3": {
                double buyThree = ((HandicapInfo)this.tableMarketBuy.getItems().get(2)).getPrice();
                this.setPrice(Double.valueOf(String.format("%." + this.mktItem.getRefItem().getScale() + "f", buyThree)));
                break;
            }
            case "4": {
                double buyFour = ((HandicapInfo)this.tableMarketBuy.getItems().get(3)).getPrice();
                this.setPrice(Double.valueOf(String.format("%." + this.mktItem.getRefItem().getScale() + "f", buyFour)));
                break;
            }
            case "5": {
                double buyFive = ((HandicapInfo)this.tableMarketBuy.getItems().get(4)).getPrice();
                this.setPrice(Double.valueOf(String.format("%." + this.mktItem.getRefItem().getScale() + "f", buyFive)));
                break;
            }
            case "6": {
                double buySix = ((HandicapInfo)this.tableMarketBuy.getItems().get(5)).getPrice();
                this.setPrice(Double.valueOf(String.format("%." + this.mktItem.getRefItem().getScale() + "f", buySix)));
                break;
            }
            case "7": {
                double buySeven = ((HandicapInfo)this.tableMarketBuy.getItems().get(6)).getPrice();
                this.setPrice(Double.valueOf(String.format("%." + this.mktItem.getRefItem().getScale() + "f", buySeven)));
                break;
            }
            case "8": {
                double buyEight = ((HandicapInfo)this.tableMarketBuy.getItems().get(7)).getPrice();
                this.setPrice(Double.valueOf(String.format("%." + this.mktItem.getRefItem().getScale() + "f", buyEight)));
                break;
            }
            case "9": {
                double buyNine = ((HandicapInfo)this.tableMarketBuy.getItems().get(8)).getPrice();
                this.setPrice(Double.valueOf(String.format("%." + this.mktItem.getRefItem().getScale() + "f", buyNine)));
                break;
            }
            case "10": {
                double buyTen = ((HandicapInfo)this.tableMarketSell.getItems().get(9)).getPrice();
                this.setPrice(Double.valueOf(String.format("%." + this.mktItem.getRefItem().getScale() + "f", buyTen)));
                break;
            }
        }
    }

    private void onRefChange() {
        TradeBindings.bindSD((Property)this.lbLatest.textProperty(), (ObservableNumberValue)this.mktItem.nowPriceProperty(), (int)DecimalUtils.getScale((double)this.mktItem.getRefItem().getPriceUnit()));
        TradeBindings.bindSD((Property)this.lbUpLimit.textProperty(), (ObservableNumberValue)this.mktItem.upLimitPriceProperty(), (int)DecimalUtils.getScale((double)this.mktItem.getRefItem().getPriceUnit()));
        TradeBindings.bindSD((Property)this.lbDownLimit.textProperty(), (ObservableNumberValue)this.mktItem.downLimitPriceProperty(), (int)DecimalUtils.getScale((double)this.mktItem.getRefItem().getPriceUnit()));
        this.spnBasePrice.getEditor().setText("0.000");
        this.spnPriceBuy.getEditor().setText("0.000");
        this.spnPriceSell.getEditor().setText("0.000");
        this.ctrlBasePrice.setScale(this.mktItem.getRefItem().getScale());
        this.ctrlDiffBuy.setScale(this.mktItem.getRefItem().getScale());
        this.ctrlDiffSell.setScale(this.mktItem.getRefItem().getScale());
        this.ctrlPriceBuy.setScale(this.mktItem.getRefItem().getScale());
        this.ctrlPriceSell.setScale(this.mktItem.getRefItem().getScale());
    }

    private void loseFocus(Boolean val) {
        if (!val.booleanValue() && this.txtCode.getText().length() > 0) {
            this.check();
        } else if (val.booleanValue()) {
            Platform.runLater(() -> this.txtCode.selectAll());
        }
    }

    protected void onSecurityChange() {
        this.refItem = (RefItem)this.txtCode.getUserData();
        if (this.refItem == null && this.model.getMI().getRefItem() == null) {
            return;
        }
        this.model.getMI().setRefItem(this.refItem);
        this.model.onSecChange();
        if (this.refItem != null) {
            this.txtCode.textProperty().set((Object)this.refItem.getCode());
            this.txtCode.selectEnd();
            this.txtCode.deselect();
        }
        this.getFilterSecAccntList();
        if (this.txtCode.getText().length() >= 6 && this.refItem == null) {
            this.check();
        }
    }

    private void getFilterSecAccntList() {
        ArrayList<SecAccount> listTemp = new ArrayList<SecAccount>();
        if (this.refItem != null) {
            for (SecAccount sec : this.secListCopy) {
                if (!sec.getExchange().getRaw().equals(this.refItem.getMarket())) continue;
                listTemp.add(sec);
            }
            this.secList.clear();
            this.secList.addAll(listTemp);
        } else {
            this.secList.clear();
            this.secList.addAll(this.secListCopy);
        }
        if (this.secList.contains((Object)this.oldSH)) {
            this.cmbSecAcct.getSelectionModel().select((Object)this.oldSH);
        } else if (this.secList.contains((Object)this.oldSZ)) {
            this.cmbSecAcct.getSelectionModel().select((Object)this.oldSZ);
        } else if (!(StringUtils.isEmpty((String)this.preModel.getSecAccnt()) || this.txtCode.isFocused() || this.cmbAcct.isFocused() || this.cmbSecAcct.isFocused())) {
            this.cmbSecAcct.getSelectionModel().select((Object)this.mapSec.get(this.preModel.getSecAccnt()));
        } else {
            this.cmbSecAcct.getSelectionModel().select(0);
        }
    }

    private void check() {
        RefItem ref = this.mktItem.getRefItem();
        if (ref == null || ref.getName().equals("") || !ref.getType().equals(this.model.getTradeType())) {
            this.lbName.setText(INVALID_CODE);
        } else if (this.mktItem.getStop().getValue().booleanValue()) {
            this.lbName.setText(this.mktItem.getStatus());
        }
    }

    public boolean valid() {
        return this.checkVaild();
    }

    private boolean checkVaild() {
        this.setOrderPriceBuy(this.model.getPriceBuy());
        this.setOrderPriceSell(this.model.getPriceSell());
        boolean flag = this.alert.check(this.refMng.getItem(this.model.getMarket(), this.txtCode.getText()) != null && this.mktItem.getRefItem().getType().equals(this.model.getTradeType()), Alert.AlertType.WARNING, "\u8bf7\u8f93\u5165\u6709\u6548\u4ee3\u7801") && this.alert.check(this.mktItem.getStop().getValue() == false, Alert.AlertType.WARNING, "\u8bc1\u5238\u505c\u724c") && this.alert.check(this.model.getPriceSell() != this.model.getPriceBuy(), Alert.AlertType.WARNING, "\u6709\u81ea\u6210\u4ea4\u98ce\u9669\uff0c\u7981\u6b62\u4e0b\u5355") && this.alert.check(this.model.getPriceBuy() >= this.mktItem.getDownLimitPrice(), Alert.AlertType.WARNING, "\u4e70\u5165\u4ef7\u683c\u4f4e\u4e8e\u8dcc\u505c\u4ef7") && this.alert.check(this.model.getPriceBuy() >= this.mktItem.getDownLimitPrice(), Alert.AlertType.WARNING, "\u4e70\u5165\u4ef7\u683c\u4f4e\u4e8e\u8dcc\u505c\u4ef7") && this.alert.check(this.model.getPriceBuy() <= this.mktItem.getUpLimitPrice(), Alert.AlertType.WARNING, "\u4e70\u5165\u4ef7\u683c\u9ad8\u4e8e\u6da8\u505c\u4ef7") && this.alert.check(this.model.getPriceSell() >= this.mktItem.getDownLimitPrice(), Alert.AlertType.WARNING, "\u5356\u51fa\u4ef7\u683c\u4f4e\u4e8e\u8dcc\u505c\u4ef7") && this.alert.check(this.model.getPriceSell() <= this.mktItem.getUpLimitPrice(), Alert.AlertType.WARNING, "\u5356\u51fa\u4ef7\u683c\u9ad8\u4e8e\u6da8\u505c\u4ef7") && this.alert.check(this.model.getFundAcct() != null, Alert.AlertType.WARNING, "\u672a\u9009\u62e9\u8d44\u91d1\u8d26\u53f7") && this.alert.check(this.model.getSecAcct() != null, Alert.AlertType.WARNING, "\u672a\u9009\u62e9\u8bc1\u5238\u8d26\u53f7") && this.alert.check(this.preModel.getBuyQuantity() >= 100L, Alert.AlertType.WARNING, "\u4e70\u5165\u6570\u91cf\u4e0d\u5408\u6cd5") && this.alert.check(this.preModel.getSellQuantity() >= 100L, Alert.AlertType.WARNING, "\u5356\u51fa\u6570\u91cf\u4e0d\u5408\u6cd5") && this.alert.check(this.model.getPriceSell() > this.model.getPriceBuy(), Alert.AlertType.WARNING, "\u5356\u51fa\u4ef7\u683c\u5e94\u5927\u4e8e\u4e70\u5165\u4ef7\u683c");
        return flag;
    }

    private Instrument getInstrument() {
        Instrument instrument = new Instrument();
        instrument.setSecId(this.model.getSecurity());
        RefItem item = this.ref.getItem(this.model.getMarket(), this.model.getSecurity());
        this.node.setRaw(item.getMarket());
        instrument.setMarket(this.node);
        instrument.setSecType(item.getType());
        return instrument;
    }

    private List<EtfEntrustConfirmParam> getComfirmParam() {
        ObservableList list = FxUtils.newList();
        String accnt = (String)this.cmbAcct.getSelectionModel().getSelectedItem();
        String secAccnt = "";
        if (this.cmbSecAcct.getSelectionModel().getSelectedItem() != null) {
            secAccnt = this.cmbSecAcct.getSelectionModel().getSelectedItem() instanceof SecAccount ? ((SecAccount)this.cmbSecAcct.getSelectionModel().getSelectedItem()).getExtSecAccntId() : String.valueOf(this.cmbSecAcct.getSelectionModel().getSelectedItem());
        }
        EtfEntrustConfirmParam buyParam = new EtfEntrustConfirmParam();
        buyParam.setAccnt(accnt);
        buyParam.setSecAccnt(secAccnt);
        buyParam.setSide(49);
        buyParam.setMarket(this.model.getMarket());
        buyParam.setTxtcode(this.txtCode.getText());
        buyParam.setLbName(this.lbName.getText());
        buyParam.setBuyPrice(this.getOrderPriceBuy());
        buyParam.setBuyCount(Double.valueOf(this.preModel.getBuyQuantity()));
        EtfEntrustConfirmParam sellParam = new EtfEntrustConfirmParam();
        sellParam.setAccnt(accnt);
        sellParam.setSecAccnt(secAccnt);
        sellParam.setSide(50);
        sellParam.setMarket(this.model.getMarket());
        sellParam.setTxtcode(this.txtCode.getText());
        sellParam.setLbName(this.lbName.getText());
        sellParam.setSellPrice(this.getOrderPriceSell());
        sellParam.setSellCount(Double.valueOf(this.preModel.getSellQuantity()));
        list.add((Object)buyParam);
        list.add((Object)sellParam);
        return list;
    }

    @FXML
    public void order() {
        if (this.valid()) {
            if (this.preModel.isPopBeforeOrder()) {
                EtfEntrustConfirmDialog obj = (EtfEntrustConfirmDialog)((Object)this.of.create(EtfEntrustConfirmDialog.class));
                obj.setParamList(this.getComfirmParam());
                MxDialog dialog = this.df.create((DialogObj)obj, "\u4e0b\u5355\u786e\u8ba4");
                if (dialog.launch() == ButtonType.OK) {
                    this.submitOrder();
                }
            } else {
                this.submitOrder();
            }
        }
    }

    private void submitOrder() {
        LinkedList<CrossOrder> newList = new LinkedList<CrossOrder>();
        ObservableList returnList = FxUtils.newList();
        try {
            newList.addAll(this.etfMng.queryOrder(false));
            List mapList = (List)this.map.get((Object)(String.valueOf(this.model.getSecAcct().getExtSecAccntId()) + this.model.getSecurity()));
            if (mapList != null) {
                this.oldList.clear();
                this.oldList.addAll(mapList);
                if (!this.oldList.isEmpty()) {
                    this.isOldOrder = true;
                    newList.forEach(newItem -> {
                        if (!this.oldList.contains(newItem)) {
                            this.isOldOrder = false;
                        }
                    });
                    if (this.isOldOrder) {
                        this.alert.alert(Alert.AlertType.WARNING, "\u64cd\u4f5c\u9891\u7e41,\u8bf7\u7a0d\u540e\u91cd\u4e0b\n\u82e5\u7b49\u5f85\u65f6\u95f4\u8fc7\u957f,\u5219\u53ef\u80fd\u51fa\u73b0\u4e22\u5305\u60c5\u51b5,\u8bf7\u4f7f\u7528\u5f3a\u5236\u4e0b\u5355\u6309\u94ae");
                        return;
                    }
                }
            }
            if (newList.isEmpty()) {
                this.submit(this.getInstrument(), newList);
            } else {
                this.checkOrders(newList);
                if (this.legPendingOrders.size() > 1) {
                    this.alert.alert(Alert.AlertType.WARNING, "\u5b58\u5728\u591a\u7b14\u672a\u5b8c\u6210\u505a\u5e02\u5355,\u8bf7\u5148\u624b\u52a8\u64a4\u5355");
                    return;
                }
                if (this.legOverOrders.size() == newList.size()) {
                    this.submit(this.getInstrument(), newList);
                } else if (this.legPendingOrders.size() > 0) {
                    CrossOrder crossOrder = (CrossOrder)this.legPendingOrders.get(0);
                    if (this.checkOrderStatus(crossOrder.getOrdStatus())) {
                        this.alert.alert(Alert.AlertType.WARNING, "\u5df2\u5b58\u5728\u672a\u5b8c\u6210\u7684\u64a4\u5355\u8bf7\u6c42\uff0c\u82e5\u957f\u65f6\u95f4\u6ca1\u6709\u54cd\u5e94\uff0c\u8bf7\u624b\u5de5\u5bf9\u59d4\u6258\u5355\u8fdb\u884c\u64a4\u5355");
                        return;
                    }
                    this.cancelReplace((List<CrossOrder>)this.legPendingOrders, this.getInstrument(), (List<CrossOrder>)newList);
                } else {
                    this.submit(this.getInstrument(), newList);
                }
            }
            returnList.add((Object)true);
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            returnList.add((Object)false);
            return;
        }
        this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.INFORMATION, "\u4e0b\u5355\u63d0\u4ea4\u6210\u529f" + returnList.filtered(each -> each).size() + "\u7b14" + " " + "\u5931\u8d25" + returnList.filtered(each -> each == false).size() + "\u7b14");
    }

    private void checkOrders(List<CrossOrder> newList) {
        this.legOverOrders.clear();
        this.legPendingOrders.clear();
        for (CrossOrder order : newList) {
            String subId = this.model.getSecAcct().getExtSecAccntId();
            if (!order.getCode().equals(this.txtCode.getText()) || !subId.equals(order.getSecAccntId()) || !order.getModeType().equals("EXEC_MODE_TYPE_MANUAL")) continue;
            if (order.getSortNum() == 2) {
                this.legOverOrders.add((Object)order);
                continue;
            }
            this.legPendingOrders.add((Object)order);
        }
    }

    private void cancelReplace(List<CrossOrder> orderList, Instrument instrument, List<CrossOrder> newList) throws MException {
        this.model.cancelReplace(this.model.getFundAcct().getExtAccntId(), this.model.getSecAcct().getExtSecAccntId(), this.getOrderPriceBuy(), (int)this.preModel.getBuyQuantity(), this.getOrderPriceSell(), (int)this.preModel.getSellQuantity(), instrument, orderList.get(0));
        this.map.put((Object)(String.valueOf(this.model.getSecAcct().getExtSecAccntId()) + this.model.getSecurity()), newList);
    }

    private void submit(Instrument instrument, List<CrossOrder> newList) throws MException {
        this.model.submit(this.model.getFundAcct().getExtAccntId(), this.model.getSecAcct().getExtSecAccntId(), this.getOrderPriceBuy(), (int)this.preModel.getBuyQuantity(), this.getOrderPriceSell(), (int)this.preModel.getSellQuantity(), instrument);
        if (newList != null) {
            this.map.put((Object)(String.valueOf(this.model.getSecAcct().getExtSecAccntId()) + this.model.getSecurity()), newList);
        }
    }

    @FXML
    public void forceOrder() {
        if (this.valid()) {
            try {
                boolean flag = this.alert.alert(Alert.AlertType.CONFIRMATION, "\u786e\u5b9a\u8981\u5f3a\u5236\u4e0b\u5355?");
                if (!flag) {
                    return;
                }
                this.submit(this.getInstrument(), null);
            }
            catch (MException e) {
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            }
        }
    }

    public void codeKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            this.spnBasePrice.requestFocus();
            this.preModel.selectTwoOrAllPriceDecimal();
            key.consume();
        }
    }

    public void basePricePress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            this.spnDiffBuy.requestFocus();
            this.preModel.selectTwoOrAllPriceDecimal();
            key.consume();
        }
    }

    public void diffBuyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            this.spnDiffSell.requestFocus();
            this.preModel.selectTwoOrAllPriceDecimal();
            key.consume();
        }
    }

    public void diffSellPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            this.spnPriceBuy.requestFocus();
            this.preModel.selectTwoOrAllPriceDecimal();
            key.consume();
        }
    }

    private void priceBuyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            this.spnPriceSell.requestFocus();
            this.preModel.selectTwoOrAllPriceDecimal();
            key.consume();
        }
    }

    private void priceSellPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            this.spnQtyBuy.requestFocus();
            TextFieldUtils.selectTwoOrAllPriceDecimal((boolean)true, (TextField)this.spnQtyBuy.getEditor());
            key.consume();
        }
    }

    private void qtyBuyKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            this.spnQtySell.requestFocus();
            TextFieldUtils.selectTwoOrAllPriceDecimal((boolean)true, (TextField)this.spnQtySell.getEditor());
            key.consume();
        }
    }

    private void qtySellKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.txtCode.requestFocus();
            this.txtCode.selectAll();
            key.consume();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.order();
            this.txtCode.requestFocus();
            key.consume();
        }
    }

    private double getDouble(String txt) {
        return txt.isEmpty() ? 0.0 : StringUtils.parseDouble((String)txt);
    }

    private double correctDouble(double d) {
        return d < 0.0 ? 0.0 : d;
    }

    private void onItemBuySelected(HandicapInfo now) {
        if (now != null) {
            this.setPrice(now.getPrice());
            this.cmbBase.getSelectionModel().select((Object)this.baseMap.get(String.valueOf(now.getIndex())));
            Platform.runLater(() -> this.clearSelection());
        }
    }

    private void onItemSellSelected(HandicapInfo now) {
        if (now != null) {
            this.setPrice(now.getPrice());
            this.cmbBase.getSelectionModel().select((Object)this.baseMap.get(String.valueOf("-" + now.getIndex())));
            Platform.runLater(() -> this.clearSelection());
        }
    }

    public double getOrderPriceBuy() {
        return this.orderPriceBuy;
    }

    public void setOrderPriceBuy(double orderPriceBuy) {
        this.orderPriceBuy = orderPriceBuy;
    }

    public double getOrderPriceSell() {
        return this.orderPriceSell;
    }

    public void setOrderPriceSell(double orderPriceSell) {
        this.orderPriceSell = orderPriceSell;
    }

    private void clearSelection() {
        this.tableMarketBuy.getSelectionModel().clearSelection();
        this.tableMarketSell.getSelectionModel().clearSelection();
    }

    private void setPrice(double price) {
        if (price > 0.0) {
            this.spnBasePrice.getValueFactory().setValue((Object)price);
            this.model.setBasePrice(price);
        } else {
            this.spnBasePrice.getEditor().setText("");
            this.spnPriceBuy.getEditor().setText("");
            this.spnPriceSell.getEditor().setText("");
        }
    }

    private void setNowPrice(double price) {
        if (price > 0.0) {
            this.model.setBasePrice(price);
            this.cmbBase.getSelectionModel().select((Object)this.baseMap.get("0"));
        }
    }

    @Override
    public IEtfTradeModel getModel() {
        return this.model;
    }

    @Override
    public EtfManualTradeModel createModel() {
        return (EtfManualTradeModel)this.of.create(EtfManualTradeModel.class);
    }

    public void initUserPre() {
        this.preModel.setType("2", "200006");
        this.preModel.setEtfTrade(this);
        try {
            this.preModel.doSet();
        }
        catch (MException mException) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u67e5\u8be2\u7528\u6237\u8bbe\u7f6e\u5931\u8d25"));
        }
    }

    public Spinner<Double> getSpnBasePrice() {
        return this.spnBasePrice;
    }

    public void setSpnBasePrice(Spinner<Double> spnBasePrice) {
        this.spnBasePrice = spnBasePrice;
    }

    public Spinner<Double> getSpnDiffBuy() {
        return this.spnDiffBuy;
    }

    public void setSpnDiffBuy(Spinner<Double> spnDiffBuy) {
        this.spnDiffBuy = spnDiffBuy;
    }

    public Spinner<Double> getSpnDiffSell() {
        return this.spnDiffSell;
    }

    public void setSpnDiffSell(Spinner<Double> spnDiffSell) {
        this.spnDiffSell = spnDiffSell;
    }

    public Spinner<Double> getSpnPriceBuy() {
        return this.spnPriceBuy;
    }

    public void setSpnPriceBuy(Spinner<Double> spnPriceBuy) {
        this.spnPriceBuy = spnPriceBuy;
    }

    public Spinner<Double> getSpnPriceSell() {
        return this.spnPriceSell;
    }

    public void setSpnPriceSell(Spinner<Double> spnPriceSell) {
        this.spnPriceSell = spnPriceSell;
    }

    public Spinner<Integer> getSpnQtyBuy() {
        return this.spnQtyBuy;
    }

    public void setSpnQtyBuy(Spinner<Integer> spnQtyBuy) {
        this.spnQtyBuy = spnQtyBuy;
    }

    public Spinner<Integer> getSpnQtySell() {
        return this.spnQtySell;
    }

    public void setSpnQtySell(Spinner<Integer> spnQtySell) {
        this.spnQtySell = spnQtySell;
    }
}

