/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.fund.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.Search;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.HandicapCountCell;
import cms.tmx.data.utils.PriceCell;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.datatype.proto.strategy.PStrategyMonitor;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.MonitHandicapInfo;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.Indicator;
import cms.tmx.fund.models.EtfMonitMarketModel;
import cms.tmx.fund.models.StrategyMonitorMng;
import cms.tmx.fund.models.UserEtfMonitPreCtrl;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.models.CcsUnfinishedOrderModel;
import cms.tmx.trade.utils.TradeBindings;
import cms.tmx.utils.DecimalUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EtfMonitMarketPart
extends MxPart {
    @FXML
    private TextField txtCode;
    @FXML
    private Label lbName;
    @FXML
    private Label lbRate;
    @FXML
    private Label lbLatest;
    @FXML
    private Label lbUpLimit;
    @FXML
    private Label lbDownLimit;
    @FXML
    private TableColumn<String, String> indexBuy;
    @FXML
    private TableColumn<String, String> indexSell;
    @FXML
    private TableView<MonitHandicapInfo> tableMarketSell2;
    @FXML
    private TableColumn<MonitHandicapInfo, String> mktSellPrice;
    @FXML
    private TableColumn<MonitHandicapInfo, Number> colSellCount;
    @FXML
    private TableColumn<MonitHandicapInfo, String> colSellOrder;
    @FXML
    private TableColumn<MonitHandicapInfo, String> colBuyOrder;
    @FXML
    private TableView<MonitHandicapInfo> tableMarketBuy2;
    @FXML
    private TableColumn<MonitHandicapInfo, String> mktBuyPrice;
    @FXML
    private TableColumn<MonitHandicapInfo, Number> colBuyCount;
    @FXML
    private Label lbCountOne;
    @FXML
    private Label lbCountTwo;
    @FXML
    private Label lbCountThree;
    @FXML
    private Label lbCountFour;
    @FXML
    private ComboBox<String> cmbAcct;
    @FXML
    private Button btnOrder;
    @FXML
    private HBox forceBtnBox;
    @FXML
    private Label forceToggle;
    @Inject
    private ExecutorService exe;
    @Inject
    protected UserEtfMonitPreCtrl preModel;
    @Inject
    private EtfMonitMarketModel model;
    @Inject
    @Named(value="core_event")
    protected MEvent eCore;
    @Inject
    private IRefDataMng refMng;
    @Inject
    protected MEventService es;
    @Inject
    private CcsUnfinishedOrderModel ccsOrderModel;
    @Inject
    private IFundAccountService fundAccMng;
    @Inject
    private MObjFactory of;
    private double orderPriceBuy;
    private double orderPriceSell;
    protected SecSuggest.StrSuggest spFund = SecSuggest.getStrSuggest();
    @Inject
    @Named(value="base.path")
    private String pathBase;
    @Inject
    protected DialogFactory df;
    private static final String INVALID_CODE = "\u65e0\u6548\u4ee3\u7801";
    private MarketItem mktItem;
    private SecSuggest spCode = new SecSuggest();
    private static final double INITPRICE = 0.0;
    private SecConverter secCvt;
    private Map<String, Integer> orderMap = FxUtils.newMap();
    private RefItem refItem = null;
    private static int BUY_SIDE = 49;
    private static int SELL_SIDE = 50;
    private Future<?> future;
    @FXML
    private TableView<Indicator> monitTable;
    @Inject
    private ScheduledExecutorService ses;
    @FXML
    private TableColumn<Indicator, Number> colorAlert;
    private Map<String, FundAccount> mapFund = new HashMap<String, FundAccount>(1000);
    @FXML
    private TableColumn<Indicator, String> realtimeValue;
    @FXML
    private TableColumn<Indicator, String> gearOne;
    @FXML
    private TableColumn<Indicator, String> gearTwo;
    private MxList<Indicator> mlist = new MxList();
    @Inject
    private StrategyMonitorMng monitorMng;
    @Inject
    private MxAlert alert;
    private static final Logger logger = LogManager.getLogger(EtfMonitMarketPart.class);
    private InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        this.mlist.update(this.monitorMng.getList(), p -> true);
        this.monitTable.refresh();
    });
    private static final String QUOTE_TIME_IN_DAY = "1";
    private static final String CONSECUTIVE_BIDDING_TIME = "2";
    private static final String CONSECUTIVE_BIDDING_RADIO = "3";
    private static final String NO_OFFER_UNILATERAL_WIDTH = "4";
    private static final String PRICE_GAP_WIDTH = "5";
    private InvalidationListener lstnMarketItem = ob -> Platform.runLater(() -> this.onRefChange());
    private InvalidationListener lstnMarketItem2 = ob -> Platform.runLater(() -> this.MonitOnRefChange());
    private InvalidationListener lstnRefMng = ob -> {
        Collection list = this.refMng.getItems(new String[]{this.model.getTradeType()});
        this.spCode.setAllSuggestions(list);
    };

    @FXML
    public void forceToggle() {
        String toggleStyleClassUp = this.forceBtnBox.isVisible() ? "forceToggleUp" : "forceToggleDown";
        String toggleStyleClassDown = this.forceBtnBox.isVisible() ? "forceToggleDown" : "forceToggleUp";
        this.forceToggle.getStyleClass().removeAll((Object[])new String[]{toggleStyleClassUp});
        this.forceToggle.getStyleClass().add((Object)toggleStyleClassDown);
        this.forceBtnBox.setVisible(!this.forceBtnBox.isVisible());
    }

    @FXML
    public void initialize() {
        this.initUserPre();
        this.mktItem = this.model.getMI();
        this.mktItem.refItemProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnMarketItem));
        this.refMng.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnRefMng));
        this.mktItem.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnMarketItem2));
        this.ccsOrderModel.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnMarketItem2));
        this.initControls();
        this.createMarketTable();
        this.initUnfinishedOrder();
        this.createMonitView();
        this.monitorMng.changedProperty().addListener(this.lstnModel);
        this.future = this.ses.scheduleAtFixedRate(() -> this.refresh(), 0L, 2L, TimeUnit.SECONDS);
    }

    private void createMonitView() {
        this.addViwer(this.monitTable);
        this.monitTable.setPlaceholder((Node)new Label());
        TableUtils.initValueFactory(this.monitTable);
        this.realtimeValue.setCellValueFactory(data -> this.getCellValueFactory((Indicator)data.getValue(), ((Indicator)data.getValue()).getRealtimeValue()));
        this.gearOne.setCellValueFactory(data -> this.getCellValueFactory((Indicator)data.getValue(), ((Indicator)data.getValue()).getValue1()));
        this.gearTwo.setCellValueFactory(data -> this.getCellValueFactory((Indicator)data.getValue(), ((Indicator)data.getValue()).getValue2()));
        this.gearOne.setCellFactory(cell -> new StyleTableCell());
        this.monitTable.setItems(this.mlist.getList());
    }

    private ObservableValue<String> getCellValueFactory(Indicator i, double value) {
        SimpleStringProperty str = new SimpleStringProperty();
        int dec = 1;
        if (!StringUtils.belongto((String)i.getIndicator().getRaw(), (String[])new String[]{QUOTE_TIME_IN_DAY, CONSECUTIVE_BIDDING_TIME, CONSECUTIVE_BIDDING_RADIO, NO_OFFER_UNILATERAL_WIDTH, PRICE_GAP_WIDTH})) {
            dec = 4;
        }
        String s = String.format("%." + dec + "f", value);
        if (i.getIndicator().getRaw().equals(CONSECUTIVE_BIDDING_RADIO)) {
            s = String.valueOf(s) + "%";
        }
        str.set((Object)s);
        return str;
    }

    private void refresh() {
        String accountId = (String)this.cmbAcct.getSelectionModel().getSelectedItem();
        try {
            if (this.txtCode.getText().length() == 6 && this.refItem != null && !StringUtils.isEmpty((String)accountId)) {
                this.monitorMng.GetRealTimeMonitior(this.refItem.getMarket(), this.mapFund.get(accountId).getExtAccntId(), this.refItem.getCode());
                this.mlist.setAll(this.monitorMng.getList());
                this.mlist.update(this.monitorMng.getList());
            } else {
                this.mlist.clear();
            }
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    @PreDestroy
    private void close() {
        if (this.future != null) {
            this.future.cancel(true);
        }
    }

    private void initUnfinishedOrder() {
        this.ccsOrderModel.query();
    }

    private void initControls() {
        this.mapFund.clear();
        ObservableList fundStrList = FxUtils.newList();
        for (FundAccount fund : this.fundAccMng.getFundAccountList().filtered(each -> each.getMarketGrp().equals("CCS") && each.getExtAccntId().contains("CNY"))) {
            this.mapFund.put(fund.getInvestId(), fund);
            fundStrList.add((Object)fund.getInvestId());
        }
        this.cmbAcct.setItems(fundStrList);
        if (!StringUtils.isEmpty((String)this.preModel.getFundAccnt()) && fundStrList.contains((Object)this.preModel.getFundAccnt())) {
            this.cmbAcct.getSelectionModel().select((Object)this.preModel.getFundAccnt());
        } else {
            this.cmbAcct.getSelectionModel().select(0);
        }
        FilteredList obList = this.fundAccMng.getFundAccountList().filtered(each -> each.getMarketGrp().equals("CCS") && each.getExtAccntId().contains("CNY"));
        ArrayList spFundList = new ArrayList();
        obList.forEach(m -> spFundList.add(m.getInvestId()));
        this.spFund.addPossibleSuggestions(spFundList);
        Search.bindAutoCompletion((TextField)this.cmbAcct.getEditor(), (Callback)this.spFund);
        this.cmbAcct.getEditor().setTextFormatter((TextFormatter)new MxFormatter("[0-9]+", 16));
        this.cmbAcct.getEditor().textProperty().addListener((ob, old, now) -> {
            this.cmbAcct.getSelectionModel().select(now);
            this.cmbAcct.hide();
            FundAccount fundAcc = this.mapFund.get(now);
            this.model.setFundAcct(fundAcc);
            this.onSecurityChange();
        });
        this.secCvt = (SecConverter)this.of.create(SecConverter.class);
        this.spCode.addPossibleSuggestions(this.refMng.getItems(new String[]{this.model.getTradeType()}));
        Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.spCode, (StringConverter)this.secCvt).changedProperty().addListener((ob, oldV, newV) -> this.onSecurityChange());
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        this.txtCode.focusedProperty().addListener((ob, old, newV) -> this.loseFocus((Boolean)newV));
        this.txtCode.textProperty().bindBidirectional((Property)this.model.securityProperty());
        this.lbName.textProperty().bindBidirectional((Property)this.model.nameProperty());
    }

    private void createMarketTable() {
        this.indexBuy.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u4e70").append(StringUtils.numToChinese((int)(this.tableMarketBuy2.getItems().indexOf(p.getValue()) + 1))))));
        this.mktBuyPrice.setCellFactory(cell -> new PriceCell(this.mktItem));
        this.mktBuyPrice.setCellValueFactory(cell -> ((MonitHandicapInfo)cell.getValue()).priceStrProperty());
        this.colBuyCount.setCellFactory(cell -> new HandicapCountCell(this.mktItem));
        this.colBuyCount.setCellValueFactory(cell -> ((MonitHandicapInfo)cell.getValue()).countProperty());
        this.tableMarketBuy2.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.onItemSelected((HandicapInfo)now));
        this.indexSell.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u5356").append(StringUtils.numToChinese((int)(this.tableMarketSell2.getItems().indexOf(p.getValue()) + 1))))));
        this.mktSellPrice.setCellFactory(cell -> new PriceCell(this.mktItem));
        this.mktSellPrice.setCellValueFactory(cell -> ((MonitHandicapInfo)cell.getValue()).priceStrProperty());
        this.colSellCount.setCellFactory(cell -> new HandicapCountCell(this.mktItem));
        this.colSellCount.setCellValueFactory(cell -> ((MonitHandicapInfo)cell.getValue()).countProperty());
        this.tableMarketSell2.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.onItemSelected((HandicapInfo)now));
        this.colSellOrder.setCellFactory(data -> new AutoTableCell());
        this.colSellOrder.setCellValueFactory(cell -> ((MonitHandicapInfo)cell.getValue()).colOrderCountProperty());
        this.colBuyOrder.setCellFactory(data -> new AutoTableCell());
        this.colBuyOrder.setCellValueFactory(cell -> ((MonitHandicapInfo)cell.getValue()).colOrderCountProperty());
        this.lbLatest.setOnMouseClicked(event -> this.setPrice(this.mktItem.getNowPrice()));
        this.lbUpLimit.setOnMouseClicked(event -> this.setPrice(this.mktItem.getUpLimitPrice()));
        this.lbDownLimit.setOnMouseClicked(event -> this.setPrice(this.mktItem.getDownLimitPrice()));
        MxBindings.bindVisible((Control)this.lbLatest, (ObservableBooleanValue)this.mktItem.clearProperty().not());
        MxBindings.bindVisible((Control)this.lbUpLimit, (ObservableBooleanValue)this.mktItem.clearProperty().not());
        MxBindings.bindVisible((Control)this.lbRate, (ObservableBooleanValue)this.mktItem.clearProperty().not());
        MxBindings.bindVisible((Control)this.lbDownLimit, (ObservableBooleanValue)this.mktItem.clearProperty().not());
        MxBindings.percentBinding((Property)this.lbRate.textProperty(), (ObservableNumberValue)this.mktItem.pctProperty(), (int)2);
        CssUtils.makeRise((Control)this.lbUpLimit);
        CssUtils.makeFall((Control)this.lbDownLimit);
        this.mktItem.changedProperty().addListener(obs -> {
            CssUtils.checkPrice((Control)this.lbLatest, (double)this.mktItem.getClosePrice(), (double)this.mktItem.getNowPrice());
            CssUtils.checkPrice((Control)this.lbRate, (double)this.mktItem.getClosePrice(), (double)this.mktItem.getNowPrice());
        });
    }

    private void onRefChange() {
        TradeBindings.bindSD((Property)this.lbLatest.textProperty(), (ObservableNumberValue)this.mktItem.nowPriceProperty(), (int)DecimalUtils.getScale((double)this.mktItem.getRefItem().getPriceUnit()));
        TradeBindings.bindSD((Property)this.lbUpLimit.textProperty(), (ObservableNumberValue)this.mktItem.upLimitPriceProperty(), (int)DecimalUtils.getScale((double)this.mktItem.getRefItem().getPriceUnit()));
        TradeBindings.bindSD((Property)this.lbDownLimit.textProperty(), (ObservableNumberValue)this.mktItem.downLimitPriceProperty(), (int)DecimalUtils.getScale((double)this.mktItem.getRefItem().getPriceUnit()));
    }

    private void MonitOnRefChange() {
        if (this.mktItem.getRefItem() != null && this.txtCode.getText().equals(this.mktItem.getRefItem().getCode()) && !this.mktItem.getRefItem().getCode().isEmpty()) {
            this.getUnfinishMap();
            this.builderTableMktBuy();
            this.builderTableMktSell();
        }
    }

    private void loseFocus(Boolean val) {
        if (!val.booleanValue() && this.txtCode.getText().length() > 0) {
            this.check();
        } else if (val.booleanValue()) {
            Platform.runLater(() -> this.txtCode.selectAll());
        }
    }

    protected void onSecurityChange() {
        this.refItem = (RefItem)this.txtCode.getUserData();
        this.refresh();
        this.future.isDone();
        this.model.getMI().setRefItem(this.refItem);
        this.model.onSecChange();
        if (this.refItem != null) {
            this.txtCode.textProperty().set((Object)this.refItem.getCode());
            this.txtCode.selectEnd();
            this.txtCode.deselect();
        }
        this.getUnfinishMap();
        this.builderTableMktBuy();
        this.builderTableMktSell();
        if (this.txtCode.getText().length() >= 6 && this.refItem == null) {
            this.check();
        }
    }

    private void getUnfinishMap() {
        this.orderMap.clear();
        String accnt = (String)this.cmbAcct.getSelectionModel().getSelectedItem();
        if (!StringUtils.isEmpty((String)accnt)) {
            Stream<CcsOrder> orderStream = this.ccsOrderModel.getList().stream().filter(e -> e.getInvestorId().equals(accnt) && e.getInstrument().getSecId().equals(this.txtCode.getText()) && !e.getLegMode().getRaw().equals(CONSECUTIVE_BIDDING_TIME) && !e.getParentId().isEmpty());
            List orderList = orderStream.collect(Collectors.toList());
            if (orderList == null) {
                return;
            }
            for (CcsOrder order : orderList) {
                String orderKey = String.valueOf(order.getPrice()) + "_" + order.getSide().getRaw();
                if (this.orderMap.containsKey(orderKey)) {
                    this.orderMap.put(orderKey, this.orderMap.get(orderKey) + order.getOrderQty() / 100);
                    continue;
                }
                this.orderMap.put(orderKey, order.getOrderQty() / 100);
            }
        }
    }

    private void builderTableMktSell() {
        ObservableList monitHandSellInfos = FxUtils.newList();
        ObservableList infoList = FxUtils.newList();
        for (HandicapInfo item : this.mktItem.getListSellHandicap().subList(0, 10)) {
            MonitHandicapInfo sellInfo = new MonitHandicapInfo();
            sellInfo.setIndex(item.getIndex());
            if (this.orderMap.get(String.valueOf(item.getPrice()) + "_" + SELL_SIDE) != null && item.getCount() != -1) {
                sellInfo.setColOrderCount(String.valueOf(this.orderMap.get(String.valueOf(item.getPrice()) + "_" + SELL_SIDE)));
                this.orderMap.remove(String.valueOf(item.getPrice()) + "_" + SELL_SIDE);
            }
            sellInfo.update((Object)item);
            if (item.getCount() == -1) {
                sellInfo.setPrice(-1.0);
                sellInfo.setPriceStr("");
            }
            monitHandSellInfos.add((Object)sellInfo);
            if (!StringUtils.isEmpty((String)sellInfo.getPriceStr()) || sellInfo.getCount() != -1) continue;
            infoList.add((Object)sellInfo);
        }
        int index = 0;
        int extIndex = 11;
        if (this.txtCode.getText().length() == 6) {
            LinkedList<String> list = new LinkedList<String>(this.orderMap.keySet());
            Collections.sort(list, new Comparator<String>(){

                @Override
                public int compare(String arg0, String arg1) {
                    double a1;
                    double a0 = Double.valueOf(arg0.substring(0, arg0.length() - 3));
                    if (a0 >= (a1 = Double.valueOf(arg1.substring(0, arg1.length() - 3)).doubleValue())) {
                        return 1;
                    }
                    return -1;
                }
            });
            for (String keyItem : list) {
                MonitHandicapInfo item;
                if (infoList == null || !keyItem.substring(keyItem.length() - 2, keyItem.length()).equals(String.valueOf(SELL_SIDE))) continue;
                if (index >= infoList.size()) {
                    item = new MonitHandicapInfo();
                    item.setIndex(extIndex);
                    item.setCount(-1);
                    monitHandSellInfos.add((Object)item);
                    ++extIndex;
                } else {
                    item = (MonitHandicapInfo)infoList.get(index);
                }
                item.setPrice(Double.valueOf(keyItem.substring(0, keyItem.length() - 3)).doubleValue());
                item.setPriceStr(keyItem.substring(0, keyItem.length() - 3));
                item.setColOrderCount(String.valueOf(this.orderMap.get(keyItem)));
                if (item.getCount() == 0 && item.getPrice() <= 0.0) {
                    item.setClear(true);
                } else {
                    item.setClear(false);
                }
                ++index;
            }
        }
        this.mktItem.getListSellHandicap().setAll((Collection)monitHandSellInfos);
        if (this.tableMarketSell2.getItems() != null) {
            this.tableMarketSell2.getItems().clear();
            this.tableMarketSell2.getItems().addAll((Collection)monitHandSellInfos);
        } else {
            this.tableMarketSell2.setItems(monitHandSellInfos);
        }
        this.tableMarketSell2.setPlaceholder((Node)new Label());
    }

    private void builderTableMktBuy() {
        ObservableList monitHandBuyInfos = FxUtils.newList();
        ObservableList infoList = FxUtils.newList();
        for (HandicapInfo item : this.mktItem.getListBuyHandicap().subList(0, 10)) {
            MonitHandicapInfo sellInfo = new MonitHandicapInfo();
            sellInfo.setIndex(item.getIndex());
            if (this.orderMap.get(String.valueOf(item.getPrice()) + "_" + BUY_SIDE) != null && item.getCount() != -1) {
                sellInfo.setColOrderCount(String.valueOf(this.orderMap.get(String.valueOf(item.getPrice()) + "_" + BUY_SIDE)));
                this.orderMap.remove(String.valueOf(item.getPrice()) + "_" + BUY_SIDE);
            }
            sellInfo.update((Object)item);
            if (item.getCount() == -1) {
                sellInfo.setPrice(-1.0);
                sellInfo.setPriceStr("");
            }
            monitHandBuyInfos.add((Object)sellInfo);
            if (!StringUtils.isEmpty((String)sellInfo.getPriceStr()) || sellInfo.getCount() != -1) continue;
            infoList.add((Object)sellInfo);
        }
        int index = 0;
        int extIndex = 11;
        if (this.txtCode.getText().length() == 6) {
            LinkedList<String> list = new LinkedList<String>(this.orderMap.keySet());
            Collections.sort(list, new Comparator<String>(){

                @Override
                public int compare(String arg0, String arg1) {
                    double a1;
                    double a0 = Double.valueOf(arg0.substring(0, arg0.length() - 3));
                    if (a0 <= (a1 = Double.valueOf(arg1.substring(0, arg1.length() - 3)).doubleValue())) {
                        return 1;
                    }
                    return -1;
                }
            });
            for (String keyItem : list) {
                MonitHandicapInfo item;
                if (infoList == null || !keyItem.substring(keyItem.length() - 2, keyItem.length()).equals(String.valueOf(BUY_SIDE))) continue;
                if (index >= infoList.size()) {
                    item = new MonitHandicapInfo();
                    item.setIndex(extIndex);
                    item.setCount(-1);
                    monitHandBuyInfos.add((Object)item);
                    ++extIndex;
                } else {
                    item = (MonitHandicapInfo)infoList.get(index);
                }
                item.setPrice(Double.valueOf(keyItem.substring(0, keyItem.length() - 3)).doubleValue());
                item.setPriceStr(keyItem.substring(0, keyItem.length() - 3));
                item.setColOrderCount(String.valueOf(this.orderMap.get(keyItem)));
                if (item.getCount() == 0 && item.getPrice() <= 0.0) {
                    item.setClear(true);
                } else {
                    item.setClear(false);
                }
                ++index;
            }
        }
        if (this.tableMarketBuy2.getItems() != null) {
            this.tableMarketBuy2.getItems().clear();
            this.tableMarketBuy2.getItems().addAll((Collection)monitHandBuyInfos);
        } else {
            this.tableMarketBuy2.setItems(monitHandBuyInfos);
        }
        this.mktItem.getListBuyHandicap().setAll((Collection)monitHandBuyInfos);
        this.tableMarketBuy2.setPlaceholder((Node)new Label());
    }

    private void check() {
        RefItem ref = this.mktItem.getRefItem();
        if (ref == null || ref.getName().equals("") || !ref.getType().equals(this.model.getTradeType())) {
            this.lbName.setText(INVALID_CODE);
        } else if (this.mktItem.getStop().getValue().booleanValue()) {
            this.lbName.setText(this.mktItem.getStatus());
        }
    }

    private void onItemSelected(HandicapInfo now) {
        if (now != null) {
            this.setPrice(now.getPrice());
            Platform.runLater(() -> this.clearSelection());
        }
    }

    public double getOrderPriceBuy() {
        return this.orderPriceBuy;
    }

    public void setOrderPriceBuy(double orderPriceBuy) {
        this.orderPriceBuy = orderPriceBuy;
    }

    public double getOrderPriceSell() {
        return this.orderPriceSell;
    }

    public void setOrderPriceSell(double orderPriceSell) {
        this.orderPriceSell = orderPriceSell;
    }

    private void clearSelection() {
        this.tableMarketBuy2.getSelectionModel().clearSelection();
        this.tableMarketSell2.getSelectionModel().clearSelection();
    }

    private void setPrice(double price) {
        if (price > 0.0) {
            this.model.setBasePrice(price);
        }
    }

    public void initUserPre() {
        this.preModel.setType(CONSECUTIVE_BIDDING_TIME, "200006");
        try {
            this.preModel.doSet();
        }
        catch (MException mException) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u67e5\u8be2\u7528\u6237\u8bbe\u7f6e\u5931\u8d25"));
        }
    }

    public class AutoTableCell<S, T>
    extends TableCell<MonitHandicapInfo, T> {
        private AutoTableCell() {
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (this.getTableRow() != null) {
                MonitHandicapInfo info = (MonitHandicapInfo)this.getTableRow().getItem();
                if (info == null) {
                    this.getTableRow().setStyle("");
                    this.setText(null);
                    return;
                }
                if (!StringUtils.isEmpty((String)info.getColOrderCount())) {
                    this.getTableRow().setStyle("-fx-background-color: #3A3E3C");
                    this.setText("(" + info.getColOrderCount() + ")");
                } else {
                    this.getTableRow().setStyle("");
                    this.setText(null);
                }
            }
        }
    }

    class StyleTableCell
    extends TableCell<Indicator, String> {
        StyleTableCell() {
        }

        protected void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (this.getTableRow() != null && !empty && this.getTableRow().getItem() != null) {
                Indicator ap = (Indicator)this.getTableRow().getItem();
                if (ap.getRealtimeColor() == PStrategyMonitor.Color.COLOR_YELLOW) {
                    this.getTableRow().setStyle("-fx-background-color: #3A3E3C");
                } else if (ap.getRealtimeColor() == PStrategyMonitor.Color.COLOR_RED) {
                    this.getTableRow().setStyle("-fx-background-color: #D62C43");
                }
                this.setText(String.valueOf(ap.getValue1()));
            }
        }
    }
}

