/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.fund.views;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.fund.models.EtfEntrustConfirmParam;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.current.models.CcsPositionModel;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javax.inject.Inject;

public class EtfEntrustConfirmDialog
extends DialogObj {
    @FXML
    private TableView<EtfEntrustConfirmParam> tableItems;
    @FXML
    private TableColumn<EtfEntrustConfirmParam, String> index;
    @FXML
    private TableColumn<EtfEntrustConfirmParam, String> colCode;
    @FXML
    private TableColumn<EtfEntrustConfirmParam, String> colName;
    @FXML
    private TableColumn<EtfEntrustConfirmParam, String> colMkt;
    @FXML
    private TableColumn<EtfEntrustConfirmParam, String> colDirection;
    @FXML
    private TableColumn<EtfEntrustConfirmParam, String> colCount;
    @FXML
    private TableColumn<EtfEntrustConfirmParam, String> colPrice;
    @FXML
    private TableColumn<EtfEntrustConfirmParam, String> colAmt;
    @FXML
    private TableColumn<EtfEntrustConfirmParam, String> colAcc;
    @FXML
    private TableColumn<EtfEntrustConfirmParam, String> colSecAcc;
    @FXML
    private TableColumn<EtfEntrustConfirmParam, String> colPorfolio;
    @FXML
    private TableColumn<EtfEntrustConfirmParam, String> colTip;
    @Inject
    private IFundAccountService fundService;
    @FXML
    private GridPane gridPaneAmt;
    @FXML
    private Label totalTip;
    @FXML
    private Tooltip tpTip;
    @Inject
    protected CcsAccountMap ccsAccSecMap;
    private boolean buyTriggered = false;
    private boolean sellTriggered = false;
    @Inject
    private MObjFactory of;
    private List<EtfEntrustConfirmParam> paramList = new ArrayList<EtfEntrustConfirmParam>();
    private ObservableList<EtfEntrustConfirmParam> itemList = FxUtils.newList();
    private String strTip = "";
    private String type = "";
    private String symbol = "_";
    private String currency = "CNY";
    @Inject
    private CcsPositionModel model;

    @FXML
    public void initialize() {
        this.createTable();
        this.calTotalInfo();
    }

    private void calTotalInfo() {
        if (this.itemList != null) {
            int i = 0;
            while (i < this.itemList.size()) {
                double buyNum;
                EtfEntrustConfirmParam item = (EtfEntrustConfirmParam)this.itemList.get(i);
                if (item.getSide() == 49 && (buyNum = item.getBuyCount() * item.getBuyPrice()) > this.getTipFundAcount().getAvailable()) {
                    this.buyTriggered = true;
                }
                if (item.getSide() == 50) {
                    String secId = "";
                    secId = item.getSecAccnt().contains(this.symbol) ? item.getSecAccnt() : String.valueOf(item.getSecAccnt()) + this.symbol + this.currency;
                    CcsPosition position = this.model.getPosition(secId, item.getTxtcode());
                    if (position == null) {
                        this.sellTriggered = true;
                    } else if (item.getSellCount() > Double.valueOf(position.getCanVol())) {
                        this.sellTriggered = true;
                    }
                }
                ++i;
            }
        }
        if (this.buyTriggered || this.sellTriggered) {
            this.strTip = "\u8bf7\u6ce8\u610f\u5907\u6ce8\u4fe1\u606f\u63d0\u793a\n";
            this.totalTip.getStyleClass().add((Object)"priceTag");
            this.totalTip.setText(this.strTip);
            CssUtils.makeRise((Control)this.totalTip);
        }
    }

    private void createTable() {
        MxNode node = MxNodeFactory.create((String)"market_code", (String)"");
        this.index.setCellValueFactory(data -> new ReadOnlyStringWrapper(String.valueOf(data.getTableView().getItems().indexOf(data.getValue()) + 1)));
        this.colCode.setCellValueFactory(m -> new SimpleStringProperty(((EtfEntrustConfirmParam)m.getValue()).getTxtcode()));
        this.colName.setCellValueFactory(m -> new SimpleStringProperty(((EtfEntrustConfirmParam)m.getValue()).getLbName()));
        this.colMkt.setCellValueFactory(m -> new SimpleStringProperty(node.getNode(((EtfEntrustConfirmParam)m.getValue()).getMarket()).getValue()));
        this.colDirection.setCellFactory(cell -> new DirectTableCell());
        this.colAmt.setCellValueFactory(m -> {
            if (((EtfEntrustConfirmParam)m.getValue()).getSide() == 49) {
                Double amt = ((EtfEntrustConfirmParam)m.getValue()).getBuyPrice() * ((EtfEntrustConfirmParam)m.getValue()).getBuyCount();
                BigDecimal bigAmt = BigDecimal.valueOf(amt).setScale(3, 4);
                return new SimpleStringProperty(bigAmt.toPlainString());
            }
            if (((EtfEntrustConfirmParam)m.getValue()).getSide() == 50) {
                Double amt = ((EtfEntrustConfirmParam)m.getValue()).getSellPrice() * ((EtfEntrustConfirmParam)m.getValue()).getSellCount();
                BigDecimal bigAmt = BigDecimal.valueOf(amt).setScale(3, 4);
                return new SimpleStringProperty(bigAmt.toPlainString());
            }
            return null;
        });
        this.colCount.setCellValueFactory(m -> {
            if (((EtfEntrustConfirmParam)m.getValue()).getSide() == 49) {
                double buyCount = ((EtfEntrustConfirmParam)m.getValue()).getBuyCount();
                BigDecimal count = BigDecimal.valueOf(buyCount);
                return new SimpleStringProperty(count.toPlainString());
            }
            if (((EtfEntrustConfirmParam)m.getValue()).getSide() == 50) {
                double sellCount = ((EtfEntrustConfirmParam)m.getValue()).getSellCount();
                BigDecimal count = BigDecimal.valueOf(sellCount);
                return new SimpleStringProperty(count.toPlainString());
            }
            return null;
        });
        this.colPrice.setCellValueFactory(m -> {
            DecimalFormat df = new DecimalFormat("0.000");
            if (((EtfEntrustConfirmParam)m.getValue()).getSide() == 49) {
                String str = df.format(((EtfEntrustConfirmParam)m.getValue()).getBuyPrice());
                SimpleStringProperty buyCount = new SimpleStringProperty(str);
                return buyCount;
            }
            if (((EtfEntrustConfirmParam)m.getValue()).getSide() == 50) {
                String str = df.format(((EtfEntrustConfirmParam)m.getValue()).getSellPrice());
                SimpleStringProperty sellCount = new SimpleStringProperty(str);
                return sellCount;
            }
            return null;
        });
        this.colAcc.setCellValueFactory(m -> new SimpleStringProperty(((EtfEntrustConfirmParam)m.getValue()).getAccnt()));
        this.colSecAcc.setCellValueFactory(m -> {
            String secId = this.afterUpdate(((EtfEntrustConfirmParam)m.getValue()).getSecAccnt());
            return new SimpleStringProperty(secId);
        });
        this.colTip.setCellFactory(cell -> new TipTableCell());
        this.itemList.addAll(this.getParamList());
        this.tableItems.setItems(this.itemList);
    }

    private String afterUpdate(String secId) {
        if (secId.contains(this.symbol)) {
            String sec = ((SecAccount)this.ccsAccSecMap.getCcsSecAccountMap().get(secId)).getInverstorSecId();
            return sec;
        }
        return secId;
    }

    private FundAccount getTipFundAcount() {
        List fundList = this.fundService.getFundAccountList("CCS").stream().filter(e -> e.getInvestId().equals(((EtfEntrustConfirmParam)this.itemList.get(0)).getAccnt())).collect(Collectors.toList());
        if (fundList != null) {
            return (FundAccount)fundList.get(0);
        }
        return null;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean priceIsEmpty() {
        switch (this.type) {
            case "PLEDGE": {
                return true;
            }
        }
        return false;
    }

    public List<EtfEntrustConfirmParam> getParamList() {
        return this.paramList;
    }

    public void setParamList(List<EtfEntrustConfirmParam> paramList) {
        this.paramList = paramList;
    }

    public class DirectTableCell<S, T>
    extends TableCell<CcsOrder, T> {
        EtfEntrustConfirmParam orderExtra;

        private DirectTableCell() {
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (this.getTableRow() != null) {
                this.orderExtra = (EtfEntrustConfirmParam)EtfEntrustConfirmParam.class.cast(this.getTableRow().getItem());
                if (this.orderExtra == null) {
                    return;
                }
                if (this.orderExtra.getSide() == 49) {
                    this.setText("\u4e70\u5165");
                    this.setStyle("-fx-text-fill:red");
                } else if (this.orderExtra.getSide() == 50) {
                    this.setText("\u5356\u51fa");
                    this.setStyle("-fx-text-fill:#2EC87B");
                }
            }
        }
    }

    private class TipCell
    extends TableCell<EtfEntrustConfirmParam, String> {
        private Label label = new Label();

        private TipCell() {
            this.label.getStyleClass().add((Object)"priceTag");
            CssUtils.makeRise((Control)this.label);
        }

        public void updateItem(String value, boolean empty) {
            if (empty) {
                this.setGraphic(null);
                return;
            }
            this.label.setText(value);
            this.setGraphic((Node)this.label);
        }
    }

    public class TipTableCell<S, T>
    extends TableCell<CcsOrder, T> {
        EtfEntrustConfirmParam orderExtra;

        private TipTableCell() {
            EtfEntrustConfirmDialog.this.tableItems.refresh();
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (this.getTableRow() != null) {
                this.orderExtra = (EtfEntrustConfirmParam)EtfEntrustConfirmParam.class.cast(this.getTableRow().getItem());
                if (this.orderExtra == null) {
                    return;
                }
                if (this.orderExtra.getSide() == 49 && EtfEntrustConfirmDialog.this.buyTriggered) {
                    this.setText("\u53ef\u7528\u8d44\u91d1\u4e0d\u8db3");
                    this.setStyle("-fx-text-fill:red");
                }
                if (this.orderExtra.getSide() == 50 && EtfEntrustConfirmDialog.this.sellTriggered) {
                    this.setText("\u53ef\u5356\u6570\u91cf\u4e0d\u8db3");
                    this.setStyle("-fx-text-fill:red");
                }
            }
        }
    }
}

